/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp;

import com.zipow.videobox.ptapp.PTAppProtos;
import java.io.IOException;

public class MeetingHistory {
    private static final String TAG = MeetingHistory.class.getName();
    private long mNativeHandle = 0L;

    public MeetingHistory(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    public long getMeetingNumber() {
        return this.getMeetingNumberImpl(this.mNativeHandle);
    }

    public String getMeetingTopic() {
        return this.getMeetingTopicImpl(this.mNativeHandle);
    }

    public long getJoinedTime() {
        return this.getJoinedTimeImpl(this.mNativeHandle) * 1000L;
    }

    public int getDurationInMinutes() {
        return this.getDurationInMinutesImpl(this.mNativeHandle);
    }

    public int getParticipantCount() {
        return this.getParticipantCountImpl(this.mNativeHandle);
    }

    public PTAppProtos.MeetingParticipant getParticipantAtIndex(int idx) {
        byte[] data = this.getParticipantDataAtIndexImpl(this.mNativeHandle, idx);
        if (data == null) {
            return null;
        }
        PTAppProtos.MeetingParticipant participant = null;
        try {
            participant = PTAppProtos.MeetingParticipant.parseFrom(data);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return participant;
    }

    public long getItemID() {
        return this.getItemIDImpl(this.mNativeHandle);
    }

    public int getCallType() {
        return this.getCallTypeImpl(this.mNativeHandle);
    }

    private native long getMeetingNumberImpl(long var1);

    private native String getMeetingTopicImpl(long var1);

    private native long getJoinedTimeImpl(long var1);

    private native int getDurationInMinutesImpl(long var1);

    private native int getParticipantCountImpl(long var1);

    private native byte[] getParticipantDataAtIndexImpl(long var1, int var3);

    private native long getItemIDImpl(long var1);

    private native int getCallTypeImpl(long var1);
}

