/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp;

import com.google.protobuf.InvalidProtocolBufferException;
import com.zipow.videobox.ptapp.MeetingHistory;
import com.zipow.videobox.ptapp.MeetingInfo;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTUserProfile;
import com.zipow.videobox.ptapp.RoomDevice;
import java.util.List;
import java.util.TimeZone;
import us.zoom.androidlib.util.StringUtil;

public class MeetingHelper {
    private static final String TAG = MeetingHelper.class.getSimpleName();
    private long mNativeHandle = 0L;

    public MeetingHelper(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    public int getMeetingCount() {
        return this.getMeetingCountImpl(this.mNativeHandle);
    }

    public MeetingInfo getMeetingItemByIndex(int index) {
        return this.getMeetingItemDataByIndex(this.mNativeHandle, index);
    }

    public MeetingInfo getMeetingItemByID(String meetingID) {
        return this.getMeetingItemDataByID(this.mNativeHandle, meetingID);
    }

    public MeetingInfo getMeetingItemByNumber(long meetingNo) {
        return this.getMeetingItemDataByNumber(this.mNativeHandle, meetingNo);
    }

    public MeetingInfo getPmiMeetingItem() {
        int count = this.getMeetingCount();
        for (int i = 0; i < count; ++i) {
            MeetingInfo info = this.getMeetingItemByIndex(i);
            if (info.getExtendMeetingType() != 1) continue;
            return info;
        }
        return null;
    }

    public boolean scheduleMeeting(MeetingInfo meetingInfo, String timeZone, String scheduleFor) {
        if (meetingInfo == null) {
            return false;
        }
        if (timeZone == null) {
            timeZone = TimeZone.getDefault().getID();
        }
        if (scheduleFor == null) {
            scheduleFor = "";
        }
        return this.scheduleMeetingImpl(this.mNativeHandle, meetingInfo, timeZone, scheduleFor);
    }

    public boolean editMeeting(MeetingInfo meetingInfo, String timeZone) {
        if (meetingInfo == null) {
            return false;
        }
        if (timeZone == null) {
            timeZone = TimeZone.getDefault().getID();
        }
        return this.editMeetingImpl(this.mNativeHandle, meetingInfo, timeZone);
    }

    public boolean deleteMeeting(long meetingNo) {
        return this.deleteMeetingImpl(this.mNativeHandle, meetingNo);
    }

    public boolean getMeetingInfo(String meetingID, String meetingNo) {
        if (StringUtil.isEmptyOrNull((String)meetingID) || StringUtil.isEmptyOrNull((String)meetingNo)) {
            return false;
        }
        return this.getMeetingInfoImpl(this.mNativeHandle, meetingID, meetingNo);
    }

    public boolean getMeetingStatus(String meetingID, String meetingPsw) {
        if (StringUtil.isEmptyOrNull((String)meetingID)) {
            return false;
        }
        if (meetingPsw == null) {
            meetingPsw = "";
        }
        return this.getMeetingStatusImpl(this.mNativeHandle, meetingID, meetingPsw);
    }

    public boolean createIcsFileFromMeeting(MeetingInfo meetingInfo, String[] filePath, String timeZoneName) {
        if (meetingInfo == null || filePath == null || filePath.length == 0) {
            return false;
        }
        return this.createIcsFileFromMeetingImpl(this.mNativeHandle, meetingInfo, filePath, timeZoneName);
    }

    public boolean listMeetingUpcoming() {
        return this.listMeetingUpcomingImpl(this.mNativeHandle);
    }

    public boolean isLoadingMeetingList() {
        return this.isLoadingMeetingListImpl(this.mNativeHandle);
    }

    public boolean deleteHistory(long historyID) {
        return this.deleteHistoryImpl(this.mNativeHandle, historyID);
    }

    public boolean clearAllHistories() {
        return this.clearAllHistoriesImpl(this.mNativeHandle);
    }

    public int getHistoryCount() {
        return this.getHistoryCountImpl(this.mNativeHandle);
    }

    public MeetingHistory getHistoryAtIndex(int idx) {
        long handle = this.getHistoryAtIndexImpl(this.mNativeHandle, idx);
        if (handle == 0L) {
            return null;
        }
        return new MeetingHistory(handle);
    }

    public MeetingHistory getHistoryByID(long historyID) {
        long handle = this.getHistoryByIDImpl(this.mNativeHandle, historyID);
        if (handle == 0L) {
            return null;
        }
        return new MeetingHistory(handle);
    }

    public boolean modifyPMI(long oldNo, long newNo) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.modifyPMIImpl(this.mNativeHandle, oldNo, newNo);
    }

    public void checkIfNeedToListUpcomingMeeting() {
        if (this.mNativeHandle == 0L) {
            return;
        }
        this.checkIfNeedToListUpcomingMeetingImpl(this.mNativeHandle);
    }

    public boolean alwaysUsePMI() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.alwaysUsePMIImpl(this.mNativeHandle);
    }

    public boolean setAlwaysUsePMI(boolean bOn) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.setAlwaysUsePMIImpl(this.mNativeHandle, bOn);
    }

    public boolean alwaysMobileVideoOn() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.alwaysMobileVideoOnImpl(this.mNativeHandle);
    }

    public boolean setAlwaysMobileVideoOn(boolean bOn) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.setAlwaysMobileVideoOnImpl(this.mNativeHandle, bOn);
    }

    public boolean callOutRoomSystem(String address, int deviceType, int roomEncrypt) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.callOutRoomSystemImpl(this.mNativeHandle, address, deviceType, roomEncrypt);
    }

    public boolean getRoomDevices(List<RoomDevice> devices) {
        if (this.mNativeHandle == 0L || devices == null) {
            return false;
        }
        return this.getRoomDevicesImpl(this.mNativeHandle, devices);
    }

    public boolean cancelRoomDevice() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.cancelRoomDeviceImpl(this.mNativeHandle);
    }

    public boolean sendMeetingParingCode(long meetingId, String paringCode) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.sendMeetingParingCodeImpl(this.mNativeHandle, meetingId, paringCode);
    }

    public boolean listCalendarEvents() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        PTUserProfile ptUserProfile = PTApp.getInstance().getCurrentUserProfile();
        if (ptUserProfile.canAccessOutlookExchange()) {
            return this.listEWSCalendarEventsImpl(this.mNativeHandle);
        }
        return this.listGoogleCalendarEventsImpl(this.mNativeHandle);
    }

    public PTAppProtos.GoogCalendarEventList getCalendarEvents() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        PTUserProfile ptUserProfile = PTApp.getInstance().getCurrentUserProfile();
        byte[] data = ptUserProfile.canAccessOutlookExchange() ? this.getEWSCalEventsImpl(this.mNativeHandle) : this.getGoogleCalEventsImpl(this.mNativeHandle);
        if (data == null || data.length == 0) {
            return null;
        }
        PTAppProtos.GoogCalendarEventList googCalendarEventList = null;
        try {
            googCalendarEventList = PTAppProtos.GoogCalendarEventList.parseFrom(data);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            // empty catch block
        }
        return googCalendarEventList;
    }

    private native int getMeetingCountImpl(long var1);

    private native MeetingInfo getMeetingItemDataByIndex(long var1, int var3);

    private native MeetingInfo getMeetingItemDataByID(long var1, String var3);

    private native MeetingInfo getMeetingItemDataByNumber(long var1, long var3);

    private native boolean scheduleMeetingImpl(long var1, MeetingInfo var3, String var4, String var5);

    private native boolean editMeetingImpl(long var1, MeetingInfo var3, String var4);

    private native boolean deleteMeetingImpl(long var1, long var3);

    private native boolean getMeetingInfoImpl(long var1, String var3, String var4);

    private native boolean getMeetingStatusImpl(long var1, String var3, String var4);

    private native boolean createIcsFileFromMeetingImpl(long var1, MeetingInfo var3, String[] var4, String var5);

    private native boolean listMeetingUpcomingImpl(long var1);

    private native boolean isLoadingMeetingListImpl(long var1);

    private native boolean deleteHistoryImpl(long var1, long var3);

    private native boolean clearAllHistoriesImpl(long var1);

    private native int getHistoryCountImpl(long var1);

    private native long getHistoryAtIndexImpl(long var1, int var3);

    private native long getHistoryByIDImpl(long var1, long var3);

    private native boolean modifyPMIImpl(long var1, long var3, long var5);

    private native void checkIfNeedToListUpcomingMeetingImpl(long var1);

    private native boolean alwaysUsePMIImpl(long var1);

    private native boolean setAlwaysUsePMIImpl(long var1, boolean var3);

    private native boolean alwaysMobileVideoOnImpl(long var1);

    private native boolean setAlwaysMobileVideoOnImpl(long var1, boolean var3);

    private native boolean callOutRoomSystemImpl(long var1, String var3, int var4, int var5);

    private native boolean cancelRoomDeviceImpl(long var1);

    private native boolean getRoomDevicesImpl(long var1, List<RoomDevice> var3);

    private native boolean sendMeetingParingCodeImpl(long var1, long var3, String var5);

    private native boolean listGoogleCalendarEventsImpl(long var1);

    private native boolean listEWSCalendarEventsImpl(long var1);

    private native byte[] getGoogleCalEventsImpl(long var1);

    private native byte[] getEWSCalEventsImpl(long var1);
}

