/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.webkit.WebViewDatabase;
import com.zipow.videobox.LauncherActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUI;
import us.zoom.thirdparty.login.LoginType;
import us.zoom.thirdparty.login.ThirdPartyLoginFactory;

public class LogoutHandler {
    private Handler mHandler;
    private static LogoutHandler mInstance;
    private static final long BEFORE_LOGOUT_TIME_OUT = 3000L;
    private Runnable mLogoutRunnable;
    private PTUI.IPTUIListener mPTUIListener = new PTUI.SimplePTUIListener(){

        @Override
        public void onPTAppEvent(int event, long result) {
            if (event == 63) {
                LogoutHandler.this.doLogout();
                if (LogoutHandler.this.mLogoutRunnable != null) {
                    LogoutHandler.this.mHandler.removeCallbacks(LogoutHandler.this.mLogoutRunnable);
                    LogoutHandler.this.mLogoutRunnable = null;
                }
            }
        }
    };

    public static LogoutHandler getInstance() {
        if (mInstance == null) {
            mInstance = new LogoutHandler();
        }
        return mInstance;
    }

    private LogoutHandler() {
        this.mHandler = new Handler();
    }

    public void startLogout() {
        if (PTApp.getInstance().beforeLogout()) {
            PTUI.getInstance().addPTUIListener(this.mPTUIListener);
            if (this.mLogoutRunnable != null) {
                this.mHandler.removeCallbacks(this.mLogoutRunnable);
            }
            this.mLogoutRunnable = new Runnable(){

                @Override
                public void run() {
                    if (PTApp.getInstance().isWebSignedOn() || PTApp.getInstance().isAuthenticating()) {
                        LogoutHandler.this.doLogout();
                    }
                }
            };
            this.mHandler.postDelayed(this.mLogoutRunnable, 3000L);
        } else {
            this.doLogout();
        }
    }

    private void doLogout() {
        WebViewDatabase webViewDatabase;
        PTUI.getInstance().removePTUIListener(this.mPTUIListener);
        VideoBoxApplication context = VideoBoxApplication.getInstance();
        if (context == null) {
            return;
        }
        boolean needRestart = false;
        int loginType = PTApp.getInstance().getPTLoginType();
        if (loginType == 101 && (webViewDatabase = WebViewDatabase.getInstance((Context)context)) != null && webViewDatabase.hasHttpAuthUsernamePassword()) {
            needRestart = true;
        }
        PTApp.getInstance().logout(0);
        if (needRestart) {
            ThirdPartyLoginFactory.build((LoginType)LoginType.Sso, (Bundle)ThirdPartyLoginFactory.buildEmptySsoBundle()).logout((Context)VideoBoxApplication.getInstance());
            LauncherActivity.showLauncherActivityAsFromHome((Context)context);
            VideoBoxApplication.getInstance().exit();
        }
    }
}

