/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp;

import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.GroupMemberSynchronizer;
import com.zipow.videobox.ptapp.mm.UnSupportMessageMgr;
import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;

public class IMCallbackUI {
    private static final String TAG = IMCallbackUI.class.getSimpleName();
    private static IMCallbackUI instance = null;
    private ListenerList mListenerList = new ListenerList();
    private long mNativeHandle;

    public void addListener(IIMCallbackUIListener l) {
        if (l == null) {
            return;
        }
        IListener[] listeners = this.mListenerList.getAll();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != l) continue;
            this.removeListener((IIMCallbackUIListener)listeners[i]);
        }
        this.mListenerList.add((IListener)l);
    }

    public void removeListener(IIMCallbackUIListener l) {
        this.mListenerList.remove((IListener)l);
    }

    public static synchronized IMCallbackUI getInstance() {
        if (instance == null) {
            instance = new IMCallbackUI();
        }
        if (!instance.initialized()) {
            instance.init();
        }
        return instance;
    }

    private IMCallbackUI() {
        this.init();
    }

    private boolean initialized() {
        return this.mNativeHandle != 0L;
    }

    private void init() {
        try {
            this.mNativeHandle = this.nativeInit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void registerCallback() {
        this.registerGroupMemberCallback();
        this.registerUnSupportMessageMgrCallback();
    }

    private void registerGroupMemberCallback() {
        GroupMemberSynchronizer groupMemberSynchronizer = PTApp.getInstance().getGroupMemberSynchronizer();
        if (groupMemberSynchronizer != null) {
            groupMemberSynchronizer.registerUICallback(IMCallbackUI.getInstance());
        }
    }

    private void registerUnSupportMessageMgrCallback() {
        UnSupportMessageMgr mgr = PTApp.getInstance().getUnsupportMessageMgr();
        if (mgr != null) {
            mgr.setMsgUI(IMCallbackUI.getInstance());
        }
    }

    protected void notifyAsyncMUCGroupInfoUpdated(String groupid) {
        try {
            this.notifyAsyncMUCGroupInfoUpdatedImpl(groupid);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void notifyAsyncMUCGroupInfoUpdatedImpl(String groupid) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IIMCallbackUIListener l = (IIMCallbackUIListener)lTmp;
                l.Notify_AsyncMUCGroupInfoUpdated(groupid);
            }
        }
    }

    protected void OnUnsupportMessageRecevied(int result, String reqID, String session, String msgGuid) {
        try {
            this.OnUnsupportMessageReceviedImpl(result, reqID, session, msgGuid);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void OnUnsupportMessageReceviedImpl(int result, String reqID, String session, String msgGuid) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IIMCallbackUIListener l = (IIMCallbackUIListener)lTmp;
                l.OnUnsupportMessageRecevied(result, reqID, session, msgGuid);
            }
        }
    }

    public long getUnSupportHandle() {
        return this.getUnSupportHandleImpl(this.mNativeHandle);
    }

    public long getAsynReadGroupMemberHandle() {
        return this.getAsynReadGroupMemberHandleImpl(this.mNativeHandle);
    }

    private native long nativeInit();

    private native void nativeUninit(long var1);

    private native long getUnSupportHandleImpl(long var1);

    private native long getAsynReadGroupMemberHandleImpl(long var1);

    public static abstract class SimpleIMCallbackUIListener
    implements IIMCallbackUIListener {
        @Override
        public void Notify_AsyncMUCGroupInfoUpdated(String groupid) {
        }

        @Override
        public void OnUnsupportMessageRecevied(int result, String reqID, String session, String msgGuids) {
        }
    }

    public static interface IIMCallbackUIListener
    extends IListener {
        public void Notify_AsyncMUCGroupInfoUpdated(String var1);

        public void OnUnsupportMessageRecevied(int var1, String var2, String var3, String var4);
    }
}

