/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp;

import com.google.protobuf.InvalidProtocolBufferException;
import com.zipow.videobox.ptapp.PTAppProtos;
import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;

public class CrawlerLinkPreviewUI {
    private static final String TAG = CrawlerLinkPreviewUI.class.getSimpleName();
    private static CrawlerLinkPreviewUI instance = null;
    private ListenerList mListenerList = new ListenerList();
    private long mNativeHandle;

    public void addListener(ICrawlerLinkPreviewUIListener l) {
        if (l == null) {
            return;
        }
        IListener[] listeners = this.mListenerList.getAll();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != l) continue;
            this.removeListener((ICrawlerLinkPreviewUIListener)listeners[i]);
        }
        this.mListenerList.add((IListener)l);
    }

    public void removeListener(ICrawlerLinkPreviewUIListener l) {
        this.mListenerList.remove((IListener)l);
    }

    public static synchronized CrawlerLinkPreviewUI getInstance() {
        if (instance == null) {
            instance = new CrawlerLinkPreviewUI();
        }
        if (!instance.initialized()) {
            instance.init();
        }
        return instance;
    }

    private CrawlerLinkPreviewUI() {
        this.init();
    }

    private boolean initialized() {
        return this.mNativeHandle != 0L;
    }

    private void init() {
        try {
            this.mNativeHandle = this.nativeInit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void OnLinkCrawlResult(byte[] data) {
        try {
            this.OnLinkCrawlResultImpl(data);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void OnLinkCrawlResultImpl(byte[] data) {
        if (data == null) {
            return;
        }
        PTAppProtos.CrawlLinkResponse res = null;
        try {
            res = PTAppProtos.CrawlLinkResponse.parseFrom(data);
        }
        catch (InvalidProtocolBufferException e) {
            return;
        }
        if (res == null) {
            return;
        }
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                ICrawlerLinkPreviewUIListener l = (ICrawlerLinkPreviewUIListener)lTmp;
                l.OnLinkCrawlResult(res);
            }
        }
    }

    protected void OnDownloadImage(int result, String req_id) {
        try {
            this.OnDownloadImageImpl(result, req_id);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void OnDownloadImageImpl(int result, String req_id) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                ICrawlerLinkPreviewUIListener l = (ICrawlerLinkPreviewUIListener)lTmp;
                l.OnDownloadImage(result, req_id);
            }
        }
    }

    protected void OnDownloadFavicon(int result, String req_id) {
        try {
            this.OnDownloadFaviconImpl(result, req_id);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void OnDownloadFaviconImpl(int result, String req_id) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                ICrawlerLinkPreviewUIListener l = (ICrawlerLinkPreviewUIListener)lTmp;
                l.OnDownloadFavicon(result, req_id);
            }
        }
    }

    public long getNativeHandle() {
        return this.mNativeHandle;
    }

    private native long nativeInit();

    private native void nativeUninit(long var1);

    public static abstract class SimpleCrawlerLinkPreviewUIListener
    implements ICrawlerLinkPreviewUIListener {
        @Override
        public void OnLinkCrawlResult(PTAppProtos.CrawlLinkResponse resp) {
        }

        @Override
        public void OnDownloadImage(int result, String req_id) {
        }

        @Override
        public void OnDownloadFavicon(int result, String req_id) {
        }
    }

    public static interface ICrawlerLinkPreviewUIListener
    extends IListener {
        public void OnLinkCrawlResult(PTAppProtos.CrawlLinkResponse var1);

        public void OnDownloadImage(int var1, String var2);

        public void OnDownloadFavicon(int var1, String var2);
    }
}

