/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp;

import android.content.Context;
import android.os.Bundle;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.sdk.SDKCustomizedMeetingUIHelper;
import com.zipow.videobox.util.IPCHelper;

public class ConfProcessMgr {
    private static final String TAG = ConfProcessMgr.class.getSimpleName();
    private static ConfProcessMgr instance = null;
    private int mCurrentConfProcessId = 0;
    private int mLastError = 0;

    private ConfProcessMgr() {
    }

    public static synchronized ConfProcessMgr getInstance() {
        if (instance == null) {
            instance = new ConfProcessMgr();
        }
        return instance;
    }

    public synchronized int createConfProcess(String commandLine) {
        int pid;
        boolean needShowActivity = !VideoBoxApplication.getInstance().isConfUIPreloaded();
        this.mCurrentConfProcessId = 0;
        Bundle args = new Bundle();
        args.putString("commandLine", commandLine);
        this.mLastError = VideoBoxApplication.getInstance().startConfService(args);
        this.mCurrentConfProcessId = pid = VideoBoxApplication.getInstance().getConfProcessId();
        if (this.mLastError == 0 && needShowActivity) {
            VideoBoxApplication context = VideoBoxApplication.getInstance();
            if (!SDKCustomizedMeetingUIHelper.isSdkUsingCustomizedMeetingUI()) {
                ConfActivity.startConfUI((Context)context);
            } else {
                SDKCustomizedMeetingUIHelper.handleSdkReconnect();
            }
        }
        if (pid <= 0) {
            IPCHelper.getInstance().sendBOStatusChangeComplete();
        }
        return pid;
    }

    public boolean isConfProcessRunning() {
        if (VideoBoxApplication.getInstance().getConfService() != null) {
            return true;
        }
        return VideoBoxApplication.getInstance().isConfProcessRunning();
    }

    public boolean terminateConfProcess(int pid) {
        if (pid == VideoBoxApplication.getInstance().getConfProcessId()) {
            VideoBoxApplication.getInstance().killConfProcess();
        }
        return true;
    }

    public synchronized int getCurrentConfProcessId() {
        return this.mCurrentConfProcessId;
    }

    public int getLastError() {
        return this.mLastError;
    }
}

