/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.poll;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.poll.PollingMgr;
import com.zipow.videobox.poll.PollingActivity;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class WebinarPollingActivity
extends PollingActivity {
    public static void show(Activity activity, String pollingID, int role, int requestCode) {
        if (activity == null || StringUtil.isEmptyOrNull((String)pollingID)) {
            return;
        }
        Intent intent = new Intent((Context)activity, WebinarPollingActivity.class);
        intent.putExtra("pollingId", pollingID);
        if (role == 1 || role == 2) {
            intent.putExtra("isReadOnly", true);
            intent.putExtra("readOnlyMessageRes", R.string.zm_polling_msg_host_and_panelist_cannot_vote);
        }
        activity.startActivityForResult(intent, requestCode);
        activity.overridePendingTransition(R.anim.zm_slide_in_bottom, R.anim.zm_fade_out);
    }

    @Override
    protected void loadPollingMgr() {
        PollingMgr pollMgr = ConfMgr.getInstance().getPollObj();
        if (pollMgr != null) {
            this.setPollingMgr(pollMgr);
        }
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(0, R.anim.zm_slide_out_bottom);
    }
}

