/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.poll;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.zipow.videobox.poll.IPollingAnswer;
import com.zipow.videobox.poll.IPollingDoc;
import com.zipow.videobox.poll.IPollingQuestion;
import com.zipow.videobox.poll.PollingResultItem;
import com.zipow.videobox.poll.PollingResultListAdapter;

public class PollingResultListView
extends ListView {
    private PollingResultListAdapter mAdapter;

    public PollingResultListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView(context);
    }

    public PollingResultListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public PollingResultListView(Context context) {
        super(context);
        this.initView(context);
    }

    private void initView(Context context) {
        this.mAdapter = new PollingResultListAdapter(context);
        if (this.isInEditMode()) {
            this.__editMode_loadItems(this.mAdapter);
        }
        this.setAdapter((ListAdapter)this.mAdapter);
    }

    public void loadPollingResult(IPollingDoc pollingDoc, boolean bShowSelectedCount) {
        if (pollingDoc == null) {
            return;
        }
        int questionCount = pollingDoc.getQuestionCount();
        for (int i = 0; i < questionCount; ++i) {
            IPollingQuestion question = pollingDoc.getQuestionAt(i);
            if (question == null) continue;
            PollingResultItem item = new PollingResultItem();
            item.setQuestion(question.getQuestionText());
            item.setQuestionType(question.getQuestionType());
            item.setShowSelectedCount(bShowSelectedCount);
            int answerCount = question.getAnswerCount();
            for (int j = 0; j < answerCount; ++j) {
                IPollingAnswer answer = question.getAnswerAt(j);
                if (answer == null) continue;
                String answerText = answer.getAnswerText();
                int countSelected = answer.getSelectedCount();
                int totalVotedUserCount = pollingDoc.getTotalVotedUserCount();
                float percent = 0.0f;
                if (totalVotedUserCount > 0) {
                    percent = (float)(countSelected * 100) / (float)totalVotedUserCount;
                }
                PollingResultItem.Answer answerItem = new PollingResultItem.Answer(answerText, countSelected, percent);
                item.addAnswer(answerItem);
            }
            this.mAdapter.addItem(item);
        }
    }

    private void __editMode_loadItems(PollingResultListAdapter adapter) {
        for (int i = 0; i < 3; ++i) {
            PollingResultItem item = new PollingResultItem();
            item.setQuestion("Question " + i);
            PollingResultItem.Answer answer = new PollingResultItem.Answer("Answer content 1", 1, 10.5f);
            item.addAnswer(answer);
            answer = new PollingResultItem.Answer("Answer content 2", 5, 50.0f);
            item.addAnswer(answer);
            answer = new PollingResultItem.Answer("Answer content 3", 4, 40.0f);
            item.addAnswer(answer);
            adapter.addItem(item);
        }
    }
}

