/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.poll;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.zipow.videobox.poll.IPollingDoc;
import com.zipow.videobox.poll.IPollingMgr;
import com.zipow.videobox.poll.PollingResultActivity;
import com.zipow.videobox.poll.PollingResultListView;
import com.zipow.videobox.poll.PollingRole;
import us.zoom.androidlib.app.ZMFragment;
import us.zoom.videomeetings.R;

public class PollingResultFragment
extends ZMFragment
implements View.OnClickListener {
    private static final String TAG = PollingResultFragment.class.getSimpleName();
    public static final String ARG_POLLING_ID = "pollingId";
    private String mPollingId;
    private View mBtnBack;
    private TextView mTxtTitle;
    private PollingResultListView mResultListView;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle args = this.getArguments();
        if (args == null) {
            return;
        }
        this.mPollingId = args.getString(ARG_POLLING_ID);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_polling_result_view, container, false);
        this.mBtnBack = view.findViewById(R.id.btnBack);
        this.mTxtTitle = (TextView)view.findViewById(R.id.txtTitle);
        this.mResultListView = (PollingResultListView)view.findViewById(R.id.resultListView);
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        this.initView(inflater, savedInstanceState);
        return view;
    }

    private void initView(LayoutInflater inflater, Bundle savedInstanceState) {
        PollingResultActivity activity = (PollingResultActivity)this.getActivity();
        if (activity != null) {
            IPollingDoc doc = this.getPollingDoc();
            if (doc == null) {
                return;
            }
            String name = doc.getPollingName();
            if (name == null) {
                name = "";
            }
            this.mTxtTitle.setText((CharSequence)name);
            boolean bShowSelectedCount = true;
            IPollingMgr pollingMgr = activity.getPollingMgr();
            if (pollingMgr != null) {
                bShowSelectedCount = pollingMgr.getPollingRole() == PollingRole.Host;
            }
            this.mResultListView.loadPollingResult(doc, bShowSelectedCount);
        }
    }

    private IPollingDoc getPollingDoc() {
        if (this.mPollingId == null) {
            return null;
        }
        PollingResultActivity activity = (PollingResultActivity)this.getActivity();
        if (activity == null) {
            return null;
        }
        IPollingMgr pollingMgr = activity.getPollingMgr();
        if (pollingMgr == null) {
            return null;
        }
        IPollingDoc doc = pollingMgr.getPollingDocById(this.mPollingId);
        if (doc == null) {
            return null;
        }
        return doc;
    }

    public void onClick(View v) {
        if (v == this.mBtnBack) {
            this.onClickBtnBack();
        }
    }

    private void onClickBtnBack() {
        PollingResultActivity activity = (PollingResultActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        activity.finish();
    }
}

