/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.poll;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.widget.Toast;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.poll.IPollingDoc;
import com.zipow.videobox.poll.IPollingListener;
import com.zipow.videobox.poll.IPollingMgr;
import com.zipow.videobox.poll.IPollingQuestion;
import com.zipow.videobox.poll.PollingQuestionFragment;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class PollingActivity
extends ZMActivity
implements IPollingListener {
    private static final String TAG = PollingActivity.class.getSimpleName();
    public static final String EXTRA_POLLING_ID = "pollingId";
    public static final String EXTRA_IS_READONLY = "isReadOnly";
    public static final String EXTRA_READYONLY_MESSAGE_RES = "readOnlyMessageRes";
    private PollingQuestionFragment mQuestionFragment = null;
    private IPollingMgr mPollingMgr;
    private String mPollingId;
    private boolean mIsReadOnly = false;
    private int mReadOnlyMessageRes = 0;
    private ProgressDialog mWaitingDialog;

    public PollingActivity() {
        this.loadPollingMgr();
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null || !mainboard.isInitialized()) {
            this.finish();
            return;
        }
        if (VideoBoxApplication.getInstance() == null || VideoBoxApplication.getInstance().isSDKMode() && !mainboard.isSDKConfAppCreated()) {
            this.finish();
            return;
        }
        Intent intent = this.getIntent();
        this.mPollingId = intent.getStringExtra(EXTRA_POLLING_ID);
        this.mIsReadOnly = intent.getBooleanExtra(EXTRA_IS_READONLY, false);
        this.mReadOnlyMessageRes = intent.getIntExtra(EXTRA_READYONLY_MESSAGE_RES, 0);
        if (savedInstanceState == null) {
            this.showQuestion(0, 0, 0);
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mPollingMgr != null) {
            this.mPollingMgr.removeListener(this);
        }
    }

    @Override
    public void onPollingSubmitResult(final String pollingId, final int result) {
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction(){

            public void run(IUIElement ui) {
                ((PollingActivity)ui).handlePollingSumbitResult(pollingId, result);
            }
        });
    }

    @Override
    public void onPollingStatusChanged(String pollingId, int status) {
        if (StringUtil.isSameString((String)pollingId, (String)this.mPollingId) && status == 2) {
            this.getNonNullEventTaskManagerOrThrowException().push(new EventAction(){

                public void run(IUIElement ui) {
                    ((PollingActivity)ui).handlePollingClosed();
                }
            });
        }
    }

    private void handlePollingSumbitResult(String pollingId, int result) {
        this.dismissWaitingDialog();
        if (result == 0) {
            this.setResult(-1);
            this.finish();
        } else {
            this.showSubmitFailure(pollingId, result);
        }
    }

    private void showSubmitFailure(String pollingId, int result) {
        String message = "";
        message = result == 1 ? this.getString(R.string.zm_polling_msg_failed_to_submit_closed_18524) : this.getString(R.string.zm_polling_msg_failed_to_submit_poll, new Object[]{result});
        Toast.makeText((Context)this, (CharSequence)message, (int)1).show();
    }

    private void handlePollingClosed() {
        this.setResult(0);
        this.finish();
    }

    private PollingQuestionFragment getCurrentQuestionFragment() {
        FragmentManager fm;
        if (this.mQuestionFragment == null && (fm = this.getSupportFragmentManager()) != null) {
            this.mQuestionFragment = (PollingQuestionFragment)fm.findFragmentByTag(PollingQuestionFragment.class.getName());
        }
        return this.mQuestionFragment;
    }

    public void showQuestion(int index, int enterAnim, int exitAnim) {
        FragmentManager fm = this.getSupportFragmentManager();
        if (fm == null) {
            return;
        }
        IPollingQuestion question = this.getPollingQuestionAt(index);
        if (question == null) {
            return;
        }
        this.mQuestionFragment = new PollingQuestionFragment();
        Bundle args = new Bundle();
        args.putInt("questionIndex", index);
        args.putString(EXTRA_POLLING_ID, this.mPollingId);
        args.putString("questionId", question.getQuestionId());
        args.putBoolean(EXTRA_IS_READONLY, this.mIsReadOnly);
        args.putInt(EXTRA_READYONLY_MESSAGE_RES, this.mReadOnlyMessageRes);
        this.mQuestionFragment.setArguments(args);
        FragmentTransaction ft = fm.beginTransaction();
        ft.setCustomAnimations(enterAnim, exitAnim);
        ft.replace(0x1020002, (Fragment)this.mQuestionFragment, PollingQuestionFragment.class.getName());
        ft.commit();
    }

    protected void loadPollingMgr() {
    }

    public void setPollingMgr(IPollingMgr pollingMgr) {
        if (this.mPollingMgr != null) {
            this.mPollingMgr.removeListener(this);
        }
        this.mPollingMgr = pollingMgr;
        if (this.mPollingMgr != null) {
            this.mPollingMgr.addListener(this);
        }
    }

    public IPollingMgr getPollingMgr() {
        return this.mPollingMgr;
    }

    public int getQuestionCount() {
        IPollingDoc doc = this.getPollingDoc();
        if (doc == null) {
            return 0;
        }
        return doc.getQuestionCount();
    }

    private IPollingQuestion getPollingQuestionAt(int index) {
        IPollingDoc doc = this.getPollingDoc();
        if (doc == null) {
            return null;
        }
        IPollingQuestion question = doc.getQuestionAt(index);
        return question;
    }

    private IPollingDoc getPollingDoc() {
        if (this.mPollingMgr == null || this.mPollingId == null) {
            return null;
        }
        IPollingDoc doc = this.mPollingMgr.getPollingDocById(this.mPollingId);
        if (doc == null) {
            return null;
        }
        return doc;
    }

    public int getCurrentQuestionIndex() {
        PollingQuestionFragment f = this.getCurrentQuestionFragment();
        if (f == null) {
            return -1;
        }
        return f.getQuestionIndex();
    }

    public void showPreviousQuesion() {
        int idx = this.getCurrentQuestionIndex() - 1;
        if (idx >= 0) {
            this.showQuestion(idx, R.anim.zm_slide_in_left, R.anim.zm_slide_out_right);
        }
    }

    public void showNextQuestion() {
        int idx = this.getCurrentQuestionIndex() + 1;
        if (idx < this.getQuestionCount()) {
            this.showQuestion(idx, R.anim.zm_slide_in_right, R.anim.zm_slide_out_left);
        }
    }

    public void submitPolling() {
        if (this.mPollingMgr == null || this.mPollingId == null) {
            return;
        }
        this.mPollingMgr.submitPoll(this.mPollingId);
        this.showWaitingDownloadDialog();
    }

    private void showWaitingDownloadDialog() {
        if (this.mWaitingDialog != null) {
            return;
        }
        this.mWaitingDialog = new ProgressDialog((Context)this);
        this.mWaitingDialog.requestWindowFeature(1);
        this.mWaitingDialog.setMessage((CharSequence)this.getString(R.string.zm_msg_waiting));
        this.mWaitingDialog.setCanceledOnTouchOutside(false);
        this.mWaitingDialog.setCancelable(false);
        this.mWaitingDialog.show();
    }

    private void dismissWaitingDialog() {
        if (this.mWaitingDialog == null) {
            return;
        }
        this.mWaitingDialog.dismiss();
        this.mWaitingDialog = null;
    }
}

