/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.photopicker;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.request.RequestOptions;
import com.zipow.videobox.photopicker.OnPhotoPickerHoriItemCallback;
import java.io.File;
import java.util.List;
import us.zoom.androidlib.util.AndroidLifecycleUtils;
import us.zoom.videomeetings.R;

public class PhotoHorizentalAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private List<String> mSelectedPath;
    private RequestManager mGlide;
    private OnPhotoPickerHoriItemCallback mCallback;
    private int imageSize = 0;
    private int currentItem;

    public PhotoHorizentalAdapter(RequestManager glide, List<String> mSelectedPath, OnPhotoPickerHoriItemCallback callback) {
        this.mSelectedPath = mSelectedPath;
        this.mGlide = glide;
        this.mCallback = callback;
    }

    public ViewHolder onCreateViewHolder(ViewGroup viewGroup, int i) {
        View itemView = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.zm_picker_horizental_item_photo, viewGroup, false);
        ViewHolder holder = new ViewHolder(itemView);
        this.imageSize = viewGroup.getResources().getDimensionPixelSize(R.dimen.zm_picker_bottom_photo_size);
        return holder;
    }

    public void onBindViewHolder(ViewHolder vh, final int i) {
        boolean canLoadImage = AndroidLifecycleUtils.canLoadImage((Context)vh.imageView.getContext());
        if (canLoadImage) {
            RequestOptions options = new RequestOptions();
            options.centerCrop().dontAnimate().override(this.imageSize, this.imageSize).placeholder(R.drawable.zm_image_placeholder).error(R.drawable.zm_image_download_error);
            this.mGlide.setDefaultRequestOptions(options).load(new File(this.mSelectedPath.get(i))).thumbnail(0.2f).into(vh.imageView);
        }
        boolean canSelected = true;
        if (this.mCallback != null) {
            canSelected = this.mCallback.canSelected(this.mSelectedPath.get(i), i);
        }
        vh.coverView.setVisibility(canSelected ? 8 : 0);
        vh.imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                boolean canSelected = true;
                if (PhotoHorizentalAdapter.this.mCallback != null) {
                    canSelected = PhotoHorizentalAdapter.this.mCallback.canSelected((String)PhotoHorizentalAdapter.this.mSelectedPath.get(i), i);
                }
                if (!canSelected) {
                    return;
                }
                PhotoHorizentalAdapter.this.currentItem = i;
                if (PhotoHorizentalAdapter.this.mCallback != null) {
                    PhotoHorizentalAdapter.this.mCallback.onItemClick(view, (String)PhotoHorizentalAdapter.this.mSelectedPath.get(i), i);
                }
                PhotoHorizentalAdapter.this.notifyDataSetChanged();
            }
        });
        boolean isChecked = this.currentItem == i;
        vh.imageView.setSelected(isChecked);
    }

    public int getItemCount() {
        return this.mSelectedPath.size();
    }

    public void onViewRecycled(ViewHolder holder) {
        this.mGlide.clear((View)holder.imageView);
        super.onViewRecycled((RecyclerView.ViewHolder)holder);
    }

    public void setCurrentItem(int currentItem) {
        this.currentItem = currentItem;
        this.notifyDataSetChanged();
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        ImageView imageView;
        View coverView;

        public ViewHolder(View itemView) {
            super(itemView);
            this.imageView = (ImageView)itemView.findViewById(R.id.iv_photo);
            this.coverView = itemView.findViewById(R.id.cover);
        }
    }
}

