/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.photopicker;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.request.RequestOptions;
import com.zipow.videobox.photopicker.OnItemCheckStateChangedListener;
import com.zipow.videobox.photopicker.OnPhotoClickListener;
import com.zipow.videobox.photopicker.SelectableAdapter;
import com.zipow.videobox.photopicker.entity.Photo;
import com.zipow.videobox.photopicker.entity.PhotoDirectory;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.AndroidLifecycleUtils;
import us.zoom.videomeetings.R;

public class PhotoGridAdapter
extends SelectableAdapter<PhotoViewHolder> {
    private RequestManager mGlide;
    private OnItemCheckStateChangedListener mOnItemCheckStateChangedListener = null;
    private OnPhotoClickListener onPhotoClickListener = null;
    private View.OnClickListener onCameraClickListener = null;
    public static final int ITEM_TYPE_CAMERA = 100;
    public static final int ITEM_TYPE_PHOTO = 101;
    private static final int COL_NUMBER_DEFAULT = 3;
    private boolean hasCamera = true;
    private boolean previewEnable = true;
    private int mMaxSelectedCount = 9;
    private boolean checkStateEnable = true;
    private int imageSize;
    private int columnNumber = 3;

    public PhotoGridAdapter(Context context, RequestManager requestManager, List<PhotoDirectory> photoDirectories, int maxSelectedCount) {
        this.photoDirectories = photoDirectories;
        this.mGlide = requestManager;
        this.setColumnNumber(context, this.columnNumber);
        this.mMaxSelectedCount = maxSelectedCount;
    }

    public PhotoGridAdapter(Context context, RequestManager requestManager, List<PhotoDirectory> photoDirectories, ArrayList<String> orginalPhotos, int colNum, int maxSelectedCount) {
        this(context, requestManager, photoDirectories, maxSelectedCount);
        this.setColumnNumber(context, colNum);
        this.selectedPhotos = new ArrayList();
        if (orginalPhotos != null) {
            this.selectedPhotos.addAll(orginalPhotos);
        }
    }

    private void setColumnNumber(Context context, int columnNumber) {
        this.columnNumber = columnNumber;
        WindowManager wm = (WindowManager)context.getSystemService("window");
        if (wm != null) {
            DisplayMetrics metrics = new DisplayMetrics();
            wm.getDefaultDisplay().getMetrics(metrics);
            int widthPixels = metrics.widthPixels;
            this.imageSize = widthPixels / columnNumber;
        }
    }

    public int getItemViewType(int position) {
        return this.showCamera() && position == 0 ? 100 : 101;
    }

    public PhotoViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.zm_picker_item_photo, parent, false);
        PhotoViewHolder holder = new PhotoViewHolder(itemView);
        if (viewType == 100) {
            holder.vSelected.setVisibility(8);
            holder.ivPhoto.setScaleType(ImageView.ScaleType.CENTER);
            holder.ivPhoto.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (PhotoGridAdapter.this.onCameraClickListener != null) {
                        PhotoGridAdapter.this.onCameraClickListener.onClick(view);
                    }
                }
            });
        }
        return holder;
    }

    public void onBindViewHolder(final PhotoViewHolder holder, int position) {
        if (this.getItemViewType(position) == 101) {
            List<Photo> photos = this.getCurrentPhotos();
            final Photo photo = this.showCamera() ? photos.get(position - 1) : photos.get(position);
            boolean canLoadImage = AndroidLifecycleUtils.canLoadImage((Context)holder.ivPhoto.getContext());
            if (canLoadImage) {
                RequestOptions options = new RequestOptions();
                options.centerCrop().dontAnimate().override(this.imageSize, this.imageSize).placeholder(R.drawable.zm_image_placeholder).error(R.drawable.zm_image_download_error);
                this.mGlide.setDefaultRequestOptions(options).load(new File(photo.getPath())).thumbnail(0.5f).into(holder.ivPhoto);
            }
            boolean isChecked = this.isSelected(photo);
            holder.vSelected.setSelected(isChecked);
            holder.ivPhoto.setSelected(isChecked);
            holder.ivPhoto.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (PhotoGridAdapter.this.onPhotoClickListener != null) {
                        int pos = holder.getAdapterPosition();
                        if (PhotoGridAdapter.this.previewEnable) {
                            PhotoGridAdapter.this.onPhotoClickListener.onClick(view, pos, PhotoGridAdapter.this.showCamera());
                        } else {
                            holder.vSelected.performClick();
                        }
                    }
                }
            });
            holder.vSelected.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    boolean isCheckStateEnable;
                    int pos = holder.getAdapterPosition();
                    boolean isEnable = PhotoGridAdapter.this.canChangeCheckState(PhotoGridAdapter.this.getSelectedPhotos().size() + (PhotoGridAdapter.this.isSelected(photo) ? -1 : 1));
                    if (isEnable && PhotoGridAdapter.this.mMaxSelectedCount > 1) {
                        PhotoGridAdapter.this.toggleSelection(photo);
                        PhotoGridAdapter.this.notifyItemChanged(pos);
                    }
                    if (PhotoGridAdapter.this.mMaxSelectedCount <= 1) {
                        PhotoGridAdapter.this.clearSelection();
                        PhotoGridAdapter.this.toggleSelection(photo);
                        PhotoGridAdapter.this.notifyDataSetChanged();
                    }
                    if (PhotoGridAdapter.this.mOnItemCheckStateChangedListener != null) {
                        PhotoGridAdapter.this.mOnItemCheckStateChangedListener.onItemCheckStateChanged(pos, photo, PhotoGridAdapter.this.getSelectedPhotos().size() + (PhotoGridAdapter.this.isSelected(photo) ? -1 : 1));
                    }
                    if ((isCheckStateEnable = PhotoGridAdapter.this.isCheckStateEnable()) != PhotoGridAdapter.this.checkStateEnable) {
                        PhotoGridAdapter.this.notifyDataSetChanged();
                        PhotoGridAdapter.this.checkStateEnable = isCheckStateEnable;
                    }
                }
            });
            boolean itemCheckStateEnable = !this.checkStateEnable ? isChecked : this.checkStateEnable;
            holder.vSelected.setClickable(itemCheckStateEnable);
            holder.ivPhoto.setClickable(itemCheckStateEnable);
            holder.cover.setVisibility(itemCheckStateEnable ? 8 : 0);
        } else {
            holder.ivPhoto.setImageResource(R.drawable.zm_picker_camera);
        }
    }

    public boolean isCheckStateEnable() {
        int curSelectedCount = this.getSelectedItemCount();
        return curSelectedCount < this.mMaxSelectedCount || this.mMaxSelectedCount <= 1;
    }

    public boolean canChangeCheckState(int selectedItemCount) {
        return selectedItemCount <= this.mMaxSelectedCount || this.mMaxSelectedCount <= 1;
    }

    public void resetCheckState() {
        this.checkStateEnable = this.isCheckStateEnable();
    }

    public int getItemCount() {
        int photosCount;
        int n = photosCount = this.photoDirectories.size() == 0 ? 0 : this.getCurrentPhotos().size();
        if (this.showCamera()) {
            return photosCount + 1;
        }
        return photosCount;
    }

    public void setOnItemCheckStateChangedListener(OnItemCheckStateChangedListener onItemCheckStateChangedListener) {
        this.mOnItemCheckStateChangedListener = onItemCheckStateChangedListener;
    }

    public void setOnPhotoClickListener(OnPhotoClickListener onPhotoClickListener) {
        this.onPhotoClickListener = onPhotoClickListener;
    }

    public void setOnCameraClickListener(View.OnClickListener onCameraClickListener) {
        this.onCameraClickListener = onCameraClickListener;
    }

    public ArrayList<String> getSelectedPhotoPaths() {
        ArrayList<String> selectedPhotoPaths = new ArrayList<String>(this.getSelectedItemCount());
        for (String photo : this.selectedPhotos) {
            selectedPhotoPaths.add(photo);
        }
        return selectedPhotoPaths;
    }

    public void setSelectedPhotoPaths(List<String> paths) {
        if (this.selectedPhotos != null) {
            this.selectedPhotos.clear();
        } else {
            this.selectedPhotos = new ArrayList();
        }
        this.selectedPhotos.addAll(paths);
        this.notifyDataSetChanged();
    }

    public void setShowCamera(boolean hasCamera) {
        this.hasCamera = hasCamera;
    }

    public void setPreviewEnable(boolean previewEnable) {
        this.previewEnable = previewEnable;
    }

    public boolean showCamera() {
        return this.hasCamera && this.currentDirectoryIndex == 0;
    }

    public void onViewRecycled(PhotoViewHolder holder) {
        this.mGlide.clear((View)holder.ivPhoto);
        super.onViewRecycled((RecyclerView.ViewHolder)holder);
    }

    public static class PhotoViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView ivPhoto;
        private View vSelected;
        private View cover;

        public PhotoViewHolder(View itemView) {
            super(itemView);
            this.ivPhoto = (ImageView)itemView.findViewById(R.id.iv_photo);
            this.vSelected = itemView.findViewById(R.id.v_selected);
            this.cover = itemView.findViewById(R.id.cover);
        }
    }
}

