/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.pdf;

import android.content.Context;
import android.graphics.Bitmap;
import android.support.v4.view.PagerAdapter;
import android.util.AttributeSet;
import android.view.MotionEvent;
import com.zipow.videobox.pdf.PDFDisplayListener;
import com.zipow.videobox.pdf.PDFStatePagerAdapter;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMViewPager;

public class PDFViewPage
extends ZMViewPager
implements PDFStatePagerAdapter.PDFStatePagerAdapterListener,
PDFDisplayListener {
    private Context mContext;
    private String mFileName;
    private String mPassword;
    private PDFStatePagerAdapter mAdapter;
    private boolean mStarted = false;
    private float mLastTouchX = 0.0f;
    private final float TOUCH_SENS = 5.0f;
    private int mClickCount = 0;
    private SwitchPageRunnable mSwitchRunnable;
    private PDFViewPageListener mListener;
    private Runnable mClickRunnable = new Runnable(){

        @Override
        public void run() {
            if (PDFViewPage.this.mListener != null && PDFViewPage.this.mClickCount < 2) {
                PDFViewPage.this.mListener.onClickEvent();
            }
            PDFViewPage.this.mClickCount = 0;
        }
    };

    public PDFViewPage(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public PDFViewPage(Context context) {
        super(context);
        this.init(context);
    }

    private void init(Context context) {
        this.mContext = context;
        ZMActivity activity = (ZMActivity)this.mContext;
        this.mAdapter = new PDFStatePagerAdapter(activity.getSupportFragmentManager());
        this.setAdapter((PagerAdapter)this.mAdapter);
    }

    public void setPDFViewPageListener(PDFViewPageListener l) {
        this.mListener = l;
    }

    public boolean openFile(String file, String password) {
        if (file == null || file.length() <= 0) {
            return false;
        }
        if (this.mFileName != null && !this.mFileName.equals(file)) {
            this.closeFile();
        }
        if (this.mStarted) {
            return true;
        }
        this.mFileName = file;
        this.mPassword = password;
        boolean success = this.mAdapter.open(this.mFileName, this.mPassword, this, this);
        if (!success) {
            return false;
        }
        this.mStarted = true;
        return true;
    }

    public void closeFile() {
        if (this.mSwitchRunnable != null) {
            this.removeCallbacks(this.mSwitchRunnable);
        }
        if (this.mClickRunnable != null) {
            this.removeCallbacks(this.mClickRunnable);
        }
        if (this.mAdapter != null) {
            this.mAdapter.close();
        }
        this.mStarted = false;
    }

    public void loadPage(int page) {
        if (this.mAdapter == null) {
            return;
        }
        this.mAdapter.loadPage(page);
    }

    public boolean isStarted() {
        return this.mStarted;
    }

    public int getPageCount() {
        if (!this.mStarted || this.mAdapter == null) {
            return 0;
        }
        return this.mAdapter.getCount();
    }

    public boolean renderPage(int page, Bitmap bm) {
        if (bm == null || !this.mStarted || this.mAdapter == null) {
            return false;
        }
        return this.mAdapter.renderPage(page, bm);
    }

    @Override
    public void onPDFDisplayRefresh() {
        if (this.mListener != null) {
            this.mListener.onPDFDisplayRefresh();
        }
    }

    @Override
    public void onRenderPageErr(int pageIndex) {
        if (this.mListener != null) {
            this.mListener.onRenderPageErr(pageIndex);
        }
    }

    @Override
    public void onLoadPageErr(int pageIndex) {
        if (this.mListener != null) {
            this.mListener.onLoaderPageErr(pageIndex);
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        if (action == 0) {
            this.mLastTouchX = ev.getX();
        } else if (action == 1) {
            float newTouchX = ev.getX();
            if (Math.abs(newTouchX - this.mLastTouchX) < (float)UIUtil.dip2px((Context)this.mContext, (float)5.0f) && this.mListener != null) {
                ++this.mClickCount;
                this.removeCallbacks(this.mClickRunnable);
                this.postDelayed(this.mClickRunnable, 300L);
            } else {
                this.mClickCount = 0;
            }
            this.mLastTouchX = 0.0f;
        }
        return super.onInterceptTouchEvent(ev);
    }

    protected boolean dispatchGenericPointerEvent(MotionEvent event) {
        float vScroll;
        int action = event.getAction();
        if (action == 8 && !this.mAdapter.canPageVerticalScroll(vScroll = event.getAxisValue(9)) && vScroll != 0.0f) {
            boolean up;
            boolean bl = up = vScroll > 0.0f;
            if (this.mSwitchRunnable != null) {
                this.removeCallbacks(this.mSwitchRunnable);
                this.mSwitchRunnable.setSwitchFlag(up);
            } else {
                this.mSwitchRunnable = new SwitchPageRunnable(this);
                this.mSwitchRunnable.setSwitchFlag(up);
            }
            this.postDelayed(this.mSwitchRunnable, 50L);
        }
        return super.dispatchGenericPointerEvent(event);
    }

    protected class SwitchPageRunnable
    implements Runnable {
        private boolean mUp = false;
        private PDFViewPage mViewPage;

        public SwitchPageRunnable(PDFViewPage viewPage) {
            this.mViewPage = viewPage;
        }

        public void setSwitchFlag(boolean up) {
            this.mUp = up;
        }

        @Override
        public void run() {
            if (this.mViewPage == null || !this.mViewPage.isStarted()) {
                return;
            }
            if (!this.mUp) {
                int page = this.mViewPage.getCurrentItem() + 1;
                if (page < this.mViewPage.getPageCount()) {
                    this.mViewPage.setCurrentItem(page);
                }
            } else {
                int page = this.mViewPage.getCurrentItem() - 1;
                if (page >= 0) {
                    this.mViewPage.setCurrentItem(page);
                }
            }
        }
    }

    public static class SimplePDFViewPageListener
    implements PDFViewPageListener {
        @Override
        public void onClickEvent() {
        }

        @Override
        public void onPDFDisplayRefresh() {
        }

        @Override
        public void onRenderPageErr(int pageIndex) {
        }

        @Override
        public void onLoaderPageErr(int pageIndex) {
        }
    }

    public static interface PDFViewPageListener {
        public void onClickEvent();

        public void onPDFDisplayRefresh();

        public void onRenderPageErr(int var1);

        public void onLoaderPageErr(int var1);
    }
}

