/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.pdf;

import android.graphics.Bitmap;
import android.os.Handler;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;
import android.view.ViewGroup;
import com.zipow.videobox.pdf.PDFDisplayListener;
import com.zipow.videobox.pdf.PDFDoc;
import com.zipow.videobox.pdf.PDFManager;
import com.zipow.videobox.pdf.PDFPageFragment;
import java.util.HashMap;

public class PDFStatePagerAdapter
extends FragmentStatePagerAdapter {
    private static final String TAG = PDFStatePagerAdapter.class.getSimpleName();
    private String mFileName;
    private String mPassword;
    private PDFManager mPDFMgr;
    private PDFDoc mDocument;
    private int mPageCount;
    private int mDisplayPage;
    private boolean mSuccess = false;
    private PDFStatePagerAdapterListener mListener;
    private PDFDisplayListener mDisplayListener;
    private Handler mHandler = new Handler();
    private HashMap<Integer, PDFPageFragment> mPageFragments = new HashMap();
    private PDFDoc.PDFDocListener mPdfDocListener = new PDFDoc.PDFDocListener(){

        @Override
        public void onRenderPageErr(final int pageIndex) {
            PDFStatePagerAdapter.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (PDFStatePagerAdapter.this.mListener != null) {
                        PDFStatePagerAdapter.this.mListener.onRenderPageErr(pageIndex);
                    }
                }
            });
        }

        @Override
        public void onLoadPageErr(final int pageIndex) {
            PDFStatePagerAdapter.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (PDFStatePagerAdapter.this.mListener != null) {
                        PDFStatePagerAdapter.this.mListener.onLoadPageErr(pageIndex);
                    }
                }
            });
        }
    };

    public PDFStatePagerAdapter(FragmentManager fm) {
        super(fm);
    }

    public Fragment getItem(int page) {
        Fragment pageFragment;
        if (this.mPageFragments.containsKey(page) && (pageFragment = (Fragment)this.mPageFragments.get(page)) != null) {
            return pageFragment;
        }
        PDFPageFragment fragment = PDFPageFragment.newInstance(this.mFileName, this.mPassword, page);
        if (this.mPageFragments.containsKey(page)) {
            this.mPageFragments.remove(page);
        }
        this.mPageFragments.put(page, fragment);
        return fragment;
    }

    public void destroyItem(ViewGroup container, int page, Object object) {
        super.destroyItem(container, page, object);
        if (this.mPageFragments.containsKey(page)) {
            this.mPageFragments.remove(page);
        }
    }

    public int getCount() {
        return this.mPageCount;
    }

    public void setPrimaryItem(ViewGroup container, int page, Object object) {
        super.setPrimaryItem(container, page, object);
        this.mDisplayPage = page;
        this.refreshDisplayPage(page);
    }

    private void refreshDisplayPage(int page) {
        for (int key : this.mPageFragments.keySet()) {
            PDFPageFragment fragment = this.mPageFragments.get(key);
            if (key == page) {
                fragment.startDisplay(this.mDisplayListener);
                continue;
            }
            fragment.stopDisplay();
        }
    }

    public void close() {
        if (this.mDocument != null) {
            this.mPDFMgr.closeDocument(this.mDocument);
            this.mDocument = null;
        }
        PDFPageFragment.shutdownSingleExecutor();
        this.mSuccess = false;
    }

    public boolean open(String file, String password, PDFStatePagerAdapterListener l, PDFDisplayListener displayListener) {
        this.mFileName = file;
        this.mPassword = password;
        this.mListener = l;
        this.mDisplayListener = displayListener;
        this.mPDFMgr = PDFManager.getInstance();
        PDFPageFragment.startSingleExecutor();
        if (this.mFileName == null || this.mFileName.length() <= 0) {
            return false;
        }
        if (this.mSuccess) {
            return true;
        }
        this.mDocument = this.mPDFMgr.createDocument(this.mFileName, this.mPassword);
        if (this.mDocument == null) {
            return false;
        }
        this.mDocument.registerListener(this.mPdfDocListener);
        try {
            this.mDocument.openDoc();
            this.mPageCount = this.mDocument.getPageCount();
            this.mSuccess = true;
        }
        catch (Exception e) {
            return false;
        }
        this.notifyDataSetChanged();
        return true;
    }

    public boolean renderPage(int page, Bitmap bm) {
        if (bm == null || !this.mSuccess || this.mDocument == null || page >= this.mPageCount || page < 0) {
            return false;
        }
        long pdfBm = this.mDocument.renderPage(page, bm.getWidth(), bm.getHeight(), 0);
        boolean ret = this.mDocument.copyBitmap(pdfBm, bm);
        return ret;
    }

    public void loadPage(int page) {
        this.refreshDisplayPage(page);
    }

    public boolean canPageVerticalScroll(float dy) {
        PDFPageFragment fragment = this.mPageFragments.get(this.mDisplayPage);
        if (fragment == null) {
            return false;
        }
        return fragment.canScrollVertical((int)dy);
    }

    public static interface PDFStatePagerAdapterListener {
        public void onRenderPageErr(int var1);

        public void onLoadPageErr(int var1);
    }
}

