/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.pdf;

import com.zipow.videobox.pdf.PDFDoc;
import com.zipow.videobox.pdf.PdfiumSDK;
import java.util.concurrent.ConcurrentHashMap;

public class PDFManager {
    private static PDFManager instance = null;
    private boolean mSDKInitialled = false;
    private ConcurrentHashMap<String, PDFDoc> mPDFDocs = new ConcurrentHashMap();

    public static synchronized PDFManager getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new PDFManager();
        return instance;
    }

    private void initialSDK() {
        if (!this.mSDKInitialled) {
            PdfiumSDK.initLibrary(0);
            this.mSDKInitialled = true;
        }
    }

    private void destroySDK() {
        if (this.mSDKInitialled) {
            PdfiumSDK.destroyLibrary();
            this.mSDKInitialled = false;
        }
    }

    public PDFDoc openDocument(String file, String password) {
        PDFDoc doc = this.getDocument(file);
        if (doc == null) {
            doc = this.createDocument(file, password);
        }
        return doc;
    }

    public PDFDoc createDocument(String file, String password) {
        this.initialSDK();
        PDFDoc doc = new PDFDoc(file, password);
        this.mPDFDocs.put(file, doc);
        return doc;
    }

    public PDFDoc getDocument(String file) {
        if (file == null || file.length() <= 0) {
            return null;
        }
        if (this.mPDFDocs.containsKey(file)) {
            PDFDoc doc = this.mPDFDocs.get(file);
            return doc;
        }
        return null;
    }

    public void closeDocument(String file) {
        PDFDoc doc = this.getDocument(file);
        if (doc != null) {
            doc.close();
        }
        if (doc != null && this.mPDFDocs.containsValue(doc)) {
            this.mPDFDocs.remove(doc);
        }
        if (this.mPDFDocs.isEmpty()) {
            this.destroySDK();
        }
    }

    public void closeDocument(PDFDoc doc) {
        if (doc == null) {
            return;
        }
        doc.close();
        if (this.mPDFDocs.containsValue(doc)) {
            this.mPDFDocs.remove(doc);
        }
        if (this.mPDFDocs.isEmpty()) {
            this.destroySDK();
        }
    }

    public void closeAllDocuments() {
        for (PDFDoc doc : this.mPDFDocs.values()) {
            doc.close();
        }
        this.mPDFDocs.clear();
        this.destroySDK();
    }
}

