/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.pdf;

import android.graphics.Bitmap;
import com.zipow.videobox.pdf.PDFFileAccessException;
import com.zipow.videobox.pdf.PDFFormatException;
import com.zipow.videobox.pdf.PDFParameterException;
import com.zipow.videobox.pdf.PDFPasswordException;
import com.zipow.videobox.pdf.PDFUnknownErrorException;
import com.zipow.videobox.pdf.PdfiumSDK;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;

public class PDFDoc {
    public static final int PDF_PRINT_DPI = 72;
    private final String TAG = PDFDoc.class.getSimpleName();
    private static final int DEFAULT_ALPHA = 255;
    private static final long DEFAULT_BG_COLOR = -1L;
    private ListenerList mListeners = new ListenerList();
    private String mFileName;
    private String mPassword;
    private long mDocument = 0L;
    private int mPageCount = 0;
    private long[] mPageHandles;
    private Object mLock = new Object();
    private List<PDF_BITMAP> mPdfBitmaps = new ArrayList<PDF_BITMAP>();

    public PDFDoc(String file, String password) {
        this.mFileName = file;
        this.mPassword = password;
    }

    public String getFileName() {
        return this.mFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openDoc() throws PDFUnknownErrorException, PDFFileAccessException, PDFFormatException, PDFParameterException, PDFPasswordException {
        if (this.mFileName == null || this.mFileName.length() <= 0) {
            throw new PDFParameterException("File name Error");
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDocument != 0L) {
                return;
            }
            this.mDocument = PdfiumSDK.loadDocument(this.mFileName, this.mPassword);
            this.mPageCount = PdfiumSDK.getPageCount(this.mDocument);
            if (this.mPageCount <= 0) {
                this.close();
                this.mDocument = 0L;
                throw new PDFUnknownErrorException("Page numbers is 0!");
            }
            this.mPageHandles = new long[this.mPageCount];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.mLock;
        synchronized (object) {
            this.releaseAllPDFBitmaps();
            this.closeAllPages();
            PdfiumSDK.closeDocument(this.mDocument);
            this.mPageCount = 0;
            this.mPageHandles = null;
            this.mDocument = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPageCount() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPageCount;
        }
    }

    private boolean checkPageIndex(int pageIndex) {
        return this.mDocument != 0L && this.mPageCount > 0 && pageIndex < this.mPageCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long renderPage(int pageIndex, int width, int height, int rotateFlag) {
        if (pageIndex < 0 || width <= 0 || height <= 0) {
            return 0L;
        }
        long pdfBm = 0L;
        Object object = this.mLock;
        synchronized (object) {
            long page = this.getPage(pageIndex);
            if (page == 0L) {
                return 0L;
            }
            pdfBm = this.createPDFBitmap(width, height, 255);
            if (pdfBm == 0L) {
                this.notifyRenderPageErr(pageIndex);
                return 0L;
            }
            try {
                PdfiumSDK.FillPDFBitmapByRect(pdfBm, 0, 0, width, height, -1L);
                PdfiumSDK.renderPageBitmap(pdfBm, page, 0, 0, width, height, rotateFlag, 16);
            }
            catch (Exception e) {
                this.notifyRenderPageErr(pageIndex);
                return 0L;
            }
        }
        return pdfBm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyBitmap(long pdfBm, Bitmap bm) {
        if (bm == null || pdfBm == 0L || bm.getWidth() <= 0 || bm.getHeight() <= 0) {
            return false;
        }
        try {
            Object object = this.mLock;
            synchronized (object) {
                PdfiumSDK.copyPDFBitmap(pdfBm, bm);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releasePDFBitmap(long pdfBm) {
        if (pdfBm == 0L) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            PdfiumSDK.destroyFPDFBitmap(pdfBm);
        }
    }

    private long createPDFBitmap(int w, int h, int alpha) {
        if (w <= 0 || h <= 0) {
            return 0L;
        }
        long bitmap = 0L;
        try {
            bitmap = PdfiumSDK.createPDFBitmap(w, h, 255);
        }
        catch (Exception e) {
            return 0L;
        }
        return bitmap;
    }

    private void releaseAllPDFBitmaps() {
        for (PDF_BITMAP bm : this.mPdfBitmaps) {
            PdfiumSDK.destroyFPDFBitmap(bm.pdfBitmap);
        }
        this.mPdfBitmaps.clear();
    }

    private long getPage(int pageIndex) {
        if (!this.checkPageIndex(pageIndex)) {
            this.notifyLoadPageErr(pageIndex);
            return 0L;
        }
        long page = 0L;
        if (this.mPageHandles != null) {
            page = this.mPageHandles[pageIndex];
        }
        if (page == 0L) {
            try {
                page = PdfiumSDK.loadPage(this.mDocument, pageIndex);
            }
            catch (Exception e) {
                this.notifyLoadPageErr(pageIndex);
                return 0L;
            }
            this.mPageHandles[pageIndex] = page;
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openPage(int pageIndex) {
        long page = 0L;
        Object object = this.mLock;
        synchronized (object) {
            page = this.getPage(pageIndex);
        }
        return page != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getPageWidth(int pageIndex) throws PDFParameterException, PDFUnknownErrorException {
        double width = 0.0;
        Object object = this.mLock;
        synchronized (object) {
            long page = this.getPage(pageIndex);
            if (page == 0L) {
                throw new PDFUnknownErrorException("Get page error");
            }
            width = PdfiumSDK.getPageWidth(page);
        }
        return width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getPageHeight(int pageIndex) throws PDFParameterException, PDFUnknownErrorException {
        long page = 0L;
        double height = 0.0;
        Object object = this.mLock;
        synchronized (object) {
            page = this.getPage(pageIndex);
            if (page == 0L) {
                throw new PDFUnknownErrorException("Get page error");
            }
            height = PdfiumSDK.getPageHeight(page);
        }
        return height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closePage(int pageIndex) {
        Object object = this.mLock;
        synchronized (object) {
            this.releasePage(pageIndex);
        }
    }

    private void releasePage(int pageIndex) {
        if (!this.checkPageIndex(pageIndex)) {
            return;
        }
        long pageHandle = this.mPageHandles[pageIndex];
        if (pageHandle <= 0L) {
            return;
        }
        PdfiumSDK.closePage(pageHandle);
        this.mPageHandles[pageIndex] = 0L;
    }

    private void closeAllPages() {
        for (int index = 0; index < this.mPageCount; ++index) {
            this.closePage(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(PDFDocListener l) {
        if (l == null) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mListeners.add((IListener)l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(PDFDocListener l) {
        if (l == null) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mListeners.remove((IListener)l);
        }
    }

    private void notifyRenderPageErr(int pageIndex) {
        IListener[] listeners;
        for (IListener l : listeners = this.mListeners.getAll()) {
            ((PDFDocListener)l).onRenderPageErr(pageIndex);
        }
    }

    private void notifyLoadPageErr(int pageIndex) {
        IListener[] listeners;
        for (IListener l : listeners = this.mListeners.getAll()) {
            ((PDFDocListener)l).onLoadPageErr(pageIndex);
        }
    }

    public static interface PDFDocListener
    extends IListener {
        public void onRenderPageErr(int var1);

        public void onLoadPageErr(int var1);
    }

    private class PDF_BITMAP {
        public long pdfBitmap;
        public int width;
        public int height;
        public int alpha;

        public PDF_BITMAP(long bm, int w, int h, int alpha) {
            this.pdfBitmap = bm;
            this.width = w;
            this.height = h;
            this.alpha = alpha;
        }
    }
}

