/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.onedrive;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import com.zipow.videobox.onedrive.OneDrive;
import com.zipow.videobox.onedrive.OneDrivePicker;
import java.util.List;

public class OneDriveManager
implements OneDrive.StatusChangedListener {
    private static OneDriveManager INSTANCE = null;
    private Context mApplicationContext;
    private OneDrive mOneDrive = null;
    private OneDrive mOneDriveForBusiness = null;

    public OneDriveManager(Context application) {
        this.mApplicationContext = application;
    }

    public static synchronized OneDriveManager getInstance(Context applicationContext) {
        if (INSTANCE == null) {
            INSTANCE = new OneDriveManager(applicationContext);
        }
        return INSTANCE;
    }

    public static synchronized void release() {
        if (INSTANCE != null) {
            INSTANCE.close();
            INSTANCE = null;
        }
    }

    private void close() {
        if (this.mOneDrive != null) {
            this.mOneDrive.logout();
        }
    }

    public OneDrive createOneDrive(boolean isBusiness) {
        if (isBusiness) {
            this.mOneDriveForBusiness = new OneDrive(this.mApplicationContext, this, true);
            return this.mOneDriveForBusiness;
        }
        this.mOneDrive = new OneDrive(this.mApplicationContext, this, false);
        return this.mOneDrive;
    }

    @Override
    public void onLogout(OneDrive drive) {
        if (drive == this.mOneDrive) {
            this.mOneDrive = null;
        }
    }

    public static boolean isLoginSupported(Context context, boolean isBusiness) {
        return OneDriveManager.canAuthViaBrowser(context) || OneDrivePicker.hasPicker(context, isBusiness);
    }

    public static boolean canAuthViaBrowser(Context context) {
        PackageManager pm = context.getPackageManager();
        if (pm == null) {
            return false;
        }
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"https://login.live.com/oauth20_authorize.srf"));
        List list = pm.queryIntentActivities(intent, 65536);
        return list != null && list.size() > 0;
    }
}

