/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.onedrive;

import android.content.Context;
import android.content.SharedPreferences;
import com.onedrive.sdk.authentication.ADALAuthenticator;
import com.onedrive.sdk.authentication.IAuthenticator;
import com.onedrive.sdk.authentication.MSAAuthenticator;
import com.onedrive.sdk.core.DefaultClientConfig;
import com.onedrive.sdk.core.IClientConfig;
import com.onedrive.sdk.logger.LoggerLevel;
import com.zipow.videobox.util.ZMWebUtil;
import us.zoom.androidlib.util.StringUtil;

public class OneDriveConfig {
    private static String ZOOM_CLIENT_ID = "0000000044144B09";
    private static String mClientId;
    private static final String ONEDRIVE_CLIENT_ID_NAME = "one_drive_client_id_name";
    private static final String ONEDRIVE_CLIENT_ID_KEY = "one_drive_client_id_key";
    private static String ZOOM_BUSINESS_CLIENT_ID;
    private static String mBusinessClientId;
    private static final String ONEDRIVE_BUSINESS_CLIENT_ID_NAME = "one_drive_business_client_id_name";
    private static final String ONEDRIVE_BUSINESS_CLIENT_ID_KEY = "one_drive_business_client_id_key";
    public static final String[] SCOPES;

    private OneDriveConfig() {
        throw new AssertionError((Object)"Unable to create Config object.");
    }

    public static IClientConfig createConfig(final Context context) {
        MSAAuthenticator msaAuthenticator = new MSAAuthenticator(){

            public String getClientId() {
                return OneDriveConfig.getClientID(context);
            }

            public String[] getScopes() {
                return SCOPES;
            }
        };
        IClientConfig config = DefaultClientConfig.createWithAuthenticator((IAuthenticator)msaAuthenticator);
        config.getLogger().setLoggingLevel(LoggerLevel.Debug);
        return config;
    }

    public static IClientConfig createBusinessConfig(final Context context) {
        ADALAuthenticator msaAuthenticator = new ADALAuthenticator(){

            public String getClientId() {
                return OneDriveConfig.getBusinessClientID(context);
            }

            protected String getRedirectUrl() {
                return ZMWebUtil.getWebDomainWithHttps();
            }
        };
        IClientConfig config = DefaultClientConfig.createWithAuthenticator((IAuthenticator)msaAuthenticator);
        config.getLogger().setLoggingLevel(LoggerLevel.Debug);
        return config;
    }

    public static boolean setClientID(Context context, String clientId) {
        if (context == null) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)clientId)) {
            mClientId = null;
            SharedPreferences prefs = context.getSharedPreferences(ONEDRIVE_CLIENT_ID_NAME, 0);
            SharedPreferences.Editor editor = prefs.edit();
            editor.clear();
            editor.commit();
            return false;
        }
        mClientId = clientId;
        SharedPreferences prefs = context.getSharedPreferences(ONEDRIVE_CLIENT_ID_NAME, 0);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString(ONEDRIVE_CLIENT_ID_KEY, clientId);
        editor.commit();
        return true;
    }

    public static boolean setBusinessClientID(Context context, String clientId) {
        if (context == null) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)clientId)) {
            mBusinessClientId = null;
            SharedPreferences prefs = context.getSharedPreferences(ONEDRIVE_BUSINESS_CLIENT_ID_NAME, 0);
            SharedPreferences.Editor editor = prefs.edit();
            editor.clear();
            editor.commit();
            return false;
        }
        mBusinessClientId = clientId;
        SharedPreferences prefs = context.getSharedPreferences(ONEDRIVE_BUSINESS_CLIENT_ID_NAME, 0);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString(ONEDRIVE_BUSINESS_CLIENT_ID_KEY, clientId);
        editor.commit();
        return true;
    }

    public static String getClientID(Context context) {
        if (context == null) {
            return null;
        }
        if ("us.zoom.videomeetings".equals(context.getPackageName())) {
            return ZOOM_CLIENT_ID;
        }
        if (mClientId == null) {
            SharedPreferences prefs = context.getSharedPreferences(ONEDRIVE_CLIENT_ID_NAME, 0);
            mClientId = prefs.getString(ONEDRIVE_CLIENT_ID_KEY, null);
        }
        return mClientId;
    }

    public static String getBusinessClientID(Context context) {
        if (context == null) {
            return null;
        }
        if ("us.zoom.videomeetings".equals(context.getPackageName())) {
            return ZOOM_BUSINESS_CLIENT_ID;
        }
        if (mBusinessClientId == null) {
            SharedPreferences prefs = context.getSharedPreferences(ONEDRIVE_BUSINESS_CLIENT_ID_NAME, 0);
            mBusinessClientId = prefs.getString(ONEDRIVE_BUSINESS_CLIENT_ID_KEY, null);
        }
        return mBusinessClientId;
    }

    static {
        ZOOM_BUSINESS_CLIENT_ID = "091b0b9b-95c6-4e3c-a7cf-de68385814bc";
        SCOPES = new String[]{"wl.signin", "wl.basic", "onedrive.appfolder", "onedrive.readwrite", "wl.offline_access", "wl.skydrive_update", "wl.contacts_create", "wl.photos", "wl.contacts_photos", "wl.contacts_skydrive"};
    }
}

