/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.mainboard;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.os.Build;
import android.os.Handler;
import android.os.RemoteException;
import android.util.Log;
import com.zipow.cmmlib.AppContext;
import com.zipow.cmmlib.Logger;
import com.zipow.cmmlib.ZoomAppPropData;
import com.zipow.nydus.UVCDevice;
import com.zipow.nydus.UVCPermissionUtil;
import com.zipow.nydus.UVCUtil;
import com.zipow.nydus.VideoCapturer;
import com.zipow.videobox.IConfService;
import com.zipow.videobox.IPTService;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.ConfIPCPort;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.confapp.ZoomShareUI;
import com.zipow.videobox.confapp.bo.BOUI;
import com.zipow.videobox.confapp.poll.PollingMgr;
import com.zipow.videobox.confapp.poll.PollingUI;
import com.zipow.videobox.ptapp.ABContactsHelper;
import com.zipow.videobox.ptapp.AutoLogoffChecker;
import com.zipow.videobox.ptapp.AutoStreamConflictChecker;
import com.zipow.videobox.ptapp.PT4SIPIPCPort;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTIPCPort;
import com.zipow.videobox.ptapp.PTSettingHelper;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.RevokeTokenAutoLogoffChecker;
import com.zipow.videobox.sip.client.SIPIPCPort;
import com.zipow.videobox.util.AppStateMonitor;
import com.zipow.videobox.util.IZMResourcesLoader;
import com.zipow.videobox.util.LogUtil;
import com.zipow.videobox.util.PreferenceUtil;
import com.zipow.videobox.util.RawFileUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.OsUtil;
import us.zoom.androidlib.util.PhoneNumberUtil;
import us.zoom.androidlib.util.ResourcesUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.util.ZMLog;
import us.zoom.cptshare.AndroidContext;
import us.zoom.videomeetings.R;

public class Mainboard
implements AppStateMonitor.IAppStateListener {
    private static final String TAG = Mainboard.class.getSimpleName();
    public static final String PT_MAINBOARD_NAME = "zChatApp";
    public static final String CONF_MAINBOARD_NAME = "zVideoApp";
    public static final String SIP_MAINBOARD_NAME = "zSipApp";
    public static final String SDK_MAINBOARD_NAME = "zSdkApp";
    private static Mainboard instancePTMainboard = null;
    private static Mainboard instanceConfMainboard = null;
    private static Mainboard instanceSipMainboard = null;
    private static Mainboard instanceSDKMainboard = null;
    private boolean mIsSDKConfAppCreated = false;
    private boolean mIsSDKConfModulesLoaded = false;
    private static boolean sIsNativeCrashed = false;
    private Context mContext;
    private String mName;
    private boolean mInitialized = false;
    private int mNetType = 0;
    private BroadcastReceiver mNetworkStateReceiver;
    private Handler mHandler = new Handler();
    private UVCPermissionUtil mUVCPermissionUtil;
    private UVCUtil.IUVCListener mUVCListener;
    private Runnable mRunnableRequestUVCPermission = new Runnable(){

        @Override
        public void run() {
            Set<UsbDevice> devices = Mainboard.this.mUVCPermissionUtil.getDevicesWithPermissionNotRequested();
            if (devices.size() > 0) {
                Mainboard.this.mUVCPermissionUtil.requestPermission(devices.iterator().next());
            }
        }
    };

    private Mainboard(String name, Context context) {
        this.mName = name;
        this.mContext = context;
    }

    public boolean isInitialized() {
        return this.mInitialized;
    }

    public static synchronized Mainboard getMainboard() {
        VideoBoxApplication app = VideoBoxApplication.getInstance();
        if (app == null) {
            return null;
        }
        if (app.isSDKMode()) {
            if (instanceSDKMainboard == null) {
                instanceSDKMainboard = new Mainboard(SDK_MAINBOARD_NAME, (Context)app);
            }
            return instanceSDKMainboard;
        }
        if (app.isPTApp()) {
            if (instancePTMainboard == null) {
                instancePTMainboard = new Mainboard(PT_MAINBOARD_NAME, (Context)app);
            }
            return instancePTMainboard;
        }
        if (app.isConfApp()) {
            if (instanceConfMainboard == null) {
                instanceConfMainboard = new Mainboard(CONF_MAINBOARD_NAME, (Context)app);
            }
            return instanceConfMainboard;
        }
        if (app.isSipApp()) {
            if (instanceSipMainboard == null) {
                instanceSipMainboard = new Mainboard(SIP_MAINBOARD_NAME, (Context)app);
            }
            return instanceSipMainboard;
        }
        return null;
    }

    public void initialize(String commandLine) {
        if (this.mInitialized) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.mNetType = NetworkUtil.getDataNetworkType((Context)VideoBoxApplication.getInstance());
        try {
            this.loadNativeModules();
        }
        catch (Exception e) {
            VideoBoxApplication.getInstance().enableWakeUpMessagesReceiver(false);
            VideoBoxApplication.getInstance().exit();
        }
        int processType = 0;
        if (this.isPTMainboard() || this.isSDKMainboard()) {
            processType = 1;
            PTIPCPort.getInstance().initialize();
            PT4SIPIPCPort.getInstance().initialize();
            if (!OsUtil.isAtLeastN()) {
                VideoCapturer.getInstance().initCameraCapabilities();
            }
        } else if (this.isConfMainboard()) {
            processType = 2;
            ConfUI.getInstance().initialize();
            ConfIPCPort.getInstance().initialize();
            VideoCapturer.getInstance().initCameraCapabilities();
        } else if (this.isSipMainboard()) {
            SIPIPCPort.getInstance().initialize();
        }
        if (!this.isSDKMainboard()) {
            Mainboard.installNativeCrashHandler();
        }
        this.initCommonResources();
        if (this.isConfMainboard() || this.isSDKMainboard()) {
            this.initConfResources();
        }
        if (this.isSipMainboard()) {
            this.initSipResource();
        }
        byte[] configData = this.loadConfigData(this.mContext);
        if (commandLine == null) {
            commandLine = "";
        }
        int ret = this.initMainboard(this.mContext.getPackageName(), this.mName, configData, this.commandLineToArgs(commandLine), processType);
        this.mInitialized = true;
        if (this.isPTMainboard()) {
            this.checkUpgradeSettingsData();
            PTUI.getInstance().initialize();
            PTApp.getInstance().initialize();
            PTApp.getInstance().setLanguageIdAsSystemConfiguration();
            this.startListenNetworkState();
            this.initUVCUtils();
            AutoLogoffChecker.getInstance().startChecker();
            AutoStreamConflictChecker.getInstance().startChecker();
            RevokeTokenAutoLogoffChecker.getInstance().startChecker();
        } else if (this.isConfMainboard()) {
            ConfMgr.getInstance().initialize();
            ConfMgr.getInstance().setLanguageIdAsSystemConfiguration();
            ConfUI.getInstance().notifyNetworkType();
            PollingMgr pollMgr = ConfMgr.getInstance().getPollObj();
            if (pollMgr != null) {
                pollMgr.setPollingUI(PollingUI.getInstance());
            }
        } else if (this.isSDKMainboard()) {
            this.checkUpgradeSettingsData();
            PTUI.getInstance().initialize();
            PTApp.getInstance().initialize();
            PTApp.getInstance().setLanguageIdAsSystemConfiguration();
            this.startListenNetworkState();
            this.initUVCUtils();
            AutoLogoffChecker.getInstance().startChecker();
        }
        this.initLog();
        this.startToListenActiveState();
        ZMActivity.addGlobalActivityListener((ZMActivity.GlobalActivityListener)new ZMActivity.GlobalActivityListener(){

            public void onActivityMoveToFront(ZMActivity activity) {
                if (Mainboard.this.isConfMainboard()) {
                    IPTService ptService = VideoBoxApplication.getInstance().getPTService();
                    if (ptService != null) {
                        try {
                            ptService.onConfUIMoveToFront(activity.getClass().getName());
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                    AppStateMonitor.getInstance().onConfUIMoveToFront();
                } else if (Mainboard.this.isPTMainboard()) {
                    IConfService confService = VideoBoxApplication.getInstance().getConfService();
                    if (confService != null) {
                        try {
                            confService.onPTUIMoveToFront(activity.getClass().getName());
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                    AppStateMonitor.getInstance().onPTUIMoveToFront();
                }
            }

            public void onUIMoveToBackground() {
                if (Mainboard.this.isConfMainboard()) {
                    IPTService ptService = VideoBoxApplication.getInstance().getPTService();
                    if (ptService != null) {
                        try {
                            ptService.onConfUIMoveToBackground();
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                    AppStateMonitor.getInstance().onConfUIMoveToBackground();
                } else if (Mainboard.this.isPTMainboard()) {
                    IConfService confService = VideoBoxApplication.getInstance().getConfService();
                    if (confService != null) {
                        try {
                            confService.onPTUIMoveToBackground();
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                    AppStateMonitor.getInstance().onPTUIMoveToBackground();
                }
            }

            public void onUserActivityOnUI() {
            }
        });
    }

    public boolean isSDKConfAppCreated() {
        return this.mIsSDKConfAppCreated;
    }

    public void createConfAppForSdk(String commandLine) {
        if (this.mIsSDKConfAppCreated) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.mNetType = NetworkUtil.getDataNetworkType((Context)VideoBoxApplication.getInstance());
        if (!this.mIsSDKConfModulesLoaded) {
            try {
                this.loadSDKConfAppNativeModules();
                this.mIsSDKConfModulesLoaded = true;
            }
            catch (Exception e) {
                VideoBoxApplication.getInstance().enableWakeUpMessagesReceiver(false);
                VideoBoxApplication.getInstance().exit();
            }
        }
        ConfUI.getInstance().initialize();
        ConfIPCPort.getInstance().initialize();
        byte[] configData = this.loadConfigDataForSDKConfApp(this.mContext);
        if (commandLine == null) {
            commandLine = "";
        }
        this.initConfModule4SingleProcessImpl(configData, this.commandLineToArgs(commandLine));
        ConfMgr.getInstance().initialize();
        ConfMgr.getInstance().setLanguageIdAsSystemConfiguration();
        ConfUI.getInstance().notifyNetworkType();
        PollingMgr pollMgr = ConfMgr.getInstance().getPollObj();
        if (pollMgr != null) {
            pollMgr.setPollingUI(PollingUI.getInstance());
        }
        this.mIsSDKConfAppCreated = true;
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null) {
            confContext.configCustomizedUIMode(PreferenceUtil.readBooleanValue("sdk_use_customized_meeting_ui", false));
        }
    }

    public void termConfAppForSDK() {
        if (!this.mIsSDKConfAppCreated) {
            return;
        }
        this.termConfModule4SingleProcessImpl();
        ZoomShareUI.clearInstance();
        ConfUI.getInstance().cleanListeners();
        ConfUI.clearInstance();
        BOUI.clearInstance();
        ConfMgr.clearInstance();
        ConfIPCPort.clearInstance();
        UVCDevice uvcDevice = UVCDevice.getInstance((Context)VideoBoxApplication.getInstance());
        if (uvcDevice != null) {
            UVCDevice.getInstance((Context)VideoBoxApplication.getInstance()).unInit();
            UVCDevice.clearInstance();
        }
        UIUtil.stopProximityScreenOffWakeLock();
        VideoCapturer.clearInstance();
        this.mIsSDKConfAppCreated = false;
    }

    private void initCommonResources() {
        RawFileUtil.installRawFile((Context)VideoBoxApplication.getInstance(), R.raw.zm_zcacert, "zcacert.pem");
        RawFileUtil.installRawFile((Context)VideoBoxApplication.getInstance(), R.raw.zm_zxmpproot, "ZXMPPROOT.cer");
        RawFileUtil.installRawFile((Context)VideoBoxApplication.getInstance(), R.raw.zm_domain_cert_zoom, "domain_cert_zoom.us.pem");
        String loaderClass = ResourcesUtil.getString((Context)VideoBoxApplication.getInstance(), (int)R.string.zm_config_ext_common_resources_loader);
        if (!StringUtil.isEmptyOrNull((String)loaderClass)) {
            try {
                Class<?> clazz = Class.forName(loaderClass);
                IZMResourcesLoader loader = (IZMResourcesLoader)clazz.newInstance();
                loader.loadResources((Context)VideoBoxApplication.getInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void requestPermissionForAllUVCDevices() {
        if (UIUtil.isTV((Context)this.mContext)) {
            return;
        }
        if (ResourcesUtil.getBoolean((Context)this.mContext, (int)R.bool.zm_config_no_uvc_camera, (boolean)false)) {
            return;
        }
        this.mHandler.removeCallbacks(this.mRunnableRequestUVCPermission);
        this.mHandler.postDelayed(this.mRunnableRequestUVCPermission, 1000L);
    }

    @SuppressLint(value={"NewApi"})
    private void initUVCUtils() {
        if (Build.VERSION.SDK_INT >= UVCUtil.getMinimumSupportedSdkInt()) {
            this.mUVCListener = new UVCUtil.SimpleUVCListener(){

                @Override
                public void onDeviceAttached(UsbDevice device) {
                    if (VideoBoxApplication.getInstance().isAtFront()) {
                        Mainboard.this.requestPermissionForAllUVCDevices();
                    }
                }

                @Override
                public void onPermissionGranted(UsbDevice device, boolean granted) {
                    if (Mainboard.this.mUVCPermissionUtil != null) {
                        Mainboard.this.requestPermissionForAllUVCDevices();
                    }
                }
            };
        }
    }

    private void initConfResources() {
        RawFileUtil.installRawFile((Context)VideoBoxApplication.getInstance(), R.raw.zm_dingdong, "dingdong.pcm");
        RawFileUtil.installRawFile((Context)VideoBoxApplication.getInstance(), R.raw.zm_dingdong1, "dingdong1.pcm");
        RawFileUtil.installRawFile((Context)VideoBoxApplication.getInstance(), R.raw.zm_leave, "leave.pcm");
        RawFileUtil.installRawFile((Context)VideoBoxApplication.getInstance(), R.raw.zm_record_start, "record_start.pcm");
        RawFileUtil.installRawFile((Context)VideoBoxApplication.getInstance(), R.raw.zm_record_stop, "record_stop.pcm");
    }

    private void initSipResource() {
        RawFileUtil.installRawFile((Context)VideoBoxApplication.getInstance(), R.raw.zm_sip_dtmf_a, "dtmf_a.wav");
        RawFileUtil.installRawFile((Context)VideoBoxApplication.getInstance(), R.raw.zm_ring, "ring.pcm");
    }

    private void checkUpgradeSettingsData() {
        ZoomAppPropData propData = ZoomAppPropData.getInstance();
        if (propData == null) {
            return;
        }
        String version = propData.queryWithKey("android.settings_version", "2.0");
        if ("2.0".equals(version)) {
            boolean alertIMMsg = PreferenceUtil.readBooleanValue("alert_im_msg", true);
            PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
            if (settingHelper == null) {
                return;
            }
            settingHelper.setShowIMMessageReminder(alertIMMsg);
            propData.setKeyValue("android.settings_version", "2.5");
            String savedName = PreferenceUtil.readStringValue("screen_name", "");
            String userDefaultName = PTApp.getInstance().getDeviceUserName();
            if (StringUtil.isEmptyOrNull((String)userDefaultName)) {
                if (!StringUtil.isEmptyOrNull((String)savedName)) {
                    PTApp.getInstance().setDeviceUserName(savedName);
                } else {
                    String name = Mainboard.getDeviceDefaultName();
                    PTApp.getInstance().setDeviceUserName(name);
                }
            }
        } else if ("2.1".equals(version)) {
            String userDefaultName = PTApp.getInstance().getDeviceUserName();
            String defNameV2_1 = Mainboard.getDeviceDefaultNameV2_1();
            if (defNameV2_1.equals(userDefaultName)) {
                String name = Mainboard.getDeviceDefaultName();
                PTApp.getInstance().setDeviceUserName(name);
            } else {
                PreferenceUtil.saveBooleanValue("is_device_name_customized", true);
            }
            propData.setKeyValue("android.settings_version", "2.5");
        } else if ("2.5".equals(version)) {
            this.mapDeviceSettingsToZoom();
        }
        ABContactsHelper contactsHelper = PTApp.getInstance().getABContactsHelper();
        if (contactsHelper != null && contactsHelper.needValidatePhoneNumber()) {
            String number;
            String countryCode;
            String fullNumber = contactsHelper.getVerifiedPhoneNumber();
            if (!StringUtil.isEmptyOrNull((String)fullNumber) && !StringUtil.isEmptyOrNull((String)(countryCode = PhoneNumberUtil.getCountryCodeFromFormatedPhoneNumber((String)fullNumber))) && (number = fullNumber.substring(countryCode.length() + 1)).startsWith("0")) {
                number = number.substring(1);
                fullNumber = "+" + countryCode + number;
            }
            if (fullNumber == null) {
                fullNumber = "";
            }
            contactsHelper.updateValidatePhoneNumber(fullNumber);
        }
    }

    private void mapDeviceSettingsToZoom() {
        boolean isDeviceNameCustomized = PreferenceUtil.readBooleanValue("is_device_name_customized", false);
        if (!isDeviceNameCustomized) {
            String name = Mainboard.getDeviceDefaultName();
            PTApp.getInstance().setDeviceUserName(name);
        }
    }

    private static String getDeviceDefaultNameV2_1() {
        StringBuilder name = new StringBuilder();
        if (!"Unknown".equalsIgnoreCase(Build.MANUFACTURER)) {
            name.append(Build.MANUFACTURER).append(" ");
        }
        name.append(Build.MODEL);
        return name.toString();
    }

    public static String getDeviceDefaultName() {
        String name = Mainboard.getLocalBluetoothName();
        if (StringUtil.isEmptyOrNull((String)name)) {
            StringBuilder sbName = new StringBuilder();
            String manufacturer = Build.MANUFACTURER;
            String model = Build.MODEL;
            if (StringUtil.isEmptyOrNull((String)manufacturer)) {
                manufacturer = "Unknown";
            }
            if (StringUtil.isEmptyOrNull((String)model)) {
                model = "Unknown";
            }
            if (!"Unknown".equalsIgnoreCase(manufacturer)) {
                if ("samsung".equalsIgnoreCase(manufacturer)) {
                    sbName.append("Samsung ");
                } else if (!model.toLowerCase().startsWith(manufacturer.toLowerCase())) {
                    sbName.append(manufacturer).append(" ");
                }
            }
            sbName.append(model);
            name = sbName.toString();
        }
        return name;
    }

    private static String getLocalBluetoothName() {
        try {
            BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            if (bluetoothAdapter == null) {
                return null;
            }
            String name = bluetoothAdapter.getName();
            return name;
        }
        catch (Exception e) {
            ZMLog.w((String)TAG, (Throwable)e, (String)"getLocalBluetoothName exception", (Object[])new Object[0]);
            return null;
        }
    }

    private void initLog() {
        Logger logger = Logger.getInstance();
        AppContext appContext = new AppContext("config");
        String enableLog = appContext.queryWithKey("enableLog", AppContext.APP_NAME_CHAT);
        String logLevel = appContext.queryWithKey("logLevel", AppContext.APP_NAME_CHAT);
        if ("true".equals(enableLog)) {
            logger.setEnabled(true);
        } else {
            logger.setEnabled(false);
        }
        if (logLevel == null || logLevel.length() == 0) {
            logger.setLevel(1);
        } else if ("info".equals(logLevel)) {
            logger.setLevel(1);
        } else if ("warning".equals(logLevel)) {
            logger.setLevel(2);
        } else {
            logger.setLevel(1);
        }
        logger.startNativeLog(true);
    }

    private String[] commandLineToArgs(String commandLine) {
        if (commandLine == null) {
            return null;
        }
        commandLine = "mainboard " + commandLine;
        String[] args = commandLine.split("\\s+");
        return args;
    }

    private boolean isPTMainboard() {
        return PT_MAINBOARD_NAME.equals(this.mName);
    }

    private boolean isConfMainboard() {
        return CONF_MAINBOARD_NAME.equals(this.mName);
    }

    private boolean isSipMainboard() {
        return SIP_MAINBOARD_NAME.equals(this.mName);
    }

    private boolean isSDKMainboard() {
        return SDK_MAINBOARD_NAME.equals(this.mName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadConfigData(Context context) {
        int configFile = 0;
        if (this.isPTMainboard()) {
            configFile = R.raw.zm_modules_chat;
        } else if (this.isConfMainboard()) {
            configFile = this.isNeonSupported() ? R.raw.zm_modules_video_neon : R.raw.zm_modules_video;
        } else if (this.isSipMainboard()) {
            configFile = this.isNeonSupported() ? R.raw.zm_modules_sip_neon : R.raw.zm_modules_sip;
        } else if (this.isSDKMainboard()) {
            configFile = context.getResources().getIdentifier("zm_modules_chat_sdk", "raw", context.getPackageName());
        } else {
            return null;
        }
        InputStream is = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            is = VideoBoxApplication.getInstance().getResources().openRawResource(configFile);
            byte[] buffer = new byte[1024];
            int len = 0;
            do {
                if ((len = is.read(buffer)) <= 0) continue;
                bos.write(buffer, 0, len);
            } while (len > 0);
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        byte[] configData = bos.toByteArray();
        return configData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadConfigDataForSDKConfApp(Context context) {
        int configFile = 0;
        configFile = this.isNeonSupported() ? context.getResources().getIdentifier("zm_modules_video_neon_sdk", "raw", context.getPackageName()) : context.getResources().getIdentifier("zm_modules_video_sdk", "raw", context.getPackageName());
        InputStream is = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            is = VideoBoxApplication.getInstance().getResources().openRawResource(configFile);
            byte[] buffer = new byte[1024];
            int len = 0;
            do {
                if ((len = is.read(buffer)) <= 0) continue;
                bos.write(buffer, 0, len);
            } while (len > 0);
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        byte[] configData = bos.toByteArray();
        return configData;
    }

    private void loadNativeModules() {
        long startTime = System.currentTimeMillis();
        if (this.isPTMainboard()) {
            System.loadLibrary("crypto_sb");
            System.loadLibrary("ssl_sb");
            System.loadLibrary("cmmlib");
            System.loadLibrary("zoom_tp");
            System.loadLibrary("zWebService");
            System.loadLibrary("zoom");
            System.loadLibrary("zAutoUpdate");
            System.loadLibrary(PT_MAINBOARD_NAME);
            System.loadLibrary("zChatUI");
            System.loadLibrary("zLoader");
            System.loadLibrary("zData");
        } else if (this.isConfMainboard()) {
            System.loadLibrary("crypto_sb");
            System.loadLibrary("ssl_sb");
            System.loadLibrary("cmmlib");
            System.loadLibrary("zoom_tp");
            System.loadLibrary("zWebService");
            System.loadLibrary("zlt");
            System.loadLibrary("nydus");
            System.loadLibrary("zoom");
            System.loadLibrary(CONF_MAINBOARD_NAME);
            System.loadLibrary("zVideoUI");
            System.loadLibrary("zLoader");
            System.loadLibrary("zData");
            System.loadLibrary("ssb_sdk");
            System.loadLibrary("annotate");
            if (this.isNeonSupported()) {
                System.loadLibrary("viper_neon");
                System.loadLibrary("mcm_neon");
            } else {
                System.loadLibrary("viper");
                System.loadLibrary("mcm");
            }
            AndroidContext.initialize((Context)VideoBoxApplication.getInstance());
        } else if (this.isSipMainboard()) {
            System.loadLibrary("crypto_sb");
            System.loadLibrary("ssl_sb");
            System.loadLibrary("cmmlib");
            System.loadLibrary("zoom_tp");
            System.loadLibrary("zWebService");
            System.loadLibrary("zoom");
            System.loadLibrary("zLoader");
            System.loadLibrary("zData");
            System.loadLibrary(SIP_MAINBOARD_NAME);
            System.loadLibrary("zSipCallApp");
            System.loadLibrary("sipsdk");
            System.loadLibrary("zSipUI");
            if (this.isNeonSupported()) {
                System.loadLibrary("viper_neon");
                System.loadLibrary("mcm_neon");
            } else {
                System.loadLibrary("viper");
                System.loadLibrary("mcm");
            }
        } else if (this.isSDKMainboard()) {
            System.loadLibrary("crypto_sb");
            System.loadLibrary("ssl_sb");
            System.loadLibrary("cmmlib");
            System.loadLibrary("zoom_tp");
            System.loadLibrary("zWebService");
            System.loadLibrary("zoom");
            System.loadLibrary(PT_MAINBOARD_NAME);
            System.loadLibrary("zChatUI");
            System.loadLibrary("zLoader");
            System.loadLibrary("zData");
        }
    }

    private void loadSDKConfAppNativeModules() {
        long startTime = System.currentTimeMillis();
        System.loadLibrary("zlt");
        System.loadLibrary("nydus");
        System.loadLibrary(CONF_MAINBOARD_NAME);
        System.loadLibrary("zVideoUI");
        System.loadLibrary("ssb_sdk");
        System.loadLibrary("annotate");
        if (this.isNeonSupported()) {
            System.loadLibrary("viper_neon");
            System.loadLibrary("mcm_neon");
        } else {
            System.loadLibrary("viper");
            System.loadLibrary("mcm");
        }
        AndroidContext.initialize((Context)VideoBoxApplication.getInstance());
    }

    public void notifyUrlAction(String urlAction) {
        this.notifyUrlActionImpl(urlAction);
    }

    private void notifyNetworkState(int state) {
        this.notifyNetworkStateImpl(state, 0);
    }

    private void startListenNetworkState() {
        if (this.mNetworkStateReceiver == null) {
            this.mNetworkStateReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    String action = intent.getAction();
                    if (!"android.net.conn.CONNECTIVITY_CHANGE".equals(action)) {
                        return;
                    }
                    Mainboard.this.onNetworkState(context);
                }
            };
            VideoBoxApplication.getInstance().registerReceiver(this.mNetworkStateReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
    }

    private void onNetworkState(Context context) {
        if (context == null) {
            return;
        }
        int netType = NetworkUtil.getDataNetworkType((Context)context);
        if (netType != this.mNetType) {
            this.mNetType = netType;
            this.notifyNetworkState(NetworkUtil.hasDataNetwork((Context)context) ? 0 : 1);
        }
    }

    private void startToListenActiveState() {
        AppStateMonitor.getInstance().addListener(this);
        AppStateMonitor.getInstance().start();
    }

    @Override
    public void onAppActivated() {
        this.notifyAppActiveImpl();
        if (this.isPTMainboard()) {
            this.mUVCPermissionUtil = UVCPermissionUtil.getInstance(this.mContext);
            if (this.mUVCPermissionUtil != null) {
                this.mUVCPermissionUtil.addUVCListener(this.mUVCListener);
                this.requestPermissionForAllUVCDevices();
            }
        }
    }

    @Override
    public void onAppInactivated() {
        this.notifyAppInactiveImpl();
        if (this.isPTMainboard() && this.mUVCPermissionUtil != null) {
            this.mUVCPermissionUtil.removeUVCListener(this.mUVCListener);
        }
    }

    public void notifyConfProcessExitCorrectly() {
        this.notifyConfProcessExitCorrectlyImpl();
    }

    private boolean isNeonSupported() {
        return this.isNeonSupportedImpl();
    }

    public static void onNativeCrashed(int signum, String info) {
        String signame = "";
        switch (signum) {
            case 4: {
                signame = "SIGILL";
                break;
            }
            case 6: {
                signame = "SIGABRT";
                break;
            }
            case 7: {
                signame = "SIGBUS";
                break;
            }
            case 8: {
                signame = "SIGFPE";
                break;
            }
            case 11: {
                signame = "SIGSEGV";
                break;
            }
            case 16: {
                signame = "SIGSTKFLT";
                break;
            }
            case 13: {
                signame = "SIGPIPE";
                break;
            }
            default: {
                signame = "???";
            }
        }
        ZMLog.e((String)TAG, (String)"onNativeCrashed, signum=%d, signame=%s, info=%s", (Object[])new Object[]{signum, signame, info});
        sIsNativeCrashed = true;
        VideoBoxApplication.getInstance().notifyStabilityServiceCrashInfo();
    }

    public static boolean isNativeCrashed() {
        return sIsNativeCrashed;
    }

    private static void installNativeCrashHandler() {
        int res = 0;
        String logFolder = LogUtil.getLogFolder();
        if (logFolder == null) {
            Log.e((String)TAG, (String)"can not get log folder , installNativeCrashHandler failed");
            return;
        }
        res = Build.VERSION.SDK_INT < 16 ? Mainboard.installNativeCrashHandlerImpl(Build.VERSION.SDK_INT, false, logFolder, LogUtil.getDeviceInfo()) : Mainboard.installNativeCrashHandlerImpl(Build.VERSION.SDK_INT, true, logFolder, LogUtil.getDeviceInfo());
    }

    public void heartBeatForSDK() {
        this.heartBeat4SingleProcessImpl();
    }

    public boolean queryBooleanPolicyValueFromMemory() {
        return this.queryBooleanPolicyValueFromMemoryImpl();
    }

    private native int initMainboard(String var1, String var2, byte[] var3, String[] var4, int var5);

    private native void notifyUrlActionImpl(String var1);

    private native void notifyNetworkStateImpl(int var1, int var2);

    private native void notifyAppActiveImpl();

    private native void notifyAppInactiveImpl();

    private native void notifyConfProcessExitCorrectlyImpl();

    private native boolean isNeonSupportedImpl();

    private static native int installNativeCrashHandlerImpl(int var0, boolean var1, String var2, String var3);

    private native boolean initConfModule4SingleProcessImpl(byte[] var1, String[] var2);

    private native boolean termConfModule4SingleProcessImpl();

    private native void heartBeat4SingleProcessImpl();

    private native boolean queryBooleanPolicyValueFromMemoryImpl();
}

