/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.kubi;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import com.revolverobotics.kubisdk.IKubiManagerDelegate;
import com.revolverobotics.kubisdk.Kubi;
import com.revolverobotics.kubisdk.KubiManager;
import com.revolverobotics.kubisdk.KubiSearchResult;
import com.zipow.videobox.ZMBaseService;
import com.zipow.videobox.kubi.IKubiService;
import com.zipow.videobox.kubi.KubiDevice;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public class KubiService
extends ZMBaseService {
    private static final String TAG = KubiService.class.getSimpleName();
    private ServiceBinder mServiceBinder;

    public IBinder onBind(Intent intent) {
        return this.getServiceBinder();
    }

    @Override
    public void onCreate() {
        super.onCreate();
    }

    private ServiceBinder getServiceBinder() {
        if (Build.VERSION.SDK_INT < 18) {
            return null;
        }
        if (this.mServiceBinder == null) {
            this.mServiceBinder = new ServiceBinder(this.getApplicationContext());
        }
        return this.mServiceBinder;
    }

    public void onDestroy() {
        if (this.mServiceBinder != null) {
            this.mServiceBinder.disconnectKubiInternal();
        }
        super.onDestroy();
    }

    public void onRebind(Intent intent) {
        super.onRebind(intent);
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        super.onStartCommand(intent, flags, startId);
        int ret = 2;
        if (intent == null) {
            return ret;
        }
        String action = intent.getAction();
        ServiceBinder serviceBinder = this.getServiceBinder();
        if (serviceBinder == null) {
            return ret;
        }
        int status = serviceBinder.getKubiStatusInternal();
        if (serviceBinder.getCurrentKubiInternal() == null && status != 2 && status != 3 && status != 5 && !"us.zoom.videomeetings.KubiContract.ACTION_START_KUBI_SERVICE_NO_AUTO_CONNECT".equals(action)) {
            serviceBinder.findKubiDeviceInternal();
        }
        return ret;
    }

    private static class ServiceBinder
    extends IKubiService.Stub
    implements IKubiManagerDelegate {
        private KubiManager mKubiManager;
        private KubiDevice mCurrentKubi;
        private Context mContext;
        private static final int DEVICE_FIND_DELAY = 1;
        private Handler mHandler = new Handler();

        public ServiceBinder(Context context) {
            this.mContext = context;
            this.mKubiManager = new KubiManager(context, this);
        }

        private boolean isMainThread() {
            return Thread.currentThread().getId() == Looper.getMainLooper().getThread().getId();
        }

        @Override
        public int getKubiStatus() throws RemoteException {
            if (this.isMainThread()) {
                return this.getKubiStatusInternal();
            }
            FutureTask<Integer> task = new FutureTask<Integer>(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return ServiceBinder.this.getKubiStatusInternal();
                }
            });
            this.mHandler.post(task);
            try {
                return task.get();
            }
            catch (Exception exception) {
                return 0;
            }
        }

        private Integer getKubiStatusInternal() {
            if (this.mKubiManager != null) {
                return this.mKubiManager.getStatus();
            }
            return 0;
        }

        @Override
        public boolean findKubiDevice() throws RemoteException {
            if (this.isMainThread()) {
                return this.findKubiDeviceInternal();
            }
            FutureTask<Boolean> task = new FutureTask<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return ServiceBinder.this.findKubiDeviceInternal();
                }
            });
            this.mHandler.post(task);
            try {
                return task.get();
            }
            catch (Exception exception) {
                return false;
            }
        }

        private boolean findKubiDeviceInternal() {
            if (this.mKubiManager == null) {
                return false;
            }
            if (!this.checkBluetoothStatus()) {
                return false;
            }
            if (!this.checkLocationPermission()) {
                return false;
            }
            if (4 == this.mKubiManager.getStatus()) {
                this.resetDevicePositionInternal();
                this.notifyKubiConnectionStatus(true);
            } else {
                this.mKubiManager.disconnect();
                this.mKubiManager.findKubi(1);
            }
            return true;
        }

        @Override
        public boolean disconnectKubi() throws RemoteException {
            if (this.isMainThread()) {
                return this.disconnectKubi();
            }
            FutureTask<Boolean> task = new FutureTask<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return ServiceBinder.this.disconnectKubiInternal();
                }
            });
            this.mHandler.post(task);
            try {
                return task.get();
            }
            catch (Exception exception) {
                return false;
            }
        }

        private boolean disconnectKubiInternal() {
            if (this.mKubiManager != null) {
                try {
                    this.mKubiManager.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setCurrentKubi(null);
            return true;
        }

        @Override
        public void findAllKubiDevices() throws RemoteException {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ServiceBinder.this.findAllKubiDevicesInternal();
                }
            });
        }

        private void findAllKubiDevicesInternal() {
            if (this.mKubiManager != null) {
                this.mKubiManager.findAllKubis();
            }
        }

        @Override
        public void connectToKubi(final KubiDevice device) throws RemoteException {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ServiceBinder.this.connectToKubiInternal(device);
                }
            });
        }

        private void connectToKubiInternal(KubiDevice device) {
            BluetoothDevice btDevice;
            if (this.mKubiManager != null && device != null && (btDevice = device.getBluetoothDevice()) != null) {
                KubiSearchResult kubiSearchResult = new KubiSearchResult(btDevice, device.getRSSI());
                this.mKubiManager.connectToKubi(kubiSearchResult);
                this.setCurrentKubi(device);
            }
        }

        @Override
        public KubiDevice getCurrentKubi() throws RemoteException {
            return this.getCurrentKubiInternal();
        }

        public synchronized KubiDevice getCurrentKubiInternal() {
            return this.mCurrentKubi;
        }

        private synchronized void setCurrentKubi(KubiDevice kubi) {
            this.mCurrentKubi = kubi;
        }

        @Override
        public float getPan() throws RemoteException {
            if (this.isMainThread()) {
                return this.getPanInternal();
            }
            FutureTask<Float> task = new FutureTask<Float>(new Callable<Float>(){

                @Override
                public Float call() throws Exception {
                    return Float.valueOf(ServiceBinder.this.getPanInternal());
                }
            });
            this.mHandler.post(task);
            try {
                return task.get().floatValue();
            }
            catch (Exception exception) {
                return 0.0f;
            }
        }

        private float getPanInternal() {
            Kubi kubi;
            if (this.mKubiManager != null && (kubi = this.mKubiManager.getKubi()) != null) {
                return kubi.getPan();
            }
            return 0.0f;
        }

        @Override
        public float getTilt() throws RemoteException {
            if (this.isMainThread()) {
                return this.getTilt();
            }
            FutureTask<Float> task = new FutureTask<Float>(new Callable<Float>(){

                @Override
                public Float call() throws Exception {
                    return Float.valueOf(ServiceBinder.this.getTiltInternal());
                }
            });
            this.mHandler.post(task);
            try {
                return task.get().floatValue();
            }
            catch (Exception exception) {
                return 0.0f;
            }
        }

        private float getTiltInternal() {
            Kubi kubi;
            if (this.mKubiManager != null && (kubi = this.mKubiManager.getKubi()) != null) {
                return kubi.getTilt();
            }
            return 0.0f;
        }

        @Override
        public void moveInPanDirectionWithSpeed(final int direction, final int speed) throws RemoteException {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ServiceBinder.this.moveInPanDirectionWithSpeedInternal(direction, speed);
                }
            });
        }

        private void moveInPanDirectionWithSpeedInternal(int direction, int speed) {
            Kubi kubi;
            if (this.mKubiManager != null && (kubi = this.mKubiManager.getKubi()) != null) {
                kubi.moveInPanDirectionWithSpeed(direction, speed);
            }
        }

        @Override
        public void moveInTiltDirectionWithSpeed(final int direction, final int speed) throws RemoteException {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ServiceBinder.this.moveInTiltDirectionWithSpeedInternal(direction, speed);
                }
            });
        }

        private void moveInTiltDirectionWithSpeedInternal(int direction, int speed) {
            Kubi kubi;
            if (this.mKubiManager != null && (kubi = this.mKubiManager.getKubi()) != null) {
                kubi.moveInTiltDirectionWithSpeed(direction, speed);
            }
        }

        @Override
        public void moveTo(final float pan, final float tilt, final float speed) throws RemoteException {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ServiceBinder.this.moveToInternal(pan, tilt, speed);
                }
            });
        }

        private void moveToInternal(float pan, float tilt, float speed) {
            Kubi kubi;
            if (this.mKubiManager != null && (kubi = this.mKubiManager.getKubi()) != null) {
                kubi.moveTo(pan, tilt, speed);
            }
        }

        @Override
        public boolean resetDevicePosition() throws RemoteException {
            if (this.isMainThread()) {
                return this.resetDevicePositionInternal();
            }
            FutureTask<Boolean> task = new FutureTask<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return ServiceBinder.this.resetDevicePositionInternal();
                }
            });
            this.mHandler.post(task);
            try {
                return task.get();
            }
            catch (Exception exception) {
                return false;
            }
        }

        public boolean resetDevicePositionInternal() {
            Kubi kubi;
            if (this.mKubiManager != null && (kubi = this.mKubiManager.getKubi()) != null) {
                kubi.moveTo(0.0f, 0.0f, 52.3f);
                return true;
            }
            return false;
        }

        @Override
        public void kubiDeviceFound(KubiManager manager, KubiSearchResult device) {
            KubiDevice kubiDevice = KubiDevice.fromKubiSearchResult(device);
            if (kubiDevice == null) {
                return;
            }
            this.connectToKubiInternal(kubiDevice);
            this.notifyKubiDeviceFound(manager, kubiDevice);
        }

        @Override
        public void kubiManagerStatusChanged(KubiManager manager, int oldStatus, int newStatus) {
            if (oldStatus == 4 && newStatus != 4) {
                this.setCurrentKubi(null);
                this.notifyKubiConnectionStatus(false);
            } else if (oldStatus != 4 && newStatus == 4) {
                this.notifyKubiConnectionStatus(true);
                this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        ServiceBinder.this.resetDevicePositionInternal();
                    }
                }, 1L);
            }
            this.notifyKubiManagerStatusChanged(manager, oldStatus, newStatus);
        }

        @Override
        public void kubiManagerFailed(KubiManager manager, int reason) {
            this.notifyKubiManagerFailed(manager, reason);
        }

        @Override
        public void kubiScanComplete(KubiManager manager, ArrayList<KubiSearchResult> results) {
            if (results == null) {
                return;
            }
            ArrayList<KubiDevice> devices = new ArrayList<KubiDevice>(results.size());
            for (KubiSearchResult result : results) {
                KubiDevice device = KubiDevice.fromKubiSearchResult(result);
                if (device == null) continue;
                devices.add(device);
            }
            this.notifyKubiScanComplete(manager, devices);
        }

        private boolean checkBluetoothStatus() {
            BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            if (bluetoothAdapter == null) {
                return false;
            }
            boolean isEnabled = bluetoothAdapter.isEnabled();
            return isEnabled;
        }

        private boolean checkLocationPermission() {
            if (Build.VERSION.SDK_INT <= 22) {
                return true;
            }
            if (this.mContext == null) {
                return false;
            }
            return 0 == this.mContext.checkPermission("android.permission.ACCESS_FINE_LOCATION", Process.myPid(), Process.myUid());
        }

        private void notifyKubiConnectionStatus(boolean connected) {
            if (this.mContext == null) {
                return;
            }
            Intent intent = new Intent();
            intent.setAction("us.zoom.videomeetings.KubiContract.ACTION_KUBI_CONNECTION_STATUS");
            intent.putExtra("connected", connected);
            this.mContext.sendBroadcast(intent, this.mContext.getPackageName() + ".permission.KUBI_MESSAGE");
        }

        private void notifyKubiDeviceFound(KubiManager manager, KubiDevice kubiDevice) {
            if (this.mContext == null) {
                return;
            }
            Intent intent = new Intent();
            intent.setAction("us.zoom.videomeetings.KubiContract.ACTION_KUBI_DEVICE_FOUND");
            intent.putExtra("device", (Parcelable)kubiDevice);
            this.mContext.sendBroadcast(intent, this.mContext.getPackageName() + ".permission.KUBI_MESSAGE");
        }

        private void notifyKubiManagerStatusChanged(KubiManager manager, int oldStatus, int newStatus) {
            if (this.mContext == null) {
                return;
            }
            Intent intent = new Intent();
            intent.setAction("us.zoom.videomeetings.KubiContract.ACTION_KUBI_MANAGER_STATUS_CHANGED");
            intent.putExtra("oldStatus", oldStatus);
            intent.putExtra("newStatus", newStatus);
            this.mContext.sendBroadcast(intent, this.mContext.getPackageName() + ".permission.KUBI_MESSAGE");
        }

        private void notifyKubiManagerFailed(KubiManager manager, int reason) {
            if (this.mContext == null) {
                return;
            }
            Intent intent = new Intent();
            intent.setAction("us.zoom.videomeetings.KubiContract.ACTION_KUBI_MANAGER_FAILED");
            intent.putExtra("reason", reason);
            this.mContext.sendBroadcast(intent, this.mContext.getPackageName() + ".permission.KUBI_MESSAGE");
        }

        private void notifyKubiScanComplete(KubiManager manager, ArrayList<KubiDevice> devices) {
            if (this.mContext == null) {
                return;
            }
            Intent intent = new Intent();
            intent.setAction("us.zoom.videomeetings.KubiContract.ACTION_KUBI_SCAN_COMPLETE");
            intent.putParcelableArrayListExtra("devices", devices);
            this.mContext.sendBroadcast(intent, this.mContext.getPackageName() + ".permission.KUBI_MESSAGE");
        }
    }
}

