/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.kubi;

import android.bluetooth.BluetoothDevice;
import android.os.Parcel;
import android.os.Parcelable;
import com.revolverobotics.kubisdk.KubiSearchResult;
import us.zoom.androidlib.util.StringUtil;

public class KubiDevice
implements Parcelable {
    private BluetoothDevice mBtDevice = null;
    private int mRSSI = 0;
    public static final Parcelable.Creator<KubiDevice> CREATOR = new Parcelable.Creator<KubiDevice>(){

        public KubiDevice createFromParcel(Parcel in) {
            return new KubiDevice(in);
        }

        public KubiDevice[] newArray(int size) {
            return new KubiDevice[size];
        }
    };

    public static KubiDevice fromKubiSearchResult(KubiSearchResult kubiSearchResult) {
        if (kubiSearchResult == null) {
            return null;
        }
        BluetoothDevice btDevice = kubiSearchResult.getDevice();
        if (btDevice == null) {
            return null;
        }
        int rssi = kubiSearchResult.getRSSI();
        return new KubiDevice(btDevice, rssi);
    }

    public KubiDevice() {
    }

    private KubiDevice(Parcel in) {
        this.readFromParcel(in);
    }

    public KubiDevice(BluetoothDevice btDevice, int rssi) {
        this.mBtDevice = btDevice;
        this.mRSSI = rssi;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.mBtDevice, 0);
        dest.writeInt(this.mRSSI);
    }

    private void readFromParcel(Parcel in) {
        this.mBtDevice = (BluetoothDevice)in.readParcelable(this.getClass().getClassLoader());
        this.mRSSI = in.readInt();
    }

    public BluetoothDevice getBluetoothDevice() {
        return this.mBtDevice;
    }

    public int getRSSI() {
        return this.mRSSI;
    }

    public String getName() {
        if (this.mBtDevice == null) {
            return null;
        }
        return this.mBtDevice.getName();
    }

    public String getMac() {
        if (this.mBtDevice == null) {
            return null;
        }
        return this.mBtDevice.getAddress();
    }

    public boolean equals(Object o) {
        if (!(o instanceof KubiDevice)) {
            return false;
        }
        KubiDevice device = (KubiDevice)o;
        return StringUtil.isSameString((String)this.getMac(), (String)device.getMac()) && StringUtil.isSameString((String)this.getName(), (String)device.getName());
    }
}

