/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.kubi;

import android.app.Dialog;
import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.zipow.nydus.KUBIDeviceController;
import com.zipow.videobox.ConfActivityNormal;
import com.zipow.videobox.kubi.KubiDevice;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class KubiChoiceFragment
extends ZMDialogFragment {
    private KubiListAdapter mAdapter;
    private KUBIDeviceController.IKubiListener mKubiListener;
    private BroadcastReceiver mBluetoothStatusReceiver;

    public static void showDialog(FragmentManager fm) {
        if (fm == null) {
            return;
        }
        Bundle args = new Bundle();
        KubiChoiceFragment f = new KubiChoiceFragment();
        f.setArguments(args);
        f.show(fm, KubiChoiceFragment.class.getName());
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        this.mAdapter = new KubiListAdapter((ZMActivity)this.getActivity());
        int titleRes = R.string.zm_kubi_connect_kubi_list_title;
        KUBIDeviceController controller = KUBIDeviceController.getInstance();
        if (controller != null && controller.getCurrentKubi() != null) {
            titleRes = R.string.zm_kubi_switch_kubi_list_title;
        }
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(titleRes).setAdapter((ListAdapter)this.mAdapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                KubiChoiceFragment.this.onClickItem(KubiChoiceFragment.this.mAdapter, which);
            }
        }).create();
        dialog.setCanceledOnTouchOutside(true);
        return dialog;
    }

    public void onResume() {
        KUBIDeviceController controller;
        super.onResume();
        if (this.mKubiListener == null) {
            this.mKubiListener = new KUBIDeviceController.SimpleKubiListener(){

                @Override
                public void onKubiScanComplete(ArrayList<KubiDevice> devices) {
                    KubiChoiceFragment.this.onKubiScanComplete(devices);
                }
            };
        }
        if ((controller = KUBIDeviceController.getInstance()) != null) {
            controller.addKubiListener(this.mKubiListener);
        }
        if (this.checkBluetoothStatus()) {
            this.startToFindAllKubis();
        } else {
            this.registerBluetoothStatusReceiver();
        }
    }

    public void onPause() {
        super.onPause();
        KUBIDeviceController controller = KUBIDeviceController.getInstance();
        if (controller != null) {
            controller.removeKubiListener(this.mKubiListener);
        }
        this.unregisterBluetoothStatusReceiver();
    }

    public void onCancel(DialogInterface dialog) {
        super.onCancel(dialog);
        this.notifyDialogConfirmed();
    }

    private void notifyDialogConfirmed() {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity instanceof ConfActivityNormal && activity.isActive()) {
            ((ConfActivityNormal)activity).onKubiChoiceFragmentClosed();
        }
    }

    private void startToFindAllKubis() {
        KUBIDeviceController controller = KUBIDeviceController.getInstance();
        if (controller != null) {
            controller.findAllKubiDevices();
        }
    }

    private boolean checkBluetoothStatus() {
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (bluetoothAdapter == null) {
            return false;
        }
        boolean isEnabled = bluetoothAdapter.isEnabled();
        return isEnabled;
    }

    private void registerBluetoothStatusReceiver() {
        if (this.mBluetoothStatusReceiver == null) {
            this.mBluetoothStatusReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    String action = intent.getAction();
                    if ("android.bluetooth.adapter.action.STATE_CHANGED".equals(action) && intent.getIntExtra("android.bluetooth.adapter.extra.STATE", -1) == 12) {
                        KubiChoiceFragment.this.startToFindAllKubis();
                    }
                }
            };
            FragmentActivity activity = this.getActivity();
            if (activity != null) {
                activity.registerReceiver(this.mBluetoothStatusReceiver, new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED"));
            }
        }
    }

    private void unregisterBluetoothStatusReceiver() {
        if (this.mBluetoothStatusReceiver != null) {
            FragmentActivity activity = this.getActivity();
            if (activity != null) {
                activity.unregisterReceiver(this.mBluetoothStatusReceiver);
            }
            this.mBluetoothStatusReceiver = null;
        }
    }

    private void onKubiScanComplete(ArrayList<KubiDevice> devices) {
        this.mAdapter.loadSearchResult(devices);
        this.mAdapter.notifyDataSetChanged();
    }

    private void onClickItem(KubiListAdapter adapter, int which) {
        this.notifyDialogConfirmed();
        Object oItem = adapter.getItem(which);
        if (oItem == null) {
            return;
        }
        KUBIDeviceController controller = KUBIDeviceController.getInstance();
        if (controller == null) {
            return;
        }
        if (oItem instanceof KubiItem) {
            KubiItem item = (KubiItem)oItem;
            if (item.connected) {
                controller.disconnectKubi();
            } else {
                controller.connectToKubi(item.device);
            }
        }
    }

    static class KubiListAdapter
    extends BaseAdapter {
        private static final int ITEM_TYPE_LOADING = 0;
        private static final int ITEM_TYPE_KUBI_NORMAL = 1;
        private static final int ITEM_TYPE_KUBI_CONNECTED = 2;
        private static final int ITEM_TYPE_EMPTY_LIST = 3;
        private ZMActivity mActivity;
        private List<Object> mList = new ArrayList<Object>();

        public KubiListAdapter(ZMActivity activity) {
            this.mActivity = activity;
            this.mList.add(new LoadingItem());
            KubiDevice kubi = this.getCurrentKubi();
            if (kubi != null) {
                this.mList.add(new KubiItem(kubi, true));
            }
        }

        private KubiDevice getCurrentKubi() {
            KUBIDeviceController kubiDeviceController = KUBIDeviceController.getInstance();
            if (kubiDeviceController == null) {
                return null;
            }
            KubiDevice kubi = kubiDeviceController.getCurrentKubi();
            return kubi;
        }

        public void loadSearchResult(ArrayList<KubiDevice> devices) {
            this.mList.clear();
            KubiDevice currentKubi = this.getCurrentKubi();
            for (KubiDevice device : devices) {
                if (device == null || currentKubi != null && StringUtil.isSameString((String)currentKubi.getMac(), (String)device.getMac())) continue;
                this.mList.add(new KubiItem(device, false));
            }
            if (currentKubi != null) {
                this.mList.add(new KubiItem(currentKubi, true));
            }
            if (this.mList.isEmpty()) {
                this.mList.add(new EmptyListItem());
            }
        }

        public int getCount() {
            return this.mList.size();
        }

        public Object getItem(int position) {
            if (position < 0 || position >= this.mList.size()) {
                return null;
            }
            return this.mList.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public int getItemViewType(int position) {
            int type = 1;
            Object item = this.getItem(position);
            if (item == null) {
                return type;
            }
            if (item instanceof LoadingItem) {
                type = 0;
            } else if (item instanceof EmptyListItem) {
                type = 3;
            } else if (item instanceof KubiItem) {
                type = ((KubiItem)item).connected ? 2 : 1;
            }
            return type;
        }

        public int getViewTypeCount() {
            return 4;
        }

        public boolean areAllItemsEnabled() {
            return false;
        }

        public boolean isEnabled(int position) {
            int type = this.getItemViewType(position);
            return type == 2 || type == 1;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            Object oItem = this.getItem(position);
            View view = null;
            LayoutInflater inflater = LayoutInflater.from((Context)this.mActivity);
            if (inflater == null) {
                return null;
            }
            if (oItem instanceof LoadingItem) {
                if (convertView != null && "LoadingItem".equals(convertView.getTag())) {
                    view = convertView;
                } else {
                    view = inflater.inflate(R.layout.zm_kubi_loading_item, parent, false);
                    view.setTag((Object)"LoadingItem");
                }
            } else if (oItem instanceof EmptyListItem) {
                if (convertView != null && "EmptyListItem".equals(convertView.getTag())) {
                    view = convertView;
                } else {
                    view = inflater.inflate(R.layout.zm_kubi_empty_list_item, parent, false);
                    view.setTag((Object)"EmptyListItem");
                }
            } else if (oItem instanceof KubiItem) {
                KubiItem item = (KubiItem)oItem;
                if (item.connected) {
                    if (convertView != null && "ConnectedItem".equals(convertView.getTag())) {
                        view = convertView;
                    } else {
                        view = inflater.inflate(R.layout.zm_kubi_item_connected, parent, false);
                        view.setTag((Object)"ConnectedItem");
                    }
                    TextView txtLabel = (TextView)view.findViewById(R.id.txtLabel);
                    if (txtLabel != null) {
                        String strLabel = this.mActivity.getString(R.string.zm_kubi_disconnect_kubi_xxx, new Object[]{item.device.getName()});
                        txtLabel.setText((CharSequence)strLabel);
                    }
                } else {
                    if (convertView != null && "NormalItem".equals(convertView.getTag())) {
                        view = convertView;
                    } else {
                        view = inflater.inflate(R.layout.zm_kubi_item_normal, parent, false);
                        view.setTag((Object)"NormalItem");
                    }
                    TextView txtLabel = (TextView)view.findViewById(R.id.txtLabel);
                    if (txtLabel != null) {
                        txtLabel.setText((CharSequence)item.device.getName());
                    }
                }
            }
            return view;
        }
    }

    static class KubiItem {
        boolean connected = false;
        KubiDevice device;

        public KubiItem(KubiDevice device, boolean connected) {
            this.device = device;
            this.connected = connected;
        }
    }

    static class EmptyListItem {
        EmptyListItem() {
        }
    }

    static class LoadingItem {
        LoadingItem() {
        }
    }
}

