/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.googledrive;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialRefreshListener;
import com.google.api.client.auth.oauth2.TokenErrorResponse;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.extensions.android.http.AndroidHttp;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeTokenRequest;
import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.zipow.videobox.googledrive.GoogleUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.ZMAsyncTask;

public class ZMGoogleCredential
implements CredentialRefreshListener {
    private static final String USER_ID = "googleAuthClientId";
    private List<CredentialGettingTask> mTasks = new ArrayList<CredentialGettingTask>();
    private GoogleAuthorizationCodeFlow mAuthFlow;
    private String mClientId;
    private CredentialListener mListener;

    public ZMGoogleCredential(String clientId, String secret, String[] scopes, CredentialListener listener) {
        this.mClientId = clientId;
        this.mListener = listener;
        this.mAuthFlow = new GoogleAuthorizationCodeFlow.Builder(AndroidHttp.newCompatibleTransport(), GoogleUtil.getDefaultJsonFactory(), clientId, secret, Arrays.asList(scopes)).addRefreshListener((CredentialRefreshListener)this).build();
    }

    public void onTokenResponse(Credential credential, TokenResponse tokenResponse) throws IOException {
        if (credential == null) {
            if (this.mListener != null) {
                this.mListener.onRefreshTokenError(null, null);
            }
            return;
        }
        Credential newOne = this.createAndStoreCredential(tokenResponse);
        if (newOne == null) {
            if (this.mListener != null) {
                this.mListener.onRefreshTokenError(credential, null);
            }
            return;
        }
        if (this.mListener != null) {
            this.mListener.onRefreshToken(credential, newOne);
        }
    }

    public void onTokenErrorResponse(Credential credential, TokenErrorResponse tokenErrorResponse) throws IOException {
        if (this.mListener != null) {
            if (tokenErrorResponse != null) {
                this.mListener.onRefreshTokenError(credential, tokenErrorResponse.getError());
            } else {
                this.mListener.onRefreshTokenError(credential, null);
            }
        }
    }

    private Credential createAndStoreCredential(TokenResponse response) throws IOException {
        if (response == null) {
            return null;
        }
        return this.mAuthFlow.createAndStoreCredential(response, USER_ID);
    }

    public void exchangeCode(String authCode, String redirectUrl) {
        if (StringUtil.isEmptyOrNull((String)authCode) || StringUtil.isEmptyOrNull((String)this.mClientId)) {
            return;
        }
        this.cancel();
        CredentialGettingTask task = new CredentialGettingTask(authCode, redirectUrl);
        this.mTasks.add(task);
        task.execute(new Void[0]);
    }

    public void cancel() {
        for (CredentialGettingTask task : this.mTasks) {
            task.cancel(true);
        }
        this.mTasks.clear();
    }

    private class CredentialGettingTask
    extends ZMAsyncTask<Void, Void, Runnable> {
        private boolean bCancel = false;
        private String mAuthCode;
        private String mRedirectUrl;
        private Credential mCredential;

        public CredentialGettingTask(String authCode, String redirectUrl) {
            this.mAuthCode = authCode;
            this.mRedirectUrl = redirectUrl;
        }

        protected void onCancelled() {
            super.onCancelled();
            this.bCancel = true;
        }

        protected Runnable doInBackground(Void ... params) {
            if (StringUtil.isEmptyOrNull((String)this.mAuthCode) || ZMGoogleCredential.this.mAuthFlow == null) {
                return new onErrorRunnable(new Exception("The parameter is invalid!"));
            }
            if (this.bCancel) {
                return new onCancelRunnable();
            }
            try {
                Credential credential = ZMGoogleCredential.this.mAuthFlow.loadCredential(ZMGoogleCredential.USER_ID);
                if (credential != null) {
                    this.mCredential = credential;
                    return new onCompeletedRunnable();
                }
            }
            catch (IOException credential) {
                // empty catch block
            }
            GoogleAuthorizationCodeTokenRequest request = ZMGoogleCredential.this.mAuthFlow.newTokenRequest(this.mAuthCode);
            request.setRedirectUri(this.mRedirectUrl);
            try {
                GoogleTokenResponse response = request.execute();
                this.mCredential = ZMGoogleCredential.this.mAuthFlow.createAndStoreCredential((TokenResponse)response, ZMGoogleCredential.USER_ID);
            }
            catch (IOException e) {
                if (this.bCancel) {
                    return new onCancelRunnable();
                }
                return new onCompeletedRunnable();
            }
            if (this.bCancel) {
                return new onCancelRunnable();
            }
            return new onCompeletedRunnable();
        }

        protected void onPostExecute(Runnable result) {
            ZMGoogleCredential.this.mTasks.remove((Object)this);
            result.run();
        }

        private class onErrorRunnable
        implements Runnable {
            private Exception exception;

            public onErrorRunnable(Exception e) {
                this.exception = e;
            }

            @Override
            public void run() {
                if (ZMGoogleCredential.this.mListener != null) {
                    ZMGoogleCredential.this.mListener.onError(this.exception);
                }
            }
        }

        private class onCancelRunnable
        implements Runnable {
            private onCancelRunnable() {
            }

            @Override
            public void run() {
                if (ZMGoogleCredential.this.mListener != null) {
                    ZMGoogleCredential.this.mListener.onCancel();
                }
            }
        }

        private class onCompeletedRunnable
        implements Runnable {
            private onCompeletedRunnable() {
            }

            @Override
            public void run() {
                if (ZMGoogleCredential.this.mListener != null) {
                    ZMGoogleCredential.this.mListener.onCompeleted(CredentialGettingTask.this.mCredential);
                }
            }
        }
    }

    public static interface CredentialListener {
        public void onCompeleted(Credential var1);

        public void onCancel();

        public void onError(Exception var1);

        public void onRefreshToken(Credential var1, Credential var2);

        public void onRefreshTokenError(Credential var1, String var2);
    }
}

