/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.googledrive;

import java.io.File;
import us.zoom.androidlib.app.ZMFileListEntry;
import us.zoom.androidlib.util.StringUtil;

public class GoogleDriveObjectEntry
extends ZMFileListEntry {
    private String mMimeType;
    private String mId;
    private String mDownloadUrl;
    private String mParentId;
    private String mAlternateLink;

    public GoogleDriveObjectEntry(String pareDir, com.google.api.services.drive.model.File file) {
        if (file == null) {
            return;
        }
        if (StringUtil.isEmptyOrNull((String)pareDir)) {
            pareDir = File.separator;
        }
        if (!pareDir.endsWith(File.separator)) {
            pareDir = pareDir + File.separator;
        }
        this.mMimeType = file.getMimeType();
        this.mId = file.getId();
        this.mDownloadUrl = file.getDownloadUrl();
        this.mAlternateLink = file.getAlternateLink();
        if ("application/vnd.google-apps.folder".equals(this.mMimeType)) {
            this.setDir(true);
        } else {
            this.setDir(false);
        }
        String path = pareDir + file.getTitle();
        this.setPath(path);
        this.setDate(file.getModifiedDate().getValue());
        Long fileSize = file.getFileSize();
        if (fileSize != null) {
            this.setBytes(fileSize);
        } else {
            this.setBytes(0L);
        }
        this.setDisplayName(file.getTitle());
    }

    public String getMimeType() {
        return this.mMimeType;
    }

    public String getAlternateLink() {
        return this.mAlternateLink;
    }

    public String getId() {
        return this.mId;
    }

    public String getDownloadUrl() {
        return this.mDownloadUrl;
    }

    public void setParentId(String id2) {
        this.mParentId = id2;
    }

    public String getParentId() {
        return this.mParentId;
    }
}

