/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.googledrive;

import android.content.Context;
import android.content.SharedPreferences;
import com.zipow.videobox.googledrive.GoogleDrive;
import com.zipow.videobox.util.GoogleAuthUtil;
import com.zipow.videobox.util.ZMAuthUtil;
import us.zoom.androidlib.util.StringUtil;

public class GoogleDriveMgr
implements GoogleDrive.DriveChangeListener {
    private static final String TAG = GoogleDriveMgr.class.getSimpleName();
    private static GoogleDriveMgr INSTANCE = null;
    private static String DRIVE_PREFERNCE_NAME = "drive_preference_name";
    private static String DRIVE_CLIENT_ID = "drive_client_id";
    private static String DRIVE_CLIENT_SECRET = "drive_client_secret";
    private static String DRIVE_REDIRECT_URL = "drive_redirect_url";
    private static String DRIVE_GOOGLE_LOGIN_URL = "drive_google_login_url";
    private static String mClientID;
    private static String mClientSecret;
    private static String mRedirectURL;
    private static String mGoogleLoginURL;
    private GoogleDrive mGoogleDrive;

    public static synchronized GoogleDriveMgr getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GoogleDriveMgr();
        }
        return INSTANCE;
    }

    public static synchronized void release() {
        if (INSTANCE != null) {
            INSTANCE.close();
            INSTANCE = null;
        }
    }

    public static boolean setClientID(Context context, String clientId) {
        if (context == null) {
            return false;
        }
        SharedPreferences prefs = context.getSharedPreferences(DRIVE_PREFERNCE_NAME, 0);
        SharedPreferences.Editor editor = prefs.edit();
        if (StringUtil.isEmptyOrNull((String)clientId)) {
            mClientID = null;
            editor.clear();
            editor.commit();
            return false;
        }
        mClientID = clientId;
        editor.putString(DRIVE_CLIENT_ID, clientId);
        editor.commit();
        return true;
    }

    public static boolean setClientSecret(Context context, String clientSecret) {
        if (context == null) {
            return false;
        }
        SharedPreferences prefs = context.getSharedPreferences(DRIVE_PREFERNCE_NAME, 0);
        SharedPreferences.Editor editor = prefs.edit();
        if (StringUtil.isEmptyOrNull((String)clientSecret)) {
            mClientSecret = null;
            editor.clear();
            editor.commit();
            return false;
        }
        mClientSecret = clientSecret;
        editor.putString(DRIVE_CLIENT_SECRET, clientSecret);
        editor.commit();
        return true;
    }

    public static boolean setRedirectURL(Context context, String redirectURL) {
        if (context == null) {
            return false;
        }
        SharedPreferences prefs = context.getSharedPreferences(DRIVE_PREFERNCE_NAME, 0);
        SharedPreferences.Editor editor = prefs.edit();
        if (StringUtil.isEmptyOrNull((String)redirectURL)) {
            mRedirectURL = null;
            editor.clear();
            editor.commit();
            return false;
        }
        mRedirectURL = redirectURL;
        editor.putString(DRIVE_REDIRECT_URL, mRedirectURL);
        editor.commit();
        return true;
    }

    public static String getClientID(Context context) {
        if (context == null) {
            return null;
        }
        if ("us.zoom.videomeetings".equals(context.getPackageName())) {
            return ZMAuthUtil.getGoogleDriveClientId();
        }
        if (StringUtil.isEmptyOrNull((String)mClientID)) {
            SharedPreferences prefs = context.getSharedPreferences(DRIVE_PREFERNCE_NAME, 0);
            mClientID = prefs.getString(DRIVE_CLIENT_ID, null);
        }
        return mClientID;
    }

    public static String getClientSecret(Context context) {
        if (context == null) {
            return null;
        }
        if ("us.zoom.videomeetings".equals(context.getPackageName())) {
            return "";
        }
        if (StringUtil.isEmptyOrNull((String)mClientSecret)) {
            SharedPreferences prefs = context.getSharedPreferences(DRIVE_PREFERNCE_NAME, 0);
            mClientSecret = prefs.getString(DRIVE_CLIENT_SECRET, null);
        }
        return mClientSecret;
    }

    public static String getRedirectURL(Context context) {
        if (context == null) {
            return null;
        }
        if ("us.zoom.videomeetings".equals(context.getPackageName())) {
            return "us.zoom.videomeetings:/oauth2redirect";
        }
        if (StringUtil.isEmptyOrNull((String)mRedirectURL)) {
            SharedPreferences prefs = context.getSharedPreferences(DRIVE_PREFERNCE_NAME, 0);
            mRedirectURL = prefs.getString(DRIVE_REDIRECT_URL, null);
        }
        return mRedirectURL;
    }

    private String[] getScopes(Context context) {
        if (context == null) {
            return null;
        }
        if ("us.zoom.videomeetings".equals(context.getPackageName())) {
            return GoogleAuthUtil.SCOPES;
        }
        return GoogleAuthUtil.GOOGLE_DRIVE_SCOPES;
    }

    public GoogleDrive getGoogleDrive(Context context) {
        if (this.mGoogleDrive == null) {
            this.mGoogleDrive = new GoogleDrive(GoogleDriveMgr.getClientID(context), GoogleDriveMgr.getClientSecret(context), this.getScopes(context), GoogleDriveMgr.getRedirectURL(context), this);
        }
        return this.mGoogleDrive;
    }

    private void close() {
        if (this.mGoogleDrive != null) {
            this.mGoogleDrive.logout();
        }
    }

    @Override
    public void onLogout(GoogleDrive drive) {
        if (this.mGoogleDrive == drive) {
            this.mGoogleDrive = null;
        }
    }
}

