/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.googledrive;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Handler;
import com.zipow.cmmlib.AppUtil;
import com.zipow.videobox.googledrive.GoogleDrive;
import com.zipow.videobox.googledrive.GoogleDriveMgr;
import com.zipow.videobox.googledrive.GoogleDriveObjectEntry;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMFileListBaseAdapter;
import us.zoom.androidlib.app.ZMFileListEntry;
import us.zoom.androidlib.app.ZMFileListListener;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.FileUtils;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class GoogleDriveFileListAdapter
extends ZMFileListBaseAdapter
implements GoogleDrive.GoogleDriveAuthListener {
    private ZMFileListListener mListener;
    private GoogleDrive mGoogleDrive;
    private String mCurrentDir;
    private String mCachedDir;
    private Handler mHandler = new Handler();
    private HashMap<String, GoogleDriveObjectEntry> mDirCached = new HashMap();
    private GoogleDrive.DriveFileListener mDownloadFileListener = new GoogleDrive.DriveFileListener(){

        @Override
        public void onDownloadCompleted(String fileId, String fileName, String outPath) {
            GoogleDriveFileListAdapter.this.dismissWaitingDialog();
            if (GoogleDriveFileListAdapter.this.mListener != null) {
                GoogleDriveFileListAdapter.this.mListener.onSelectedFile(outPath, fileName);
            }
        }

        @Override
        public void onDownloadFailed(String fileId, String fileName, Exception exception) {
            GoogleDriveFileListAdapter.this.dismissWaitingDialog();
            if (GoogleDriveFileListAdapter.this.mListener != null) {
                String message = exception != null ? exception.getMessage() : GoogleDriveFileListAdapter.this.mActivity.getString(R.string.zm_msg_load_file_fail, new Object[]{fileName});
                GoogleDriveFileListAdapter.this.mListener.onOpenFileFailed(message);
            }
        }

        @Override
        public void onDownloadProgress(String fileId, String fileName, long totalBytes, long bytesRead) {
            if (totalBytes > 0L) {
                long progress = bytesRead * 100L / totalBytes;
                GoogleDriveFileListAdapter.this.updateProgressWaitingDialog(GoogleDriveFileListAdapter.this.mActivity.getString(R.string.zm_msg_download_file_progress, new Object[]{progress}));
            } else {
                GoogleDriveFileListAdapter.this.updateProgressWaitingDialog(GoogleDriveFileListAdapter.this.mActivity.getString(R.string.zm_msg_download_file_size, new Object[]{FileUtils.toFileSizeString((Context)GoogleDriveFileListAdapter.this.mActivity, (long)bytesRead)}));
            }
        }

        @Override
        public void onDownloadCanceled(String fileId, String fileName) {
            GoogleDriveFileListAdapter.this.dismissWaitingDialog();
        }

        @Override
        public void onRefreshTokenFailed(String fileId, String fileName, String outPath) {
            GoogleDriveFileListAdapter.this.dismissWaitingDialog();
        }
    };
    private GoogleDrive.DriveFoldListener mLoadFolderListener = new GoogleDrive.DriveFoldListener(){

        @Override
        public void onLoadFolderCompeleted(GoogleDrive.GDAsyncLoadFolder task, String folderId, ArrayList<GoogleDriveObjectEntry> entries) {
            GoogleDriveFileListAdapter.this.dismissWaitingDialog();
            if (StringUtil.isEmptyOrNull((String)folderId)) {
                return;
            }
            GoogleDriveFileListAdapter.this.mCurrentDir = task.getPath();
            GoogleDriveFileListAdapter.this.mFileList.clear();
            for (GoogleDriveObjectEntry entry : entries) {
                if (entry == null || !entry.isDir() && !GoogleDriveFileListAdapter.this.acceptFileTypeByMimeType(entry.getMimeType())) continue;
                GoogleDriveFileListAdapter.this.mFileList.add(entry);
            }
            GoogleDriveFileListAdapter.this.sortFileList();
            GoogleDriveFileListAdapter.this.notifyDataSetChanged();
            if (GoogleDriveFileListAdapter.this.mListener != null) {
                GoogleDriveFileListAdapter.this.mListener.onRefresh();
            }
        }

        @Override
        public void onLoadFolderCanceled(GoogleDrive.GDAsyncLoadFolder task, String folderId) {
            GoogleDriveFileListAdapter.this.dismissWaitingDialog();
        }

        @Override
        public void onLoadFolderFailed(GoogleDrive.GDAsyncLoadFolder task, String folderId, Exception e) {
            GoogleDriveFileListAdapter.this.dismissWaitingDialog();
            if (GoogleDriveFileListAdapter.this.mListener != null) {
                String message;
                String string2 = message = e == null ? null : e.getMessage();
                if (StringUtil.isEmptyOrNull((String)message)) {
                    message = GoogleDriveFileListAdapter.this.mActivity.getString(R.string.zm_msg_load_dir_fail, new Object[]{""});
                }
                GoogleDriveFileListAdapter.this.mListener.onOpenDirFailed(message);
            }
        }

        @Override
        public void onRefreshTokenFailed(String dir, String folderId) {
            GoogleDriveFileListAdapter.this.dismissWaitingDialog();
        }
    };
    private DialogInterface.OnCancelListener mWaitingDialogCancelListener = new DialogInterface.OnCancelListener(){

        public void onCancel(DialogInterface arg0) {
            GoogleDriveFileListAdapter.this.cancel();
        }
    };

    public void init(ZMActivity activity, ZMFileListListener l) {
        super.init(activity, l);
        this.mListener = l;
        this.mGoogleDrive = GoogleDriveMgr.getInstance().getGoogleDrive((Context)activity);
        this.mGoogleDrive.bind(activity, this.mHandler, this);
        this.mCachedDir = AppUtil.getCachePath();
    }

    public void onResume() {
        this.login();
    }

    public void login() {
        if (this.mGoogleDrive.isAuthed()) {
            if (this.mListener != null) {
                this.mListener.onStarted(true, null);
            }
            return;
        }
        this.mGoogleDrive.login();
        if (this.mListener != null) {
            this.mListener.onStarting();
        }
    }

    public void onDestroy() {
        this.mGoogleDrive.onDestroy();
    }

    public void logout() {
        super.logout();
        this.mGoogleDrive.logout();
    }

    protected void openFile(ZMFileListEntry file) {
        if (file == null || file.isDir()) {
            return;
        }
        long size = file.getBytes();
        if (size <= 0L) {
            size = 0x3200000L;
        }
        if (!AppUtil.hasEnoughDiskSpace(this.mCachedDir, size)) {
            this.alertMemoryNotEnough(this.mActivity.getString(R.string.zm_title_error), this.mActivity.getString(R.string.zm_msg_memory_size_insufficient));
            return;
        }
        if (!(file instanceof GoogleDriveObjectEntry)) {
            return;
        }
        GoogleDriveObjectEntry entry = (GoogleDriveObjectEntry)file;
        boolean ret = this.mGoogleDrive.downloadFile(entry, this.mCachedDir, this.mDownloadFileListener);
        if (ret) {
            this.showWaitingDialog(this.mActivity.getString(R.string.zm_msg_download_file_progress, new Object[]{0}), this.mWaitingDialogCancelListener);
        }
    }

    public boolean openDir(String dir) {
        boolean ret;
        if (StringUtil.isEmptyOrNull((String)dir)) {
            dir = File.separator;
        }
        if (dir.equals(this.mCurrentDir)) {
            return true;
        }
        String dirId = null;
        if (this.mDirCached.containsKey(dir)) {
            GoogleDriveObjectEntry entry = this.mDirCached.get(dir);
            dirId = entry.getId();
        }
        if (ret = this.mGoogleDrive.loadFolder(dir, dirId, this.mLoadFolderListener)) {
            this.showWaitingDialog(this.mActivity.getString(R.string.zm_msg_loading), this.mWaitingDialogCancelListener);
        }
        return true;
    }

    protected void openDir(ZMFileListEntry dir) {
        if (dir == null || !dir.isDir()) {
            return;
        }
        if (!(dir instanceof GoogleDriveObjectEntry)) {
            return;
        }
        GoogleDriveObjectEntry entry = (GoogleDriveObjectEntry)dir;
        String path = entry.getPath();
        if (this.mCurrentDir.equals(path)) {
            return;
        }
        boolean ret = this.mGoogleDrive.loadFolder(entry.getPath(), entry.getId(), this.mLoadFolderListener);
        if (ret) {
            this.showWaitingDialog(this.mActivity.getString(R.string.zm_msg_loading), this.mWaitingDialogCancelListener);
        }
    }

    public boolean onBackPressed() {
        this.cancel();
        return super.onBackPressed();
    }

    public boolean isNeedAuth() {
        return true;
    }

    public boolean isRootDir() {
        return this.mCurrentDir == null || this.mCurrentDir.equals(File.separator);
    }

    public String getCurrentDirName() {
        if (StringUtil.isEmptyOrNull((String)this.mCurrentDir)) {
            return "";
        }
        return AndroidAppUtil.getPathLastName((String)this.mCurrentDir);
    }

    public String getCurrentDirPath() {
        if (StringUtil.isEmptyOrNull((String)this.mCurrentDir)) {
            return "";
        }
        return this.mCurrentDir;
    }

    protected void gotoParentDir() {
        boolean ret;
        int last;
        if (this.isRootDir() || this.mCurrentDir == null) {
            return;
        }
        if (!this.mGoogleDrive.isAuthed()) {
            return;
        }
        StringBuilder builder = new StringBuilder(this.getCurrentDirPath());
        String dir = builder.toString();
        if (dir.endsWith(File.separator)) {
            dir = dir.substring(0, dir.lastIndexOf(File.separator));
        }
        if ((dir = dir.substring(0, (last = dir.lastIndexOf(File.separator)) + 1)).equals(this.getCurrentDirName())) {
            return;
        }
        if (!dir.equals(File.separator) && dir.endsWith(File.separator)) {
            dir = dir.substring(0, dir.length() - 1);
        }
        String folderId = null;
        if (this.mDirCached.containsKey(dir)) {
            GoogleDriveObjectEntry entry = this.mDirCached.get(dir);
            folderId = entry.getId();
        }
        if (ret = this.mGoogleDrive.loadFolder(dir, folderId, this.mLoadFolderListener)) {
            this.showWaitingDialog(this.mActivity.getString(R.string.zm_msg_loading), this.mWaitingDialogCancelListener);
        }
    }

    @Override
    public void onAuthCredentialStarting() {
        this.showWaitingDialog(this.mActivity.getString(R.string.zm_msg_loading), this.mWaitingDialogCancelListener);
    }

    @Override
    public void onAuthStarting() {
        if (this.mListener != null) {
            this.mListener.onStarting();
        }
    }

    @Override
    public void onAuthSuccess() {
        this.dismissWaitingDialog();
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (GoogleDriveFileListAdapter.this.mListener != null) {
                    GoogleDriveFileListAdapter.this.mListener.onStarted(true, null);
                }
            }
        });
    }

    @Override
    public void onAuthError(final String errMsg) {
        this.dismissWaitingDialog();
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (GoogleDriveFileListAdapter.this.mListener != null) {
                    if (StringUtil.isEmptyOrNull((String)errMsg)) {
                        GoogleDriveFileListAdapter.this.mListener.onStarted(false, GoogleDriveFileListAdapter.this.mActivity.getString(R.string.zm_alert_auth_token_failed_msg));
                    } else {
                        GoogleDriveFileListAdapter.this.mListener.onStarted(false, errMsg);
                    }
                }
            }
        });
    }

    @Override
    public void onAuthCancel() {
        this.dismissWaitingDialog();
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (GoogleDriveFileListAdapter.this.mListener != null) {
                    GoogleDriveFileListAdapter.this.mListener.onStarted(false, "");
                }
            }
        });
    }

    @Override
    public void onAuthUnknowError() {
        this.dismissWaitingDialog();
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (GoogleDriveFileListAdapter.this.mListener != null) {
                    GoogleDriveFileListAdapter.this.mListener.onStarted(false, GoogleDriveFileListAdapter.this.mActivity.getString(R.string.zm_alert_auth_token_failed_msg));
                }
            }
        });
    }

    private void cancel() {
        this.mGoogleDrive.cancelAuth();
    }
}

