/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment.mm;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.fragment.mm.ContactItem;
import com.zipow.videobox.fragment.mm.ContactsAdapter;
import com.zipow.videobox.fragment.mm.MMInvitePhoneContactsFragment;
import com.zipow.videobox.ptapp.ABContactsCache;
import com.zipow.videobox.ptapp.ContactsMatchHelper;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.ZMBuddySyncInstance;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomBuddyGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.view.IMAddrBookItem;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.util.ZMLog;
import us.zoom.androidlib.widget.QuickSearchListView;
import us.zoom.videomeetings.R;

public class MMPhoneContactsInZoomFragment
extends ZMDialogFragment
implements SimpleActivity.ExtListener,
TextView.OnEditorActionListener,
ABContactsCache.IABContactsCacheListener,
View.OnClickListener,
ContactsAdapter.OnContactOPListener {
    private static final String TAG = MMPhoneContactsInZoomFragment.class.getSimpleName();
    private QuickSearchListView mContactListView;
    private View mEmptyView;
    private ContactsAdapter mAdapter;
    private List<ContactItem> mContacts = new ArrayList<ContactItem>();
    private View mPanelTitleBar;
    private EditText mEdtSearch;
    private View mPanelSearchBarReal;
    private View mPanelSearch;
    private EditText mEdtSearchReal;
    private Button mBtnClearSearchView;
    private boolean isKeyboardOpen;
    private String mFilterKey;
    private FrameLayout mPanelListViews;
    private Drawable mDimmedForground = null;
    private Handler mHandler = new Handler();
    private Runnable mRunnableFilter = new Runnable(){

        @Override
        public void run() {
            String key = MMPhoneContactsInZoomFragment.this.mEdtSearchReal.getText().toString();
            MMPhoneContactsInZoomFragment.this.filter(key);
            if (key.length() > 0 || MMPhoneContactsInZoomFragment.this.mPanelTitleBar.getVisibility() == 0) {
                MMPhoneContactsInZoomFragment.this.mPanelListViews.setForeground(null);
            } else {
                MMPhoneContactsInZoomFragment.this.mPanelListViews.setForeground(MMPhoneContactsInZoomFragment.this.mDimmedForground);
            }
        }
    };
    private PTUI.IPhoneABListener mIPhoneABListener = new PTUI.IPhoneABListener(){

        @Override
        public void onPhoneABEvent(int event, long result, Object content) {
            MMPhoneContactsInZoomFragment.this.loadAllZoomPhoneContacts();
        }
    };
    private ZoomMessengerUI.SimpleZoomMessengerUIListener mMessengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

        @Override
        public void Indicate_BuddyGroupsRemoved(List<String> groupIDs) {
            MMPhoneContactsInZoomFragment.this.loadAllZoomPhoneContacts();
        }

        @Override
        public void Indicate_BuddyGroupAdded(String groupID) {
            MMPhoneContactsInZoomFragment.this.loadAllZoomPhoneContacts();
        }

        @Override
        public void Indicate_BuddyGroupInfoUpdated(String groupID) {
            MMPhoneContactsInZoomFragment.this.loadAllZoomPhoneContacts();
        }

        @Override
        public void Indicate_BuddyGroupMembersAdded(String groupID, List<String> jidList) {
            MMPhoneContactsInZoomFragment.this.loadAllZoomPhoneContacts();
        }

        @Override
        public void Indicate_BuddyGroupMembersRemoved(String groupID, List<String> jidList) {
            MMPhoneContactsInZoomFragment.this.loadAllZoomPhoneContacts();
        }

        @Override
        public void Indicate_BuddyGroupMembersChanged(PTAppProtos.ChangedBuddyGroups changedBuddyGroups, boolean bLastPage) {
            MMPhoneContactsInZoomFragment.this.loadAllZoomPhoneContacts();
        }

        @Override
        public void Indicate_BuddyGroupMemberAdded(String groupName, String jid) {
            MMPhoneContactsInZoomFragment.this.loadAllZoomPhoneContacts();
        }

        @Override
        public void Indicate_BuddyGroupMemberRemoved(String groupName, String jid) {
            MMPhoneContactsInZoomFragment.this.loadAllZoomPhoneContacts();
        }

        @Override
        public void onIndicateInfoUpdatedWithJID(String jid) {
            MMPhoneContactsInZoomFragment.this.onIndicateInfoUpdatedWithJID(jid);
        }
    };

    public static void showAsActivity(ZMActivity activity, int requestCode) {
        Bundle args = new Bundle();
        SimpleActivity.show(activity, MMPhoneContactsInZoomFragment.class.getName(), args, requestCode, false, 1);
    }

    public static void showAsActivity(Fragment fragment, int requestCode) {
        Bundle args = new Bundle();
        SimpleActivity.show(fragment, MMPhoneContactsInZoomFragment.class.getName(), args, requestCode, false, 1);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_contacts_in_zoom, container, false);
        view.findViewById(R.id.btnCancel).setOnClickListener((View.OnClickListener)this);
        this.mContactListView = (QuickSearchListView)view.findViewById(R.id.contactListView);
        this.mEmptyView = view.findViewById(R.id.emptyView);
        view.findViewById(R.id.btnInviteZoom).setOnClickListener((View.OnClickListener)this);
        this.mAdapter = new ContactsAdapter((Context)this.getActivity(), this);
        this.mContactListView.setAdapter((QuickSearchListView.QuickSearchListDataAdapter)this.mAdapter);
        this.addFooterView();
        this.mPanelListViews = (FrameLayout)view.findViewById(R.id.panelListViews);
        this.mPanelTitleBar = view.findViewById(R.id.panelTitleBar);
        this.mEdtSearch = (EditText)view.findViewById(R.id.edtSearch);
        this.mPanelSearchBarReal = view.findViewById(R.id.panelSearchBarReal);
        this.mEdtSearchReal = (EditText)view.findViewById(R.id.edtSearchReal);
        this.mBtnClearSearchView = (Button)view.findViewById(R.id.btnClearSearchView);
        this.mPanelSearch = view.findViewById(R.id.panelSearch);
        Resources res = this.getResources();
        if (res != null) {
            this.mDimmedForground = new ColorDrawable(res.getColor(R.color.zm_dimmed_forground));
        }
        this.mEdtSearchReal.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        this.mBtnClearSearchView.setOnClickListener((View.OnClickListener)this);
        this.mEdtSearchReal.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                MMPhoneContactsInZoomFragment.this.mHandler.removeCallbacks(MMPhoneContactsInZoomFragment.this.mRunnableFilter);
                MMPhoneContactsInZoomFragment.this.mHandler.postDelayed(MMPhoneContactsInZoomFragment.this.mRunnableFilter, 300L);
                MMPhoneContactsInZoomFragment.this.updateClearSearchView();
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
        this.compatPCModeForSearch();
        return view;
    }

    private void addFooterView() {
        View view = View.inflate((Context)this.getActivity(), (int)R.layout.zm_item_invite_people, null);
        view.findViewById(R.id.btnInviteZoom).setOnClickListener((View.OnClickListener)this);
        this.mContactListView.getListView().addFooterView(view);
    }

    private void compatPCModeForSearch() {
        View.OnFocusChangeListener onFocusChangeListener = new View.OnFocusChangeListener(){

            public void onFocusChange(final View v, boolean hasFocus) {
                if (hasFocus) {
                    MMPhoneContactsInZoomFragment.this.mHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (!MMPhoneContactsInZoomFragment.this.isAdded() || !MMPhoneContactsInZoomFragment.this.isResumed()) {
                                return;
                            }
                            int id2 = v.getId();
                            if (id2 != R.id.edtSearch) {
                                return;
                            }
                            EditText editText = (EditText)v;
                            if (editText.hasFocus()) {
                                MMPhoneContactsInZoomFragment.this.onKeyboardOpen();
                            }
                        }
                    }, 500L);
                }
            }
        };
        this.mEdtSearch.setOnFocusChangeListener(onFocusChangeListener);
    }

    private void onIndicateInfoUpdatedWithJID(String jid) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        ZoomBuddy buddy = messenger.getBuddyWithJID(jid);
        if (buddy == null || buddy.getPhoneNumber() == null) {
            boolean found = false;
            for (int i = 0; i < this.mContacts.size(); ++i) {
                ContactItem item = this.mContacts.get(i);
                if (item.getBuddy() == null || !TextUtils.equals((CharSequence)jid, (CharSequence)item.getBuddy().getJid())) continue;
                found = true;
                this.mContacts.remove(i);
            }
            if (found) {
                this.doFilter();
            }
        } else {
            ABContactsCache contactsCache;
            ABContactsCache.Contact contact;
            String phoneNumber = buddy.getPhoneNumber();
            boolean found = false;
            for (int i = 0; i < this.mContacts.size(); ++i) {
                ContactItem item = this.mContacts.get(i);
                if (item.getBuddy() == null || !TextUtils.equals((CharSequence)jid, (CharSequence)item.getBuddy().getJid())) continue;
                found = true;
            }
            if (!found && (contact = (contactsCache = ABContactsCache.getInstance()).getFirstContactByPhoneNumber(phoneNumber)) != null) {
                ContactItem item = new ContactItem();
                item.setContact(contact);
                item.setBuddy(IMAddrBookItem.fromZoomBuddy(buddy));
                this.mContacts.add(item);
                this.doFilter();
            }
        }
    }

    private void doFilter() {
        ArrayList<ContactItem> contacts = new ArrayList<ContactItem>();
        if (StringUtil.isEmptyOrNull((String)this.mFilterKey)) {
            contacts.addAll(this.mContacts);
        } else {
            for (ContactItem contact : this.mContacts) {
                if (contact.getContact() == null || !contact.getContact().filter(this.mFilterKey)) continue;
                contacts.add(contact);
            }
        }
        this.mAdapter.setData(contacts);
        this.mAdapter.notifyDataSetChanged();
        this.mEmptyView.setVisibility(this.mAdapter.getCount() == 0 ? 0 : 8);
    }

    private void filter(String key) {
        if (key == null) {
            return;
        }
        if (StringUtil.isSameString((String)(key = key.trim().toLowerCase(CompatUtils.getLocalDefault())), (String)this.mFilterKey)) {
            return;
        }
        this.mFilterKey = key;
        this.doFilter();
    }

    @Override
    public boolean onSearchRequested() {
        return false;
    }

    @Override
    public boolean onTipLayerTouched() {
        return false;
    }

    @Override
    public void onKeyboardOpen() {
        if (this.isKeyboardOpen) {
            return;
        }
        this.isKeyboardOpen = true;
        if (this.mEdtSearch.hasFocus()) {
            this.mPanelTitleBar.setVisibility(8);
            this.mPanelListViews.setForeground(this.mDimmedForground);
            this.mPanelSearchBarReal.setVisibility(0);
            this.mPanelSearch.setVisibility(8);
            this.mEdtSearchReal.setText((CharSequence)"");
            this.mEdtSearchReal.requestFocus();
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    MMPhoneContactsInZoomFragment.this.mPanelListViews.getParent().requestLayout();
                }
            });
        }
    }

    @Override
    public void onKeyboardClosed() {
        this.isKeyboardOpen = false;
        if (this.mEdtSearch == null) {
            return;
        }
        if (this.mEdtSearchReal.length() == 0 || this.mContactListView.getListView().getCount() == 0) {
            this.mPanelListViews.setForeground(null);
            this.mEdtSearchReal.setText((CharSequence)"");
            this.mPanelTitleBar.setVisibility(0);
            this.mPanelSearchBarReal.setVisibility(4);
            this.mPanelSearch.setVisibility(0);
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                MMPhoneContactsInZoomFragment.this.mContactListView.requestLayout();
            }
        });
    }

    @Override
    public boolean onBackPressed() {
        return this.handleBackPressed();
    }

    public boolean handleBackPressed() {
        if (this.mPanelSearchBarReal.getVisibility() == 0) {
            this.mPanelTitleBar.setVisibility(0);
            this.mPanelSearchBarReal.setVisibility(4);
            this.mPanelSearch.setVisibility(0);
            this.mEdtSearchReal.setText((CharSequence)"");
            this.isKeyboardOpen = false;
            return true;
        }
        return false;
    }

    private void updateClearSearchView() {
        this.mBtnClearSearchView.setVisibility(this.mEdtSearchReal.getText().length() > 0 ? 0 : 8);
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        int id2 = v.getId();
        if (id2 == R.id.edtSearch) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
            return true;
        }
        return false;
    }

    @Override
    public void onContactsCacheUpdated() {
        this.loadAllZoomPhoneContacts();
    }

    private void onClickBtnClearSearchView() {
        this.mEdtSearchReal.setText((CharSequence)"");
        if (!this.isKeyboardOpen) {
            this.mPanelTitleBar.setVisibility(0);
            this.mPanelSearchBarReal.setVisibility(8);
            this.mPanelSearch.setVisibility(0);
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    MMPhoneContactsInZoomFragment.this.mContactListView.requestLayout();
                }
            });
        }
    }

    public void onResume() {
        super.onResume();
        this.mContactListView.onResume();
        this.loadAllZoomPhoneContacts();
    }

    public void onStart() {
        super.onStart();
        ABContactsCache cache = ABContactsCache.getInstance();
        if (cache.needReloadAll()) {
            this.matchNewNumbers();
            cache.reloadAllContacts();
        }
        cache.addListener(this);
        ZoomMessengerUI.getInstance().addListener(this.mMessengerUIListener);
        PTUI.getInstance().addPhoneABListener(this.mIPhoneABListener);
    }

    public void onStop() {
        ABContactsCache.getInstance().removeListener(this);
        ZoomMessengerUI.getInstance().removeListener(this.mMessengerUIListener);
        PTUI.getInstance().removePhoneABListener(this.mIPhoneABListener);
        super.onStop();
    }

    private void matchNewNumbers() {
        if (!PTApp.getInstance().isWebSignedOn()) {
            return;
        }
        ContactsMatchHelper.getInstance().matchNewNumbers(this.getContext());
    }

    private void loadAllZoomPhoneContacts() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddyGroup buddyGroup = messenger.getAddressbookContactBuddyGroup();
        if (buddyGroup == null || buddyGroup.getBuddyCount() == 0) {
            return;
        }
        ABContactsCache cache = ABContactsCache.getInstance();
        this.mContacts.clear();
        for (int i = 0; i < buddyGroup.getBuddyCount(); ++i) {
            ZoomBuddy buddy = buddyGroup.getBuddyAt(i);
            if (buddy == null) continue;
            ZMLog.i((String)TAG, (String)"loadAllZoomPhoneContacts find buddy %s ", (Object[])new Object[]{buddy.getJid()});
            String number = buddy.getPhoneNumber();
            if (StringUtil.isEmptyOrNull((String)number)) {
                ZMLog.e((String)TAG, (String)"loadAllZoomPhoneContacts buddy in AddressbookContactBuddyGroup but no phone %s ", (Object[])new Object[]{buddy.getJid()});
                continue;
            }
            ABContactsCache.Contact contact = cache.getFirstContactByPhoneNumber(number);
            if (contact == null) {
                ZMLog.e((String)TAG, (String)"loadAllZoomPhoneContacts buddy in AddressbookContactBuddyGroup but can not match %s number:%s", (Object[])new Object[]{buddy.getJid(), number});
                continue;
            }
            ContactItem item = new ContactItem();
            item.setBuddy(IMAddrBookItem.fromZoomBuddy(buddy));
            item.setContact(contact);
            this.mContacts.add(item);
        }
        this.doFilter();
    }

    public void onClick(View v) {
        if (v == null) {
            return;
        }
        int id2 = v.getId();
        if (id2 == R.id.btnCancel) {
            this.finishFragment(true);
        } else if (id2 == R.id.btnInviteZoom) {
            this.onBtnInviteClick();
        } else if (id2 == R.id.btnClearSearchView) {
            this.onClickBtnClearSearchView();
        }
    }

    private void onBtnInviteClick() {
        MMInvitePhoneContactsFragment.showAsActivity((Fragment)this, 0);
    }

    @Override
    public void onContactAddClick(ContactItem item) {
        if (item == null || item.getBuddy() == null) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (!messenger.isConnectionGood()) {
            this.showConnectionError();
            return;
        }
        ZoomBuddy myself = messenger.getMyself();
        String myName = myself == null ? "" : myself.getScreenName();
        boolean res = messenger.addBuddyByJID(item.getBuddy().getJid(), myName, null, item.getBuddy().getScreenName(), item.getBuddy().getAccountEmail());
        if (res) {
            ZMBuddySyncInstance.getInsatance().onAddBuddyByJid(item.getBuddy().getJid());
            item.getBuddy().setPending(true);
            this.mAdapter.notifyDataSetChanged();
        }
    }

    private void showConnectionError() {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        Toast.makeText((Context)context, (int)R.string.zm_msg_disconnected_try_again, (int)1).show();
    }
}

