/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment.mm;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import com.zipow.videobox.fragment.mm.ContactItem;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.widget.QuickSearchListView;
import us.zoom.videomeetings.R;

class ContactsAdapter
extends QuickSearchListView.QuickSearchListDataAdapter
implements View.OnClickListener {
    private static final String TAG = ContactsAdapter.class.getSimpleName();
    private List<ContactItem> mData = new ArrayList<ContactItem>();
    private Context mContext;
    private OnContactOPListener mOnContactOPListener;

    public ContactsAdapter(Context context, OnContactOPListener onContactOPListener) {
        if (context == null) {
            // empty if block
        }
        this.mOnContactOPListener = onContactOPListener;
        this.mContext = context;
    }

    public String getItemSortKey(Object item) {
        if (item instanceof ContactItem) {
            return ((ContactItem)item).getContact().sortKey;
        }
        return null;
    }

    public void setData(List<ContactItem> data) {
        this.mData.clear();
        if (data != null) {
            this.mData.addAll(data);
        }
    }

    public int getCount() {
        return this.mData.size();
    }

    public ContactItem getItem(int position) {
        if (this.mData.size() <= position) {
            return null;
        }
        return this.mData.get(position);
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        return this.getContactView(position, convertView, parent);
    }

    private View getContactView(int position, View convertView, ViewGroup parent) {
        ContactItem item = this.getItem(position);
        if (item == null) {
            return convertView;
        }
        if (convertView == null || !"ContactItem".equals(convertView.getTag())) {
            convertView = View.inflate((Context)this.mContext, (int)R.layout.zm_item_contacts_in_zoom, null);
        }
        TextView name = (TextView)convertView.findViewById(R.id.txtContactName);
        TextView number = (TextView)convertView.findViewById(R.id.txtContactNumber);
        Button btnAdd = (Button)convertView.findViewById(R.id.btnAdd);
        View txtAdded = convertView.findViewById(R.id.txtAdded);
        if (item.getContact() == null) {
            return convertView;
        }
        name.setText((CharSequence)item.getContact().displayName);
        number.setText((CharSequence)item.getContact().normalizedNumber);
        if (item.getBuddy() != null && (item.getBuddy().isMyContact() || item.getBuddy().isPending())) {
            btnAdd.setVisibility(8);
            txtAdded.setVisibility(0);
        } else {
            btnAdd.setVisibility(0);
            txtAdded.setVisibility(8);
        }
        btnAdd.setOnClickListener((View.OnClickListener)this);
        btnAdd.setTag((Object)item);
        return convertView;
    }

    public void onClick(View v) {
        if (v.getId() == R.id.btnAdd) {
            ContactItem item = (ContactItem)v.getTag();
            if (this.mOnContactOPListener != null) {
                this.mOnContactOPListener.onContactAddClick(item);
            }
        }
    }

    public static interface OnContactOPListener {
        public void onContactAddClick(ContactItem var1);
    }
}

