/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment.meeting.qa.dialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.widget.CheckedTextView;
import android.widget.ImageView;
import android.widget.TextView;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class ZMQAMoreDialog
extends ZMDialogFragment
implements View.OnClickListener {
    private View mViewAllQuestions;
    private View mViewAnswerQaOnly;
    private TextView mTxtAllQuestions;
    private TextView mTxtAnswerQaOnly;
    private TextView mTxtCanComment;
    private TextView mTxtCanUpVote;
    private ImageView mImgAllQuestions;
    private ImageView mImgAnswerQaOnly;
    private View mViewDivider;
    private View mOptionAllowAskQA;
    private View mOptionCanComment;
    private View mOptionCanUpVote;
    private CheckedTextView mChkAllowAskQA;
    private CheckedTextView mChkCanUpVote;
    private CheckedTextView mChkCanComment;
    private ConfUI.IConfUIListener mConfUIListener;

    public static void show(ZMActivity activity) {
        if (activity == null || activity.isDestroyed()) {
            return;
        }
        ZMQAMoreDialog dlg = new ZMQAMoreDialog();
        dlg.show(activity.getSupportFragmentManager(), ZMQAMoreDialog.class.getName());
    }

    public static void dismiss(FragmentManager fm) {
        if (fm == null) {
            return;
        }
        ZMQAMoreDialog zmqaMoreDialog = (ZMQAMoreDialog)fm.findFragmentByTag(ZMQAMoreDialog.class.getName());
        if (zmqaMoreDialog != null) {
            zmqaMoreDialog.dismiss();
        }
    }

    public static void refresh(ZMActivity zmActivity) {
        ZMQAMoreDialog confAllowAskQADialog;
        if (zmActivity != null && zmActivity.isActive() && (confAllowAskQADialog = (ZMQAMoreDialog)zmActivity.getSupportFragmentManager().findFragmentByTag(ZMQAMoreDialog.class.getName())) != null && confAllowAskQADialog.isAdded()) {
            confAllowAskQADialog.update();
        }
    }

    public ZMQAMoreDialog() {
        this.setCancelable(true);
    }

    public void onStart() {
        super.onStart();
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        ZMAlertDialog.Builder builder = new ZMAlertDialog.Builder((Context)this.getActivity()).setCancelable(true).setTheme(R.style.ZMDialog_Material).setView(this.createContent()).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        });
        ZMAlertDialog dialog = builder.create();
        dialog.setCanceledOnTouchOutside(true);
        return dialog;
    }

    public void onPause() {
        super.onPause();
        ConfUI.getInstance().removeListener(this.mConfUIListener);
    }

    public void onResume() {
        super.onResume();
        if (this.mConfUIListener == null) {
            this.mConfUIListener = new ConfUI.SimpleConfUIListener(){

                @Override
                public boolean onConfStatusChanged2(int cmd, long ret) {
                    if (cmd == 30 || cmd == 32 || cmd == 33 || cmd == 34) {
                        ZMQAMoreDialog.this.update();
                    }
                    return true;
                }
            };
        }
        ConfUI.getInstance().addListener(this.mConfUIListener);
        this.update();
    }

    private View createContent() {
        ContextThemeWrapper contextThemeWrapper = new ContextThemeWrapper((Context)this.getActivity(), R.style.ZMDialog_Material);
        View view = View.inflate((Context)contextThemeWrapper, (int)R.layout.zm_dialog_qa_more, null);
        this.mOptionAllowAskQA = view.findViewById(R.id.optionChkAllowAskQA);
        this.mOptionCanComment = view.findViewById(R.id.optionChkCanComment);
        this.mOptionCanUpVote = view.findViewById(R.id.optionChkCanUpVote);
        this.mOptionAllowAskQA.setOnClickListener((View.OnClickListener)this);
        this.mOptionCanComment.setOnClickListener((View.OnClickListener)this);
        this.mOptionCanUpVote.setOnClickListener((View.OnClickListener)this);
        this.mChkAllowAskQA = (CheckedTextView)view.findViewById(R.id.chkAllowAskQA);
        this.mChkCanUpVote = (CheckedTextView)view.findViewById(R.id.chkCanUpVote);
        this.mChkCanComment = (CheckedTextView)view.findViewById(R.id.chkCanComment);
        this.mTxtCanComment = (TextView)view.findViewById(R.id.txtCanComment);
        this.mTxtCanUpVote = (TextView)view.findViewById(R.id.txtCanUpVote);
        this.mViewAllQuestions = view.findViewById(R.id.llAllQuestions);
        this.mViewAnswerQaOnly = view.findViewById(R.id.llAnswerQaOnly);
        this.mImgAllQuestions = (ImageView)view.findViewById(R.id.imgSelectedAllQuestions);
        this.mImgAnswerQaOnly = (ImageView)view.findViewById(R.id.imgSelectedAnswerQaOnly);
        this.mTxtAllQuestions = (TextView)view.findViewById(R.id.txtAllQuestions);
        this.mTxtAnswerQaOnly = (TextView)view.findViewById(R.id.txtAnswerQaOnly);
        this.mViewDivider = view.findViewById(R.id.viewDivider);
        this.mViewAllQuestions.setOnClickListener((View.OnClickListener)this);
        this.mViewAnswerQaOnly.setOnClickListener((View.OnClickListener)this);
        this.update();
        return view;
    }

    private void update() {
        if (this.mChkAllowAskQA == null) {
            return;
        }
        ConfMgr confMgr = ConfMgr.getInstance();
        if (confMgr == null) {
            return;
        }
        this.mChkAllowAskQA.setChecked(confMgr.isAllowAskQuestionAnonymously());
        this.updateAllowAttendeeViewAllQuestion(confMgr.isAllowAttendeeViewAllQuestion());
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.optionChkAllowAskQA) {
            this.onClickOptionChkAllowAskQA();
        } else if (id2 == R.id.optionChkCanComment) {
            this.onClickOptionChkCanComment();
        } else if (id2 == R.id.optionChkCanUpVote) {
            this.onClickOptionChkCanUpVote();
        } else if (id2 == R.id.llAnswerQaOnly) {
            this.onClickAnswerQaOnly();
        } else if (id2 == R.id.llAllQuestions) {
            this.onClickAllQuestions();
        }
    }

    private void onClickAnswerQaOnly() {
        ConfMgr confMgr = ConfMgr.getInstance();
        if (confMgr == null) {
            return;
        }
        boolean isAllowAttendeeViewAllQuestion = confMgr.isAllowAttendeeViewAllQuestion();
        if (isAllowAttendeeViewAllQuestion && confMgr.handleConfCmd(112)) {
            this.updateAllowAttendeeViewAllQuestion(false);
        }
    }

    private void onClickAllQuestions() {
        ConfMgr confMgr = ConfMgr.getInstance();
        if (confMgr == null) {
            return;
        }
        boolean isAllowAttendeeViewAllQuestion = confMgr.isAllowAttendeeViewAllQuestion();
        if (!isAllowAttendeeViewAllQuestion && confMgr.handleConfCmd(111)) {
            this.updateAllowAttendeeViewAllQuestion(true);
        }
    }

    private void onClickOptionChkAllowAskQA() {
        boolean isAllowAskQa = ConfMgr.getInstance().isAllowAskQuestionAnonymously();
        if (ConfMgr.getInstance().handleConfCmd(isAllowAskQa ? 110 : 109)) {
            this.mChkAllowAskQA.setChecked(!isAllowAskQa);
        }
    }

    private void onClickOptionChkCanComment() {
        boolean isAllowAttendeeAnswerQuestion = ConfMgr.getInstance().isAllowAttendeeAnswerQuestion();
        if (ConfMgr.getInstance().handleConfCmd(isAllowAttendeeAnswerQuestion ? 116 : 115)) {
            this.mChkCanComment.setChecked(!isAllowAttendeeAnswerQuestion);
        }
    }

    private void onClickOptionChkCanUpVote() {
        boolean isAllowAttendeeUpvoteQuestion = ConfMgr.getInstance().isAllowAttendeeUpvoteQuestion();
        if (ConfMgr.getInstance().handleConfCmd(isAllowAttendeeUpvoteQuestion ? 114 : 113)) {
            this.mChkCanUpVote.setChecked(!isAllowAttendeeUpvoteQuestion);
        }
    }

    private void updateAllowAttendeeViewAllQuestion(boolean isAllowAttendeeViewAllQuestion) {
        ConfMgr confMgr = ConfMgr.getInstance();
        if (confMgr == null) {
            return;
        }
        CmmConfContext confContext = confMgr.getConfContext();
        if (confContext == null) {
            return;
        }
        Resources resources = this.getResources();
        if (confContext.isAllowAttendeeViewAllQuestionChangable()) {
            this.mViewAllQuestions.setEnabled(true);
            this.mViewAnswerQaOnly.setEnabled(true);
            this.mImgAllQuestions.setAlpha(1.0f);
            this.mImgAnswerQaOnly.setAlpha(1.0f);
            this.mTxtAllQuestions.setTextColor(resources.getColor(R.color.zm_text_light_dark));
            this.mTxtAnswerQaOnly.setTextColor(resources.getColor(R.color.zm_text_light_dark));
        } else {
            this.mViewAllQuestions.setEnabled(false);
            this.mViewAnswerQaOnly.setEnabled(false);
            this.mImgAllQuestions.setAlpha(0.3f);
            this.mImgAnswerQaOnly.setAlpha(0.3f);
            this.mTxtAllQuestions.setTextColor(resources.getColor(R.color.zm_text_dim));
            this.mTxtAnswerQaOnly.setTextColor(resources.getColor(R.color.zm_text_dim));
        }
        if (isAllowAttendeeViewAllQuestion) {
            this.mImgAllQuestions.setVisibility(0);
            this.mImgAnswerQaOnly.setVisibility(4);
            this.mViewDivider.setVisibility(0);
            this.mOptionCanComment.setVisibility(0);
            this.mOptionCanUpVote.setVisibility(0);
            this.mChkCanUpVote.setChecked(confMgr.isAllowAttendeeUpvoteQuestion());
            this.mChkCanComment.setChecked(confMgr.isAllowAttendeeAnswerQuestion());
            if (confContext.isAllowAttendeeUpvoteQuestionChangable()) {
                this.mOptionCanUpVote.setEnabled(true);
                this.mChkCanUpVote.setEnabled(true);
                this.mTxtCanUpVote.setTextColor(resources.getColor(R.color.zm_text_light_dark));
            } else {
                this.mOptionCanUpVote.setEnabled(false);
                this.mChkCanUpVote.setEnabled(false);
                this.mTxtCanUpVote.setTextColor(resources.getColor(R.color.zm_text_dim));
            }
            if (confContext.isAllowAttendeeAnswerQuestionChangable()) {
                this.mOptionCanComment.setEnabled(true);
                this.mChkCanComment.setEnabled(true);
                this.mTxtCanComment.setTextColor(resources.getColor(R.color.zm_text_light_dark));
            } else {
                this.mOptionCanComment.setEnabled(false);
                this.mChkCanComment.setEnabled(false);
                this.mTxtCanComment.setTextColor(resources.getColor(R.color.zm_text_dim));
            }
        } else {
            this.mImgAllQuestions.setVisibility(4);
            this.mImgAnswerQaOnly.setVisibility(0);
            this.mViewDivider.setVisibility(8);
            this.mOptionCanComment.setVisibility(8);
            this.mOptionCanUpVote.setVisibility(8);
        }
    }
}

