/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment.meeting.qa.dialog;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.text.method.ScrollingMovementMethod;
import android.view.ContextThemeWrapper;
import android.view.KeyEvent;
import android.view.View;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.qa.ZoomQAAnswer;
import com.zipow.videobox.confapp.qa.ZoomQAComponent;
import com.zipow.videobox.confapp.qa.ZoomQAQuestion;
import com.zipow.videobox.confapp.qa.ZoomQAUI;
import java.util.LinkedHashMap;
import java.util.Map;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.WaitingDialog;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class ZMQAAnswerDialog
extends ZMDialogFragment
implements View.OnClickListener {
    private static final String TAG = ZMQAAnswerDialog.class.getSimpleName();
    private static final int MAX_CACHE_COUNT = 2;
    private static final String ARG_QUESTION_ID = "questionId";
    private View mBtnSend;
    private EditText mEdtContent;
    private CheckBox mChkPrivately;
    private View mOptionPrivately;
    private View mTxtPrivately;
    private TextView mTxtQuestion;
    private String mQuestionId;
    private String mAnswerId;
    private ZoomQAUI.IZoomQAUIListener mQAUIListener;
    private long mLastClickSendTime = 0L;
    private static LinkedHashMap<String, String> mDraft = new LinkedHashMap();
    private Handler mHandler = new Handler();
    private Runnable mShowKeyboardRunnable = new Runnable(){

        @Override
        public void run() {
            if (ZMQAAnswerDialog.this.mEdtContent != null) {
                ZMQAAnswerDialog.this.mEdtContent.requestFocus();
                UIUtil.openSoftKeyboard((Context)ZMQAAnswerDialog.this.getActivity(), (View)ZMQAAnswerDialog.this.mEdtContent);
            }
        }
    };

    public static void show(ZMActivity activity, String questionId) {
        if (activity != null && activity.isActive()) {
            ZMQAAnswerDialog zmqaAnswerDialog = new ZMQAAnswerDialog();
            Bundle bundle = new Bundle();
            bundle.putString(ARG_QUESTION_ID, questionId);
            zmqaAnswerDialog.setArguments(bundle);
            zmqaAnswerDialog.show(activity.getSupportFragmentManager(), ZMQAAnswerDialog.class.getName());
        }
    }

    public static void dismiss(FragmentManager fm) {
        if (fm == null) {
            return;
        }
        ZMQAAnswerDialog zmqaAnswerDialog = (ZMQAAnswerDialog)fm.findFragmentByTag(ZMQAAnswerDialog.class.getName());
        if (zmqaAnswerDialog != null) {
            zmqaAnswerDialog.dismiss();
        }
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        View view;
        Bundle args = this.getArguments();
        if (args != null) {
            this.mQuestionId = args.getString(ARG_QUESTION_ID);
        }
        if ((view = this.createContent(savedInstanceState)) == null) {
            return this.createEmptyDialog();
        }
        ZMAlertDialog.Builder builder = new ZMAlertDialog.Builder((Context)this.getActivity()).setCancelable(true).setTheme(R.style.ZMDialog_Material_RoundRect).setView(view, true);
        ZMAlertDialog dialog = builder.create();
        dialog.setCanceledOnTouchOutside(false);
        return dialog;
    }

    private View createContent(Bundle savedInstanceState) {
        String content;
        if (savedInstanceState != null) {
            this.mQuestionId = savedInstanceState.getString("mQuestionId");
            this.mAnswerId = savedInstanceState.getString("mAnswerId");
        }
        ContextThemeWrapper context = new ContextThemeWrapper((Context)this.getActivity(), R.style.ZMDialog_Material_RoundRect);
        View view = View.inflate((Context)context, (int)R.layout.zm_dialog_qa_answer, null);
        view.findViewById(R.id.imgClose).setOnClickListener((View.OnClickListener)this);
        this.mTxtQuestion = (TextView)view.findViewById(R.id.txtQuestion);
        this.mTxtQuestion.setMovementMethod(ScrollingMovementMethod.getInstance());
        this.mEdtContent = (EditText)view.findViewById(R.id.edtContent);
        this.mBtnSend = view.findViewById(R.id.btnSend);
        this.mBtnSend.setOnClickListener((View.OnClickListener)this);
        this.mOptionPrivately = view.findViewById(R.id.optionPrivately);
        this.mChkPrivately = (CheckBox)view.findViewById(R.id.chkPrivately);
        this.mTxtPrivately = view.findViewById(R.id.txtPrivately);
        this.mOptionPrivately.setOnClickListener((View.OnClickListener)this);
        this.mOptionPrivately.setVisibility(ConfMgr.getInstance().isViewOnlyMeeting() ? 4 : 0);
        this.mEdtContent.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == 4) {
                    ZMQAAnswerDialog.this.onClickBtnSend();
                }
                return false;
            }
        });
        this.mEdtContent.addTextChangedListener(new TextWatcher(){

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void afterTextChanged(Editable s) {
                String content = ZMQAAnswerDialog.this.mEdtContent.getEditableText().toString();
                ZMQAAnswerDialog.this.mBtnSend.setEnabled(content.length() != 0);
                if (!StringUtil.isEmptyOrNull((String)ZMQAAnswerDialog.this.mQuestionId)) {
                    if (mDraft.containsKey(ZMQAAnswerDialog.this.mQuestionId)) {
                        if (!StringUtil.isSameString((String)((String)mDraft.get(ZMQAAnswerDialog.this.mQuestionId)), (String)content)) {
                            mDraft.remove(ZMQAAnswerDialog.this.mQuestionId);
                        }
                        mDraft.put(ZMQAAnswerDialog.this.mQuestionId, content);
                    } else {
                        if (mDraft.size() >= 2) {
                            Map.Entry toEvict = mDraft.entrySet().iterator().next();
                            mDraft.remove(toEvict.getKey());
                        }
                        mDraft.put(ZMQAAnswerDialog.this.mQuestionId, content);
                    }
                }
            }
        });
        if (!StringUtil.isEmptyOrNull((String)this.mQuestionId) && mDraft.containsKey(this.mQuestionId) && !StringUtil.isEmptyOrNull((String)(content = mDraft.get(this.mQuestionId)))) {
            this.mEdtContent.setText((CharSequence)content);
            this.mEdtContent.setSelection(content.length());
            this.mBtnSend.setEnabled(true);
        }
        return view;
    }

    public void onPause() {
        super.onPause();
        this.mHandler.removeCallbacks(this.mShowKeyboardRunnable);
        ZoomQAUI.getInstance().removeListener(this.mQAUIListener);
    }

    public void onResume() {
        super.onResume();
        if (this.mQAUIListener == null) {
            this.mQAUIListener = new ZoomQAUI.SimpleZoomQAUIListener(){

                @Override
                public void onAddAnswer(String answerID, boolean bSuccess) {
                    ZMQAAnswerDialog.this.onAddAnswer(answerID, bSuccess);
                }

                @Override
                public void notifyConnectResult(boolean bConnectSuccess) {
                    ZMQAAnswerDialog.this.notifyConnectResult(bConnectSuccess);
                }

                @Override
                public void onQuestionMarkedAsDismissed(String question_id) {
                    if (StringUtil.isSameStringForNotAllowNull((String)question_id, (String)ZMQAAnswerDialog.this.mQuestionId)) {
                        ZMQAAnswerDialog.this.onClickBtnBack();
                    }
                }
            };
        }
        ZoomQAUI.getInstance().addListener(this.mQAUIListener);
        this.updateData();
    }

    private void updateData() {
        ZoomQAQuestion question;
        Bundle args;
        ZoomQAAnswer answer;
        ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
        if (qacomponent == null) {
            return;
        }
        if (!StringUtil.isEmptyOrNull((String)this.mAnswerId) && (answer = qacomponent.getAnswerByID(this.mAnswerId)) != null) {
            this.updateAnswerState(answer.getState());
        }
        if (StringUtil.isEmptyOrNull((String)this.mQuestionId) && (args = this.getArguments()) != null) {
            this.mQuestionId = args.getString(ARG_QUESTION_ID);
        }
        if ((question = qacomponent.getQuestionByID(this.mQuestionId)) == null) {
            return;
        }
        this.mTxtQuestion.setText((CharSequence)question.getText());
        if (UIUtil.isPortraitMode((Context)this.getContext())) {
            this.mHandler.postDelayed(this.mShowKeyboardRunnable, 100L);
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString("mQuestionId", this.mQuestionId);
        outState.putString("mAnswerId", this.mAnswerId);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.imgClose) {
            this.onClickBtnBack();
        } else if (id2 == R.id.btnSend) {
            this.onClickBtnSend();
        } else if (id2 == R.id.optionPrivately) {
            this.onClickCheckPrivately();
        }
    }

    private void onClickBtnSend() {
        long curTime = System.currentTimeMillis();
        long delta = curTime - this.mLastClickSendTime;
        if (delta > 0L && delta < 1000L) {
            return;
        }
        this.mLastClickSendTime = curTime;
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtContent);
        String content = this.mEdtContent.getText().toString().trim();
        if (content.length() == 0) {
            return;
        }
        ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
        if (qacomponent == null) {
            return;
        }
        ZoomQAQuestion question = qacomponent.getQuestionByID(this.mQuestionId);
        if (question == null) {
            return;
        }
        String destJID = null;
        if (!ConfMgr.getInstance().isViewOnlyMeeting() && this.mChkPrivately.isChecked()) {
            destJID = question.getSenderJID();
        }
        this.mAnswerId = qacomponent.addAnswer(this.mQuestionId, content, destJID);
        if (StringUtil.isEmptyOrNull((String)this.mAnswerId)) {
            this.showSendFailedMessage();
        } else {
            this.showWaitingDialog();
        }
    }

    private void onClickCheckPrivately() {
        this.mChkPrivately.setChecked(!this.mChkPrivately.isChecked());
    }

    private void onAddAnswer(String answerID, boolean bSuccess) {
        if (answerID == null) {
            return;
        }
        ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
        if (qacomponent == null) {
            return;
        }
        if (StringUtil.isSameString((String)answerID, (String)this.mAnswerId)) {
            ZoomQAAnswer answer = qacomponent.getAnswerByID(this.mAnswerId);
            this.updateAnswerState(answer.getState());
        }
    }

    private void updateAnswerState(int state) {
        switch (state) {
            case 1: {
                if (!StringUtil.isEmptyOrNull((String)this.mQuestionId)) {
                    mDraft.remove(this.mQuestionId);
                }
                this.dismissWaitingDialog();
                this.dismiss();
                break;
            }
            case 3: {
                this.dismissWaitingDialog();
                this.showSendFailedMessage();
            }
        }
    }

    private void onClickBtnBack() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtContent);
        this.dismiss();
    }

    public void dismiss() {
        this.finishFragment(true);
    }

    private void notifyConnectResult(boolean bConnectSuccess) {
        ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
        if (qacomponent != null && qacomponent.isStreamConflict()) {
            this.dismiss();
        }
    }

    private void showWaitingDialog() {
        FragmentManager fm = this.getFragmentManager();
        if (fm == null) {
            return;
        }
        WaitingDialog waitingDialog = new WaitingDialog(R.string.zm_msg_waiting);
        waitingDialog.setCancelable(true);
        waitingDialog.show(fm, "WaitingDialog");
    }

    private void dismissWaitingDialog() {
        FragmentManager fm = this.getFragmentManager();
        if (fm == null) {
            return;
        }
        fm.executePendingTransactions();
        ZMDialogFragment waitingDialog = (ZMDialogFragment)fm.findFragmentByTag("WaitingDialog");
        if (waitingDialog != null) {
            waitingDialog.dismissAllowingStateLoss();
        }
    }

    private void showSendFailedMessage() {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        Toast.makeText((Context)context, (int)R.string.zm_qa_msg_send_answer_failed, (int)1).show();
    }
}

