/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment.meeting.qa;

import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.view.PagerAdapter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.confapp.qa.ZoomQAComponent;
import com.zipow.videobox.confapp.qa.ZoomQAUI;
import com.zipow.videobox.fragment.meeting.qa.ZMQAHelper;
import com.zipow.videobox.fragment.meeting.qa.ZMQAPanelistTabFragment;
import com.zipow.videobox.fragment.meeting.qa.ZMQuestionsMode;
import com.zipow.videobox.fragment.meeting.qa.dialog.ZMQAMoreDialog;
import com.zipow.videobox.util.ConfLocalHelper;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.widget.ZMViewPager;
import us.zoom.androidlib.widget.segement.OnTabSelectListener;
import us.zoom.androidlib.widget.segement.ZMSegmentTabLayout;
import us.zoom.videomeetings.R;

public class ZMQAPanelistViewerFragment
extends ZMDialogFragment
implements View.OnClickListener {
    private static int[] TITLE_IDS = new int[]{R.string.zm_qa_tab_open, R.string.zm_qa_tab_answered, R.string.zm_qa_tab_dismissed_34305};
    private View llContent;
    private ZMViewPager mZMViewPager;
    private ZMSegmentTabLayout mZMSegmentTabLayout;
    private View mPanelNoItemMsg;
    private TabViewPagerAdapter mTabViewPagerAdapter;
    private ImageView mBtnMore;
    private ZoomQAUI.IZoomQAUIListener mQAUIListener;
    private ConfUI.IConfUIListener mConfUIListener;

    public static void showAsActivity(ZMActivity activity) {
        Bundle args = new Bundle();
        SimpleActivity.show(activity, ZMQAPanelistViewerFragment.class.getName(), args, 0);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_qa_panelist_viewer, container, false);
        this.llContent = view.findViewById(R.id.llContent);
        this.mBtnMore = (ImageView)view.findViewById(R.id.btnMore);
        this.mZMSegmentTabLayout = (ZMSegmentTabLayout)view.findViewById(R.id.zmSegmentTabLayout);
        this.mZMSegmentTabLayout.setTabWidth((float)ZMQAHelper.getTabWidth(this.getContext(), TITLE_IDS.length));
        this.mZMViewPager = (ZMViewPager)view.findViewById(R.id.viewPager);
        this.mZMViewPager.setOffscreenPageLimit(TITLE_IDS.length);
        this.mZMViewPager.setDisableScroll(true);
        this.mTabViewPagerAdapter = new TabViewPagerAdapter(this.getChildFragmentManager());
        this.mZMViewPager.setAdapter((PagerAdapter)this.mTabViewPagerAdapter);
        this.mZMSegmentTabLayout.setTabData(this.getTabTitles());
        this.mZMSegmentTabLayout.setOnTabSelectListener(new OnTabSelectListener(){

            public void onTabSelect(int position) {
                ZMQAPanelistViewerFragment.this.mZMViewPager.setCurrentItem(position);
            }

            public void onTabReselect(int position) {
            }
        });
        this.mPanelNoItemMsg = view.findViewById(R.id.panelNoItemMsg);
        view.findViewById(R.id.btnBack).setOnClickListener((View.OnClickListener)this);
        this.mBtnMore.setOnClickListener((View.OnClickListener)this);
        return view;
    }

    public void onPause() {
        super.onPause();
        ZoomQAUI.getInstance().removeListener(this.mQAUIListener);
        ConfUI.getInstance().removeListener(this.mConfUIListener);
    }

    public void onResume() {
        super.onResume();
        if (this.mQAUIListener == null) {
            this.mQAUIListener = new ZoomQAUI.SimpleZoomQAUIListener(){

                @Override
                public void onRefreshQAUI() {
                    ZMQAPanelistViewerFragment.this.updateData();
                }

                @Override
                public void onReceiveQuestion(String questionID) {
                    ZMQAPanelistViewerFragment.this.updateData();
                }

                @Override
                public void onReceiveAnswer(String answerID) {
                    ZMQAPanelistViewerFragment.this.updateData();
                }

                @Override
                public void onAddAnswer(String answerID, boolean bSuccess) {
                    if (ZMQAHelper.isAnswerSent(answerID)) {
                        ZMQAPanelistViewerFragment.this.updateData();
                    }
                }

                @Override
                public void onQuestionMarkedAsAnswered(String questionID) {
                    ZMQAPanelistViewerFragment.this.updateData();
                }

                @Override
                public void onUserLivingReply(String questionID) {
                    ZMQAPanelistViewerFragment.this.updateData();
                }

                @Override
                public void notifyConnectResult(boolean bConnectSuccess) {
                    ZMQAPanelistViewerFragment.this.updateData();
                }

                @Override
                public void onAnswerSenderNameChanged(String sender_jid, String question_id) {
                    ZMQAPanelistViewerFragment.this.updateData();
                }

                @Override
                public void onQuestionMarkedAsDismissed(String question_id) {
                    ZMQAPanelistViewerFragment.this.updateData();
                }

                @Override
                public void onReopenQuestion(String question_id) {
                    ZMQAPanelistViewerFragment.this.updateData();
                }

                @Override
                public void onUpvoteQuestion(String question_id, boolean order_changed) {
                    ZMQAPanelistViewerFragment.this.updateData();
                }

                @Override
                public void onRevokeUpvoteQuestion(String question_id, boolean order_changed) {
                    ZMQAPanelistViewerFragment.this.updateData();
                }
            };
        }
        ZoomQAUI.getInstance().addListener(this.mQAUIListener);
        if (this.mConfUIListener == null) {
            this.mConfUIListener = new ConfUI.SimpleConfUIListener(){

                @Override
                public boolean onUserStatusChanged(int cmd, long userId, int userAction) {
                    switch (cmd) {
                        case 1: 
                        case 43: 
                        case 44: {
                            ZMQAPanelistViewerFragment.this.processOnHostOrCoHostChanged(userId);
                            break;
                        }
                    }
                    return true;
                }
            };
        }
        ConfUI.getInstance().addListener(this.mConfUIListener);
        this.mBtnMore.setVisibility(ConfLocalHelper.isHostCoHost() ? 0 : 8);
        this.updateData();
    }

    private void processOnHostOrCoHostChanged(long userId) {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus != null && confStatus.isMyself(userId)) {
            boolean isHostCohost = ConfLocalHelper.isHostCoHost();
            if (isHostCohost) {
                this.mBtnMore.setVisibility(0);
            } else {
                this.mBtnMore.setVisibility(8);
                ZMActivity zmActivity = (ZMActivity)this.getActivity();
                ZMQAMoreDialog.dismiss(zmActivity.getSupportFragmentManager());
            }
        }
    }

    private void updateData() {
        ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
        if (qacomponent != null && qacomponent.isStreamConflict()) {
            this.llContent.setVisibility(8);
            this.mPanelNoItemMsg.setVisibility(0);
        } else {
            this.llContent.setVisibility(0);
            this.mPanelNoItemMsg.setVisibility(8);
            this.mZMSegmentTabLayout.updateTabData(this.getTabTitles());
        }
    }

    private String[] getTabTitles() {
        String[] titles = new String[TITLE_IDS.length];
        ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
        if (qacomponent != null) {
            for (int i = 0; i < TITLE_IDS.length; ++i) {
                int count = i == 0 ? qacomponent.getOpenQuestionCount() : (i == 1 ? qacomponent.getAnsweredQuestionCount() : qacomponent.getDismissedQuestionCount());
                titles[i] = count == 0 ? this.getString(TITLE_IDS[i]) : this.getString(TITLE_IDS[i]) + "(" + (count > 99 ? "99+" : String.valueOf(count)) + ")";
            }
        } else {
            for (int i = 0; i < TITLE_IDS.length; ++i) {
                titles[i] = this.getString(TITLE_IDS[i]);
            }
        }
        return titles;
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        } else if (id2 == R.id.btnMore) {
            this.onClickBtnMore();
        }
    }

    private void onClickBtnBack() {
        this.dismiss();
    }

    private void onClickBtnMore() {
        ZMQAMoreDialog.show((ZMActivity)this.getActivity());
    }

    public void dismiss() {
        this.finishFragment(true);
    }

    static class TabViewPagerAdapter
    extends FragmentPagerAdapter {
        private List<Fragment> mCacheFragments = new ArrayList<Fragment>();

        public TabViewPagerAdapter(FragmentManager fm) {
            super(fm);
        }

        public int getCount() {
            return TITLE_IDS.length;
        }

        public Fragment getItem(int position) {
            if (position < this.mCacheFragments.size()) {
                return this.mCacheFragments.get(position);
            }
            ZMQAPanelistTabFragment fragment = null;
            if (position == 0) {
                fragment = ZMQAPanelistTabFragment.newInstance(ZMQuestionsMode.MODE_OPEN_QUESTIONS.ordinal());
            } else if (position == 1) {
                fragment = ZMQAPanelistTabFragment.newInstance(ZMQuestionsMode.MODE_ANSWERED_QUESTIONS.ordinal());
            } else if (position == 2) {
                fragment = ZMQAPanelistTabFragment.newInstance(ZMQuestionsMode.MODE_DISMISSED_QUESTIONS.ordinal());
            }
            if (fragment != null) {
                this.mCacheFragments.add(fragment);
            }
            return fragment;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            super.destroyItem(container, position, object);
            if (position < this.mCacheFragments.size()) {
                this.mCacheFragments.remove(position);
            }
        }
    }
}

