/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment.meeting.qa;

import android.content.Context;
import android.support.annotation.NonNull;
import android.widget.ImageView;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.qa.ZoomQAAnswer;
import com.zipow.videobox.confapp.qa.ZoomQAComponent;
import com.zipow.videobox.confapp.qa.ZoomQAQuestion;
import com.zipow.videobox.fragment.meeting.qa.ZMQAHelper;
import com.zipow.videobox.fragment.meeting.qa.ZMQuestionsMode;
import com.zipow.videobox.fragment.meeting.qa.model.BaseQAMultiItemEntity;
import com.zipow.videobox.fragment.meeting.qa.model.ZMQAPanelistExpandCollapseItemEntity;
import com.zipow.videobox.fragment.meeting.qa.model.ZMQATextAnswerItemEntity;
import com.zipow.videobox.view.AvatarView;
import java.util.HashMap;
import java.util.List;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.TimeUtil;
import us.zoom.androidlib.widget.recyclerview.ZMBaseMultiItemRecyclerViewAdapter;
import us.zoom.androidlib.widget.recyclerview.ZMBaseRecyclerViewItemHolder;
import us.zoom.videomeetings.R;

public class ZMQAPanelistViewerAdapter
extends ZMBaseMultiItemRecyclerViewAdapter<BaseQAMultiItemEntity, ZMBaseRecyclerViewItemHolder> {
    private final ZoomQAComponent mQacomponent;
    private HashMap<String, String> mExpandedItems = new HashMap();
    private int mQuestionsMode = ZMQuestionsMode.MODE_OPEN_QUESTIONS.ordinal();

    public ZMQAPanelistViewerAdapter(List<BaseQAMultiItemEntity> data, int questionMode) {
        super(data);
        this.mQacomponent = ConfMgr.getInstance().getQAComponent();
        this.mQuestionsMode = questionMode;
        this.addItemType(1, R.layout.zm_qa_list_item_question);
        this.addItemType(2, R.layout.zm_qa_list_item_live_answer);
        this.addItemType(3, R.layout.zm_qa_list_item_answer);
        this.addItemType(6, R.layout.zm_qa_list_item_panelist_action);
        this.addItemType(7, R.layout.zm_qa_list_item_expand_collapse);
        this.addItemType(8, R.layout.zm_qa_list_item_waiting_live_answer);
        this.addItemType(5, R.layout.zm_qa_list_item_divider);
    }

    public HashMap<String, String> getmExpandedItems() {
        return this.mExpandedItems;
    }

    public void refresh(List<BaseQAMultiItemEntity> data) {
        this.setNewData(data);
    }

    public boolean updateUpVoteQuestion(@NonNull String questionId) {
        List datas = this.getData();
        if (!CollectionsUtil.isListEmpty((List)datas)) {
            int position = 0;
            for (BaseQAMultiItemEntity baseQAMultiItemEntity : datas) {
                if (baseQAMultiItemEntity != null && baseQAMultiItemEntity.getItemType() == 1 && questionId.equals(baseQAMultiItemEntity.getmItemId())) {
                    this.notifyItemChanged(position);
                    return true;
                }
                ++position;
            }
        }
        return false;
    }

    public void expandOrCollapse(int position) {
        String itemId;
        ZoomQAQuestion question;
        BaseQAMultiItemEntity baseQAMultiItemEntity;
        if (position < this.getItemCount() && (baseQAMultiItemEntity = (BaseQAMultiItemEntity)this.getItem(position)).getItemType() == 7 && (question = baseQAMultiItemEntity.getQuestion()) != null && !StringUtil.isEmptyOrNull((String)(itemId = question.getItemID()))) {
            if (this.mExpandedItems.containsKey(itemId)) {
                this.mExpandedItems.remove(itemId);
            } else {
                this.mExpandedItems.put(itemId, itemId);
            }
        }
    }

    protected void convert(ZMBaseRecyclerViewItemHolder baseViewHolder, BaseQAMultiItemEntity item) {
        if (this.mQacomponent == null) {
            return;
        }
        ZoomQAQuestion question = item.getQuestion();
        if (question == null) {
            return;
        }
        switch (item.getItemType()) {
            case 1: {
                baseViewHolder.setText(R.id.txtQuestion, (CharSequence)question.getText());
                baseViewHolder.setText(R.id.txtQuestionName, (CharSequence)(question.isAnonymous() ? this.mContext.getString(R.string.zm_qa_msg_anonymous_attendee_asked_41047) : StringUtil.safeString((String)this.mQacomponent.getUserNameByJID(question.getSenderJID()))));
                baseViewHolder.setText(R.id.txtQuestionTime, (CharSequence)TimeUtil.formatTimeCap((Context)this.mContext, (long)question.getTimeStamp()));
                if (ZMQAHelper.isAttendeeCanUpvote()) {
                    baseViewHolder.setVisible(R.id.txtUpVoteCount, question.getUpvoteNum() != 0);
                    baseViewHolder.setText(R.id.txtUpVoteCount, (CharSequence)String.valueOf(question.getUpvoteNum()));
                    boolean isMyUpVote = question.isMySelfUpvoted();
                    baseViewHolder.setGone(R.id.llUpvote, true);
                    if (this.mQuestionsMode == ZMQuestionsMode.MODE_DISMISSED_QUESTIONS.ordinal()) {
                        baseViewHolder.setImageResource(R.id.imgUpVote, R.drawable.zm_ic_upvote_disable);
                        baseViewHolder.setTextColor(R.id.txtUpVoteCount, this.mContext.getResources().getColor(R.color.zm_status_text_deep_grey));
                    } else {
                        baseViewHolder.setImageResource(R.id.imgUpVote, isMyUpVote ? R.drawable.zm_ic_upvote_active : R.drawable.zm_ic_upvote);
                        baseViewHolder.setTextColor(R.id.txtUpVoteCount, isMyUpVote ? this.mContext.getResources().getColor(R.color.zm_text_light_orange) : this.mContext.getResources().getColor(R.color.zm_status_text_deep_grey));
                        baseViewHolder.addOnClickListener(R.id.llUpvote);
                    }
                } else {
                    baseViewHolder.setGone(R.id.llUpvote, false);
                }
                baseViewHolder.setGone(R.id.dividerLine, !ZMQAHelper.isShouldShowLiveAnsweringForPanelist(question));
                break;
            }
            case 3: {
                ZoomQAAnswer answer;
                ZMQATextAnswerItemEntity zmAttendeeQATextAnswerItemEntry = (ZMQATextAnswerItemEntity)item;
                int index = zmAttendeeQATextAnswerItemEntry.getIndex();
                if (index >= question.getAnswerCount() || (answer = question.getAnswerAt(index)) == null) break;
                String senderJid = answer.getSenderJID();
                if (!StringUtil.isEmptyOrNull((String)senderJid) && StringUtil.isSameString((String)this.mQacomponent.getMyJID(), (String)senderJid)) {
                    baseViewHolder.setText(R.id.txtAnswerName, (CharSequence)this.mContext.getString(R.string.zm_qa_you));
                } else {
                    baseViewHolder.setText(R.id.txtAnswerName, (CharSequence)this.mQacomponent.getUserNameByJID(senderJid));
                }
                baseViewHolder.setText(R.id.txtAnswerTime, (CharSequence)TimeUtil.formatTimeCap((Context)this.mContext, (long)answer.getTimeStamp()));
                baseViewHolder.setText(R.id.txtAnswer, (CharSequence)answer.getText());
                baseViewHolder.setGone(R.id.txtPrivateAnswer, answer.isPrivate());
                AvatarView avatarView = (AvatarView)baseViewHolder.getView(R.id.avatarView);
                if (!StringUtil.isEmptyOrNull((String)senderJid)) {
                    CmmUser user = ConfMgr.getInstance().getUserByQAAttendeeJID(senderJid);
                    if (user != null) {
                        if (user.isViewOnlyUser()) {
                            avatarView.setAvatar(R.drawable.zm_no_avatar);
                            break;
                        }
                        if (user.isH323User()) {
                            avatarView.setAvatar(R.drawable.zm_h323_avatar);
                            break;
                        }
                        if (user.isPureCallInUser()) {
                            avatarView.setAvatar(R.drawable.zm_phone_avatar);
                            break;
                        }
                        avatarView.setAvatar(user.getSmallPicPath());
                        avatarView.setBgColorSeedString(senderJid);
                        avatarView.setName(this.mQacomponent.getUserNameByJID(senderJid));
                        break;
                    }
                    avatarView.setAvatar(R.drawable.zm_no_avatar);
                    break;
                }
                avatarView.setAvatar(R.drawable.zm_no_avatar);
                break;
            }
            case 2: {
                if (question.hasLiveAnswers() && question.getLiveAnsweringCount() == 0) {
                    baseViewHolder.setText(R.id.txtLivingAnswerDesc, (CharSequence)this.mContext.getString(R.string.zm_qa_msg_question_ansered_41047));
                    break;
                }
                baseViewHolder.setText(R.id.txtLivingAnswerDesc, (CharSequence)this.mContext.getString(R.string.zm_qa_msg_waiting_live_answer_41047, new Object[]{ZMQAHelper.getLiveAnsweringNames(this.mContext, question)}));
                break;
            }
            case 8: {
                baseViewHolder.setText(R.id.txtWaitingLiveAnswer, (CharSequence)this.mContext.getString(R.string.zm_qa_msg_waiting_live_answer_41047, new Object[]{this.mContext.getString(R.string.zm_qa_you)}));
                baseViewHolder.addOnClickListener(R.id.txtPositive);
                break;
            }
            case 7: {
                boolean isExpand;
                ZMQAPanelistExpandCollapseItemEntity zmqaPanelistActionItemEntity = (ZMQAPanelistExpandCollapseItemEntity)item;
                ImageView imageView = (ImageView)baseViewHolder.getView(R.id.imgDropdown);
                String itemId = item.getmItemId();
                boolean bl = isExpand = itemId != null && this.mExpandedItems.containsKey(itemId);
                if (isExpand) {
                    imageView.setRotation(180.0f);
                    baseViewHolder.setText(R.id.txtMoreFeedback, (CharSequence)this.mContext.getString(R.string.zm_qa_msg_collapse_feedback_41047));
                } else {
                    imageView.setRotation(0.0f);
                    baseViewHolder.setText(R.id.txtMoreFeedback, (CharSequence)this.mContext.getString(R.string.zm_qa_msg_count_feedbacks_41047, new Object[]{zmqaPanelistActionItemEntity.getmTxtAnswerCount()}));
                }
                baseViewHolder.addOnClickListener(R.id.plMoreFeedback);
                break;
            }
            case 6: {
                if (this.mQuestionsMode == ZMQuestionsMode.MODE_DISMISSED_QUESTIONS.ordinal()) {
                    baseViewHolder.setGone(R.id.txtNegative, false);
                    baseViewHolder.setGone(R.id.txtPositive, false);
                    break;
                }
                if (ZMQAHelper.isShouldHideLiveAnswerButtonForPanelist(question)) {
                    baseViewHolder.setGone(R.id.txtNegative, false);
                } else {
                    baseViewHolder.setGone(R.id.txtNegative, true);
                }
                baseViewHolder.addOnClickListener(R.id.txtPositive);
                baseViewHolder.addOnClickListener(R.id.txtNegative);
            }
        }
    }
}

