/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment.meeting.qa;

import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import android.widget.TextView;
import android.widget.Toast;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.confapp.qa.ZoomQAComponent;
import com.zipow.videobox.confapp.qa.ZoomQAQuestion;
import com.zipow.videobox.confapp.qa.ZoomQAUI;
import com.zipow.videobox.fragment.meeting.qa.ZMQAHelper;
import com.zipow.videobox.fragment.meeting.qa.ZMQAPanelistViewerAdapter;
import com.zipow.videobox.fragment.meeting.qa.ZMQuestionsMode;
import com.zipow.videobox.fragment.meeting.qa.dialog.ZMQAAnswerDialog;
import com.zipow.videobox.fragment.meeting.qa.model.BaseQAMultiItemEntity;
import java.util.Collections;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.IZMMenuItem;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMMenuAdapter;
import us.zoom.androidlib.widget.ZMSimpleMenuItem;
import us.zoom.androidlib.widget.recyclerview.ZMBaseRecyclerViewAdapter;
import us.zoom.videomeetings.R;

public class ZMQAPanelistTabFragment
extends Fragment {
    private static final String TAG = ZMQAPanelistTabFragment.class.getSimpleName();
    private static final String KEY_QUESTION_MODE = "KEY_QUESTION_MODE";
    private ZoomQAUI.IZoomQAUIListener mQAUIListener;
    private ConfUI.IConfUIListener mConfUIListener;
    private View mPanelNoItemMsg;
    private TextView mTxtNoItemMsg;
    private RecyclerView mRecyclerView;
    private ZMQAPanelistViewerAdapter mZMQAPanelistViewerAdapter;
    private int mQuestionsMode = ZMQuestionsMode.MODE_OPEN_QUESTIONS.ordinal();
    private String mDismissQuestionId;
    private String mReOpenQuestionId;

    public static ZMQAPanelistTabFragment newInstance(int questionMode) {
        ZMQAPanelistTabFragment zmqaPanelistTabFragment = new ZMQAPanelistTabFragment();
        Bundle bundle = new Bundle();
        bundle.putInt(KEY_QUESTION_MODE, questionMode);
        zmqaPanelistTabFragment.setArguments(bundle);
        return zmqaPanelistTabFragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.mQuestionsMode = bundle.getInt(KEY_QUESTION_MODE, ZMQuestionsMode.MODE_ATTENDEE_ALL_QUESTIONS.ordinal());
        }
        if (savedInstanceState != null) {
            this.mDismissQuestionId = savedInstanceState.getString("mDismissQuestionId", null);
            this.mReOpenQuestionId = savedInstanceState.getString("mReOpenQuestionId", null);
        }
        View view = inflater.inflate(R.layout.zm_qa_tab_question, container, false);
        this.mPanelNoItemMsg = view.findViewById(R.id.panelNoItemMsg);
        this.mTxtNoItemMsg = (TextView)view.findViewById(R.id.txtMsg);
        this.mRecyclerView = (RecyclerView)view.findViewById(R.id.recyclerView);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mZMQAPanelistViewerAdapter = new ZMQAPanelistViewerAdapter(Collections.EMPTY_LIST, this.mQuestionsMode);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mZMQAPanelistViewerAdapter);
        this.mZMQAPanelistViewerAdapter.setOnItemChildClickListener(new ZMBaseRecyclerViewAdapter.OnItemChildClickListener(){

            public void onItemChildClick(ZMBaseRecyclerViewAdapter adapter, View view, int position) {
                BaseQAMultiItemEntity baseQAMultiItemEntity = (BaseQAMultiItemEntity)ZMQAPanelistTabFragment.this.mZMQAPanelistViewerAdapter.getItem(position);
                if (baseQAMultiItemEntity == null) {
                    return;
                }
                switch (baseQAMultiItemEntity.getItemType()) {
                    case 1: {
                        if (view.getId() != R.id.llUpvote) break;
                        ZMQAPanelistTabFragment.this.onClickUpVote(baseQAMultiItemEntity.getmItemId(), position);
                        break;
                    }
                    case 6: {
                        if (view.getId() == R.id.txtPositive) {
                            ZMQAPanelistTabFragment.this.onClickTextAnswer(baseQAMultiItemEntity.getmItemId());
                            break;
                        }
                        if (view.getId() != R.id.txtNegative) break;
                        ZMQAPanelistTabFragment.this.onClickStartLiveAnswer(baseQAMultiItemEntity.getmItemId());
                        break;
                    }
                    case 7: {
                        if (view.getId() != R.id.plMoreFeedback) break;
                        ZMQAPanelistTabFragment.this.onClickMoreFeedback(position);
                        break;
                    }
                    case 8: {
                        if (view.getId() != R.id.txtPositive) break;
                        ZMQAPanelistTabFragment.this.onClickMarkAsAnswered(baseQAMultiItemEntity.getmItemId());
                    }
                }
            }
        });
        this.mZMQAPanelistViewerAdapter.setOnItemLongClickListener(new ZMBaseRecyclerViewAdapter.OnItemLongClickListener(){

            public boolean onItemLongClick(ZMBaseRecyclerViewAdapter adapter, View view, int position) {
                BaseQAMultiItemEntity baseQAMultiItemEntity = (BaseQAMultiItemEntity)ZMQAPanelistTabFragment.this.mZMQAPanelistViewerAdapter.getItem(position);
                if (baseQAMultiItemEntity == null) {
                    return false;
                }
                if (baseQAMultiItemEntity.getItemType() == 1) {
                    ZoomQAQuestion question = baseQAMultiItemEntity.getQuestion();
                    if (question == null || question.getLiveAnsweringCount() > 0) {
                        return false;
                    }
                    String questionId = baseQAMultiItemEntity.getmItemId();
                    if (!StringUtil.isEmptyOrNull((String)questionId)) {
                        if (ZMQAPanelistTabFragment.this.mQuestionsMode == ZMQuestionsMode.MODE_DISMISSED_QUESTIONS.ordinal()) {
                            ZMQAPanelistTabFragment.this.mReOpenQuestionId = questionId;
                            ZMQAPanelistTabFragment.this.popReopen(view);
                        } else {
                            ZMQAPanelistTabFragment.this.mDismissQuestionId = questionId;
                            ZMQAPanelistTabFragment.this.popDismiss(view);
                        }
                    }
                }
                return false;
            }
        });
        return view;
    }

    public void onPause() {
        super.onPause();
        ZoomQAUI.getInstance().removeListener(this.mQAUIListener);
        ConfUI.getInstance().removeListener(this.mConfUIListener);
    }

    public void onResume() {
        super.onResume();
        if (this.mQAUIListener == null) {
            this.mQAUIListener = new ZoomQAUI.SimpleZoomQAUIListener(){

                @Override
                public void onRefreshQAUI() {
                    ZMQAPanelistTabFragment.this.updateData();
                }

                @Override
                public void onReceiveQuestion(String questionID) {
                    ZMQAPanelistTabFragment.this.updateData();
                }

                @Override
                public void onAddQuestion(String questionID, boolean bSuccess) {
                    if (ZMQAPanelistTabFragment.this.mQuestionsMode == ZMQuestionsMode.MODE_OPEN_QUESTIONS.ordinal() && ZMQAHelper.isQuestionSent(questionID)) {
                        ZMQAPanelistTabFragment.this.updateData();
                    }
                }

                @Override
                public void onAddAnswer(String answerID, boolean bSuccess) {
                    if (ZMQAHelper.isAnswerSent(answerID)) {
                        ZMQAPanelistTabFragment.this.updateData();
                    }
                }

                @Override
                public void onReceiveAnswer(String answerID) {
                    ZMQAPanelistTabFragment.this.updateData();
                }

                @Override
                public void onQuestionMarkedAsAnswered(String questionID) {
                    ZMQAPanelistTabFragment.this.updateData();
                }

                @Override
                public void onUserLivingReply(String questionID) {
                    ZMQAPanelistTabFragment.this.updateData();
                }

                @Override
                public void notifyConnectResult(boolean bConnectSuccess) {
                    ZMQAPanelistTabFragment.this.updateData();
                }

                @Override
                public void onAnswerSenderNameChanged(String sender_jid, String question_id) {
                    ZMQAPanelistTabFragment.this.updateData();
                }

                @Override
                public void onQuestionMarkedAsDismissed(String question_id) {
                    ZMQAPanelistTabFragment.this.updateData();
                }

                @Override
                public void onReopenQuestion(String question_id) {
                    ZMQAPanelistTabFragment.this.updateData();
                }

                @Override
                public void onUpvoteQuestion(String question_id, boolean order_changed) {
                    ZMQAPanelistTabFragment.this.updateUpVoteQuestion(question_id, order_changed);
                }

                @Override
                public void onRevokeUpvoteQuestion(String question_id, boolean order_changed) {
                    ZMQAPanelistTabFragment.this.updateUpVoteQuestion(question_id, order_changed);
                }
            };
        }
        ZoomQAUI.getInstance().addListener(this.mQAUIListener);
        if (this.mConfUIListener == null) {
            this.mConfUIListener = new ConfUI.SimpleConfUIListener(){

                @Override
                public boolean onConfStatusChanged2(int cmd, long ret) {
                    if (cmd == 33) {
                        ZMQAPanelistTabFragment.this.updateData();
                    }
                    return true;
                }
            };
        }
        ConfUI.getInstance().addListener(this.mConfUIListener);
        this.updateData();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (outState != null) {
            if (!StringUtil.isEmptyOrNull((String)this.mDismissQuestionId)) {
                outState.putString("mDismissQuestionId", this.mDismissQuestionId);
            }
            if (!StringUtil.isEmptyOrNull((String)this.mReOpenQuestionId)) {
                outState.putString("mReOpenQuestionId", this.mReOpenQuestionId);
            }
        }
    }

    private void onClickUpVote(String questionId, int position) {
        ZoomQAQuestion question;
        ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
        if (qacomponent == null) {
            return;
        }
        if (!StringUtil.isEmptyOrNull((String)questionId) && !((question = qacomponent.getQuestionByID(questionId)) != null && question.isMySelfUpvoted() ? !qacomponent.revokeUpvoteQuestion(questionId) : !qacomponent.upvoteQuestion(questionId))) {
            this.mZMQAPanelistViewerAdapter.notifyItemChanged(position);
        }
    }

    private void onClickMarkAsAnswered(String questionId) {
        ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
        if (qacomponent == null) {
            return;
        }
        if (!StringUtil.isEmptyOrNull((String)questionId) && !qacomponent.endLiving(questionId)) {
            Toast.makeText((Context)this.getContext(), (int)R.string.zm_qa_msg_mark_live_answer_done_failed, (int)1).show();
            return;
        }
        this.updateData();
    }

    private void onClickMoreFeedback(int position) {
        this.mZMQAPanelistViewerAdapter.expandOrCollapse(position);
        this.updateData();
    }

    private void onClickTextAnswer(String questionId) {
        ZMQAAnswerDialog.show((ZMActivity)this.getActivity(), questionId);
    }

    private void onClickStartLiveAnswer(String questionId) {
        ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
        if (qacomponent == null) {
            return;
        }
        qacomponent.startLiving(questionId);
    }

    private void onSelectDismissedQuestion(@NonNull String questionId) {
        ZoomQAComponent qaComponent = ConfMgr.getInstance().getQAComponent();
        if (qaComponent != null) {
            qaComponent.dismissQuestion(questionId);
        }
    }

    private void popDismiss(View view) {
        ZMMenuAdapter menuAdapter = new ZMMenuAdapter(this.getContext(), false);
        menuAdapter.addItem((IZMMenuItem)new ZMSimpleMenuItem(this.getString(R.string.zm_qa_btn_dismiss_question_34305), null));
        ZMAlertDialog dialog = new ZMAlertDialog.Builder(this.getContext()).setTitle(R.string.zm_qa_title_qa).setAdapter((ListAdapter)menuAdapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ZoomQAComponent qaComponent;
                if (!StringUtil.isEmptyOrNull((String)ZMQAPanelistTabFragment.this.mDismissQuestionId) && (qaComponent = ConfMgr.getInstance().getQAComponent()) != null) {
                    qaComponent.dismissQuestion(ZMQAPanelistTabFragment.this.mDismissQuestionId);
                }
            }
        }).create();
        dialog.setCanceledOnTouchOutside(true);
        dialog.show();
    }

    private void popReopen(View view) {
        ZMMenuAdapter menuAdapter = new ZMMenuAdapter(this.getContext(), false);
        menuAdapter.addItem((IZMMenuItem)new ZMSimpleMenuItem(this.getString(R.string.zm_btn_reopen_41047), null));
        ZMAlertDialog dialog = new ZMAlertDialog.Builder(this.getContext()).setTitle(R.string.zm_qa_title_qa).setAdapter((ListAdapter)menuAdapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ZoomQAComponent qaComponent;
                if (!StringUtil.isEmptyOrNull((String)ZMQAPanelistTabFragment.this.mReOpenQuestionId) && (qaComponent = ConfMgr.getInstance().getQAComponent()) != null) {
                    qaComponent.reopenQuestion(ZMQAPanelistTabFragment.this.mReOpenQuestionId);
                }
            }
        }).create();
        dialog.setCanceledOnTouchOutside(true);
        dialog.show();
    }

    private void updateData() {
        this.mZMQAPanelistViewerAdapter.refresh(ZMQAHelper.getZoomQuestionsForPanelist(this.mQuestionsMode, this.mZMQAPanelistViewerAdapter.getmExpandedItems()));
        this.updateNoItemMessage();
    }

    private void updateUpVoteQuestion(String questionId, boolean needReorder) {
        if (needReorder || StringUtil.isEmptyOrNull((String)questionId)) {
            this.mZMQAPanelistViewerAdapter.refresh(ZMQAHelper.getZoomQuestionsForPanelist(this.mQuestionsMode, this.mZMQAPanelistViewerAdapter.getmExpandedItems()));
            this.updateNoItemMessage();
        } else if (!this.mZMQAPanelistViewerAdapter.updateUpVoteQuestion(questionId)) {
            this.mZMQAPanelistViewerAdapter.refresh(ZMQAHelper.getZoomQuestionsForPanelist(this.mQuestionsMode, this.mZMQAPanelistViewerAdapter.getmExpandedItems()));
            this.updateNoItemMessage();
        }
    }

    private void updateNoItemMessage() {
        ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
        if (qacomponent != null && qacomponent.isStreamConflict()) {
            this.mRecyclerView.setVisibility(4);
            this.mTxtNoItemMsg.setText(R.string.zm_qa_msg_stream_conflict);
            this.mPanelNoItemMsg.setVisibility(0);
        } else {
            this.mRecyclerView.setVisibility(0);
            int count = ZMQAHelper.getQustionCount(this.mQuestionsMode);
            if (count == 0) {
                if (this.mQuestionsMode == ZMQuestionsMode.MODE_OPEN_QUESTIONS.ordinal()) {
                    this.mTxtNoItemMsg.setText(R.string.zm_qa_msg_no_open_question);
                } else if (this.mQuestionsMode == ZMQuestionsMode.MODE_ANSWERED_QUESTIONS.ordinal()) {
                    this.mTxtNoItemMsg.setText(R.string.zm_qa_msg_no_answered_question);
                } else if (this.mQuestionsMode == ZMQuestionsMode.MODE_DISMISSED_QUESTIONS.ordinal()) {
                    this.mTxtNoItemMsg.setText(R.string.zm_qa_msg_no_dismissed_question_34305);
                }
                this.mPanelNoItemMsg.setVisibility(0);
            } else {
                this.mPanelNoItemMsg.setVisibility(8);
            }
        }
    }

    static class ContextMenuItem
    extends ZMSimpleMenuItem {
        private String mLabel;

        public ContextMenuItem(String label) {
            this.mLabel = label;
        }

        public String toString() {
            return this.mLabel;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public Drawable getIcon() {
            return null;
        }
    }
}

