/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment.meeting.qa;

import android.content.Context;
import android.support.annotation.NonNull;
import android.widget.ImageView;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.qa.ZoomQAAnswer;
import com.zipow.videobox.confapp.qa.ZoomQAComponent;
import com.zipow.videobox.confapp.qa.ZoomQAQuestion;
import com.zipow.videobox.fragment.meeting.qa.ZMQAHelper;
import com.zipow.videobox.fragment.meeting.qa.model.BaseQAMultiItemEntity;
import com.zipow.videobox.fragment.meeting.qa.model.ZMQAAttendeeActionItemEntity;
import com.zipow.videobox.fragment.meeting.qa.model.ZMQATextAnswerItemEntity;
import com.zipow.videobox.view.AvatarView;
import java.util.HashMap;
import java.util.List;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.TimeUtil;
import us.zoom.androidlib.widget.recyclerview.ZMBaseMultiItemRecyclerViewAdapter;
import us.zoom.androidlib.widget.recyclerview.ZMBaseRecyclerViewItemHolder;
import us.zoom.videomeetings.R;

public class ZMQAAttendeeViewerAdapter
extends ZMBaseMultiItemRecyclerViewAdapter<BaseQAMultiItemEntity, ZMBaseRecyclerViewItemHolder> {
    private final ZoomQAComponent mQacomponent;
    private HashMap<String, String> mExpandedItems = new HashMap();

    public ZMQAAttendeeViewerAdapter(List<BaseQAMultiItemEntity> data) {
        super(data);
        this.mQacomponent = ConfMgr.getInstance().getQAComponent();
        this.addItemType(1, R.layout.zm_qa_list_item_question);
        this.addItemType(2, R.layout.zm_qa_list_item_live_answer);
        this.addItemType(3, R.layout.zm_qa_list_item_answer);
        this.addItemType(4, R.layout.zm_qa_list_item_action);
        this.addItemType(5, R.layout.zm_qa_list_item_divider);
    }

    public HashMap<String, String> getmExpandedItems() {
        return this.mExpandedItems;
    }

    public void refresh(List<BaseQAMultiItemEntity> data) {
        this.setNewData(data);
    }

    public boolean updateUpVoteQuestion(@NonNull String questionId) {
        List datas = this.getData();
        if (!CollectionsUtil.isListEmpty((List)datas)) {
            int position = 0;
            for (BaseQAMultiItemEntity baseQAMultiItemEntity : datas) {
                if (baseQAMultiItemEntity != null && baseQAMultiItemEntity.getItemType() == 1 && questionId.equals(baseQAMultiItemEntity.getmItemId())) {
                    this.notifyItemChanged(position);
                    return true;
                }
                ++position;
            }
        }
        return false;
    }

    public void expandOrCollapse(int position) {
        String itemId;
        ZoomQAQuestion question;
        BaseQAMultiItemEntity baseQAMultiItemEntity;
        if (position < this.getItemCount() && (baseQAMultiItemEntity = (BaseQAMultiItemEntity)this.getItem(position)).getItemType() == 4 && (question = baseQAMultiItemEntity.getQuestion()) != null && !StringUtil.isEmptyOrNull((String)(itemId = question.getItemID()))) {
            if (this.mExpandedItems.containsKey(itemId)) {
                this.mExpandedItems.remove(itemId);
            } else {
                this.mExpandedItems.put(itemId, itemId);
            }
        }
    }

    protected void convert(ZMBaseRecyclerViewItemHolder baseViewHolder, BaseQAMultiItemEntity item) {
        if (this.mQacomponent == null) {
            return;
        }
        ZoomQAQuestion question = item.getQuestion();
        if (question == null) {
            return;
        }
        switch (item.getItemType()) {
            case 1: {
                boolean isDismissed = question.isMarkedAsDismissed();
                baseViewHolder.setText(R.id.txtQuestion, (CharSequence)question.getText());
                if (this.mQacomponent.isJIDMyself(question.getSenderJID())) {
                    baseViewHolder.setText(R.id.txtQuestionName, (CharSequence)this.mContext.getString(R.string.zm_qa_you));
                } else {
                    baseViewHolder.setText(R.id.txtQuestionName, (CharSequence)(question.isAnonymous() ? this.mContext.getString(R.string.zm_qa_msg_anonymous_attendee_asked_41047) : StringUtil.safeString((String)this.mQacomponent.getUserNameByJID(question.getSenderJID()))));
                }
                baseViewHolder.setText(R.id.txtQuestionTime, (CharSequence)TimeUtil.formatTimeCap((Context)this.mContext, (long)question.getTimeStamp()));
                boolean canUpvote = ZMQAHelper.isAttendeeCanUpvote();
                if (canUpvote) {
                    baseViewHolder.setVisible(R.id.txtUpVoteCount, question.getUpvoteNum() != 0);
                    baseViewHolder.setText(R.id.txtUpVoteCount, (CharSequence)String.valueOf(question.getUpvoteNum()));
                    boolean isMyUpVote = question.isMySelfUpvoted();
                    baseViewHolder.setGone(R.id.llUpvote, true);
                    if (isDismissed) {
                        baseViewHolder.setImageResource(R.id.imgUpVote, R.drawable.zm_ic_upvote_disable);
                        baseViewHolder.setTextColor(R.id.txtUpVoteCount, this.mContext.getResources().getColor(R.color.zm_status_text_deep_grey));
                    } else {
                        if (isMyUpVote) {
                            baseViewHolder.setImageResource(R.id.imgUpVote, R.drawable.zm_ic_upvote_active);
                            baseViewHolder.setTextColor(R.id.txtUpVoteCount, this.mContext.getResources().getColor(R.color.zm_text_light_orange));
                        } else {
                            baseViewHolder.setImageResource(R.id.imgUpVote, R.drawable.zm_ic_upvote);
                            baseViewHolder.setTextColor(R.id.txtUpVoteCount, this.mContext.getResources().getColor(R.color.zm_status_text_deep_grey));
                        }
                        baseViewHolder.addOnClickListener(R.id.llUpvote);
                    }
                } else {
                    baseViewHolder.setGone(R.id.llUpvote, false);
                }
                baseViewHolder.setGone(R.id.dividerLine, question.getAnswerCount() > 0 || isDismissed);
                if (isDismissed && (canUpvote || ZMQAHelper.isAttendeeCanComment())) {
                    baseViewHolder.getView(R.id.txtQuestion).setEnabled(false);
                    baseViewHolder.getView(R.id.txtQuestionName).setEnabled(false);
                    break;
                }
                baseViewHolder.getView(R.id.txtQuestion).setEnabled(true);
                baseViewHolder.getView(R.id.txtQuestionName).setEnabled(true);
                break;
            }
            case 3: {
                ZoomQAAnswer answer;
                ZMQATextAnswerItemEntity zmAttendeeQATextAnswerItemEntry = (ZMQATextAnswerItemEntity)item;
                boolean isDismissed = question.isMarkedAsDismissed();
                int index = zmAttendeeQATextAnswerItemEntry.getIndex();
                if (index >= question.getAnswerCount() || (answer = question.getAnswerAt(index)) == null) break;
                String senderJid = answer.getSenderJID();
                if (!StringUtil.isEmptyOrNull((String)senderJid) && StringUtil.isSameString((String)this.mQacomponent.getMyJID(), (String)senderJid)) {
                    baseViewHolder.setText(R.id.txtAnswerName, (CharSequence)this.mContext.getString(R.string.zm_qa_you));
                } else {
                    baseViewHolder.setText(R.id.txtAnswerName, (CharSequence)this.mQacomponent.getUserNameByJID(senderJid));
                }
                baseViewHolder.setText(R.id.txtAnswerTime, (CharSequence)TimeUtil.formatTimeCap((Context)this.mContext, (long)answer.getTimeStamp()));
                baseViewHolder.setText(R.id.txtAnswer, (CharSequence)answer.getText());
                baseViewHolder.setGone(R.id.txtPrivateAnswer, answer.isPrivate());
                AvatarView avatarView = (AvatarView)baseViewHolder.getView(R.id.avatarView);
                if (!StringUtil.isEmptyOrNull((String)senderJid)) {
                    CmmUser user = ConfMgr.getInstance().getUserByQAAttendeeJID(senderJid);
                    if (user != null) {
                        if (user.isViewOnlyUser()) {
                            avatarView.setAvatar(R.drawable.zm_no_avatar);
                        } else if (user.isH323User()) {
                            avatarView.setAvatar(R.drawable.zm_h323_avatar);
                        } else if (user.isPureCallInUser()) {
                            avatarView.setAvatar(R.drawable.zm_phone_avatar);
                        } else {
                            avatarView.setAvatar(user.getSmallPicPath());
                            avatarView.setBgColorSeedString(senderJid);
                            avatarView.setName(this.mQacomponent.getUserNameByJID(senderJid));
                        }
                    } else {
                        avatarView.setAvatar(R.drawable.zm_no_avatar);
                    }
                } else {
                    avatarView.setAvatar(R.drawable.zm_no_avatar);
                }
                if (isDismissed && (ZMQAHelper.isAttendeeCanUpvote() || ZMQAHelper.isAttendeeCanComment())) {
                    baseViewHolder.getView(R.id.txtPrivateAnswer).setEnabled(false);
                    baseViewHolder.getView(R.id.txtAnswerName).setEnabled(false);
                    baseViewHolder.getView(R.id.txtAnswer).setEnabled(false);
                    break;
                }
                baseViewHolder.getView(R.id.txtPrivateAnswer).setEnabled(true);
                baseViewHolder.getView(R.id.txtAnswerName).setEnabled(true);
                baseViewHolder.getView(R.id.txtAnswer).setEnabled(true);
                break;
            }
            case 2: {
                if (question.hasLiveAnswers() && question.getLiveAnsweringCount() == 0) {
                    baseViewHolder.setText(R.id.txtLivingAnswerDesc, (CharSequence)this.mContext.getString(R.string.zm_qa_msg_question_ansered_41047));
                    break;
                }
                baseViewHolder.setText(R.id.txtLivingAnswerDesc, (CharSequence)this.mContext.getString(R.string.zm_qa_msg_waiting_live_answer_41047, new Object[]{ZMQAHelper.getLiveAnsweringNames(this.mContext, question)}));
                break;
            }
            case 4: {
                ZMQAAttendeeActionItemEntity zmAttendeeQAActionItemEntry = (ZMQAAttendeeActionItemEntity)item;
                if (!zmAttendeeQAActionItemEntry.ismIsShowFeedback() && !ZMQAHelper.isAttendeeCanComment()) {
                    baseViewHolder.setGone(R.id.llActionArea, false);
                    break;
                }
                baseViewHolder.setGone(R.id.llActionArea, true);
                ImageView imageView = (ImageView)baseViewHolder.getView(R.id.imgDropdown);
                String itemId = item.getmItemId();
                boolean isExpand = itemId != null && this.mExpandedItems.containsKey(itemId);
                imageView.setRotation(isExpand ? 180.0f : 0.0f);
                if (zmAttendeeQAActionItemEntry.ismIsShowFeedback()) {
                    baseViewHolder.setVisible(R.id.plMoreFeedback, true);
                    if (isExpand) {
                        baseViewHolder.setText(R.id.txtMoreFeedback, (CharSequence)this.mContext.getString(R.string.zm_qa_msg_collapse_feedback_41047));
                    } else {
                        baseViewHolder.setText(R.id.txtMoreFeedback, (CharSequence)this.mContext.getString(R.string.zm_qa_msg_count_feedbacks_41047, new Object[]{zmAttendeeQAActionItemEntry.getmTxtAnswerCount()}));
                    }
                    baseViewHolder.addOnClickListener(R.id.plMoreFeedback);
                } else {
                    baseViewHolder.setVisible(R.id.plMoreFeedback, false);
                }
                if (ZMQAHelper.isAttendeeCanComment() && !question.isMarkedAsDismissed()) {
                    baseViewHolder.setVisible(R.id.btnAnswer, true);
                    baseViewHolder.addOnClickListener(R.id.btnAnswer);
                    break;
                }
                baseViewHolder.setVisible(R.id.btnAnswer, false);
            }
        }
    }
}

