/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment.meeting.qa;

import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.confapp.qa.ZoomQAComponent;
import com.zipow.videobox.confapp.qa.ZoomQAQuestion;
import com.zipow.videobox.confapp.qa.ZoomQAUI;
import com.zipow.videobox.fragment.meeting.qa.ZMQAAttendeeViewerAdapter;
import com.zipow.videobox.fragment.meeting.qa.ZMQAHelper;
import com.zipow.videobox.fragment.meeting.qa.ZMQuestionsMode;
import com.zipow.videobox.fragment.meeting.qa.dialog.ZMQAAnswerDialog;
import com.zipow.videobox.fragment.meeting.qa.model.BaseQAMultiItemEntity;
import java.util.Collections;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.recyclerview.ZMBaseRecyclerViewAdapter;
import us.zoom.videomeetings.R;

public class ZMQAAttendeeTabFragment
extends Fragment {
    private static final String TAG = ZMQAAttendeeTabFragment.class.getSimpleName();
    private static final String KEY_QUESTION_MODE = "KEY_QUESTION_MODE";
    private ZoomQAUI.IZoomQAUIListener mQAUIListener;
    private ConfUI.IConfUIListener mConfUIListener;
    private View mPanelNoItemMsg;
    private TextView mTxtNoItemMsg;
    private RecyclerView mRecyclerView;
    private ZMQAAttendeeViewerAdapter mZMQAAttendeeViewerAdapter;
    private int mQuestionsMode = ZMQuestionsMode.MODE_ATTENDEE_ALL_QUESTIONS.ordinal();

    public static ZMQAAttendeeTabFragment newInstance(int questionMode) {
        ZMQAAttendeeTabFragment zmqaAttendeeTabFragment = new ZMQAAttendeeTabFragment();
        Bundle bundle = new Bundle();
        bundle.putInt(KEY_QUESTION_MODE, questionMode);
        zmqaAttendeeTabFragment.setArguments(bundle);
        return zmqaAttendeeTabFragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.mQuestionsMode = bundle.getInt(KEY_QUESTION_MODE, ZMQuestionsMode.MODE_ATTENDEE_ALL_QUESTIONS.ordinal());
        }
        View view = inflater.inflate(R.layout.zm_qa_tab_question, container, false);
        this.mPanelNoItemMsg = view.findViewById(R.id.panelNoItemMsg);
        this.mTxtNoItemMsg = (TextView)view.findViewById(R.id.txtMsg);
        this.mRecyclerView = (RecyclerView)view.findViewById(R.id.recyclerView);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mZMQAAttendeeViewerAdapter = new ZMQAAttendeeViewerAdapter(Collections.EMPTY_LIST);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mZMQAAttendeeViewerAdapter);
        this.mZMQAAttendeeViewerAdapter.setOnItemChildClickListener(new ZMBaseRecyclerViewAdapter.OnItemChildClickListener(){

            public void onItemChildClick(ZMBaseRecyclerViewAdapter adapter, View view, int position) {
                BaseQAMultiItemEntity baseQAMultiItemEntity = (BaseQAMultiItemEntity)ZMQAAttendeeTabFragment.this.mZMQAAttendeeViewerAdapter.getItem(position);
                if (baseQAMultiItemEntity == null) {
                    return;
                }
                switch (baseQAMultiItemEntity.getItemType()) {
                    case 1: {
                        if (view.getId() != R.id.llUpvote) break;
                        ZMQAAttendeeTabFragment.this.onClickUpVote(baseQAMultiItemEntity.getmItemId(), position);
                        break;
                    }
                    case 4: {
                        if (view.getId() == R.id.plMoreFeedback) {
                            ZMQAAttendeeTabFragment.this.onClickMoreFeedback(position);
                            break;
                        }
                        if (view.getId() != R.id.btnAnswer) break;
                        ZMQAAttendeeTabFragment.this.onClickAnswer(baseQAMultiItemEntity.getmItemId());
                    }
                }
            }
        });
        return view;
    }

    public void onPause() {
        super.onPause();
        ZoomQAUI.getInstance().removeListener(this.mQAUIListener);
        ConfUI.getInstance().removeListener(this.mConfUIListener);
    }

    public void onResume() {
        super.onResume();
        if (this.mQAUIListener == null) {
            this.mQAUIListener = new ZoomQAUI.SimpleZoomQAUIListener(){

                @Override
                public void onRefreshQAUI() {
                    ZMQAAttendeeTabFragment.this.updateData();
                }

                @Override
                public void onReceiveQuestion(String questionID) {
                    ZMQAAttendeeTabFragment.this.updateData();
                }

                @Override
                public void onAddQuestion(String questionID, boolean bSuccess) {
                    if (ZMQAHelper.isQuestionSent(questionID)) {
                        ZMQAAttendeeTabFragment.this.updateData();
                    }
                }

                @Override
                public void onAddAnswer(String answerID, boolean bSuccess) {
                    if (ZMQAHelper.isAnswerSent(answerID)) {
                        ZMQAAttendeeTabFragment.this.updateData();
                    }
                }

                @Override
                public void onUserLivingReply(String questionID) {
                    ZMQAAttendeeTabFragment.this.updateData();
                }

                @Override
                public void onReceiveAnswer(String answerID) {
                    ZMQAAttendeeTabFragment.this.updateData();
                }

                @Override
                public void onQuestionMarkedAsAnswered(String questionID) {
                    ZMQAAttendeeTabFragment.this.updateData();
                }

                @Override
                public void notifyConnectResult(boolean bConnectSuccess) {
                    ZMQAAttendeeTabFragment.this.updateData();
                }

                @Override
                public void onAnswerSenderNameChanged(String sender_jid, String question_id) {
                    ZMQAAttendeeTabFragment.this.updateData();
                }

                @Override
                public void onQuestionMarkedAsDismissed(String question_id) {
                    ZMQAAttendeeTabFragment.this.updateData();
                }

                @Override
                public void onReopenQuestion(String question_id) {
                    ZMQAAttendeeTabFragment.this.updateData();
                }

                @Override
                public void onUpvoteQuestion(String question_id, boolean order_changed) {
                    ZMQAAttendeeTabFragment.this.updateData();
                }

                @Override
                public void onRevokeUpvoteQuestion(String question_id, boolean order_changed) {
                    ZMQAAttendeeTabFragment.this.updateData();
                }
            };
        }
        ZoomQAUI.getInstance().addListener(this.mQAUIListener);
        if (this.mConfUIListener == null) {
            this.mConfUIListener = new ConfUI.SimpleConfUIListener(){

                @Override
                public boolean onConfStatusChanged2(int cmd, long ret) {
                    if (cmd == 33) {
                        ZMQAAttendeeTabFragment.this.updateData();
                    } else if (cmd == 34) {
                        ZMQAAttendeeTabFragment.this.onAllowAnswerQuestionStatusChanged();
                    }
                    return true;
                }
            };
        }
        ConfUI.getInstance().addListener(this.mConfUIListener);
        this.updateData();
    }

    private void onAllowAnswerQuestionStatusChanged() {
        if (!ConfMgr.getInstance().isAllowAttendeeAnswerQuestion()) {
            ZMActivity zmActivity = (ZMActivity)this.getActivity();
            ZMQAAnswerDialog.dismiss(zmActivity.getSupportFragmentManager());
        }
        this.updateData();
    }

    private void onClickUpVote(String questionId, int position) {
        if (!ZMQAHelper.isAttendeeCanUpvote()) {
            return;
        }
        ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
        if (qacomponent == null) {
            return;
        }
        if (!StringUtil.isEmptyOrNull((String)questionId)) {
            ZoomQAQuestion question = qacomponent.getQuestionByID(questionId);
            if (question == null || question.isMarkedAsDismissed()) {
                return;
            }
            if (!(question.isMySelfUpvoted() ? !qacomponent.revokeUpvoteQuestion(questionId) : !qacomponent.upvoteQuestion(questionId))) {
                this.mZMQAAttendeeViewerAdapter.notifyItemChanged(position);
            }
        }
    }

    private void onClickAnswer(String itemId) {
        if (!StringUtil.isEmptyOrNull((String)itemId)) {
            ZMQAAnswerDialog.show((ZMActivity)this.getActivity(), itemId);
        }
    }

    private void onClickMoreFeedback(int position) {
        this.mZMQAAttendeeViewerAdapter.expandOrCollapse(position);
        this.updateData();
    }

    private void updateData() {
        this.mZMQAAttendeeViewerAdapter.refresh(ZMQAHelper.getZoomQuestionsForAttendee(this.mQuestionsMode, this.mZMQAAttendeeViewerAdapter.getmExpandedItems()));
        this.updateNoItemMessage();
    }

    private void updateUpVoteQuestion(String questionId, boolean needReorder) {
        if (needReorder || StringUtil.isEmptyOrNull((String)questionId)) {
            this.mZMQAAttendeeViewerAdapter.refresh(ZMQAHelper.getZoomQuestionsForPanelist(this.mQuestionsMode, this.mZMQAAttendeeViewerAdapter.getmExpandedItems()));
            this.updateNoItemMessage();
        } else if (!this.mZMQAAttendeeViewerAdapter.updateUpVoteQuestion(questionId)) {
            this.mZMQAAttendeeViewerAdapter.refresh(ZMQAHelper.getZoomQuestionsForPanelist(this.mQuestionsMode, this.mZMQAAttendeeViewerAdapter.getmExpandedItems()));
            this.updateNoItemMessage();
        }
    }

    private void updateNoItemMessage() {
        ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
        if (qacomponent != null && qacomponent.isStreamConflict()) {
            this.mRecyclerView.setVisibility(4);
            this.mTxtNoItemMsg.setText(R.string.zm_qa_msg_stream_conflict);
            this.mPanelNoItemMsg.setVisibility(0);
        } else {
            this.mRecyclerView.setVisibility(0);
            int count = ZMQAHelper.getQustionCount(this.mQuestionsMode);
            if (count == 0) {
                this.mTxtNoItemMsg.setText(R.string.zm_qa_msg_no_question);
                this.mPanelNoItemMsg.setVisibility(0);
            } else {
                this.mPanelNoItemMsg.setVisibility(8);
            }
        }
    }
}

