/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.TextView;
import android.widget.Toast;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.fragment.MMSelectSessionAndBuddyFragment;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.MMFileContentMgr;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomChatSession;
import com.zipow.videobox.ptapp.mm.ZoomFile;
import com.zipow.videobox.ptapp.mm.ZoomMessage;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.CodeSnipptUtils;
import com.zipow.videobox.util.TintUtil;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.ZMCodeView;
import com.zipow.videobox.view.mm.MMMessageItem;
import com.zipow.videobox.view.mm.MMShareZoomFileDialogFragment;
import com.zipow.videobox.view.mm.MMZoomFile;
import com.zipow.videobox.view.mm.MMZoomShareAction;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.IZMMenuItem;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMMenuAdapter;
import us.zoom.androidlib.widget.ZMSimpleMenuItem;
import us.zoom.videomeetings.R;

public class ZMCodeViewFragment
extends ZMDialogFragment {
    private ZMCodeView zmCodeView;
    private TextView mTitle;
    private ImageView mCloseBtn;
    private TextView mContent;
    private ImageView mMoreBtn;
    private String mSessionId;
    private String mMessageId;
    private static final String ARG_SHARED_MESSAGE_ID = "messageid";
    private static final int REQUEST_GET_SHAREES = 100;
    private static final String ARGS_CODE_URL = "code_url";
    private static final String ARGS_CODE_FILE = "code_file";
    private static final String ARGS_CODE_HTML = "code_html";
    private static final String ARGS_CODE_SESSION_ID = "sessionid";
    private static final String ARGS_CODE_FILENAME = "code_filename";
    private MMMessageItem mMessageItem = null;
    private ZoomMessengerUI.IZoomMessengerUIListener mZoomMessengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

        @Override
        public void Indicate_FileActionStatus(int actionType, String fileId, String actionOwner, String fileName, String sessionId, String msgId) {
            if (ZMCodeViewFragment.this.mMessageItem != null && ((ZMCodeViewFragment)ZMCodeViewFragment.this).mMessageItem.fileId.equals(fileId) && ZMCodeViewFragment.this.mSessionId != null && ZMCodeViewFragment.this.mSessionId.equals(sessionId) && (actionType == 1 || actionType == 2)) {
                ZMCodeViewFragment.this.finishFragment(true);
            }
        }
    };

    public static void showAsFragment(Fragment fragment, URL url) {
        Bundle args = new Bundle();
        args.putSerializable(ARGS_CODE_URL, (Serializable)url);
        SimpleActivity.show(fragment, ZMCodeViewFragment.class.getName(), args, -1);
    }

    public static void showAsFragment(Fragment fragment, File file) {
        Bundle args = new Bundle();
        args.putSerializable(ARGS_CODE_FILE, (Serializable)file);
        SimpleActivity.show(fragment, ZMCodeViewFragment.class.getName(), args, -1);
    }

    public static void showAsFragment(ZMActivity activity, String sessionid, String messageid, File file, String fileName) {
        Bundle args = new Bundle();
        args.putSerializable(ARGS_CODE_FILE, (Serializable)file);
        args.putString(ARGS_CODE_FILENAME, fileName);
        args.putString(ARGS_CODE_SESSION_ID, sessionid);
        args.putString(ARG_SHARED_MESSAGE_ID, messageid);
        SimpleActivity.show(activity, ZMCodeViewFragment.class.getName(), args, -1);
    }

    public static void showAsFragment(Fragment fragment, String html) {
        Bundle args = new Bundle();
        args.putString(ARGS_CODE_HTML, html);
        SimpleActivity.show(fragment, ZMCodeViewFragment.class.getName(), args, -1);
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (Build.VERSION.SDK_INT >= 21) {
            View decorView;
            Window window = this.getActivity().getWindow();
            if (Build.VERSION.SDK_INT >= 23 && (decorView = window.getDecorView()) != null) {
                int vis = decorView.getSystemUiVisibility();
                decorView.setSystemUiVisibility(vis |= 0x2000);
            }
            window.addFlags(Integer.MIN_VALUE);
            window.clearFlags(0x4000000);
            window.setStatusBarColor(this.getResources().getColor(R.color.zm_code_view_title_bg));
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_code_view_fragment, container, false);
        this.zmCodeView = (ZMCodeView)view.findViewById(R.id.codeView);
        this.mTitle = (TextView)view.findViewById(R.id.zm_code_view_title_name);
        this.mCloseBtn = (ImageView)view.findViewById(R.id.zm_code_view_close_btn);
        this.mContent = (TextView)view.findViewById(R.id.zm_code_view_bottom_content);
        this.mMoreBtn = (ImageView)view.findViewById(R.id.zm_code_view_more_btn);
        if (this.getContext() != null) {
            Drawable closeDrawable = TintUtil.tintColor(this.getContext(), R.drawable.zm_btn_viewer_close, R.color.zm_code_view_close_btn);
            this.mCloseBtn.setImageDrawable(closeDrawable);
            Drawable moreDrawable = TintUtil.tintColor(this.getContext(), R.drawable.zm_ic_btn_more, R.color.zm_code_view_bottom_txt);
            this.mMoreBtn.setImageDrawable(moreDrawable);
        }
        ZoomMessengerUI.getInstance().addListener(this.mZoomMessengerUIListener);
        return view;
    }

    public void onDestroyView() {
        ZoomMessengerUI.getInstance().removeListener(this.mZoomMessengerUIListener);
        super.onDestroyView();
    }

    public void shareMessage(String msgId) {
        Bundle bundle = new Bundle();
        bundle.putString(ARG_SHARED_MESSAGE_ID, msgId);
        MMSelectSessionAndBuddyFragment.showAsFragment((Fragment)this, bundle, false, false, 100);
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        int transferState;
        super.onActivityCreated(savedInstanceState);
        Bundle bundle = this.getArguments();
        URL url = (URL)bundle.getSerializable(ARGS_CODE_URL);
        if (url != null) {
            this.zmCodeView.setSource(url);
        }
        final String fileName = bundle.getString(ARGS_CODE_FILENAME, "");
        this.mTitle.setText((CharSequence)fileName);
        this.mSessionId = bundle.getString(ARGS_CODE_SESSION_ID, "");
        this.mMessageId = bundle.getString(ARG_SHARED_MESSAGE_ID, "");
        final ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(this.mSessionId);
        if (session == null) {
            return;
        }
        ZoomMessage zoomMsg = session.getMessageById(this.mMessageId);
        if (zoomMsg == null) {
            return;
        }
        ZoomBuddy buddy = messenger.getMyself();
        if (buddy == null) {
            return;
        }
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        File file = (File)bundle.getSerializable(ARGS_CODE_FILE);
        if (file != null) {
            String src = CodeSnipptUtils.parseZipSnippetSrc(zoomMsg, "html");
            this.zmCodeView.setSource(src);
        }
        boolean isOutMessage = StringUtil.isSameString((String)zoomMsg.getSenderID(), (String)buddy.getJid());
        this.mMessageItem = MMMessageItem.initWithZoomMessage(zoomMsg, this.mSessionId, messenger, session.isGroup(), isOutMessage, (Context)this.getActivity(), IMAddrBookItem.fromZoomBuddy(session.getSessionBuddy()), mgr);
        String html = bundle.getString(ARGS_CODE_HTML);
        if (!TextUtils.isEmpty((CharSequence)html)) {
            String content = ZMCodeViewFragment.readAssetsTxt(this.getContext(), "test.html");
            this.zmCodeView.setSource(content);
        }
        this.mCloseBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ZMCodeViewFragment.this.finishFragment(false);
            }
        });
        final ZMMenuAdapter menuAdapter = new ZMMenuAdapter(this.getContext(), false);
        ZoomFile zoomFile = mgr.getFileWithMessageID(this.mSessionId, this.mMessageItem.messageXMPPId);
        if (zoomFile != null && !this.mMessageItem.isE2E && messenger.e2eGetMyOption() != 2 && (transferState = zoomFile.getFileTransferState()) != 2 && transferState != 3 && transferState != 1 && transferState != 0) {
            menuAdapter.addItem((IZMMenuItem)new ZMSimpleMenuItem(0, this.getContext().getString(R.string.zm_btn_share)));
        }
        if (this.mMessageItem.isDeleteable(this.mSessionId)) {
            menuAdapter.addItem((IZMMenuItem)new ZMSimpleMenuItem(1, this.getContext().getString(R.string.zm_btn_delete)));
        }
        if (menuAdapter.getCount() <= 0) {
            this.mMoreBtn.setVisibility(8);
        } else {
            this.mMoreBtn.setVisibility(0);
        }
        this.mMoreBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ZMAlertDialog dialog = new ZMAlertDialog.Builder(ZMCodeViewFragment.this.getContext()).setTitle(fileName).setAdapter((ListAdapter)menuAdapter, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        ZMSimpleMenuItem menuItem = (ZMSimpleMenuItem)menuAdapter.getItem(which);
                        if (menuItem.getAction() == 0) {
                            ZMCodeViewFragment.this.shareMessage(ZMCodeViewFragment.this.mMessageId);
                        } else if (menuItem.getAction() == 1) {
                            boolean isNetWorkWell = messenger.isConnectionGood();
                            if (isNetWorkWell) {
                                if (ZMCodeViewFragment.this.getActivity() != null) {
                                    ZMCodeViewFragment.this.mMessageItem.deleteMessage((Context)ZMCodeViewFragment.this.getActivity());
                                }
                            } else {
                                Toast.makeText((Context)ZMCodeViewFragment.this.getContext(), (CharSequence)ZMCodeViewFragment.this.getResources().getString(R.string.zm_mm_msg_network_unavailable), (int)1).show();
                            }
                        }
                    }
                }).create();
                dialog.setCanceledOnTouchOutside(true);
                dialog.show();
            }
        });
    }

    public void onResume() {
        this.refreshFileShares(this.mSessionId, this.mMessageId);
        super.onResume();
    }

    private void refreshFileShares(String sessionId, String messageXMPPID) {
        String sharedInStr = "";
        ZoomFile zoomFile = null;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return;
        }
        String myJid = myself.getJid();
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        zoomFile = mgr.getFileWithMessageID(sessionId, messageXMPPID);
        if (zoomFile == null) {
            return;
        }
        MMZoomFile file = MMZoomFile.initWithZoomFile(zoomFile, mgr);
        List<MMZoomShareAction> actions = file.getShareAction();
        if (actions != null) {
            String ownerName;
            StringBuffer buff = new StringBuffer();
            for (MMZoomShareAction action : actions) {
                if (!action.isGroup() || action.isMUC()) continue;
                buff.append(action.getShareeName((Context)this.getActivity()));
                buff.append(",");
            }
            String string2 = ownerName = StringUtil.isSameString((String)file.getOwnerJid(), (String)myJid) ? this.getString(R.string.zm_lbl_content_me) : file.getOwnerName();
            sharedInStr = buff.length() == 0 ? (StringUtil.isSameString((String)file.getOwnerJid(), (String)myJid) ? "" : this.getString(R.string.zm_lbl_content_share_in_buddy, new Object[]{ownerName})) : this.getString(R.string.zm_lbl_content_share_in_group, new Object[]{buff.subSequence(0, buff.length() - 1)});
        }
        if (sharedInStr.length() > 0) {
            this.mContent.setText((CharSequence)sharedInStr);
        } else {
            this.mContent.setText((CharSequence)this.getString(R.string.zm_lbl_content_no_share));
        }
    }

    public static String readAssetsTxt(Context context, String fileName) {
        try {
            InputStream is = context.getAssets().open(fileName);
            int size = is.available();
            byte[] buffer = new byte[size];
            is.read(buffer);
            is.close();
            String text = new String(buffer, "utf-8");
            return text;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 100 && resultCode == -1 && data != null) {
            Bundle bundle = data.getExtras();
            if (bundle == null) {
                return;
            }
            String messageId = bundle.getString(ARG_SHARED_MESSAGE_ID);
            if (StringUtil.isEmptyOrNull((String)messageId)) {
                return;
            }
            String jid = data.getStringExtra("selectedItem");
            if (StringUtil.isEmptyOrNull((String)jid)) {
                return;
            }
            ArrayList<String> sharees = new ArrayList<String>();
            sharees.add(jid);
            if (sharees.size() > 0) {
                this.doShareFile(sharees, messageId);
            }
        }
    }

    private void doShareFile(ArrayList<String> sharees, String messageId) {
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        ZoomFile file = mgr.getFileWithMessageID(this.mSessionId, messageId);
        if (file == null) {
            return;
        }
        MMShareZoomFileDialogFragment.showShareFileDialog(this.getFragmentManager(), sharees, file.getWebFileID(), messageId, this.mSessionId, null, 0);
        mgr.destroyFileObject(file);
    }
}

