/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import com.zipow.videobox.SimpleInMeetingActivity;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.confapp.ZoomRaiseHandInWebinar;
import com.zipow.videobox.confapp.meeting.PromoteOrDowngradeItem;
import com.zipow.videobox.confapp.qa.ZoomQAUI;
import com.zipow.videobox.fragment.PAttendeeListActionDialog;
import com.zipow.videobox.fragment.PListItemActionDialog;
import com.zipow.videobox.fragment.meeting.PromoteOrDowngradeMockFragment;
import com.zipow.videobox.view.WebinarRaiseHandListView;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.AccessibilityUtil;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.EventTaskManager;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.videomeetings.R;

public class WebinarRaiseHandFragment
extends ZMDialogFragment
implements View.OnClickListener {
    private static final String TAG = WebinarRaiseHandFragment.class.getSimpleName();
    private static final int DELAY_REFRESH_TIME = 600;
    private WebinarRaiseHandListView mListView;
    private ZoomQAUI.IZoomQAUIListener mQAUIListener;
    private ConfUI.IConfUIListener mConfUIListener;
    private TextView mTxtTitle;
    private Button mBtnLowerAllHands;
    private PromoteOrDowngradeMockFragment mPromoteOrDowngradeMockFragment;
    private final Handler mHandler = new Handler();
    private final Runnable mRunnableRefreshAttendees = new Runnable(){

        @Override
        public void run() {
            WebinarRaiseHandFragment.this.refreshAttendees();
        }
    };

    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View content = inflater.inflate(R.layout.zm_webinar_raise_hand, container, false);
        this.mPromoteOrDowngradeMockFragment = new PromoteOrDowngradeMockFragment((Fragment)this);
        this.mPromoteOrDowngradeMockFragment.onCreateView(savedInstanceState);
        this.mListView = (WebinarRaiseHandListView)content.findViewById(R.id.raiseHandListView);
        this.mTxtTitle = (TextView)content.findViewById(R.id.txtTitle);
        content.findViewById(R.id.btnDone).setOnClickListener((View.OnClickListener)this);
        this.mBtnLowerAllHands = (Button)content.findViewById(R.id.btnLowerAllHands);
        this.mBtnLowerAllHands.setOnClickListener((View.OnClickListener)this);
        this.mListView.setEmptyView(content.findViewById(R.id.emptyView));
        if (this.mQAUIListener == null) {
            this.mQAUIListener = new ZoomQAUI.SimpleZoomQAUIListener(){

                @Override
                public void onUserListUpdated() {
                    WebinarRaiseHandFragment.this.postRefreshAttendees();
                }

                @Override
                public void onUserListInitialized() {
                    WebinarRaiseHandFragment.this.postRefreshAttendees();
                }

                @Override
                public void onUserRemoved(String jid) {
                    WebinarRaiseHandFragment.this.postRefreshAttendees();
                    WebinarRaiseHandFragment.this.onUserRemoved(jid);
                }

                @Override
                public void onWebinarAttendeeGuestStatusChanged(long nodeID, boolean isGuest) {
                    WebinarRaiseHandFragment.this.postRefreshAttendees();
                }
            };
        }
        ZoomQAUI.getInstance().addListener(this.mQAUIListener);
        if (this.mConfUIListener == null) {
            this.mConfUIListener = new ConfUI.SimpleConfUIListener(){

                @Override
                public boolean onConfStatusChanged2(int cmd, final long ret) {
                    EventTaskManager eventTaskMgr = WebinarRaiseHandFragment.this.getEventTaskManager();
                    if (eventTaskMgr != null) {
                        if (cmd == 31) {
                            eventTaskMgr.pushLater("onConfAllowRaiseHandStatusChanged", new EventAction("onConfAllowRaiseHandStatusChanged"){

                                public void run(IUIElement ui) {
                                    WebinarRaiseHandFragment f = (WebinarRaiseHandFragment)ui;
                                    f.onConfAllowRaiseHandStatusChanged();
                                }
                            });
                        } else if (cmd == 99) {
                            eventTaskMgr.pushLater("onPromotePanelistResult", new EventAction("onPromotePanelistResult"){

                                public void run(IUIElement ui) {
                                    if (WebinarRaiseHandFragment.this.mPromoteOrDowngradeMockFragment != null) {
                                        WebinarRaiseHandFragment f;
                                        WebinarRaiseHandFragment.this.mPromoteOrDowngradeMockFragment.onPromotePanelistResult((int)ret);
                                        if (ret == 0L && (f = (WebinarRaiseHandFragment)ui) != null) {
                                            WebinarRaiseHandFragment.this.mListView.reloadAllAttendees();
                                        }
                                    }
                                }
                            });
                        } else if (cmd == 3) {
                            eventTaskMgr.pushLater("onConfLockStatusChanged", new EventAction("onConfLockStatusChanged"){

                                public void run(IUIElement ui) {
                                    if (WebinarRaiseHandFragment.this.mPromoteOrDowngradeMockFragment != null) {
                                        WebinarRaiseHandFragment.this.mPromoteOrDowngradeMockFragment.onConfLockStatusChanged();
                                    }
                                }
                            });
                        } else if (cmd == 100) {
                            eventTaskMgr.push("onDePromotePanelist", new EventAction("onDePromotePanelist"){

                                public void run(IUIElement ui) {
                                    if (WebinarRaiseHandFragment.this.mPromoteOrDowngradeMockFragment != null) {
                                        WebinarRaiseHandFragment f;
                                        WebinarRaiseHandFragment.this.mPromoteOrDowngradeMockFragment.onDePromotePanelist((int)ret);
                                        if (ret == 0L && (f = (WebinarRaiseHandFragment)ui) != null) {
                                            WebinarRaiseHandFragment.this.mListView.reloadAllPanelist();
                                        }
                                    }
                                }
                            });
                        } else if (cmd == 92) {
                            eventTaskMgr.pushLater("onRosterAttributeChangedForAll", new EventAction("onRosterAttributeChangedForAll"){

                                public void run(IUIElement ui) {
                                    WebinarRaiseHandFragment f = (WebinarRaiseHandFragment)ui;
                                    f.refreshPanelist();
                                }
                            });
                        }
                    }
                    return true;
                }

                @Override
                public boolean onUserStatusChanged(int cmd, final long userId, int userAction) {
                    EventTaskManager eventTaskMgr = WebinarRaiseHandFragment.this.getEventTaskManager();
                    if (eventTaskMgr != null) {
                        if (cmd == 35 || cmd == 36 || cmd == 37) {
                            eventTaskMgr.pushLater("onUserRaiseHandStatusChange", new EventAction("onUserRaiseHandStatusChange"){

                                public void run(IUIElement ui) {
                                    WebinarRaiseHandFragment f = (WebinarRaiseHandFragment)ui;
                                    f.refreshPanelist();
                                }
                            });
                        } else if (cmd == 1 || cmd == 43 || cmd == 44) {
                            eventTaskMgr.pushLater("onHostChanged", new EventAction("onHostChanged"){

                                public void run(IUIElement ui) {
                                    WebinarRaiseHandFragment f = (WebinarRaiseHandFragment)ui;
                                    f.onHostChanged(userId);
                                }
                            });
                        } else if (cmd == 9 || cmd == 21) {
                            WebinarRaiseHandFragment.this.updateUserAudioStatus(userId);
                        } else if (cmd == 27 || cmd == 28) {
                            WebinarRaiseHandFragment.this.talkPrivilegeChange(userId);
                        } else if (cmd == 45) {
                            WebinarRaiseHandFragment.this.refreshPanelist();
                        }
                    }
                    return true;
                }

                @Override
                public boolean onUserEvent(final int eventType, final long userId, int flag) {
                    EventTaskManager eventTaskMgr = WebinarRaiseHandFragment.this.getEventTaskManager();
                    if (eventTaskMgr != null) {
                        eventTaskMgr.pushLater("onUserEvent", new EventAction("onUserEvent"){

                            public void run(IUIElement ui) {
                                WebinarRaiseHandFragment f = (WebinarRaiseHandFragment)ui;
                                f.onUserEvent(eventType, userId);
                            }
                        });
                    }
                    return true;
                }
            };
        }
        ConfUI.getInstance().addListener(this.mConfUIListener);
        return content;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.mPromoteOrDowngradeMockFragment != null) {
            this.mPromoteOrDowngradeMockFragment.onSaveInstanceState(outState);
        }
    }

    private void onHostChanged(long userId) {
        ZMActivity zmActivity = (ZMActivity)this.getActivity();
        if (zmActivity != null) {
            PAttendeeListActionDialog.refreshAction(zmActivity.getSupportFragmentManager(), userId);
        }
    }

    private void updateUserAudioStatus(long nodeId) {
        this.refreshPanelist();
        ZMActivity zmActivity = (ZMActivity)this.getActivity();
        if (zmActivity != null) {
            PAttendeeListActionDialog.refreshAction(zmActivity.getSupportFragmentManager(), nodeId);
        }
    }

    private void talkPrivilegeChange(long nodeId) {
        this.refreshAttendees();
        ZMActivity zmActivity = (ZMActivity)this.getActivity();
        if (zmActivity != null) {
            PAttendeeListActionDialog.refreshAction(zmActivity.getSupportFragmentManager(), nodeId);
        }
    }

    private void onConfAllowRaiseHandStatusChanged() {
        this.updateLowerHandAllButton();
        this.refreshTitle();
        this.mListView.onConfAllowRaiseHandStatusChanged();
    }

    private void updateLowerHandAllButton() {
        CmmUser myself = ConfMgr.getInstance().getMyself();
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (myself != null && (myself.isHost() || myself.isCoHost()) && confStatus != null && confStatus.isAllowRaiseHand()) {
            this.mBtnLowerAllHands.setVisibility(0);
        } else {
            this.mBtnLowerAllHands.setVisibility(8);
        }
    }

    public static void showAsActivity(ZMActivity activity, int requestCode) {
        Bundle args = new Bundle();
        SimpleInMeetingActivity.show(activity, WebinarRaiseHandFragment.class.getName(), args, requestCode, true, 2);
    }

    public static WebinarRaiseHandFragment getFragment(FragmentManager fm) {
        return (WebinarRaiseHandFragment)fm.findFragmentByTag(WebinarRaiseHandFragment.class.getName());
    }

    public void onResume() {
        super.onResume();
        this.refreshTitle();
    }

    public void promoteOrDowngrade(PromoteOrDowngradeItem promoteOrDowngradeItem) {
        if (this.mPromoteOrDowngradeMockFragment != null) {
            this.mPromoteOrDowngradeMockFragment.promoteOrDowngrade(promoteOrDowngradeItem);
        }
    }

    private void refreshTitle() {
        if (!this.isAdded()) {
            return;
        }
        int handCount = this.mListView.getRaiseHandCount();
        this.mTxtTitle.setText((CharSequence)this.getString(R.string.zm_title_webinar_raise_hand, new Object[]{handCount}));
        this.mBtnLowerAllHands.setEnabled(handCount != 0);
    }

    private void postRefreshAttendees() {
        this.mHandler.removeCallbacks(this.mRunnableRefreshAttendees);
        this.mHandler.postDelayed(this.mRunnableRefreshAttendees, 600L);
    }

    private void refreshAttendees() {
        this.mListView.reloadAllAttendees();
        this.refreshTitle();
    }

    private void onUserEvent(int eventType, long userId) {
        ZMActivity zmActivity;
        this.refreshPanelist();
        if (eventType == 1 && (zmActivity = (ZMActivity)this.getActivity()) != null) {
            PListItemActionDialog.dismissPListActionDialogForUserId(zmActivity.getSupportFragmentManager(), userId);
        }
    }

    private void refreshPanelist() {
        this.mListView.reloadAllPanelist();
        this.refreshTitle();
    }

    private void onUserRemoved(String jid) {
        this.refreshPanelist();
        ZMActivity zmActivity = (ZMActivity)this.getActivity();
        if (zmActivity != null) {
            PAttendeeListActionDialog.dismissPAttendeeListActionDialogForUserId(zmActivity.getSupportFragmentManager(), jid);
        }
    }

    public void onDestroyView() {
        this.mHandler.removeCallbacks(this.mRunnableRefreshAttendees);
        ZoomQAUI.getInstance().removeListener(this.mQAUIListener);
        ConfUI.getInstance().removeListener(this.mConfUIListener);
        super.onDestroyView();
    }

    public void dismiss() {
        this.finishFragment(true);
    }

    private void onClickBtnLowerHandAll() {
        ZoomRaiseHandInWebinar raiseHandInWebinar = ConfMgr.getInstance().getRaiseHandAPIObj();
        if (raiseHandInWebinar == null || !raiseHandInWebinar.lowerAllHand()) {
            // empty if block
        }
        if (ConfMgr.getInstance().handleUserCmd(37, 0L) && AccessibilityUtil.isSpokenFeedbackEnabled((Context)this.getContext())) {
            AccessibilityUtil.announceForAccessibilityCompat((View)this.mListView, (int)R.string.zm_accessibility_all_hands_lowered_23053);
        }
    }

    public void onClick(View v) {
        if (v == null) {
            return;
        }
        int id2 = v.getId();
        if (id2 == R.id.btnDone) {
            this.dismiss();
        } else if (id2 == R.id.btnLowerAllHands) {
            this.onClickBtnLowerHandAll();
        }
    }
}

