/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import com.zipow.videobox.WelcomeActivity;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.VerifyCertEvent;
import java.io.Serializable;
import java.util.ArrayList;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class VerifyCertFailureDialog
extends ZMDialogFragment {
    private static final String ARG_VERIFY_CERT_EVENT = "verifyCertEvent";
    private static final String ARG_EXT_VERIFY_CERT_EVENTS = "extVerifyCertEvents";
    private static final String ARG_FINISH_ACTIVITY_ON_DISMISS = "finishActivityOnDismiss";
    private VerifyCertEvent mVerifyCertEvent;
    private boolean mFinishActivityOnDismiss = false;
    private ArrayList<VerifyCertEvent> mExtEvents = new ArrayList();

    public static VerifyCertFailureDialog newInstance(VerifyCertEvent event, boolean finishActivityOnDismiss) {
        return VerifyCertFailureDialog.newInstance(event, null, finishActivityOnDismiss);
    }

    public static VerifyCertFailureDialog newInstance(VerifyCertEvent event, ArrayList<VerifyCertEvent> extEvents, boolean finishActivityOnDismiss) {
        VerifyCertFailureDialog dialog = new VerifyCertFailureDialog();
        Bundle args = new Bundle();
        args.putSerializable(ARG_VERIFY_CERT_EVENT, (Serializable)event);
        if (extEvents != null) {
            args.putSerializable(ARG_EXT_VERIFY_CERT_EVENTS, extEvents);
        }
        args.putBoolean(ARG_FINISH_ACTIVITY_ON_DISMISS, finishActivityOnDismiss);
        dialog.setArguments(args);
        return dialog;
    }

    public VerifyCertFailureDialog() {
        this.setCancelable(true);
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        ZMAlertDialog dialog;
        Mainboard mainboard;
        ArrayList extEvents;
        Bundle args = this.getArguments();
        if (args != null) {
            this.mVerifyCertEvent = (VerifyCertEvent)args.getSerializable(ARG_VERIFY_CERT_EVENT);
            this.mFinishActivityOnDismiss = args.getBoolean(ARG_FINISH_ACTIVITY_ON_DISMISS);
            extEvents = (ArrayList)args.getSerializable(ARG_EXT_VERIFY_CERT_EVENTS);
            if (extEvents != null) {
                this.mExtEvents = extEvents;
            }
        }
        if (savedInstanceState != null && (extEvents = (ArrayList)savedInstanceState.getSerializable("mExtEvents")) != null) {
            this.mExtEvents = extEvents;
        }
        if ((mainboard = Mainboard.getMainboard()) == null || mainboard.queryBooleanPolicyValueFromMemory()) {
            dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.zm_security_certificate_title_42900).setMessage(R.string.zm_security_certificate_question_42900).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    VerifyCertFailureDialog.this.denyCertification();
                }
            }).create();
        } else {
            FragmentActivity context = this.getActivity();
            String site = "";
            if (this.mVerifyCertEvent != null && this.mVerifyCertEvent.cert_item_ != null) {
                site = this.mVerifyCertEvent.cert_item_.issuer_;
            }
            String msg = context.getString(R.string.zm_security_certificate_question_detail_42900, new Object[]{site});
            dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.zm_security_certificate_title_42900).setMessage(msg).setNegativeButton(R.string.zm_btn_no, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.cancel();
                }
            }).setPositiveButton(R.string.zm_btn_yes, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    VerifyCertFailureDialog.this.trustCertification();
                }
            }).create();
        }
        dialog.setCanceledOnTouchOutside(false);
        return dialog;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putSerializable("mExtEvents", this.mExtEvents);
    }

    public void onCancel(DialogInterface dialog) {
        WelcomeActivity welcomeActivity;
        VerifyCertEvent event;
        PTApp.getInstance().VTLSConfirmAcceptCertItem(this.mVerifyCertEvent, false, false);
        for (int i = 0; i < this.mExtEvents.size(); ++i) {
            event = this.mExtEvents.get(i);
            if (this.mVerifyCertEvent.cert_item_ == null || event.cert_item_ == null || !this.mVerifyCertEvent.cert_item_.equalsIgnoreHostName(event.cert_item_)) continue;
            PTApp.getInstance().VTLSConfirmAcceptCertItem(event, false, false);
            this.mExtEvents.remove(i);
            --i;
        }
        FragmentActivity activity = this.getActivity();
        if (this.mExtEvents.size() > 0) {
            event = this.mExtEvents.remove(0);
            VerifyCertFailureDialog dlg = VerifyCertFailureDialog.newInstance(event, this.mExtEvents, this.mFinishActivityOnDismiss);
            dlg.show(this.getFragmentManager(), VerifyCertFailureDialog.class.getName());
            return;
        }
        if (this.mFinishActivityOnDismiss && activity != null) {
            activity.finish();
        }
        if (!PTApp.getInstance().isWebSignedOn() && (welcomeActivity = WelcomeActivity.getCurrentInstance()) != null) {
            welcomeActivity.setNeedBlockNextTimeAutoLogin(true);
        }
    }

    private void denyCertification() {
        VerifyCertEvent event;
        PTApp.getInstance().VTLSConfirmAcceptCertItem(this.mVerifyCertEvent, false, false);
        for (int i = 0; i < this.mExtEvents.size(); ++i) {
            event = this.mExtEvents.get(i);
            if (this.mVerifyCertEvent.cert_item_ == null || event.cert_item_ == null || !this.mVerifyCertEvent.cert_item_.equalsIgnoreHostName(event.cert_item_)) continue;
            PTApp.getInstance().VTLSConfirmAcceptCertItem(event, false, false);
            this.mExtEvents.remove(i);
            --i;
        }
        FragmentActivity activity = this.getActivity();
        if (this.mExtEvents.size() > 0) {
            event = this.mExtEvents.remove(0);
            VerifyCertFailureDialog dlg = VerifyCertFailureDialog.newInstance(event, this.mExtEvents, this.mFinishActivityOnDismiss);
            dlg.show(this.getFragmentManager(), VerifyCertFailureDialog.class.getName());
            return;
        }
        if (this.mFinishActivityOnDismiss && activity != null) {
            activity.finish();
        }
    }

    private void trustCertification() {
        VerifyCertEvent event;
        PTApp.getInstance().VTLSConfirmAcceptCertItem(this.mVerifyCertEvent, true, true);
        for (int i = 0; i < this.mExtEvents.size(); ++i) {
            event = this.mExtEvents.get(i);
            if (this.mVerifyCertEvent.cert_item_ == null || event.cert_item_ == null || !this.mVerifyCertEvent.cert_item_.equalsIgnoreHostName(event.cert_item_)) continue;
            PTApp.getInstance().VTLSConfirmAcceptCertItem(event, true, true);
            this.mExtEvents.remove(i);
            --i;
        }
        FragmentActivity activity = this.getActivity();
        if (this.mExtEvents.size() > 0) {
            event = this.mExtEvents.remove(0);
            VerifyCertFailureDialog dlg = VerifyCertFailureDialog.newInstance(event, this.mExtEvents, this.mFinishActivityOnDismiss);
            dlg.show(this.getFragmentManager(), VerifyCertFailureDialog.class.getName());
            return;
        }
        if (this.mFinishActivityOnDismiss && activity != null) {
            activity.finish();
        }
    }

    public void onNewVerifyCertFailure(VerifyCertEvent event) {
        this.mExtEvents.add(event);
    }
}

