/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.fragment.ZMErrorMessageDialog;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.util.ZMWebUtil;
import java.util.ArrayList;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class VanityURLModifyFragment
extends ZMDialogFragment
implements View.OnClickListener,
TextView.OnEditorActionListener {
    private EditText mMeetingRoomName;
    private Button btnSave;
    private Button btnBack;
    private TextView mTxtMessage;
    private String mRequestID;
    private static String WAITING_DIALOG_TAG = "vanity_url_edit_waiting_dialog";
    private static String ARGS_MEETING_ROOM_NAME = "args_meeting_room_name";
    private PTUI.IProfileListener mListener = new PTUI.SimpleProfileListener(){

        @Override
        public void OnProfileFieldUpdated(String reqID, int result, int type, String param) {
            if (StringUtil.isEmptyOrNull((String)reqID)) {
                return;
            }
            if (!reqID.equals(VanityURLModifyFragment.this.mRequestID)) {
                return;
            }
            UIUtil.dismissWaitingDialog((FragmentManager)VanityURLModifyFragment.this.getFragmentManager(), (String)WAITING_DIALOG_TAG);
            VanityURLModifyFragment.this.handleProfileUpdate(result, type);
        }
    };

    private void handleProfileUpdate(int result, int type) {
        if (result == 0) {
            this.dismiss();
        } else {
            this.showErrorMessage(result);
        }
    }

    public static void showAsActivity(ZMActivity activity, String meetingName) {
        Bundle args = new Bundle();
        args.putString(ARGS_MEETING_ROOM_NAME, meetingName);
        SimpleActivity.show(activity, VanityURLModifyFragment.class.getName(), args, 0);
    }

    public static void showAsActivity(Fragment fragment, String meetingName) {
        Bundle args = new Bundle();
        args.putString(ARGS_MEETING_ROOM_NAME, meetingName);
        SimpleActivity.show(fragment, VanityURLModifyFragment.class.getName(), args, 0);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        String name;
        View view = inflater.inflate(R.layout.zm_vanity_url, container, false);
        this.mMeetingRoomName = (EditText)view.findViewById(R.id.edtMeetingRoomName);
        this.btnSave = (Button)view.findViewById(R.id.btnApply);
        this.btnBack = (Button)view.findViewById(R.id.btnBack);
        this.mTxtMessage = (TextView)view.findViewById(R.id.txtMessage);
        this.mTxtMessage.setVisibility(8);
        TextView txtInstructions = (TextView)view.findViewById(R.id.txtInstructions);
        txtInstructions.setText((CharSequence)this.getString(R.string.zm_lbl_vanity_url_instruction, new Object[]{ZMWebUtil.getWebDomainWithHttps()}));
        Bundle args = this.getArguments();
        if (args != null && !StringUtil.isEmptyOrNull((String)(name = args.getString(ARGS_MEETING_ROOM_NAME)))) {
            this.mMeetingRoomName.setText((CharSequence)name);
        }
        this.btnSave.setEnabled(false);
        this.btnSave.setOnClickListener((View.OnClickListener)this);
        this.btnBack.setOnClickListener((View.OnClickListener)this);
        if (this.mMeetingRoomName != null) {
            this.mMeetingRoomName.setImeOptions(6);
            this.mMeetingRoomName.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        }
        this.mMeetingRoomName.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                VanityURLModifyFragment.this.mTxtMessage.setVisibility(8);
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                VanityURLModifyFragment.this.updateUI();
            }
        });
        return view;
    }

    public void onResume() {
        PTUI.getInstance().addProfileListener(this.mListener);
        this.updateUI();
        super.onResume();
    }

    public void onPause() {
        PTUI.getInstance().removeProfileListener(this.mListener);
        super.onPause();
    }

    public void updateUI() {
        boolean ret = this.validInput();
        this.btnSave.setEnabled(ret);
    }

    private boolean validInput() {
        char[] charArray;
        String name = this.mMeetingRoomName.getText().toString();
        if (StringUtil.isEmptyOrNull((String)name)) {
            return false;
        }
        int length = name.length();
        if (length < 5 || length > 40) {
            return false;
        }
        char first = name.toLowerCase().charAt(0);
        if (first < 'a' || first > 'z') {
            return false;
        }
        for (char c : charArray = name.toCharArray()) {
            if (this.isValidChar(c)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '.';
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnApply) {
            this.onClickBtnSave();
        } else if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        }
    }

    private void onClickBtnSave() {
        if (!this.validInput()) {
            return;
        }
        String name = this.mMeetingRoomName.getText().toString();
        this.mRequestID = PTApp.getInstance().modifyVanityUrl(name);
        if (StringUtil.isEmptyOrNull((String)this.mRequestID)) {
            this.showErrorMessage(5000);
            return;
        }
        UIUtil.showWaitingDialog((FragmentManager)this.getFragmentManager(), (int)R.string.zm_msg_waiting, (String)WAITING_DIALOG_TAG);
    }

    private void showErrorMessage(int result) {
        if (result == 0) {
            return;
        }
        String message = "";
        switch (result) {
            case 5000: 
            case 5003: {
                message = this.getString(R.string.zm_lbl_profile_change_fail_cannot_connect_service);
                break;
            }
            case 1001: {
                message = this.getString(R.string.zm_lbl_user_not_exist);
                break;
            }
            case 4100: 
            case 4102: {
                message = this.getString(R.string.zm_lbl_vanity_url_exist);
                break;
            }
            case 4103: {
                message = this.getString(R.string.zm_lbl_start_with_letter);
                break;
            }
            default: {
                message = this.getString(R.string.zm_lbl_unknow_error, new Object[]{result});
            }
        }
        String title = this.getString(R.string.zm_title_vanity_url_modify_fail);
        ArrayList<String> messages = new ArrayList<String>();
        messages.add(message);
        ZMErrorMessageDialog.show(this.getFragmentManager(), title, messages, "VanityURLModifyFragment error dialog");
    }

    private void onClickBtnBack() {
        this.dismiss();
    }

    public void dismiss() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        this.finishFragment(true);
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        switch (actionId) {
            case 6: {
                this.onClickBtnSave();
                return true;
            }
        }
        return false;
    }
}

