/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.zipow.videobox.SystemNotificationActivity;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.NotificationMgr;
import com.zipow.videobox.view.mm.MMSystemNotificationListView;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.videomeetings.R;

public class SystemNotificationFragment
extends ZMDialogFragment
implements View.OnClickListener {
    private MMSystemNotificationListView mBuddyInviteListView;
    private ZoomMessengerUI.IZoomMessengerUIListener mZoomMessengerUIListener;

    public static void showAsActivity(ZMActivity activity, int requestCode) {
        Bundle args = new Bundle();
        SystemNotificationActivity.show(activity, SystemNotificationFragment.class.getName(), args, requestCode, true, 1);
    }

    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_system_notification, container, false);
        view.findViewById(R.id.btnCancel).setOnClickListener((View.OnClickListener)this);
        this.mBuddyInviteListView = (MMSystemNotificationListView)view.findViewById(R.id.systemNotificationListView);
        this.mBuddyInviteListView.setEmptyView(view.findViewById(R.id.panelNoItemMsg));
        this.mBuddyInviteListView.setParentFragment(this);
        return view;
    }

    public void onClick(View v) {
        if (v.getId() == R.id.btnCancel) {
            this.dismiss();
        }
    }

    public void onPause() {
        super.onPause();
        ZoomMessengerUI.getInstance().removeListener(this.mZoomMessengerUIListener);
    }

    public void onResume() {
        super.onResume();
        if (this.mZoomMessengerUIListener == null) {
            this.mZoomMessengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

                @Override
                public boolean onNotifySubscribeRequest(String jid, String msg) {
                    SystemNotificationFragment.this.onZoomMessengerNotifySubscribeRequest();
                    return true;
                }

                @Override
                public void onIndicateInfoUpdatedWithJID(String jid) {
                    SystemNotificationFragment.this.onIndicateInfoUpdatedWithJID(jid);
                }

                @Override
                public boolean onNotifySubscriptionAccepted(String jid) {
                    SystemNotificationFragment.this.onZoomMessengerNotifySubscribeRequest();
                    return true;
                }

                @Override
                public void onIndicateBuddyListUpdated() {
                    SystemNotificationFragment.this.onIndicateBuddyListUpdated();
                }

                @Override
                public boolean onNotifySubscriptionDenied(String jid) {
                    SystemNotificationFragment.this.onZoomMessengerNotifySubscribeRequest();
                    return true;
                }

                @Override
                public void onNotifySubscribeRequestUpdated(String jid) {
                    SystemNotificationFragment.this.onNotifySubscribeRequestUpdated(jid);
                }
            };
        }
        ZoomMessengerUI.getInstance().addListener(this.mZoomMessengerUIListener);
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (messenger.getUnreadRequestCount() > 0) {
            NotificationMgr.removeMessageNotificationMM((Context)this.getActivity(), "######SYSTEM_NOTIFICATION_SESSION");
        }
        this.mBuddyInviteListView.reloadAllItems();
    }

    private void onIndicateBuddyListUpdated() {
        this.mBuddyInviteListView.onIndicateBuddyListUpdated();
    }

    private void onIndicateInfoUpdatedWithJID(String jid) {
        this.mBuddyInviteListView.onIndicateInfoUpdatedWithJID(jid);
    }

    private void onZoomMessengerNotifySubscribeRequest() {
        this.mBuddyInviteListView.onZoomMessengerNotifySubscribeRequest();
    }

    private void onNotifySubscribeRequestUpdated(String jid) {
        this.mBuddyInviteListView.onNotifySubscribeRequestUpdated(jid);
    }

    public void dismiss() {
        this.finishFragment(true);
    }
}

