/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class SimpleMessageDialog
extends ZMDialogFragment {
    private static final String ARG_MESSAGE = "message";
    private static final String ARG_TITLE = "title";
    private static final String ARG_MESSAGE_ID = "messageId";
    private static final String ARG_TITLE_ID = "titleId";
    private static final String ARG_FINISH_ACTIVITY_ON_DISMISS = "finishActivityOnDismiss";

    public static SimpleMessageDialog newInstance(String message) {
        return SimpleMessageDialog.newInstance(message, null);
    }

    public static SimpleMessageDialog newInstance(String message, boolean finishActivityOnDismiss) {
        return SimpleMessageDialog.newInstance(message, null, finishActivityOnDismiss);
    }

    public static SimpleMessageDialog newInstance(String message, String title) {
        return SimpleMessageDialog.newInstance(message, title, false);
    }

    public static SimpleMessageDialog newInstance(String message, String title, boolean finishActivityOnDismiss) {
        SimpleMessageDialog dialog = new SimpleMessageDialog();
        dialog.setCancelable(true);
        Bundle args = new Bundle();
        args.putString(ARG_MESSAGE, message);
        args.putString(ARG_TITLE, title);
        args.putBoolean(ARG_FINISH_ACTIVITY_ON_DISMISS, finishActivityOnDismiss);
        dialog.setArguments(args);
        return dialog;
    }

    public static SimpleMessageDialog newInstance(int messageId) {
        return SimpleMessageDialog.newInstance(messageId, 0);
    }

    public static SimpleMessageDialog newInstance(int messageId, boolean finishActivityOnDismiss) {
        return SimpleMessageDialog.newInstance(messageId, 0, finishActivityOnDismiss);
    }

    public static SimpleMessageDialog newInstance(int messageId, int titleId) {
        return SimpleMessageDialog.newInstance(messageId, titleId, false);
    }

    public static SimpleMessageDialog newInstance(int messageId, int titleId, boolean finishActivityOnDismiss) {
        SimpleMessageDialog dialog = new SimpleMessageDialog();
        dialog.setCancelable(true);
        Bundle args = new Bundle();
        args.putInt(ARG_MESSAGE_ID, messageId);
        args.putInt(ARG_TITLE_ID, titleId);
        args.putBoolean(ARG_FINISH_ACTIVITY_ON_DISMISS, finishActivityOnDismiss);
        dialog.setArguments(args);
        return dialog;
    }

    public void onStart() {
        super.onStart();
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        int titleId;
        int messageId;
        Bundle args = this.getArguments();
        String message = args.getString(ARG_MESSAGE);
        String title = args.getString(ARG_TITLE);
        final boolean finishActivityOnDismiss = args.getBoolean(ARG_FINISH_ACTIVITY_ON_DISMISS, false);
        if (message == null && (messageId = args.getInt(ARG_MESSAGE_ID)) > 0) {
            message = this.getActivity().getString(messageId);
        }
        if (title == null && (titleId = args.getInt(ARG_TITLE_ID)) > 0) {
            title = this.getActivity().getString(titleId);
        }
        return new ZMAlertDialog.Builder((Context)this.getActivity()).setMessage(message).setTitle(title).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                FragmentActivity activity = SimpleMessageDialog.this.getActivity();
                if (activity != null && finishActivityOnDismiss) {
                    activity.finish();
                }
            }
        }).create();
    }
}

