/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckedTextView;
import android.widget.Toast;
import com.zipow.videobox.AddrBookSettingActivity;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTSettingHelper;
import com.zipow.videobox.ptapp.mm.ZMBuddySyncInstance;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.videomeetings.R;

public class SettingMessengerFragment
extends ZMDialogFragment
implements View.OnClickListener {
    private static final int REQUEST_ENABLE_ADDRBOOK = 100;
    private Button mBtnBack;
    private CheckedTextView mChkAlertImMsg;
    private CheckedTextView mChkEnableAddrBook;
    private CheckedTextView mChkShowOfflineBuddies;
    private CheckedTextView mChkAlertSound;
    private CheckedTextView mChkAlertVibrate;
    private CheckedTextView mChkDisableAddonNotification;
    private View mPanelAlertOptions;
    private View mPanelAlertImMsg;
    private View mOptionShowOfflineBuddies;
    private View mOptionAlertImMsg;
    private View mOptionAlertSound;
    private View mOptionAlertVibrate;
    private View mTxtAlertOptionDes;
    private View mOptionDisableAddonNotification;
    private View mPanelNotification;
    private View mPanelNotificationInstant;
    private View mImgNotificationInstant;
    private View mPanelNotificationIdle;
    private View mImgNotificationIdle;
    private View mOptionShowLinkPreviewDetail;
    private CheckedTextView mChkShowLinkPreviewDetail;

    public static void showAsActivity(Fragment fragment) {
        if (fragment == null) {
            return;
        }
        Bundle args = new Bundle();
        SimpleActivity.show(fragment, SettingMessengerFragment.class.getName(), args, 0);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_setting_messenger, null);
        this.mBtnBack = (Button)view.findViewById(R.id.btnBack);
        this.mChkAlertImMsg = (CheckedTextView)view.findViewById(R.id.chkAlertImMsg);
        this.mChkEnableAddrBook = (CheckedTextView)view.findViewById(R.id.chkEnableAddrBook);
        this.mChkShowOfflineBuddies = (CheckedTextView)view.findViewById(R.id.chkShowOfflineBuddies);
        this.mChkAlertSound = (CheckedTextView)view.findViewById(R.id.chkAlertSound);
        this.mChkAlertVibrate = (CheckedTextView)view.findViewById(R.id.chkAlertVibrate);
        this.mChkDisableAddonNotification = (CheckedTextView)view.findViewById(R.id.chkDisableAddonNotification);
        this.mPanelAlertOptions = view.findViewById(R.id.panelAlertOptions);
        this.mOptionShowOfflineBuddies = view.findViewById(R.id.optionShowOfflineBuddies);
        this.mOptionAlertImMsg = view.findViewById(R.id.optionAlertImMsg);
        this.mOptionAlertSound = view.findViewById(R.id.optionAlertSound);
        this.mOptionAlertVibrate = view.findViewById(R.id.optionAlertVibrate);
        this.mPanelAlertImMsg = view.findViewById(R.id.panelAlertImMsg);
        this.mTxtAlertOptionDes = view.findViewById(R.id.txtAlertOptionDes);
        this.mOptionDisableAddonNotification = view.findViewById(R.id.optionDisableAddonNotification);
        this.mOptionShowLinkPreviewDetail = view.findViewById(R.id.optionShowLinkPreviewDetail);
        this.mChkShowLinkPreviewDetail = (CheckedTextView)view.findViewById(R.id.chkShowLinkPreviewDetail);
        this.mPanelNotification = view.findViewById(R.id.panelNotification);
        this.mPanelNotificationInstant = view.findViewById(R.id.panelNotificationInstant);
        this.mImgNotificationInstant = view.findViewById(R.id.imgNotificationInstant);
        this.mPanelNotificationIdle = view.findViewById(R.id.panelNotificationIdle);
        this.mImgNotificationIdle = view.findViewById(R.id.imgNotificationIdle);
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        this.mOptionAlertImMsg.setOnClickListener((View.OnClickListener)this);
        this.mChkEnableAddrBook.setOnClickListener((View.OnClickListener)this);
        this.mOptionShowOfflineBuddies.setOnClickListener((View.OnClickListener)this);
        this.mOptionAlertSound.setOnClickListener((View.OnClickListener)this);
        this.mOptionAlertVibrate.setOnClickListener((View.OnClickListener)this);
        this.mChkDisableAddonNotification.setOnClickListener((View.OnClickListener)this);
        this.mPanelNotificationInstant.setOnClickListener((View.OnClickListener)this);
        this.mPanelNotificationIdle.setOnClickListener((View.OnClickListener)this);
        this.mOptionShowLinkPreviewDetail.setOnClickListener((View.OnClickListener)this);
        return view;
    }

    private int getShowIMMessageReminder() {
        return PTSettingHelper.getShowChatMessageReminder();
    }

    private void updateUI() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (!PTApp.getInstance().hasMessenger() || PTApp.getInstance().getZoomMessenger().imChatGetOption() == 2) {
            this.mOptionShowLinkPreviewDetail.setVisibility(8);
        } else {
            this.mOptionShowLinkPreviewDetail.setVisibility(0);
        }
        this.mChkShowLinkPreviewDetail.setChecked(this.isImLlinkPreviewDescription());
    }

    private boolean getShowOfflineBuddies() {
        PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
        if (settingHelper != null) {
            return settingHelper.getShowOfflineBuddies();
        }
        return false;
    }

    private void saveShowOfflineBuddies(boolean show) {
        PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
        if (settingHelper != null) {
            settingHelper.saveShowOfflineBuddies(show);
        }
        this.mChkShowOfflineBuddies.setChecked(this.getShowOfflineBuddies());
        ZMBuddySyncInstance.getInsatance().requestBuddyListUpdate();
    }

    private boolean getPlayAlertSound() {
        PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
        if (settingHelper != null) {
            return settingHelper.getPlayAlertSound();
        }
        return true;
    }

    private void savePlayAlertSound(boolean b) {
        PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
        if (settingHelper != null) {
            settingHelper.savePlayAlertSound(b);
        }
        this.mChkAlertSound.setChecked(this.getPlayAlertSound());
    }

    private boolean getPlayAlertVibrate() {
        PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
        if (settingHelper != null) {
            return settingHelper.getPlayAlertVibrate();
        }
        return true;
    }

    private void saveImLlinkPreviewDescription(boolean b) {
        PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
        if (settingHelper != null) {
            PTSettingHelper.saveImLlinkPreviewDescription(b);
        }
        this.mChkShowLinkPreviewDetail.setChecked(this.isImLlinkPreviewDescription());
    }

    private boolean isImLlinkPreviewDescription() {
        PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
        if (settingHelper != null) {
            return settingHelper.isImLlinkPreviewDescription();
        }
        return true;
    }

    private void savePlayAlertVibrate(boolean b) {
        PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
        if (settingHelper != null) {
            settingHelper.savePlayAlertVibrate(b);
        }
        this.mChkAlertVibrate.setChecked(this.getPlayAlertVibrate());
    }

    private void showConnectionError() {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        Toast.makeText((Context)context, (int)R.string.zm_msg_disconnected_try_again, (int)1).show();
    }

    public void onResume() {
        super.onResume();
        this.mChkEnableAddrBook.setChecked(this.isPhoneNumberRegistered());
        this.updateUI();
    }

    private boolean isPhoneNumberRegistered() {
        return PTApp.getInstance().isPhoneNumberRegistered();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode != 100 || resultCode == -1) {
            // empty if block
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        } else if (id2 == R.id.optionAlertImMsg) {
            this.onClickChkAlertImMsg();
        } else if (id2 == R.id.chkEnableAddrBook) {
            this.onClickChkEnableAddrBook();
        } else if (id2 == R.id.optionShowOfflineBuddies) {
            this.onClickChkShowOfflineBuddies();
        } else if (id2 == R.id.optionAlertSound) {
            this.onClickChkAlertSound();
        } else if (id2 == R.id.optionAlertVibrate) {
            this.onClickChkAlertVibrate();
        } else if (id2 != R.id.chkDisableAddonNotification) {
            if (id2 == R.id.panelNotificationInstant) {
                this.onClickPanelNotificationInstant();
            } else if (id2 == R.id.panelNotificationIdle) {
                this.onClickPanelNotificationIdle();
            } else if (id2 == R.id.optionShowLinkPreviewDetail) {
                this.onClickOptionShowLinkPreviewDetail();
            }
        }
    }

    private void onClickOptionShowLinkPreviewDetail() {
        this.saveImLlinkPreviewDescription(!this.mChkShowLinkPreviewDetail.isChecked());
    }

    private void onClickPanelNotificationInstant() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (!messenger.isConnectionGood() || !NetworkUtil.hasDataNetwork((Context)this.getActivity())) {
            this.showConnectionError();
            return;
        }
        PTSettingHelper.saveShowChatMessageReminder(4);
        this.updateUI();
    }

    private void onClickPanelNotificationIdle() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (!messenger.isConnectionGood() || !NetworkUtil.hasDataNetwork((Context)this.getActivity())) {
            this.showConnectionError();
            return;
        }
        PTSettingHelper.saveShowChatMessageReminder(5);
        this.updateUI();
    }

    private void onClickBtnBack() {
        if (this.getShowsDialog()) {
            this.dismiss();
        } else {
            FragmentActivity activity = this.getActivity();
            if (activity != null) {
                activity.finish();
            }
        }
    }

    private void onClickChkAlertImMsg() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (!messenger.isConnectionGood() || !NetworkUtil.hasDataNetwork((Context)this.getActivity())) {
            this.showConnectionError();
            return;
        }
        int type = messenger.blockAll_Get();
        type = type == 2 ? 5 : 2;
        PTSettingHelper.saveShowChatMessageReminder(type);
        this.updateUI();
    }

    private void onClickChkEnableAddrBook() {
        AddrBookSettingActivity.show((Fragment)this, 100);
    }

    private void onClickChkShowOfflineBuddies() {
        this.saveShowOfflineBuddies(!this.mChkShowOfflineBuddies.isChecked());
    }

    private void onClickChkAlertSound() {
        this.savePlayAlertSound(!this.mChkAlertSound.isChecked());
    }

    private void onClickChkAlertVibrate() {
        this.savePlayAlertVibrate(!this.mChkAlertVibrate.isChecked());
    }
}

