/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckedTextView;
import android.widget.TextView;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.kubi.IKubiService;
import com.zipow.videobox.kubi.KubiDevice;
import com.zipow.videobox.kubi.KubiServiceManager;
import com.zipow.videobox.kubi.SettingMeetingKubiItem;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTSettingHelper;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.PTUserProfile;
import com.zipow.videobox.util.PreferenceUtil;
import java.util.ArrayList;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.HardwareUtil;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class SettingMeetingFragment
extends ZMDialogFragment
implements View.OnClickListener,
KubiServiceManager.IKubiServiceConnectionListener {
    private static final String TAG = SettingMeetingFragment.class.getSimpleName();
    private static final int REQUEST_ENABLE_BT = 1017;
    private static final int REQUEST_LOCATION_PERMISSION_FOR_KUBI = 1018;
    private Button mBtnBack;
    private CheckedTextView mChkEnableDrivingMode;
    private CheckedTextView mChkAutoConnectVoIP;
    private CheckedTextView mChkAutoMuteMic;
    private CheckedTextView mChkNotOpenCamera;
    private CheckedTextView mChkShowTimer;
    private View mPanelEnableKubiRobot;
    private CheckedTextView mChkEnableKubiRobot;
    private TextView mTxtEnableKubiRobotInstructions;
    private View mPanelAvailableKubis;
    private View mProgressScanKubi;
    private ViewGroup mPanelKubisContainer;
    private CheckedTextView mChkClosedCaption;
    private CheckedTextView mChkDriveMode;
    private View mOptionEnableDrivingMode;
    private View mOptionAutoConnectVoIP;
    private View mOptionAutoMuteMic;
    private View mOptionNotOpenCamera;
    private View mOptionEnableKubiRobot;
    private View mOptionClosedCaption;
    private View mOptionShowTimer;
    private View mOptionDriveMode;
    private BroadcastReceiver mKubiMsgReceiver;
    private BroadcastReceiver mBluetoothStateReceiver;
    private Handler mHandler = new Handler();
    private ArrayList<KubiDevice> mKubiDevices;

    public static void showAsActivity(Fragment fragment) {
        if (fragment == null) {
            return;
        }
        Bundle args = new Bundle();
        SimpleActivity.show(fragment, SettingMeetingFragment.class.getName(), args, 0);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_setting_meeting, null);
        this.mBtnBack = (Button)view.findViewById(R.id.btnBack);
        this.mChkEnableDrivingMode = (CheckedTextView)view.findViewById(R.id.chkEnableDrivingMode);
        this.mChkAutoConnectVoIP = (CheckedTextView)view.findViewById(R.id.chkAutoConnectVoIP);
        this.mChkAutoMuteMic = (CheckedTextView)view.findViewById(R.id.chkAutoMuteMic);
        this.mChkNotOpenCamera = (CheckedTextView)view.findViewById(R.id.chkNotOpenCamera);
        this.mPanelEnableKubiRobot = view.findViewById(R.id.panelEnableKubiRobot);
        this.mChkEnableKubiRobot = (CheckedTextView)view.findViewById(R.id.chkEnableKubiRobot);
        this.mTxtEnableKubiRobotInstructions = (TextView)view.findViewById(R.id.txtEnableKubiRobotInstructions);
        this.mChkClosedCaption = (CheckedTextView)view.findViewById(R.id.chkClosedCaption);
        this.mChkShowTimer = (CheckedTextView)view.findViewById(R.id.chkShowTimer);
        this.mChkDriveMode = (CheckedTextView)view.findViewById(R.id.chkDriveMode);
        this.mOptionEnableDrivingMode = view.findViewById(R.id.optionEnableDrivingMode);
        this.mOptionAutoConnectVoIP = view.findViewById(R.id.optionAutoConnectVoIP);
        this.mOptionAutoMuteMic = view.findViewById(R.id.optionAutoMuteMic);
        this.mOptionNotOpenCamera = view.findViewById(R.id.optionNotOpenCamera);
        this.mOptionEnableKubiRobot = view.findViewById(R.id.optionEnableKubiRobot);
        this.mOptionClosedCaption = view.findViewById(R.id.optionCloseCaption);
        this.mOptionShowTimer = view.findViewById(R.id.optionShowTimer);
        this.mOptionDriveMode = view.findViewById(R.id.optionDriveMode);
        this.mPanelAvailableKubis = view.findViewById(R.id.panelAvailableKubis);
        this.mProgressScanKubi = view.findViewById(R.id.progressScanKubi);
        this.mPanelKubisContainer = (ViewGroup)view.findViewById(R.id.panelKubisContainer);
        this.mChkEnableDrivingMode.setChecked(this.getEnabledDrivingMode());
        this.mChkAutoConnectVoIP.setChecked(this.getAutoConnectVoIP());
        this.mChkAutoMuteMic.setChecked(this.getAutoMuteMic());
        this.mChkNotOpenCamera.setChecked(this.getNotOpenCamera());
        this.mChkEnableKubiRobot.setChecked(this.getEnabledKubiRobot());
        this.mChkClosedCaption.setChecked(this.isClosedCaptionEnabled());
        this.mChkShowTimer.setChecked(this.isShowTimer());
        this.mChkDriveMode.setChecked(this.isEnableDriveMode());
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        this.mOptionEnableDrivingMode.setOnClickListener((View.OnClickListener)this);
        this.mOptionAutoConnectVoIP.setOnClickListener((View.OnClickListener)this);
        this.mOptionAutoMuteMic.setOnClickListener((View.OnClickListener)this);
        this.mOptionNotOpenCamera.setOnClickListener((View.OnClickListener)this);
        this.mOptionEnableKubiRobot.setOnClickListener((View.OnClickListener)this);
        this.mOptionClosedCaption.setOnClickListener((View.OnClickListener)this);
        this.mOptionShowTimer.setOnClickListener((View.OnClickListener)this);
        this.mOptionDriveMode.setOnClickListener((View.OnClickListener)this);
        if (!this.isKubiSupported()) {
            this.mPanelEnableKubiRobot.setVisibility(8);
            this.mTxtEnableKubiRobotInstructions.setVisibility(8);
        }
        return view;
    }

    private boolean isKubiSupported() {
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        boolean bEnabledInProfile = profile != null && profile.isKubiEnabled();
        boolean bSupportedByDevice = UIUtil.isTablet((Context)this.getActivity()) && HardwareUtil.isBluetoothLESupported((Context)this.getActivity());
        return bEnabledInProfile && bSupportedByDevice;
    }

    public void onResume() {
        super.onResume();
        PTUI.getInstance().checkStartKubiService();
        KubiServiceManager kubiServiceMgr = KubiServiceManager.getInstance((Context)this.getActivity());
        if (kubiServiceMgr != null) {
            kubiServiceMgr.addConnectionListener(this);
        }
        if (this.isKubiSupported()) {
            this.registerKubiReceiver();
            this.registerBluetoothStatusReceiver();
            this.mTxtEnableKubiRobotInstructions.setVisibility(0);
        }
        this.mPanelAvailableKubis.setVisibility(8);
        if (this.getEnabledKubiRobot()) {
            this.showKubiDevices();
            this.startScanKubis(true);
        }
    }

    private void registerBluetoothStatusReceiver() {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        if (this.mBluetoothStateReceiver == null) {
            this.mBluetoothStateReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    SettingMeetingFragment.this.onBluetoothStateChanged(intent);
                }
            };
            IntentFilter filter = new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED");
            context.registerReceiver(this.mBluetoothStateReceiver, filter);
        }
    }

    private void onBluetoothStateChanged(Intent intent) {
        String action = intent.getAction();
        if (action != null && action.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
            int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE);
            switch (state) {
                case 12: {
                    if (!this.getEnabledKubiRobot()) break;
                    this.startScanKubis(false);
                    break;
                }
                case 10: {
                    if (!this.getEnabledKubiRobot()) break;
                    this.mKubiDevices = null;
                    this.mPanelAvailableKubis.setVisibility(8);
                    this.mTxtEnableKubiRobotInstructions.setVisibility(0);
                }
            }
        }
    }

    private void registerKubiReceiver() {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        if (this.mKubiMsgReceiver == null) {
            this.mKubiMsgReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    SettingMeetingFragment.this.onKubiMessageReceived(intent);
                }
            };
            IntentFilter filter = new IntentFilter();
            filter.addAction("us.zoom.videomeetings.KubiContract.ACTION_KUBI_CONNECTION_STATUS");
            filter.addAction("us.zoom.videomeetings.KubiContract.ACTION_KUBI_DEVICE_FOUND");
            filter.addAction("us.zoom.videomeetings.KubiContract.ACTION_KUBI_MANAGER_FAILED");
            filter.addAction("us.zoom.videomeetings.KubiContract.ACTION_KUBI_MANAGER_STATUS_CHANGED");
            filter.addAction("us.zoom.videomeetings.KubiContract.ACTION_KUBI_SCAN_COMPLETE");
            context.registerReceiver(this.mKubiMsgReceiver, filter, context.getPackageName() + ".permission.KUBI_MESSAGE", this.mHandler);
        }
    }

    private void unregisterKubiReceiver() {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        if (this.mKubiMsgReceiver != null) {
            context.unregisterReceiver(this.mKubiMsgReceiver);
        }
        this.mKubiMsgReceiver = null;
    }

    private void unregisterBluetoothStatusReceiver() {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        if (this.mBluetoothStateReceiver != null) {
            context.unregisterReceiver(this.mBluetoothStateReceiver);
        }
        this.mBluetoothStateReceiver = null;
    }

    private void onKubiMessageReceived(Intent intent) {
        if (intent == null) {
            return;
        }
        String action = intent.getAction();
        if ("us.zoom.videomeetings.KubiContract.ACTION_KUBI_CONNECTION_STATUS".equals(action)) {
            boolean connected = intent.getBooleanExtra("connected", false);
            this.onKubiDeviceConnectionStatus(connected);
        } else if ("us.zoom.videomeetings.KubiContract.ACTION_KUBI_DEVICE_FOUND".equals(action)) {
            KubiDevice device = (KubiDevice)intent.getParcelableExtra("device");
            this.onKubiDeviceFound(device);
        } else if ("us.zoom.videomeetings.KubiContract.ACTION_KUBI_MANAGER_FAILED".equals(action)) {
            int reason = intent.getIntExtra("reason", 0);
            this.onKubiManagerFailed(reason);
        } else if ("us.zoom.videomeetings.KubiContract.ACTION_KUBI_MANAGER_STATUS_CHANGED".equals(action)) {
            int oldStatus = intent.getIntExtra("oldStatus", 0);
            int newStatus = intent.getIntExtra("newStatus", 0);
            this.onKubiManagerStatusChanged(oldStatus, newStatus);
        } else if ("us.zoom.videomeetings.KubiContract.ACTION_KUBI_SCAN_COMPLETE".equals(action)) {
            ArrayList devices = intent.getParcelableArrayListExtra("devices");
            this.onKubiScanComplete(devices);
        }
    }

    private void onKubiDeviceConnectionStatus(boolean connected) {
        this.showKubiDevices();
    }

    private void onKubiDeviceFound(KubiDevice device) {
    }

    private void onKubiManagerFailed(int reason) {
        this.mProgressScanKubi.setVisibility(8);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (SettingMeetingFragment.this.isResumed() && SettingMeetingFragment.this.checkBluetoothStatus()) {
                    SettingMeetingFragment.this.startScanKubis(false);
                }
            }
        }, 3000L);
    }

    private void onKubiManagerStatusChanged(int oldStatus, int newStatus) {
        if (oldStatus != 0 && newStatus == 0 && this.checkBluetoothStatus()) {
            this.startScanKubis(true);
        }
    }

    private void onKubiScanComplete(ArrayList<KubiDevice> devices) {
        this.mKubiDevices = devices;
        this.showKubiDevices();
        KubiDevice connectedKubi = this.getConnectedKubi();
        if ((devices == null || devices.size() == 0) && connectedKubi == null) {
            this.startScanKubis(true);
        } else {
            this.mProgressScanKubi.setVisibility(8);
            if (devices != null && devices.size() > 0 && connectedKubi == null) {
                this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        SettingMeetingFragment.this.connectNearestKubi();
                    }
                }, 500L);
            }
        }
    }

    private void connectNearestKubi() {
        if (this.mKubiDevices == null) {
            return;
        }
        if (!this.isResumed()) {
            return;
        }
        if (!this.getEnabledKubiRobot()) {
            return;
        }
        KubiDevice device = this.getNearestKubi(this.mKubiDevices);
        if (device != null) {
            SettingMeetingKubiItem itemView = this.getKubiItemForDevice(device);
            this.connectKubi(itemView, device);
        }
    }

    private KubiDevice getNearestKubi(ArrayList<KubiDevice> devices) {
        if (devices == null) {
            return null;
        }
        KubiDevice nearestKubi = null;
        int maxRSSI = Integer.MIN_VALUE;
        for (KubiDevice device : devices) {
            int rssi;
            if (device == null || maxRSSI >= (rssi = device.getRSSI())) continue;
            maxRSSI = rssi;
            nearestKubi = device;
        }
        return nearestKubi;
    }

    private SettingMeetingKubiItem getKubiItemForDevice(KubiDevice device) {
        if (device == null) {
            return null;
        }
        int count = this.mPanelKubisContainer.getChildCount();
        for (int i = 0; i < count; ++i) {
            SettingMeetingKubiItem item = (SettingMeetingKubiItem)this.mPanelKubisContainer.getChildAt(i);
            if (item == null || !device.equals(item.getKubiDevice())) continue;
            return item;
        }
        return null;
    }

    private KubiDevice getConnectedKubi() {
        KubiServiceManager kubiServiceMgr = KubiServiceManager.getInstance((Context)this.getActivity());
        if (kubiServiceMgr == null) {
            return null;
        }
        IKubiService kubiService = kubiServiceMgr.getKubiService();
        if (kubiService == null) {
            return null;
        }
        try {
            int status = kubiService.getKubiStatus();
            if (status == 4) {
                return kubiService.getCurrentKubi();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }

    private void showKubiDevices() {
        this.mPanelKubisContainer.removeAllViews();
        KubiDevice connectedKubi = this.getConnectedKubi();
        if (connectedKubi != null) {
            this.mPanelKubisContainer.addView((View)this.createKubiItem(connectedKubi, 2));
        }
        if (this.mKubiDevices != null) {
            for (final KubiDevice device : this.mKubiDevices) {
                if (device == null || device.equals(connectedKubi)) continue;
                final SettingMeetingKubiItem item = this.createKubiItem(device, 0);
                this.mPanelKubisContainer.addView((View)item);
                item.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        SettingMeetingFragment.this.connectKubi(item, device);
                    }
                });
            }
        }
    }

    protected void connectKubi(SettingMeetingKubiItem itemView, KubiDevice device) {
        KubiServiceManager kubiServiceMgr = KubiServiceManager.getInstance((Context)this.getActivity());
        if (kubiServiceMgr == null) {
            return;
        }
        IKubiService kubiService = kubiServiceMgr.getKubiService();
        if (kubiService == null) {
            return;
        }
        try {
            SettingMeetingKubiItem connectedItem;
            KubiDevice connectedKubi;
            kubiService.connectToKubi(device);
            if (itemView != null) {
                itemView.setKubiStatus(1);
            }
            if ((connectedKubi = this.getConnectedKubi()) != null && (connectedItem = this.getKubiItemForDevice(connectedKubi)) != null) {
                connectedItem.setKubiStatus(0);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private SettingMeetingKubiItem createKubiItem(KubiDevice connectedKubi, int status) {
        SettingMeetingKubiItem item = new SettingMeetingKubiItem((Context)this.getActivity());
        item.setKubiDevice(connectedKubi);
        item.setKubiStatus(status);
        return item;
    }

    public void onPause() {
        super.onPause();
        KubiServiceManager kubiServiceMgr = KubiServiceManager.getInstance((Context)this.getActivity());
        if (kubiServiceMgr != null) {
            kubiServiceMgr.removeConnectionListener(this);
        }
        this.unregisterKubiReceiver();
        this.unregisterBluetoothStatusReceiver();
    }

    @Override
    public void onKubiServiceConnected(IKubiService service) {
        this.startScanKubis(true);
    }

    @Override
    public void onKubiServiceDisconnected() {
    }

    private void startScanKubis(boolean bCheckBluetoothStatus) {
        if (!this.getEnabledKubiRobot()) {
            return;
        }
        if (!bCheckBluetoothStatus || this.checkBluetoothStatus()) {
            if (this.checkLocationPermissionForKubi()) {
                this.doScanKubis();
            } else {
                this.requestLocationPermissionForKubi();
            }
        } else {
            this.turnOnBluetoothForKubi();
        }
    }

    private void doScanKubis() {
        KubiServiceManager kubiServiceMgr = KubiServiceManager.getInstance((Context)this.getActivity());
        if (kubiServiceMgr == null) {
            this.mProgressScanKubi.setVisibility(8);
            return;
        }
        IKubiService kubiService = kubiServiceMgr.getKubiService();
        if (kubiService == null) {
            this.mProgressScanKubi.setVisibility(8);
            return;
        }
        try {
            kubiService.findAllKubiDevices();
            this.mPanelAvailableKubis.setVisibility(0);
            this.mTxtEnableKubiRobotInstructions.setVisibility(8);
            this.mProgressScanKubi.setVisibility(0);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private boolean getEnabledDrivingMode() {
        PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
        if (settingHelper == null) {
            return false;
        }
        return settingHelper.isDriveModeSettingOn();
    }

    private void saveEnabledDrivingMode(boolean enabled) {
        PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
        if (settingHelper == null) {
            return;
        }
        if (!settingHelper.setDriveMode(enabled)) {
            this.mChkEnableDrivingMode.setChecked(this.getEnabledDrivingMode());
        }
    }

    private boolean getAutoConnectVoIP() {
        PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
        if (settingHelper == null) {
            return false;
        }
        return settingHelper.alwaysUseVoIPWhenJoinMeeting();
    }

    private void saveAutoConnectVoIP(boolean bOn) {
        PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
        if (settingHelper == null) {
            return;
        }
        settingHelper.setAlwaysUseVoIPWhenJoinMeeting(bOn);
        this.mChkAutoConnectVoIP.setChecked(this.getAutoConnectVoIP());
    }

    private boolean getAutoMuteMic() {
        PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
        if (settingHelper == null) {
            return false;
        }
        return settingHelper.alwaysMuteMicWhenJoinVoIP();
    }

    private void saveAutoMuteMic(boolean bOn) {
        PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
        if (settingHelper == null) {
            return;
        }
        settingHelper.setAlwaysMuteMicWhenJoinVoIP(bOn);
        this.mChkAutoMuteMic.setChecked(this.getAutoMuteMic());
    }

    private boolean getNotOpenCamera() {
        PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
        if (settingHelper == null) {
            return false;
        }
        return settingHelper.neverStartVideoWhenJoinMeeting();
    }

    private void saveNotOpenCamera(boolean bOn) {
        PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
        if (settingHelper == null) {
            return;
        }
        settingHelper.setNeverStartVideoWhenJoinMeeting(bOn);
        this.mChkNotOpenCamera.setChecked(this.getNotOpenCamera());
    }

    private boolean isClosedCaptionEnabled() {
        return PreferenceUtil.readBooleanValue("closed_caption_enabled", false);
    }

    private void saveIsClosedCaptionEnabled(boolean bOn) {
        PreferenceUtil.saveBooleanValue("closed_caption_enabled", bOn);
    }

    private boolean isShowTimer() {
        return PreferenceUtil.readBooleanValue("show_timer_enabled", false);
    }

    private void saveIsShowTimerEnabled(boolean bOn) {
        PreferenceUtil.saveBooleanValue("show_timer_enabled", bOn);
    }

    private boolean isEnableDriveMode() {
        return PreferenceUtil.readBooleanValue("drive_mode_enabled", true);
    }

    private void saveIsDriveModeEnabled(boolean bOn) {
        PreferenceUtil.saveBooleanValue("drive_mode_enabled", bOn);
    }

    private boolean getEnabledKubiRobot() {
        PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
        if (settingHelper == null) {
            return false;
        }
        return settingHelper.getIsKubiDeviceEnabled();
    }

    private void saveEnableKubiRobot(boolean bOn) {
        PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
        if (settingHelper == null) {
            return;
        }
        settingHelper.saveIsKubiDeviceEnabled(bOn);
        boolean enabled = this.getEnabledKubiRobot();
        this.mChkEnableKubiRobot.setChecked(enabled);
        KubiServiceManager kubiServiceMgr = KubiServiceManager.getInstance((Context)this.getActivity());
        if (enabled) {
            kubiServiceMgr.startKubiService("us.zoom.videomeetings.KubiContract.ACTION_START_KUBI_SERVICE_NO_AUTO_CONNECT");
            kubiServiceMgr.connectKubiService(false);
            this.showKubiDevices();
        } else {
            kubiServiceMgr.stopKubiService();
            this.mPanelAvailableKubis.setVisibility(8);
            this.mTxtEnableKubiRobotInstructions.setVisibility(0);
            this.mKubiDevices = null;
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        } else if (id2 == R.id.optionEnableDrivingMode) {
            this.onClickChkEnableDrivingMode();
        } else if (id2 == R.id.optionAutoConnectVoIP) {
            this.onClickChkAutoConnectVoIP();
        } else if (id2 == R.id.optionAutoMuteMic) {
            this.onClickChkAutoMuteMic();
        } else if (id2 == R.id.optionNotOpenCamera) {
            this.onClickChkNotOpenCamera();
        } else if (id2 == R.id.optionEnableKubiRobot) {
            this.onClickChkEnableKubiRobot();
        } else if (id2 == R.id.optionCloseCaption) {
            this.onClickChkClosedCaption();
        } else if (id2 == R.id.optionShowTimer) {
            this.onClickShowTimer();
        } else if (id2 == R.id.optionDriveMode) {
            this.onClickDriveMode();
        }
    }

    private void onClickBtnBack() {
        if (this.getShowsDialog()) {
            this.dismiss();
        } else {
            FragmentActivity activity = this.getActivity();
            if (activity != null) {
                activity.finish();
            }
        }
    }

    private void onClickChkEnableDrivingMode() {
        this.mChkEnableDrivingMode.setChecked(!this.mChkEnableDrivingMode.isChecked());
        this.saveEnabledDrivingMode(this.mChkEnableDrivingMode.isChecked());
    }

    private void onClickChkAutoConnectVoIP() {
        this.mChkAutoConnectVoIP.setChecked(!this.mChkAutoConnectVoIP.isChecked());
        this.saveAutoConnectVoIP(this.mChkAutoConnectVoIP.isChecked());
    }

    private void onClickChkAutoMuteMic() {
        this.mChkAutoMuteMic.setChecked(!this.mChkAutoMuteMic.isChecked());
        this.saveAutoMuteMic(this.mChkAutoMuteMic.isChecked());
    }

    private void onClickChkNotOpenCamera() {
        this.mChkNotOpenCamera.setChecked(!this.mChkNotOpenCamera.isChecked());
        this.saveNotOpenCamera(this.mChkNotOpenCamera.isChecked());
    }

    private void onClickChkEnableKubiRobot() {
        this.mChkEnableKubiRobot.setChecked(!this.mChkEnableKubiRobot.isChecked());
        this.saveEnableKubiRobot(this.mChkEnableKubiRobot.isChecked());
    }

    private void onClickChkClosedCaption() {
        this.mChkClosedCaption.setChecked(!this.mChkClosedCaption.isChecked());
        this.saveIsClosedCaptionEnabled(this.mChkClosedCaption.isChecked());
    }

    private void onClickShowTimer() {
        this.mChkShowTimer.setChecked(!this.mChkShowTimer.isChecked());
        this.saveIsShowTimerEnabled(this.mChkShowTimer.isChecked());
    }

    private void onClickDriveMode() {
        this.mChkDriveMode.setChecked(!this.mChkDriveMode.isChecked());
        this.saveIsDriveModeEnabled(this.mChkDriveMode.isChecked());
    }

    private boolean checkBluetoothStatus() {
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (bluetoothAdapter == null) {
            return false;
        }
        boolean isEnabled = bluetoothAdapter.isEnabled();
        return isEnabled;
    }

    private boolean checkLocationPermissionForKubi() {
        if (Build.VERSION.SDK_INT <= 22) {
            return true;
        }
        return 0 == this.checkSelfPermission("android.permission.ACCESS_FINE_LOCATION");
    }

    private void requestLocationPermissionForKubi() {
        ZMAlertDialog dlg = new ZMAlertDialog.Builder((Context)this.getActivity()).setMessage(R.string.zm_kubi_request_location_permission).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                SettingMeetingFragment.this.zm_requestPermissions(new String[]{"android.permission.ACCESS_FINE_LOCATION"}, 1018);
            }
        }).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).create();
        dlg.show();
    }

    private void turnOnBluetoothForKubi() {
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        PackageManager pm = activity.getPackageManager();
        if (pm != null && 0 == pm.checkPermission("android.permission.BLUETOOTH_ADMIN", activity.getPackageName())) {
            ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)activity).setTitle(R.string.zm_kubi_bluetooth_turn_on_request).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    SettingMeetingFragment.this.turnOnBluetooth();
                }
            }).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    SettingMeetingFragment.this.onTurnOnBluetoothRejected();
                }
            }).create();
            dialog.setCanceledOnTouchOutside(true);
            dialog.show();
        } else {
            Intent enableBtIntent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
            this.startActivityForResult(enableBtIntent, 1017);
        }
    }

    private void turnOnBluetooth() {
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (bluetoothAdapter != null && !bluetoothAdapter.isEnabled()) {
            bluetoothAdapter.enable();
        }
    }

    private void onTurnOnBluetoothRejected() {
        this.mPanelAvailableKubis.setVisibility(8);
        this.mTxtEnableKubiRobotInstructions.setVisibility(0);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 1017: {
                if (resultCode != -1) break;
                this.startScanKubis(false);
            }
        }
    }

    public void onRequestPermissionsResult(final int requestCode, final String[] permissions, final int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction(){

            public void run(IUIElement ui) {
                ((SettingMeetingFragment)ui).handleRequestPermissionResult(requestCode, permissions, grantResults);
            }
        });
    }

    private void handleRequestPermissionResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (permissions == null || grantResults == null) {
            return;
        }
        for (int i = 0; i < permissions.length; ++i) {
            if (1018 != requestCode || !"android.permission.ACCESS_FINE_LOCATION".equals(permissions[i]) || grantResults[i] != 0) continue;
            this.startScanKubis(true);
        }
    }
}

