/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebViewDatabase;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import com.zipow.videobox.LauncherActivity;
import com.zipow.videobox.MyProfileActivity;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.fragment.AvatarPreviewFragment;
import com.zipow.videobox.fragment.MMNotificationsFragment;
import com.zipow.videobox.fragment.SettingAboutFragment;
import com.zipow.videobox.fragment.SettingContactsFragment;
import com.zipow.videobox.fragment.SettingMeetingFragment;
import com.zipow.videobox.fragment.SettingMessengerFragment;
import com.zipow.videobox.fragment.SettingTipFragment;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.PTUserProfile;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.PreferenceUtil;
import com.zipow.videobox.util.ZMBitmapFactory;
import com.zipow.videobox.view.AvatarView;
import com.zipow.videobox.view.IMView;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.ResourcesUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMTip;
import us.zoom.thirdparty.login.LoginType;
import us.zoom.thirdparty.login.ThirdPartyLoginFactory;
import us.zoom.videomeetings.R;

public class SettingFragment
extends SettingTipFragment
implements View.OnClickListener,
PTUI.IPTUIListener,
IMView.OnFragmentShowListener {
    private static final String TAG = SettingFragment.class.getSimpleName();
    private static final String ARG_NO_TITLE_BAR_BUTTONS = "noTitleBar";
    private static final String ARG_DISMISS_ON_SIGNOUT = "dismissOnSignout";
    private Button mBtnBack;
    private TextView mTxtDisplayName;
    private View mOptionMMProfile;
    private AvatarView mAvatarView;
    private ImageView mImgIndicatorSetProfile;
    private ImageView mImgIndicatorAbout;
    private View mBtnMeeting;
    private View mBtnMessenger;
    private View mPanelMessenger;
    private View mBtnAbout;
    private View mBtnNotifications;
    private TextView mTxtEmail;
    private ImageView mImgAccountType;
    private View mOptionAccountEmail;
    private View mBtnSignout;
    private View mOptionPhoneNumber;
    private View mPanelNotifications;
    private View mPanelProfile;
    private View mPanelPhoneNumber;
    private View mPanelAbout;

    public static void showAsActivity(ZMActivity activity, int requestCode, boolean dismissOnSignout) {
        Bundle args = new Bundle();
        args.putBoolean(ARG_DISMISS_ON_SIGNOUT, dismissOnSignout);
        SimpleActivity.show(activity, SettingFragment.class.getName(), args, requestCode, true, 1);
    }

    public static void show(FragmentManager fm, int anchorId) {
        if (SettingFragment.getSettingFragment(fm) != null) {
            return;
        }
        SettingFragment f = new SettingFragment();
        Bundle args = new Bundle();
        args.putInt("anchorId", anchorId);
        f.setArguments(args);
        f.show(fm, SettingFragment.class.getName());
    }

    public static SettingFragment getSettingFragment(FragmentManager fm) {
        return (SettingFragment)fm.findFragmentByTag(SettingFragment.class.getName());
    }

    public static boolean needShowNewTipsOnSettingsTab(Context context) {
        if (context == null) {
            return false;
        }
        long timeLastClearNewTipOnSettingsTab = PreferenceUtil.readLongValue("last_clear_new_tip_on_settings_tab_time", 0L);
        if (!SettingFragment.hasProfile() && System.currentTimeMillis() - timeLastClearNewTipOnSettingsTab > 86400000L) {
            return true;
        }
        return SettingAboutFragment.needShowAboutTip(context) && System.currentTimeMillis() - timeLastClearNewTipOnSettingsTab > 86400000L;
    }

    public static void saveNewTipsOnSettingsTabCleared() {
        PreferenceUtil.saveLongValue("last_clear_new_tip_on_settings_tab_time", System.currentTimeMillis());
    }

    public static void saveNewVersionReadyTime() {
        String newVersionOnServer;
        String rememberedNewVersionOnServer = PreferenceUtil.readStringValue("new_version_on_server", null);
        if (StringUtil.isSameString((String)rememberedNewVersionOnServer, (String)(newVersionOnServer = PTApp.getInstance().getLatestVersionString()))) {
            return;
        }
        PreferenceUtil.saveStringValue("new_version_on_server", newVersionOnServer);
        PreferenceUtil.saveLongValue("last_get_new_version_notification_time", System.currentTimeMillis());
    }

    private static boolean needShowSetProfileTip(Context context) {
        long time = PreferenceUtil.readLongValue("last_show_set_profile_time", 0L);
        if (time > 0L) {
            return false;
        }
        return !SettingFragment.hasProfile();
    }

    private static boolean hasProfile() {
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        if (profile != null) {
            String name = profile.getUserName();
            String avatar = profile.getPictureLocalPath();
            if (!StringUtil.isEmptyOrNull((String)name) || !StringUtil.isEmptyOrNull((String)avatar)) {
                return true;
            }
        }
        return false;
    }

    public static SettingFragment createSettingFragment(boolean noTitleBarButtons, boolean dismissOnSignout) {
        SettingFragment f = new SettingFragment();
        Bundle args = new Bundle();
        args.putBoolean(ARG_NO_TITLE_BAR_BUTTONS, noTitleBarButtons);
        args.putBoolean(ARG_DISMISS_ON_SIGNOUT, dismissOnSignout);
        f.setArguments(args);
        return f;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        boolean noTitleBarButtons;
        View view = inflater.inflate(R.layout.zm_setting, null);
        this.mBtnBack = (Button)view.findViewById(R.id.btnBack);
        this.mOptionMMProfile = view.findViewById(R.id.optionMMProfile);
        this.mTxtDisplayName = (TextView)view.findViewById(R.id.txtDisplayName);
        this.mAvatarView = (AvatarView)view.findViewById(R.id.avatarView);
        this.mBtnMeeting = view.findViewById(R.id.btnMeeting);
        this.mBtnMessenger = view.findViewById(R.id.btnMessenger);
        this.mPanelMessenger = view.findViewById(R.id.panelMessenger);
        this.mBtnAbout = view.findViewById(R.id.btnAbout);
        this.mImgIndicatorSetProfile = (ImageView)view.findViewById(R.id.imgIndicatorSetProfile);
        this.mImgIndicatorAbout = (ImageView)view.findViewById(R.id.imgIndicatorAbout);
        this.mTxtEmail = (TextView)view.findViewById(R.id.txtEmail);
        this.mImgAccountType = (ImageView)view.findViewById(R.id.imgAccountType);
        this.mOptionAccountEmail = view.findViewById(R.id.optionAccountEmail);
        View panelCopyright = view.findViewById(R.id.panelCopyright);
        this.mBtnSignout = view.findViewById(R.id.btnSignout);
        this.mOptionPhoneNumber = view.findViewById(R.id.optionPhoneNumber);
        this.mBtnNotifications = view.findViewById(R.id.btnNotifications);
        this.mPanelNotifications = view.findViewById(R.id.panelNotifications);
        this.mPanelProfile = view.findViewById(R.id.panelProfile);
        this.mPanelPhoneNumber = view.findViewById(R.id.panelPhoneNumber);
        this.mPanelAbout = view.findViewById(R.id.panelAbout);
        Bundle args = this.getArguments();
        if (args != null && (noTitleBarButtons = args.getBoolean(ARG_NO_TITLE_BAR_BUTTONS, false))) {
            this.mBtnBack.setVisibility(8);
        }
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        this.mOptionMMProfile.setOnClickListener((View.OnClickListener)this);
        this.mBtnMeeting.setOnClickListener((View.OnClickListener)this);
        this.mBtnMessenger.setOnClickListener((View.OnClickListener)this);
        this.mBtnAbout.setOnClickListener((View.OnClickListener)this);
        this.mAvatarView.setOnClickListener(this);
        this.mOptionPhoneNumber.setOnClickListener((View.OnClickListener)this);
        this.mBtnNotifications.setOnClickListener((View.OnClickListener)this);
        if (this.mBtnSignout != null) {
            this.mBtnSignout.setOnClickListener((View.OnClickListener)this);
        }
        if (ResourcesUtil.getBoolean((Context)this.getActivity(), (int)R.bool.zm_config_no_copyright, (boolean)false)) {
            panelCopyright.setVisibility(8);
        }
        if (!PTApp.getInstance().hasZoomMessenger()) {
            this.mOptionPhoneNumber.setVisibility(8);
        }
        return view;
    }

    private void updateDisplayName() {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        String name = PTApp.getInstance().getMyName();
        if (StringUtil.isEmptyOrNull((String)name)) {
            name = context.getString(R.string.zm_mm_lbl_not_set);
        }
        this.mTxtDisplayName.setText((CharSequence)name);
    }

    private void updateAvatar() {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        String avatar = null;
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        if (profile != null) {
            avatar = profile.getPictureLocalPath();
        }
        this.mAvatarView.setAvatar(avatar);
        this.mAvatarView.setBgColorSeedString(this.getMyJid());
        this.mAvatarView.setName(PTApp.getInstance().getMyName());
    }

    private String getMyJid() {
        ZoomBuddy buddy;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null && (buddy = messenger.getMyself()) != null) {
            return buddy.getJid();
        }
        return null;
    }

    private void updateProfileIndicator() {
        if (SettingFragment.needShowSetProfileTip((Context)this.getActivity())) {
            this.mImgIndicatorSetProfile.setVisibility(0);
        } else {
            this.mImgIndicatorSetProfile.setVisibility(8);
        }
    }

    private void updateAboutIndicator() {
        if (SettingAboutFragment.needShowAboutTip((Context)this.getActivity())) {
            this.mImgIndicatorAbout.setVisibility(0);
        } else {
            this.mImgIndicatorAbout.setVisibility(8);
        }
    }

    private void updateAccountEmail() {
        int loginType = this.getLoginType();
        switch (loginType) {
            case 0: 
            case 2: 
            case 100: 
            case 101: {
                String email = null;
                PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
                if (profile != null) {
                    email = profile.getEmail();
                }
                if (email == null) {
                    email = "";
                }
                this.mTxtEmail.setText((CharSequence)email);
                int iconRes = this.getImageIconByLoginType(loginType);
                this.mImgAccountType.setImageResource(iconRes);
                this.mOptionAccountEmail.setVisibility(0);
                break;
            }
            case 98: {
                this.mOptionAccountEmail.setVisibility(8);
            }
        }
    }

    private void updateMessengerPanel() {
        ZoomMessenger messenger;
        if (this.mPanelMessenger == null) {
            return;
        }
        if (!PTApp.getInstance().hasZoomMessenger()) {
            this.mPanelNotifications.setVisibility(8);
            this.mPanelMessenger.setVisibility(8);
        }
        if ((messenger = PTApp.getInstance().getZoomMessenger()) == null) {
            return;
        }
        if (messenger.imChatGetOption() == 2) {
            this.mPanelNotifications.setVisibility(8);
            if (messenger.isAnyBuddyGroupLarge()) {
                this.mPanelMessenger.setVisibility(8);
            }
        }
    }

    private int getImageIconByLoginType(int loginType) {
        switch (loginType) {
            case 100: 
            case 101: {
                return R.drawable.zm_ic_setting_zoom;
            }
            case 2: {
                return R.drawable.zm_ic_setting_google;
            }
            case 0: {
                return R.drawable.zm_ic_setting_fb;
            }
        }
        return R.drawable.zm_ic_setting_nolink;
    }

    private int getLoginType() {
        PTAppProtos.ZoomAccount account;
        int loginType = PTApp.getInstance().getPTLoginType();
        if (loginType == 100 && (account = PTApp.getInstance().getSavedZoomAccount()) == null) {
            loginType = 102;
        }
        return loginType;
    }

    public void onResume() {
        super.onResume();
        PTUI.getInstance().addPTUIListener(this);
        this.updateDisplayName();
        this.updateAvatar();
        this.updateProfileIndicator();
        this.updateAboutIndicator();
        this.updateAccountEmail();
        this.updateMessengerPanel();
        this.checkLoginState();
    }

    public void onPause() {
        super.onPause();
        PTUI.getInstance().removePTUIListener(this);
    }

    @Override
    public void onPTAppEvent(int event, long result) {
        if (event == 9 || event == 12) {
            this.updateDisplayName();
            this.updateAvatar();
        } else if (event == 1) {
            this.onLogout();
        }
    }

    private void checkLoginState() {
        if (!PTApp.getInstance().isWebSignedOn()) {
            Bundle args = this.getArguments();
            if (args == null || !args.getBoolean(ARG_DISMISS_ON_SIGNOUT)) {
                this.mPanelAbout.setVisibility(8);
                this.mPanelMessenger.setVisibility(8);
                this.mPanelNotifications.setVisibility(8);
                this.mPanelPhoneNumber.setVisibility(8);
                this.mPanelProfile.setVisibility(8);
                SettingAboutFragment aboutFragment = SettingAboutFragment.getSettingAboutFragmentInView((Fragment)this);
                if (aboutFragment == null) {
                    SettingAboutFragment.showSettingAboutFragmentInView((Fragment)this, R.id.panelFragmentContent);
                } else {
                    this.getChildFragmentManager().beginTransaction().show((Fragment)aboutFragment).commit();
                }
            }
            this.onLogout();
        }
    }

    private void onLogout() {
        Bundle args = this.getArguments();
        if (args != null && args.getBoolean(ARG_DISMISS_ON_SIGNOUT)) {
            this.dismiss();
        }
    }

    public void dismiss() {
        if (this.getShowsTip()) {
            super.dismiss();
        } else {
            FragmentActivity activity = this.getActivity();
            if (activity != null) {
                activity.finish();
            }
        }
    }

    @Override
    public void onDataNetworkStatusChanged(boolean connected) {
    }

    @Override
    public ZMTip onCreateTip(Context context, LayoutInflater layoutInflater, Bundle savedInstanceState) {
        ZMTip tip = super.onCreateTip(context, layoutInflater, savedInstanceState);
        View panelOptions = tip.findViewById(R.id.panelOptions);
        panelOptions.setBackgroundResource(0);
        this.mBtnBack.setVisibility(8);
        return tip;
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        } else if (id2 == R.id.btnMeeting) {
            this.onClickBtnMeeting();
        } else if (id2 == R.id.btnMessenger) {
            this.onClickBtnMessenger();
        } else if (id2 == R.id.btnAbout) {
            this.onClickBtnAbout();
        } else if (id2 == R.id.optionMMProfile) {
            this.onClickOptionMMProfile();
        } else if (id2 == R.id.avatarView) {
            this.onClickAvatarView();
        } else if (id2 == R.id.btnSignout) {
            this.onClickBtnSignout();
        } else if (id2 == R.id.optionPhoneNumber) {
            this.onClickOptionPhoneNumber();
        } else if (id2 == R.id.btnNotifications) {
            this.onClickBtnNotifications();
        }
    }

    private void onClickBtnNotifications() {
        MMNotificationsFragment.showAsActivity((Fragment)this);
    }

    private void onClickBtnBack() {
        if (this.getShowsTip()) {
            this.dismiss();
        } else {
            FragmentActivity activity = this.getActivity();
            if (activity != null) {
                activity.finish();
            }
        }
    }

    private void onClickBtnMeeting() {
        SettingMeetingFragment.showAsActivity((Fragment)this);
    }

    private void onClickBtnMessenger() {
        SettingMessengerFragment.showAsActivity((Fragment)this);
    }

    private void onClickBtnAbout() {
        SettingAboutFragment.showAsActivity((Fragment)this);
    }

    private void onClickOptionMMProfile() {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        MyProfileActivity.show(activity, 0);
        PreferenceUtil.saveLongValue("last_show_set_profile_time", System.currentTimeMillis());
    }

    private void onClickAvatarView() {
        Bitmap bitmap;
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        String avatar = null;
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        if (profile != null) {
            avatar = profile.getPictureLocalPath();
        }
        if ((bitmap = ZMBitmapFactory.decodeFile(avatar)) == null) {
            return;
        }
        AvatarPreviewFragment.showMyAvatar((Fragment)this);
    }

    private void onClickOptionPhoneNumber() {
        SettingContactsFragment.showAsActivity((Fragment)this);
    }

    private void onClickBtnSignout() {
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setCancelable(true).setTitle(R.string.zm_alert_logout).setNegativeButton(R.string.zm_btn_no, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).setPositiveButton(R.string.zm_btn_yes, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                SettingFragment.this.signout();
            }
        }).create();
        dialog.show();
    }

    private void signout() {
        boolean needRestart = false;
        int loginType = PTApp.getInstance().getPTLoginType();
        if (loginType == 101) {
            FragmentActivity context = this.getActivity();
            if (context == null) {
                return;
            }
            WebViewDatabase webViewDatabase = WebViewDatabase.getInstance((Context)context);
            if (webViewDatabase != null && webViewDatabase.hasHttpAuthUsernamePassword()) {
                needRestart = true;
            }
        }
        PTApp.getInstance().logout(0);
        if (needRestart) {
            ThirdPartyLoginFactory.build((LoginType)LoginType.Sso, (Bundle)ThirdPartyLoginFactory.buildEmptySsoBundle()).logout((Context)VideoBoxApplication.getInstance());
            LauncherActivity.showLauncherActivityAsFromHome((Context)this.getActivity());
            VideoBoxApplication.getInstance().exit();
        }
    }

    @Override
    public void onShow() {
        this.updateMessengerPanel();
    }
}

