/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.zipow.videobox.LoginActivity;
import com.zipow.videobox.fragment.SimpleMessageDialog;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUI;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.EventTaskManager;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class SetPasswordFragment
extends ZMDialogFragment
implements View.OnClickListener,
PTUI.IPTUIListener {
    private static final String ARG_UNAME = "uname";
    private static final String ARG_EMAIL = "email";
    private static final String ARG_CODE = "code";
    private Button mBtnBack;
    private Button mBtnOK;
    private TextView mTxtError;
    private EditText mEdtPassword;
    private EditText mEdtVerifyPassword;
    private String mEmail = null;
    private String mCode = null;
    private boolean mVerifyFailed = false;
    private ProgressDialog mWaitingDialog;

    public static void show(ZMActivity activity, String uname, String email, String code) {
        SetPasswordFragment f = new SetPasswordFragment();
        Bundle args = SetPasswordFragment.buildArguments(uname, email, code);
        f.setArguments(args);
        activity.getSupportFragmentManager().beginTransaction().add(0x1020002, (Fragment)f, SetPasswordFragment.class.getName()).commit();
    }

    private static Bundle buildArguments(String uname, String email, String code) {
        Bundle args = new Bundle();
        args.putString(ARG_UNAME, uname);
        args.putString(ARG_EMAIL, email);
        args.putString(ARG_CODE, code);
        return args;
    }

    public SetPasswordFragment() {
        this.setStyle(1, R.style.ZMDialog);
    }

    public void onStart() {
        super.onStart();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        Bundle args = this.getArguments();
        if (args != null) {
            this.mEmail = args.getString(ARG_EMAIL);
            this.mCode = args.getString(ARG_CODE);
        }
        View view = inflater.inflate(R.layout.zm_resetpwd, null);
        this.mBtnBack = (Button)view.findViewById(R.id.btnBack);
        this.mBtnOK = (Button)view.findViewById(R.id.btnOK);
        this.mTxtError = (TextView)view.findViewById(R.id.txtError);
        this.mEdtPassword = (EditText)view.findViewById(R.id.edtPassword);
        this.mEdtVerifyPassword = (EditText)view.findViewById(R.id.edtVerifyPassword);
        EditText edtEmail = (EditText)view.findViewById(R.id.edtEmail);
        if (savedInstanceState == null) {
            if (edtEmail != null && this.mEmail != null) {
                edtEmail.setText((CharSequence)this.mEmail);
            }
        } else {
            this.mVerifyFailed = savedInstanceState.getBoolean("mVerifyFailed");
        }
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        this.mBtnOK.setOnClickListener((View.OnClickListener)this);
        TextWatcher inputValidator = new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                SetPasswordFragment.this.updateOKButton();
                SetPasswordFragment.this.mVerifyFailed = false;
                SetPasswordFragment.this.mTxtError.setVisibility(4);
            }
        };
        this.mEdtPassword.addTextChangedListener(inputValidator);
        this.mEdtVerifyPassword.addTextChangedListener(inputValidator);
        PTUI.getInstance().addPTUIListener(this);
        return view;
    }

    public void onResume() {
        super.onResume();
        this.updateUI();
    }

    public void onDestroy() {
        super.onDestroy();
        PTUI.getInstance().removePTUIListener(this);
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("mVerifyFailed", this.mVerifyFailed);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        } else if (id2 == R.id.btnOK) {
            this.onClickBtnOK();
        }
    }

    private void onClickBtnBack() {
        this.dismiss();
    }

    private void onClickBtnOK() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        String password = this.mEdtPassword.getText().toString();
        String verify = this.mEdtVerifyPassword.getText().toString();
        if (!this.validateInput()) {
            return;
        }
        if (!password.equals(verify)) {
            this.mVerifyFailed = true;
            this.mTxtError.setVisibility(0);
            return;
        }
        boolean res = PTApp.getInstance().setPassword(true, this.mEmail, password, this.mCode);
        if (res) {
            this.showWaitingDialog(R.string.zm_msg_requesting_setpwd);
        } else {
            this.showSetPwdErrorDialog();
        }
    }

    private void showSetPwdErrorDialog() {
        int msgId = R.string.zm_msg_resetpwd_failed;
        SimpleMessageDialog dialog = SimpleMessageDialog.newInstance(msgId);
        dialog.show(this.getFragmentManager(), SimpleMessageDialog.class.getName());
    }

    private void updateUI() {
        if (this.mVerifyFailed) {
            this.mTxtError.setVisibility(0);
        } else {
            this.mTxtError.setVisibility(4);
        }
        this.updateOKButton();
    }

    private void updateOKButton() {
        this.mBtnOK.setEnabled(this.validateInput());
    }

    private boolean validateInput() {
        String password = this.mEdtPassword.getText().toString();
        String verify = this.mEdtVerifyPassword.getText().toString();
        if (password.length() == 0) {
            return false;
        }
        return verify.length() != 0;
    }

    public void dismiss() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        this.finishFragment(true);
    }

    @Override
    public void onPTAppEvent(int event, long result) {
        switch (event) {
            case 41: {
                this.onSetPasswordRet(result);
            }
        }
    }

    @Override
    public void onDataNetworkStatusChanged(boolean connected) {
    }

    private void onSetPasswordRet(final long result) {
        EventTaskManager eventTaskMgr = this.getEventTaskManager();
        if (eventTaskMgr != null) {
            eventTaskMgr.push(new EventAction(){

                public void run(IUIElement ui) {
                    ((SetPasswordFragment)ui).handleOnSetPasswordRet(result);
                }
            });
        }
    }

    private void handleOnSetPasswordRet(long result) {
        this.dismissWaitingDialog();
        switch ((int)result) {
            case 0: {
                this.autoLogin();
                break;
            }
            default: {
                this.showSetPwdErrorDialog();
            }
        }
    }

    private void autoLogin() {
        this.dismiss();
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            LoginActivity.show((Context)activity, false);
            activity.overridePendingTransition(R.anim.zm_slide_in_right, R.anim.zm_slide_out_left);
        }
    }

    private void showWaitingDialog(int message) {
        if (this.mWaitingDialog != null) {
            return;
        }
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        this.mWaitingDialog = UIUtil.showSimpleWaitingDialog((Activity)activity, (int)message);
    }

    private void dismissWaitingDialog() {
        if (this.mWaitingDialog != null) {
            this.mWaitingDialog.dismiss();
            this.mWaitingDialog = null;
        }
    }
}

