/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.fragment.SelectCountryCodeFragment;
import com.zipow.videobox.ptapp.ABContactsCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.SortUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.QuickSearchListView;
import us.zoom.videomeetings.R;

public class SelectPhoneNumberFragment
extends ZMDialogFragment
implements SimpleActivity.ExtListener,
View.OnClickListener,
TextView.OnEditorActionListener,
ABContactsCache.IABContactsCacheListener {
    public static final String RESULT_ARG_PHONE_NUMBER = "phoneNumber";
    private static final String ARG_FILTER_COUNTRY_CODES = "filterContryCodes";
    private View mBtnCancel;
    private EditText mEdtSearch;
    private EditText mEdtSearchDummy;
    private View mPanelSearchBar;
    private View mBtnClearSearchView;
    private QuickSearchListView mPhoneNumberListView;
    private View mPanelTitleBar;
    private FrameLayout mListContainer;
    private Drawable mDimmedForground = null;
    private PhoneNumberAdapter mPhoneNumberAdapter;
    private Handler mHandler = new Handler();
    private Runnable mRunnableFilter = new Runnable(){

        @Override
        public void run() {
            String key = SelectPhoneNumberFragment.this.mEdtSearch.getText().toString();
            SelectPhoneNumberFragment.this.mPhoneNumberAdapter.setFilter(key);
            if (key.length() > 0 && SelectPhoneNumberFragment.this.mPhoneNumberAdapter.getCount() > 0 || SelectPhoneNumberFragment.this.mPanelTitleBar.getVisibility() == 0) {
                SelectPhoneNumberFragment.this.mListContainer.setForeground(null);
            } else {
                SelectPhoneNumberFragment.this.mListContainer.setForeground(SelectPhoneNumberFragment.this.mDimmedForground);
            }
        }
    };

    public static void showAsActivity(Fragment fragment, int requestCode) {
        SelectPhoneNumberFragment.showAsActivity(fragment, null, requestCode);
    }

    public static void showAsActivity(Fragment fragment, ArrayList<SelectCountryCodeFragment.CountryCodeItem> filterCountryCodes, int requestCode) {
        if (fragment == null) {
            return;
        }
        Bundle args = new Bundle();
        args.putSerializable(ARG_FILTER_COUNTRY_CODES, filterCountryCodes);
        SimpleActivity.show(fragment, SelectPhoneNumberFragment.class.getName(), args, requestCode, true, 1);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_select_phone_number, null);
        this.mBtnCancel = view.findViewById(R.id.btnCancel);
        this.mEdtSearch = (EditText)view.findViewById(R.id.edtSearch);
        this.mEdtSearchDummy = (EditText)view.findViewById(R.id.edtSearchDummy);
        this.mPanelSearchBar = view.findViewById(R.id.panelSearchBar);
        this.mPhoneNumberListView = (QuickSearchListView)view.findViewById(R.id.phoneNumberListView);
        this.mBtnClearSearchView = view.findViewById(R.id.btnClearSearchView);
        this.mPanelTitleBar = view.findViewById(R.id.panelTitleBar);
        this.mListContainer = (FrameLayout)view.findViewById(R.id.listContainer);
        this.mBtnCancel.setOnClickListener((View.OnClickListener)this);
        this.mBtnClearSearchView.setOnClickListener((View.OnClickListener)this);
        FragmentActivity context = this.getActivity();
        Bundle args = this.getArguments();
        ArrayList filterCountryCodes = null;
        if (args != null) {
            filterCountryCodes = (ArrayList)args.getSerializable(ARG_FILTER_COUNTRY_CODES);
        }
        this.mPhoneNumberAdapter = new PhoneNumberAdapter((Context)context, filterCountryCodes);
        this.mPhoneNumberListView.setAdapter((QuickSearchListView.QuickSearchListDataAdapter)this.mPhoneNumberAdapter);
        this.mPhoneNumberListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                Object item = SelectPhoneNumberFragment.this.mPhoneNumberListView.getItemAtPosition(position);
                if (item instanceof PhoneNumberItem) {
                    SelectPhoneNumberFragment.this.onSelectPhoneNumber((PhoneNumberItem)item);
                }
            }
        });
        this.mEdtSearch.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                SelectPhoneNumberFragment.this.mHandler.removeCallbacks(SelectPhoneNumberFragment.this.mRunnableFilter);
                SelectPhoneNumberFragment.this.mHandler.postDelayed(SelectPhoneNumberFragment.this.mRunnableFilter, 300L);
                SelectPhoneNumberFragment.this.updateBtnClearSearchView();
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
        this.mEdtSearch.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        Resources res = this.getResources();
        if (res != null) {
            this.mDimmedForground = new ColorDrawable(res.getColor(R.color.zm_dimmed_forground));
        }
        return view;
    }

    public void onResume() {
        super.onResume();
        this.updateBtnClearSearchView();
        if (this.hasReadContactsPermission()) {
            ABContactsCache cache = ABContactsCache.getInstance();
            cache.addListener(this);
        }
        this.reloadAll();
        this.mPhoneNumberAdapter.notifyDataSetChanged();
        this.mPhoneNumberListView.onResume();
    }

    public void onRequestPermissionsResult(final int requestCode, final String[] permissions, final int[] grantResults) {
        if (permissions == null || grantResults == null) {
            return;
        }
        for (int i = 0; i < permissions.length; ++i) {
            if (!"android.permission.READ_CONTACTS".equals(permissions[i]) || grantResults[i] == 0) continue;
            this.dismiss();
            return;
        }
        this.getNonNullEventTaskManagerOrThrowException().pushLater("SelectPhonePermissionResult", new EventAction("SelectPhonePermissionResult"){

            public void run(IUIElement ui) {
                ((SelectPhoneNumberFragment)ui).handleRequestPermissionResult(requestCode, permissions, grantResults);
            }
        });
    }

    public void handleRequestPermissionResult(int requestCode, String[] permissions, int[] grantResults) {
        if (permissions == null || grantResults == null) {
            return;
        }
        for (int i = 0; i < permissions.length; ++i) {
            if (!"android.permission.READ_CONTACTS".equals(permissions[i]) || grantResults[i] != 0) continue;
            ABContactsCache cache = ABContactsCache.getInstance();
            cache.addListener(this);
            if (!cache.needReloadAll()) continue;
            cache.reloadAllContacts(true);
        }
    }

    public void onPause() {
        super.onPause();
        if (this.hasReadContactsPermission()) {
            ABContactsCache cache = ABContactsCache.getInstance();
            cache.removeListener(this);
        }
    }

    @Override
    public void onContactsCacheUpdated() {
        this.reloadAll();
        this.mPhoneNumberAdapter.notifyDataSetChanged();
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        if (v.getId() == R.id.edtSearch) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
            return true;
        }
        return false;
    }

    @Override
    public boolean onSearchRequested() {
        this.mEdtSearch.requestFocus();
        UIUtil.openSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        return true;
    }

    @Override
    public boolean onTipLayerTouched() {
        return false;
    }

    @Override
    public void onKeyboardOpen() {
        if (this.getView() == null) {
            return;
        }
        if (this.mEdtSearchDummy.hasFocus()) {
            this.mEdtSearchDummy.setVisibility(8);
            this.mPanelTitleBar.setVisibility(8);
            this.mPanelSearchBar.setVisibility(0);
            this.mListContainer.setForeground(this.mDimmedForground);
            this.mEdtSearch.requestFocus();
        }
    }

    @Override
    public void onKeyboardClosed() {
        if (this.mEdtSearch == null) {
            return;
        }
        this.mEdtSearchDummy.setVisibility(0);
        this.mPanelSearchBar.setVisibility(4);
        this.mListContainer.setForeground(null);
        this.mPanelTitleBar.setVisibility(0);
        this.mPhoneNumberListView.post(new Runnable(){

            @Override
            public void run() {
                SelectPhoneNumberFragment.this.mPhoneNumberListView.requestLayout();
            }
        });
    }

    @Override
    public boolean onBackPressed() {
        return false;
    }

    private void updateBtnClearSearchView() {
        this.mBtnClearSearchView.setVisibility(this.mEdtSearch.getText().length() > 0 ? 0 : 8);
    }

    private void onSelectPhoneNumber(PhoneNumberItem item) {
        if (!this.getShowsDialog()) {
            ZMActivity activity = (ZMActivity)this.getActivity();
            if (activity == null) {
                return;
            }
            Intent data = new Intent();
            data.putExtra(RESULT_ARG_PHONE_NUMBER, (Serializable)item);
            activity.setResult(-1, data);
        }
        this.dismiss();
    }

    public void dismiss() {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity != null) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        }
        this.finishFragment(true);
    }

    public void onClick(View v) {
        if (v == this.mBtnCancel) {
            this.onClickBtnCancel();
        } else if (v == this.mBtnClearSearchView) {
            this.onClickBtnClearSearchView();
        }
    }

    private void onClickBtnCancel() {
        this.dismiss();
    }

    private void onClickBtnClearSearchView() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        this.mEdtSearch.setText((CharSequence)"");
        this.mPhoneNumberAdapter.setFilter(null);
    }

    public boolean hasReadContactsPermission() {
        return Build.VERSION.SDK_INT < 23 || this.checkSelfPermission("android.permission.READ_CONTACTS") == 0;
    }

    public void requestContactsPermission() {
        this.zm_requestPermissions(new String[]{"android.permission.READ_CONTACTS"}, 0);
    }

    private void reloadAll() {
        if (this.hasReadContactsPermission()) {
            ABContactsCache cache = ABContactsCache.getInstance();
            if (cache.needReloadAll()) {
                cache.reloadAllContacts(true);
            }
            this.mPhoneNumberAdapter.reloadAll();
        } else {
            this.requestContactsPermission();
        }
    }

    public static class PhoneNumberAdapter
    extends QuickSearchListView.QuickSearchListDataAdapter {
        private Context mContext;
        private List<PhoneNumberItem> mList = new ArrayList<PhoneNumberItem>();
        private List<PhoneNumberItem> mListFiltered = new ArrayList<PhoneNumberItem>();
        private String mFilter;
        private ArrayList<SelectCountryCodeFragment.CountryCodeItem> mFilterCountryCodes;

        public PhoneNumberAdapter(Context context, ArrayList<SelectCountryCodeFragment.CountryCodeItem> filterCountryCodes) {
            this.mContext = context;
            this.mFilterCountryCodes = filterCountryCodes;
        }

        public void setFilterCountryCodes(ArrayList<SelectCountryCodeFragment.CountryCodeItem> filterCountryCodes) {
            this.mFilterCountryCodes = filterCountryCodes;
            this.reloadAll();
        }

        public void setFilter(String filter) {
            if (filter != null) {
                filter = filter.trim();
            }
            this.mFilter = filter;
            this.updateFilteredList();
            this.notifyDataSetChanged();
        }

        private void updateFilteredList() {
            this.mListFiltered.clear();
            if (!StringUtil.isEmptyOrNull((String)this.mFilter)) {
                Locale locale = CompatUtils.getLocalDefault();
                String filter = this.mFilter.toLowerCase(locale);
                for (PhoneNumberItem item : this.mList) {
                    if (!item.contactName.toLowerCase(locale).contains(filter) && !item.phoneNumber.contains(filter)) continue;
                    this.mListFiltered.add(item);
                }
            }
        }

        private void loadAll() {
            ABContactsCache cache = ABContactsCache.getInstance();
            int count = cache.getCachedContactsCount();
            for (int i = 0; i < count; ++i) {
                ABContactsCache.Contact contact = cache.getCachedContact(i);
                if (contact == null) continue;
                boolean accepted = true;
                if (this.mFilterCountryCodes != null) {
                    accepted = false;
                    for (SelectCountryCodeFragment.CountryCodeItem code : this.mFilterCountryCodes) {
                        if (code == null || code.countryCode == null || !code.countryCode.equalsIgnoreCase(contact.normalizeCountryCode)) continue;
                        accepted = true;
                        break;
                    }
                }
                if (!accepted) continue;
                PhoneNumberItem item = new PhoneNumberItem(contact.displayName, contact.number, contact.normalizeCountryCode, contact.normalizedNumber);
                this.mList.add(item);
            }
        }

        public void reloadAll() {
            this.mList.clear();
            this.loadAll();
        }

        public int getCount() {
            if (!StringUtil.isEmptyOrNull((String)this.mFilter)) {
                return this.mListFiltered.size();
            }
            return this.mList.size();
        }

        public Object getItem(int position) {
            if (position < 0 || position >= this.getCount()) {
                return null;
            }
            if (!StringUtil.isEmptyOrNull((String)this.mFilter)) {
                return this.mListFiltered.get(position);
            }
            return this.mList.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null || !"dropdown".equals(convertView.getTag())) {
                convertView = View.inflate((Context)this.mContext, (int)R.layout.zm_select_phone_number_item, null);
                convertView.setTag((Object)"dropdown");
            }
            this.bindView(position, convertView);
            return convertView;
        }

        private void bindView(int position, View view) {
            TextView txtName = (TextView)view.findViewById(R.id.txtName);
            TextView txtNumber = (TextView)view.findViewById(R.id.txtNumber);
            PhoneNumberItem item = (PhoneNumberItem)this.getItem(position);
            txtName.setText((CharSequence)item.contactName);
            txtNumber.setText((CharSequence)item.phoneNumber);
        }

        public String getItemSortKey(Object oItem) {
            PhoneNumberItem item = (PhoneNumberItem)oItem;
            return item.sortKey;
        }
    }

    public static class PhoneNumberItem
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String contactName;
        public String phoneNumber;
        public String countryCode;
        public String normalizedNumber;
        private String sortKey;

        public PhoneNumberItem(String contactName, String phoneNumber, String countryCode, String normalizedNumber) {
            this.contactName = contactName;
            this.phoneNumber = phoneNumber;
            this.countryCode = countryCode;
            this.normalizedNumber = normalizedNumber;
            this.sortKey = SortUtil.getSortKey((String)contactName, (Locale)CompatUtils.getLocalDefault());
        }
    }
}

