/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.FragmentActivity;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.VideoBoxApplication;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.SortUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.QuickSearchListView;
import us.zoom.videomeetings.R;

public abstract class SelectCallInCountryFragment
extends ZMDialogFragment
implements SimpleActivity.ExtListener,
View.OnClickListener,
TextView.OnEditorActionListener {
    public static final String RESULT_ARG_CALLIN_NUMBER = "phoneNumber";
    private View mBtnCancel;
    private EditText mEdtSearch;
    private EditText mEdtSearchDummy;
    private View mPanelSearchBar;
    private View mBtnClearSearchView;
    private QuickSearchListView mPhoneNumberListView;
    private View mPanelTitleBar;
    private FrameLayout mListContainer;
    private Drawable mDimmedForground = null;
    private CallInNumberAdapter mPhoneNumberAdapter;
    private Handler mHandler = new Handler();
    private Runnable mRunnableFilter = new Runnable(){

        @Override
        public void run() {
            String key = SelectCallInCountryFragment.this.mEdtSearch.getText().toString();
            SelectCallInCountryFragment.this.mPhoneNumberAdapter.setFilter(key);
            if (key.length() > 0 && SelectCallInCountryFragment.this.mPhoneNumberAdapter.getCount() > 0 || SelectCallInCountryFragment.this.mPanelTitleBar.getVisibility() == 0) {
                SelectCallInCountryFragment.this.mListContainer.setForeground(null);
            } else {
                SelectCallInCountryFragment.this.mListContainer.setForeground(SelectCallInCountryFragment.this.mDimmedForground);
            }
        }
    };

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_select_callin_country, null);
        this.mBtnCancel = view.findViewById(R.id.btnCancel);
        this.mEdtSearch = (EditText)view.findViewById(R.id.edtSearch);
        this.mEdtSearchDummy = (EditText)view.findViewById(R.id.edtSearchDummy);
        this.mPanelSearchBar = view.findViewById(R.id.panelSearchBar);
        this.mPhoneNumberListView = (QuickSearchListView)view.findViewById(R.id.phoneNumberListView);
        this.mBtnClearSearchView = view.findViewById(R.id.btnClearSearchView);
        this.mPanelTitleBar = view.findViewById(R.id.panelTitleBar);
        this.mListContainer = (FrameLayout)view.findViewById(R.id.listContainer);
        this.mBtnCancel.setOnClickListener((View.OnClickListener)this);
        this.mBtnClearSearchView.setOnClickListener((View.OnClickListener)this);
        FragmentActivity context = this.getActivity();
        this.mPhoneNumberAdapter = new CallInNumberAdapter((Context)context, this);
        this.mPhoneNumberListView.setAdapter((QuickSearchListView.QuickSearchListDataAdapter)this.mPhoneNumberAdapter);
        this.mPhoneNumberListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                Object item = SelectCallInCountryFragment.this.mPhoneNumberListView.getItemAtPosition(position);
                if (item instanceof CallInNumberItem) {
                    SelectCallInCountryFragment.this.onSelectPhoneNumber((CallInNumberItem)item);
                }
            }
        });
        this.mEdtSearch.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                SelectCallInCountryFragment.this.mHandler.removeCallbacks(SelectCallInCountryFragment.this.mRunnableFilter);
                SelectCallInCountryFragment.this.mHandler.postDelayed(SelectCallInCountryFragment.this.mRunnableFilter, 300L);
                SelectCallInCountryFragment.this.updateBtnClearSearchView();
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
        this.mEdtSearch.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        Resources res = this.getResources();
        if (res != null) {
            this.mDimmedForground = new ColorDrawable(res.getColor(R.color.zm_dimmed_forground));
        }
        return view;
    }

    public void onResume() {
        super.onResume();
        this.updateBtnClearSearchView();
        this.mPhoneNumberAdapter.reloadAll();
        this.mPhoneNumberAdapter.notifyDataSetChanged();
        this.mPhoneNumberListView.onResume();
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        if (v.getId() == R.id.edtSearch) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
            return true;
        }
        return false;
    }

    @Override
    public boolean onSearchRequested() {
        this.mEdtSearch.requestFocus();
        UIUtil.openSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        return true;
    }

    @Override
    public boolean onTipLayerTouched() {
        return false;
    }

    @Override
    public void onKeyboardOpen() {
        if (this.getView() == null) {
            return;
        }
        if (this.mEdtSearchDummy.hasFocus()) {
            this.mEdtSearchDummy.setVisibility(8);
            this.mPanelTitleBar.setVisibility(8);
            this.mPanelSearchBar.setVisibility(0);
            this.mListContainer.setForeground(this.mDimmedForground);
            this.mEdtSearch.requestFocus();
        }
    }

    @Override
    public void onKeyboardClosed() {
        if (this.mEdtSearch == null) {
            return;
        }
        this.mEdtSearchDummy.setVisibility(0);
        this.mPanelSearchBar.setVisibility(4);
        this.mListContainer.setForeground(null);
        this.mPanelTitleBar.setVisibility(0);
        this.mPhoneNumberListView.post(new Runnable(){

            @Override
            public void run() {
                SelectCallInCountryFragment.this.mPhoneNumberListView.requestLayout();
            }
        });
    }

    @Override
    public boolean onBackPressed() {
        return false;
    }

    private void updateBtnClearSearchView() {
        this.mBtnClearSearchView.setVisibility(this.mEdtSearch.getText().length() > 0 ? 0 : 8);
    }

    protected void onSelectPhoneNumber(CallInNumberItem item) {
        if (!this.getShowsDialog()) {
            ZMActivity activity = (ZMActivity)this.getActivity();
            if (activity == null) {
                return;
            }
            Intent data = new Intent();
            data.putExtra(RESULT_ARG_CALLIN_NUMBER, (Serializable)item);
            activity.setResult(-1, data);
        }
        this.dismiss();
    }

    public void dismiss() {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity != null) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        }
        this.finishFragment(true);
    }

    public void onClick(View v) {
        if (v == this.mBtnCancel) {
            this.onClickBtnCancel();
        } else if (v == this.mBtnClearSearchView) {
            this.onClickBtnClearSearchView();
        }
    }

    private void onClickBtnCancel() {
        this.dismiss();
    }

    private void onClickBtnClearSearchView() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        this.mEdtSearch.setText((CharSequence)"");
        this.mPhoneNumberAdapter.setFilter(null);
    }

    public abstract void loadAllCountryCodes(Map<String, CallInNumberItem> var1);

    public static class CallInNumberAdapter
    extends QuickSearchListView.QuickSearchListDataAdapter {
        private Context mContext;
        private List<CallInNumberItem> mList = new ArrayList<CallInNumberItem>();
        private List<CallInNumberItem> mListFiltered = new ArrayList<CallInNumberItem>();
        private String mFilter;
        private SelectCallInCountryFragment mFragment;

        public CallInNumberAdapter(Context context, SelectCallInCountryFragment fragment) {
            this.mContext = context;
            this.mFragment = fragment;
            this.loadAll();
        }

        public void setFilter(String filter) {
            this.mFilter = filter;
            this.updateFilteredList();
            this.notifyDataSetChanged();
        }

        private void updateFilteredList() {
            this.mListFiltered.clear();
            if (!StringUtil.isEmptyOrNull((String)this.mFilter)) {
                Locale locale = CompatUtils.getLocalDefault();
                String filter = this.mFilter.toLowerCase(locale);
                for (CallInNumberItem item : this.mList) {
                    if (!item.countryName.toLowerCase(locale).contains(filter) && !item.countryCode.contains(filter)) continue;
                    this.mListFiltered.add(item);
                }
            }
        }

        private void loadAll() {
            HashMap<String, CallInNumberItem> countryCodeMap = new HashMap<String, CallInNumberItem>();
            this.mFragment.loadAllCountryCodes(countryCodeMap);
            for (Map.Entry entry : countryCodeMap.entrySet()) {
                CallInNumberItem item = (CallInNumberItem)entry.getValue();
                if (item == null) continue;
                this.mList.add(item);
            }
            Collections.sort(this.mList, new CallInNumberItemComparator(CompatUtils.getLocalDefault()));
        }

        public void reloadAll() {
            this.mList.clear();
            this.loadAll();
        }

        public int getCount() {
            if (!StringUtil.isEmptyOrNull((String)this.mFilter)) {
                return this.mListFiltered.size();
            }
            return this.mList.size();
        }

        public Object getItem(int position) {
            if (position < 0 || position >= this.getCount()) {
                return null;
            }
            if (!StringUtil.isEmptyOrNull((String)this.mFilter)) {
                return this.mListFiltered.get(position);
            }
            return this.mList.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null || !"dropdown".equals(convertView.getTag())) {
                convertView = View.inflate((Context)this.mContext, (int)R.layout.zm_select_callin_country_item, null);
                convertView.setTag((Object)"dropdown");
            }
            this.bindView(position, convertView);
            return convertView;
        }

        private void bindView(int position, View view) {
            int flagId;
            TextView txtCountryName = (TextView)view.findViewById(R.id.txtCountryName);
            ImageView imgCountryFlag = (ImageView)view.findViewById(R.id.imgCountryFlag);
            CallInNumberItem item = (CallInNumberItem)this.getItem(position);
            txtCountryName.setText((CharSequence)item.countryName);
            String countryId = item.countryId;
            if (countryId != null) {
                countryId = countryId.toLowerCase(Locale.US);
            }
            if ((flagId = view.getResources().getIdentifier("zm_flag_" + countryId, "drawable", VideoBoxApplication.getInstance().getPackageName())) != 0) {
                imgCountryFlag.setVisibility(0);
                imgCountryFlag.setImageResource(flagId);
            } else {
                imgCountryFlag.setVisibility(4);
            }
        }

        public String getItemSortKey(Object oItem) {
            CallInNumberItem item = (CallInNumberItem)oItem;
            return item.sortKey;
        }
    }

    static class CallInNumberItemComparator
    implements Comparator<CallInNumberItem> {
        private Collator mCollator;

        public CallInNumberItemComparator(Locale locale) {
            this.mCollator = Collator.getInstance(locale);
            this.mCollator.setStrength(0);
        }

        @Override
        public int compare(CallInNumberItem lhs, CallInNumberItem rhs) {
            if (lhs == rhs) {
                return 0;
            }
            int res = this.mCollator.compare(lhs.countryName, rhs.countryName);
            return res;
        }
    }

    public static class CallInNumberItem
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String countryName = "";
        public String countryCode = "";
        public String countryId = "";
        private String sortKey;

        public CallInNumberItem(String countryName, String countryCode, String countryId) {
            if (countryName != null) {
                this.countryName = countryName;
            }
            if (countryCode != null) {
                this.countryCode = countryCode;
            }
            if (countryId != null) {
                this.countryId = countryId;
                String localeCountryName = new Locale("", countryId).getDisplayCountry();
                if (!StringUtil.isEmptyOrNull((String)localeCountryName)) {
                    this.countryName = localeCountryName;
                }
            }
            this.sortKey = SortUtil.getSortKey((String)this.countryName, (Locale)CompatUtils.getLocalDefault());
        }
    }
}

