/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.text.Editable;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.format.DateFormat;
import android.text.method.DigitsKeyListener;
import android.text.method.KeyListener;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckedTextView;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.TimePicker;
import com.google.gson.Gson;
import com.zipow.videobox.AudioOptionActivity;
import com.zipow.videobox.IMActivity;
import com.zipow.videobox.MMSelectContactsActivity;
import com.zipow.videobox.confapp.meeting.AudioOptionParcelItem;
import com.zipow.videobox.confapp.meeting.SelectAlterHostItem;
import com.zipow.videobox.fragment.EndRepeatFragment;
import com.zipow.videobox.fragment.MeetingInfoFragment;
import com.zipow.videobox.fragment.ScheduleChooseUserTypeFragment;
import com.zipow.videobox.fragment.SimpleMessageDialog;
import com.zipow.videobox.fragment.TimeZonePickerFragment;
import com.zipow.videobox.ptapp.AlterHost;
import com.zipow.videobox.ptapp.AvailableDialinCountry;
import com.zipow.videobox.ptapp.MeetingHelper;
import com.zipow.videobox.ptapp.MeetingInfo;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.PTUserProfile;
import com.zipow.videobox.util.ConfLocalHelper;
import com.zipow.videobox.util.DialogUtils;
import com.zipow.videobox.util.MeetingInvitationUtil;
import com.zipow.videobox.util.PreferenceUtil;
import com.zipow.videobox.util.TimeFormatUtil;
import com.zipow.videobox.util.ZmPtUtils;
import com.zipow.videobox.view.ScheduledMeetingItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.app.ZMFragment;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.EventTaskManager;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.ResourcesUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.TimeUtil;
import us.zoom.androidlib.util.TimeZoneUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.IZMMenuItem;
import us.zoom.androidlib.widget.WaitingDialog;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMDatePickerDialog;
import us.zoom.androidlib.widget.ZMMenuAdapter;
import us.zoom.androidlib.widget.ZMSimpleMenuItem;
import us.zoom.androidlib.widget.ZMTimePickerDialog;
import us.zoom.videomeetings.R;

public class ScheduleFragment
extends ZMDialogFragment
implements View.OnClickListener,
PTUI.IMeetingMgrListener {
    private static final String ARG_IS_EDIT_MEETING = "isEditMeeting";
    private static final String ARG_MEETING_ITEM = "meetingItem";
    private static final int REQUEST_PICK_TIME_ZONE = 2000;
    private static final int REQUEST_JOIN_USER_TYPE = 2001;
    private static final int REQUEST_ADD_CALENDAR_EVENT = 2002;
    private static final int REQUEST_UPDATE_CALENDAR_EVENT = 2003;
    public static final int REQUEST_SELECT_ALTERNATIVE_HOST = 2004;
    public static final int REQUEST_SELECT_AUDIO_OPTION = 2005;
    private static final int COLOR_DATE_TIME_INCORRECT = -65536;
    private ScrollView mScrollView;
    private TextView mTxtTitle;
    private Button mBtnBack;
    private Button mBtnSchedule;
    private CheckedTextView mChkEnableJBH;
    private CheckedTextView mChkAddToCalendar;
    private View mOptionAddToCalendar;
    private View mOptionEnableJBH;
    private View mOptionEnableCNMetting;
    private View mOptionRepeat;
    private View mOptionEndRepeat;
    private View mOptionTimeZone;
    private EditText mEdtTopic;
    private EditText mEdtPassword;
    private TextView mTxtDate;
    private TextView mTxtTimeFrom;
    private TextView mTxtTimeTo;
    private TextView mTxtRepeatType;
    private TextView mTxtEndRepeat;
    private View mOptionScheduleFor;
    private TextView mTxtScheduleFor;
    private TextView mTxtTimeZoneName;
    private View mPanelScheduleFor;
    private CheckedTextView mChkHostVideo;
    private View mOptionHostVideo;
    private CheckedTextView mChkAttendeeVideo;
    private View mOptionAttendeeVideo;
    private View mOptionJoinUserType;
    private TextView mTxtJoinUserType;
    private View mOptionOnlySignJoin;
    private CheckedTextView mChkOnlySignJoin;
    private TextView mTxtAudioOption;
    private TextView mTxtDialInDesc;
    private View mOptionAudio;
    private EditText mEdt3rdPartyAudioInfo;
    private View mOption3rdPartyAudioInfo;
    private View mOptionUsePMI;
    private CheckedTextView mChkUsePMI;
    private TextView mTxtUsePMI;
    private CheckedTextView mChkCNMeeting;
    private TextView mTvAdvancedOptions;
    private View mOptionAlterHost;
    private TextView mTvAlterHost;
    private Calendar mDateFrom;
    private Calendar mDateTo;
    private ZMDatePickerDialog mDatePickerDialog;
    private ZMTimePickerDialog mTimePickerDialog;
    private int mColorDateTimeNormal = 0;
    private ScheduledMeetingItem mMeetingItem;
    private boolean mIsEditMeeting = false;
    private AndroidAppUtil.EventRepeatType mRepeatType = AndroidAppUtil.EventRepeatType.NONE;
    private long mTimeEndRepeat = 0L;
    private boolean mDateTimeChangedByMannual = false;
    private String mScheduleForId = null;
    private String mScheduleForName = null;
    private AudioOptionParcelItem mAudioOptionParcelItem = new AudioOptionParcelItem();
    private boolean mHostVideoOn = true;
    private boolean mAttendeeVideoOn = true;
    private String mTimeZoneId;
    private String mJoinSpecifiedDomains;
    private int mJoinUserType;
    private ArrayList<AlterHost> mAlterHostList;
    private Set<String> mManualInputEmails = new HashSet<String>();
    private MeetingInfo mScheduleMeetingInfo;
    private MeetingInfo mUpdateMeetingInfo;
    private WaitingDialog mWaitingDialog;
    private RetainedFragment mRetainedFragment;

    public static void showInActivity(ZMActivity activity) {
        ScheduleFragment f = new ScheduleFragment();
        Bundle args = new Bundle();
        f.setArguments(args);
        activity.getSupportFragmentManager().beginTransaction().add(0x1020002, (Fragment)f, ScheduleFragment.class.getName()).commit();
    }

    public static void showEditMeetingInActivity(ZMActivity activity, ScheduledMeetingItem mi) {
        ScheduleFragment f = new ScheduleFragment();
        Bundle args = new Bundle();
        args.putBoolean(ARG_IS_EDIT_MEETING, true);
        args.putSerializable(ARG_MEETING_ITEM, (Serializable)mi);
        f.setArguments(args);
        activity.getSupportFragmentManager().beginTransaction().add(0x1020002, (Fragment)f, ScheduleFragment.class.getName()).commit();
    }

    public static void showDialog(FragmentManager fm) {
        if (ScheduleFragment.getScheduleFragment(fm) != null) {
            return;
        }
        ScheduleFragment f = new ScheduleFragment();
        Bundle args = new Bundle();
        f.setArguments(args);
        f.show(fm, ScheduleFragment.class.getName());
    }

    public static void showEditMeetingDialog(FragmentManager fm, ScheduledMeetingItem mi) {
        if (ScheduleFragment.getScheduleFragment(fm) != null) {
            return;
        }
        ScheduleFragment f = new ScheduleFragment();
        Bundle args = new Bundle();
        args.putBoolean(ARG_IS_EDIT_MEETING, true);
        args.putSerializable(ARG_MEETING_ITEM, (Serializable)mi);
        f.setArguments(args);
        f.show(fm, ScheduleFragment.class.getName());
    }

    public static ScheduleFragment getScheduleFragment(FragmentManager fm) {
        return (ScheduleFragment)fm.findFragmentByTag(ScheduleFragment.class.getName());
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 2000: {
                String id2;
                if (data == null || resultCode != -1 || StringUtil.isEmptyOrNull((String)(id2 = data.getStringExtra("time_zone_selected_name")))) break;
                this.mTimeZoneId = id2;
                this.setTimeZone(id2);
                this.updateUIStatus();
                break;
            }
            case 2001: {
                if (data != null && resultCode == -1) {
                    this.mJoinSpecifiedDomains = data.getStringExtra("EXTRA_SPECIFIED_DOMAINS");
                    this.mJoinUserType = data.getIntExtra("EXTRA_JOIN_USER_TYPE", 2);
                }
                this.updateJoinUserType();
                break;
            }
            case 2004: {
                if (resultCode != -1 || data == null) break;
                ArrayList abItems = (ArrayList)data.getSerializableExtra("selectedItems");
                this.mAlterHostList = ConfLocalHelper.transformIMAddrBookItemsToAlterHosts(abItems, this.mManualInputEmails);
                this.mTvAlterHost.setText((CharSequence)ConfLocalHelper.getDescAlternativeHosts(this.getContext(), this.mAlterHostList));
                this.mBtnSchedule.setEnabled(this.validateInput());
                if (this.mRetainedFragment == null) break;
                this.mRetainedFragment.saveAlterHostItems(this.mAlterHostList);
                this.mRetainedFragment.savManualInputEmails(this.mManualInputEmails);
                break;
            }
            case 2005: {
                if (resultCode != -1 || data == null) break;
                this.mAudioOptionParcelItem = (AudioOptionParcelItem)data.getParcelableExtra("RESULT_SELECT_AUDIO_OPTION_ITEM");
                this.mBtnSchedule.setEnabled(this.validateInput());
                if (this.mRetainedFragment != null) {
                    this.mRetainedFragment.saveAudioOptionParcelItem(this.mAudioOptionParcelItem);
                }
                this.updateAudioOptions();
            }
        }
    }

    public ScheduleFragment() {
        this.setStyle(1, R.style.ZMDialog_HideSoftKeyboard);
    }

    public void onStart() {
        super.onStart();
    }

    @SuppressLint(value={"NewApi"})
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_schedule, null);
        this.mScrollView = (ScrollView)view.findViewById(R.id.scrollView);
        this.mTxtTitle = (TextView)view.findViewById(R.id.txtTitle);
        this.mBtnBack = (Button)view.findViewById(R.id.btnBack);
        this.mBtnSchedule = (Button)view.findViewById(R.id.btnSchedule);
        this.mEdtTopic = (EditText)view.findViewById(R.id.edtTopic);
        this.mEdtPassword = (EditText)view.findViewById(R.id.edtPassword);
        this.mChkEnableJBH = (CheckedTextView)view.findViewById(R.id.chkEnableJBH);
        this.mChkAddToCalendar = (CheckedTextView)view.findViewById(R.id.chkAddToCalendar);
        this.mOptionAddToCalendar = view.findViewById(R.id.optionAddToCalendar);
        this.mOptionRepeat = view.findViewById(R.id.optionRepeat);
        this.mOptionEndRepeat = view.findViewById(R.id.optionEndRepeat);
        this.mTxtDate = (TextView)view.findViewById(R.id.txtDate);
        this.mTxtTimeFrom = (TextView)view.findViewById(R.id.txtTimeFrom);
        this.mTxtTimeTo = (TextView)view.findViewById(R.id.txtTimeTo);
        this.mTxtRepeatType = (TextView)view.findViewById(R.id.txtRepeatType);
        this.mTxtEndRepeat = (TextView)view.findViewById(R.id.txtEndRepeat);
        this.mOptionScheduleFor = view.findViewById(R.id.optionScheduleFor);
        this.mTxtScheduleFor = (TextView)view.findViewById(R.id.txtScheduleFor);
        this.mPanelScheduleFor = view.findViewById(R.id.panelScheduleFor);
        this.mOptionEnableJBH = view.findViewById(R.id.optionEnableJBH);
        this.mOptionEnableCNMetting = view.findViewById(R.id.optionEnableCNMeeting);
        this.mChkHostVideo = (CheckedTextView)view.findViewById(R.id.chkHostVideo);
        this.mOptionHostVideo = view.findViewById(R.id.optionHostVideo);
        this.mChkAttendeeVideo = (CheckedTextView)view.findViewById(R.id.chkAttendeeVideo);
        this.mOptionAttendeeVideo = view.findViewById(R.id.optionAttendeeVideo);
        this.mTxtAudioOption = (TextView)view.findViewById(R.id.txtAudioOption);
        this.mTxtDialInDesc = (TextView)view.findViewById(R.id.txtDialInDesc);
        this.mOptionAudio = view.findViewById(R.id.optionAudio);
        this.mEdt3rdPartyAudioInfo = (EditText)view.findViewById(R.id.edt3rdPartyAudioInfo);
        this.mOption3rdPartyAudioInfo = view.findViewById(R.id.option3rdPartyAudioInfo);
        this.mOptionUsePMI = view.findViewById(R.id.optionUsePMI);
        this.mChkUsePMI = (CheckedTextView)view.findViewById(R.id.chkUsePMI);
        this.mTxtUsePMI = (TextView)view.findViewById(R.id.txtUsePMI);
        this.mChkCNMeeting = (CheckedTextView)view.findViewById(R.id.chkEnableCNMeeting);
        this.mOptionTimeZone = view.findViewById(R.id.optionTimeZone);
        this.mTxtTimeZoneName = (TextView)view.findViewById(R.id.txtTimeZone);
        this.mOptionJoinUserType = view.findViewById(R.id.optionJoinUserType);
        this.mTxtJoinUserType = (TextView)view.findViewById(R.id.txtJoinUserType);
        this.mChkOnlySignJoin = (CheckedTextView)view.findViewById(R.id.chkOnlySignJoin);
        this.mOptionOnlySignJoin = view.findViewById(R.id.optionOnlySignJoin);
        this.mTvAdvancedOptions = (TextView)view.findViewById(R.id.tvAdvancedOptions);
        this.mOptionAlterHost = view.findViewById(R.id.optionAlterHost);
        this.mTvAlterHost = (TextView)view.findViewById(R.id.txtAlterHost);
        this.hideAdvancedOptions();
        View optionDate = view.findViewById(R.id.optionDate);
        View optionTimeFrom = view.findViewById(R.id.optionTimeFrom);
        View optionTimeTo = view.findViewById(R.id.optionTimeTo);
        this.mColorDateTimeNormal = this.mTxtDate.getTextColors().getDefaultColor();
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        this.mBtnSchedule.setOnClickListener((View.OnClickListener)this);
        optionDate.setOnClickListener((View.OnClickListener)this);
        optionTimeFrom.setOnClickListener((View.OnClickListener)this);
        optionTimeTo.setOnClickListener((View.OnClickListener)this);
        this.mOptionEnableJBH.setOnClickListener((View.OnClickListener)this);
        this.mOptionAddToCalendar.setOnClickListener((View.OnClickListener)this);
        this.mOptionRepeat.setOnClickListener((View.OnClickListener)this);
        this.mOptionEndRepeat.setOnClickListener((View.OnClickListener)this);
        this.mOptionScheduleFor.setOnClickListener((View.OnClickListener)this);
        this.mOptionHostVideo.setOnClickListener((View.OnClickListener)this);
        this.mOptionAttendeeVideo.setOnClickListener((View.OnClickListener)this);
        this.mOptionAudio.setOnClickListener((View.OnClickListener)this);
        this.mOptionUsePMI.setOnClickListener((View.OnClickListener)this);
        this.mOptionEnableCNMetting.setOnClickListener((View.OnClickListener)this);
        this.mOptionTimeZone.setOnClickListener((View.OnClickListener)this);
        this.mOptionOnlySignJoin.setOnClickListener((View.OnClickListener)this);
        this.mOptionJoinUserType.setOnClickListener((View.OnClickListener)this);
        this.mTvAdvancedOptions.setOnClickListener((View.OnClickListener)this);
        this.mOptionAlterHost.setOnClickListener((View.OnClickListener)this);
        Date timeFrom = new Date(System.currentTimeMillis() + 3600000L);
        Date timeTo = new Date(System.currentTimeMillis() + 0x6DDD00L);
        this.mDateFrom = Calendar.getInstance();
        this.mDateFrom.setTime(timeFrom);
        this.mDateFrom.set(12, 0);
        this.mDateFrom.set(13, 0);
        this.mDateTo = Calendar.getInstance();
        this.mDateTo.setTime(timeTo);
        this.mDateTo.set(12, 0);
        this.mDateTo.set(13, 0);
        TextWatcher inputWatcher = new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                ScheduleFragment.this.mBtnSchedule.setEnabled(ScheduleFragment.this.validateInput());
            }
        };
        this.mEdtTopic.addTextChangedListener(inputWatcher);
        this.mEdtPassword.setKeyListener((KeyListener)new PasswordKeyListener());
        this.mEdtPassword.addTextChangedListener(inputWatcher);
        this.mEdt3rdPartyAudioInfo.addTextChangedListener(inputWatcher);
        this.initViewData(savedInstanceState);
        if (Build.VERSION.SDK_INT >= 11) {
            this.mTxtJoinUserType.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

                public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    ScheduleFragment.this.updateJoinUserType();
                }
            });
        }
        this.initRetainedFragment();
        return view;
    }

    private void initViewData(Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            String name = PTApp.getInstance().getMyName();
            String topic = name.endsWith("s") ? this.getString(R.string.zm_lbl_xxx_s_meeting_no_s, new Object[]{name}) : this.getString(R.string.zm_lbl_xxx_s_meeting_s, new Object[]{name});
            this.mEdtTopic.setText((CharSequence)topic);
        }
        this.mTimeZoneId = TimeZone.getDefault().getID();
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        if (profile == null) {
            return;
        }
        AvailableDialinCountry availableDialinCountry = profile.getAvailableDiallinCountry();
        if (availableDialinCountry != null) {
            this.mAudioOptionParcelItem.setHash(availableDialinCountry.getHash());
            this.mAudioOptionParcelItem.setmAllDialInCountries(availableDialinCountry.getAllCountriesList());
            this.mAudioOptionParcelItem.setmSelectedDialInCountries(availableDialinCountry.getSelectedCountriesList());
        }
        Bundle args = this.getArguments();
        this.mIsEditMeeting = args.getBoolean(ARG_IS_EDIT_MEETING);
        this.mMeetingItem = (ScheduledMeetingItem)args.getSerializable(ARG_MEETING_ITEM);
        boolean cnMeetingOn = PTApp.getInstance().isCNMeetingON();
        if (this.mMeetingItem != null) {
            ScheduledMeetingItem meetingForOptions = this.mMeetingItem;
            if (this.mMeetingItem.isUsePmiAsMeetingID() && (meetingForOptions = this.getPMIMeetingItem()) == null) {
                meetingForOptions = this.mMeetingItem;
            }
            this.mEdtTopic.setText((CharSequence)this.mMeetingItem.getTopic());
            this.mEdtPassword.setText((CharSequence)meetingForOptions.getPassword());
            this.mChkEnableJBH.setChecked(meetingForOptions.getCanJoinBeforeHost());
            this.mChkUsePMI.setChecked(this.mMeetingItem.isUsePmiAsMeetingID());
            this.mChkOnlySignJoin.setChecked(meetingForOptions.isOnlySignJoin());
            if (cnMeetingOn) {
                this.mChkCNMeeting.setChecked(this.mMeetingItem.isCnMeetingOn());
            }
            if (this.mMeetingItem.isRecurring()) {
                this.mRepeatType = ScheduledMeetingItem.zoomRepeatTypeToNativeRepeatType(this.mMeetingItem.getRepeatType());
                this.mTimeEndRepeat = this.mMeetingItem.getRepeatEndTime();
            } else {
                this.mOptionEndRepeat.setVisibility(8);
            }
            this.mDateFrom.setTimeInMillis(this.mMeetingItem.getStartTime());
            this.mDateTo.setTimeInMillis(this.mMeetingItem.getStartTime() + (long)(this.mMeetingItem.getDuration() * 60000));
            this.mTimeZoneId = this.mMeetingItem.getTimeZoneId();
            this.mScheduleForId = this.mMeetingItem.getHostId();
            this.mScheduleForName = this.mMeetingItem.getHostName();
            this.mHostVideoOn = !meetingForOptions.isHostVideoOff();
            this.mAttendeeVideoOn = !meetingForOptions.isAttendeeVideoOff();
            this.mAudioOptionParcelItem.setmSelectedAudioType(ZmPtUtils.getMeetingDefaultAudioOption(profile, meetingForOptions));
            if (meetingForOptions.isOnlySignJoin()) {
                String domains = meetingForOptions.getSpecialDomains();
                if (!TextUtils.isEmpty((CharSequence)domains)) {
                    this.mJoinUserType = 3;
                    this.mJoinSpecifiedDomains = domains;
                } else {
                    this.mJoinUserType = 2;
                }
            } else {
                this.mJoinUserType = 1;
            }
            MeetingInfo meetingInfoProto = PTApp.getInstance().getMeetingHelper().getMeetingItemByNumber(this.mMeetingItem.getMeetingNo());
            if (meetingInfoProto != null) {
                availableDialinCountry = meetingInfoProto.getAvailableDialinCountry();
                if (availableDialinCountry != null) {
                    this.mAudioOptionParcelItem.setIncludeTollFree(availableDialinCountry.getIncludedTollfree());
                    if (!CollectionsUtil.isCollectionEmpty(availableDialinCountry.getSelectedCountriesList())) {
                        this.mAudioOptionParcelItem.setmSelectedDialInCountries(availableDialinCountry.getSelectedCountriesList());
                    }
                }
                this.mAlterHostList = meetingInfoProto.getAlterHostList();
            }
        } else {
            boolean usePmi = PreferenceUtil.readBooleanValue("schedule_opt.use_pmi", false);
            ScheduledMeetingItem pmiMeetingItem = this.getPMIMeetingItem();
            this.mChkUsePMI.setChecked(usePmi);
            if (availableDialinCountry != null) {
                this.mAudioOptionParcelItem.setIncludeTollFree(availableDialinCountry.getIncludedTollfree());
                this.mAudioOptionParcelItem.setmSelectedDialInCountries(availableDialinCountry.getSelectedCountriesList());
            }
            if (usePmi && pmiMeetingItem != null) {
                this.mEdtPassword.setText((CharSequence)pmiMeetingItem.getPassword());
                this.mChkEnableJBH.setChecked(pmiMeetingItem.getCanJoinBeforeHost());
                this.mHostVideoOn = !pmiMeetingItem.isHostVideoOff();
                this.mAttendeeVideoOn = !pmiMeetingItem.isAttendeeVideoOff();
                this.mAudioOptionParcelItem.setmSelectedAudioType(ZmPtUtils.getMeetingDefaultAudioOption(profile, pmiMeetingItem));
                if (cnMeetingOn) {
                    this.mChkCNMeeting.setChecked(pmiMeetingItem.isCnMeetingOn());
                }
                this.mDateFrom.setTimeInMillis(pmiMeetingItem.getStartTime());
                this.mDateTo.setTimeInMillis(pmiMeetingItem.getStartTime() + (long)(pmiMeetingItem.getDuration() * 60000));
                this.mTimeZoneId = pmiMeetingItem.getTimeZoneId();
                this.mChkOnlySignJoin.setChecked(pmiMeetingItem.isOnlySignJoin());
                if (pmiMeetingItem.isOnlySignJoin()) {
                    String domains = pmiMeetingItem.getSpecialDomains();
                    if (!TextUtils.isEmpty((CharSequence)domains)) {
                        this.mJoinUserType = 3;
                        this.mJoinSpecifiedDomains = domains;
                    } else {
                        this.mJoinUserType = 2;
                    }
                } else {
                    this.mJoinUserType = 1;
                }
            } else {
                if (profile.alwaysPreFillRandomPassword()) {
                    this.mEdtPassword.setText((CharSequence)profile.getRandomPassword());
                }
                this.mHostVideoOn = profile.alwaysTurnOnHostVideoByDefault() ? true : PreferenceUtil.readBooleanValue("schedule_opt.host_video_on", true);
                this.mAttendeeVideoOn = profile.alwaysTurnOnAttendeeVideoByDefault() ? true : PreferenceUtil.readBooleanValue("schedule_opt.attendee_video_on", true);
                if (profile.alwaysEnableJoinBeforeHostByDefault()) {
                    this.mChkEnableJBH.setChecked(true);
                } else {
                    this.mChkEnableJBH.setChecked(PreferenceUtil.readBooleanValue("schedule_opt.jbh", true));
                }
                this.mAudioOptionParcelItem.setmSelectedAudioType(ZmPtUtils.getDefaultAudioOption(profile));
                boolean isOnlySignJoin = PTApp.getInstance().isSignedInUserMeetingOn();
                boolean isSpecifiedDomains = PTApp.getInstance().isSpecifiedDomainsMeetingOn();
                boolean isLastSpecifiedDomains = PreferenceUtil.readBooleanValue("schedule_opt.is_specified_domains", isSpecifiedDomains);
                if (profile.enforceJoinLoginSpecifiedDomainsDefaultOn() || isSpecifiedDomains != isLastSpecifiedDomains) {
                    if (isSpecifiedDomains) {
                        String domains = profile.getRestrictJoinUserDomains();
                        if (!StringUtil.isEmptyOrNull((String)domains)) {
                            this.mJoinUserType = 3;
                            this.mJoinSpecifiedDomains = domains;
                        } else {
                            this.mJoinUserType = 2;
                        }
                        this.mChkOnlySignJoin.setChecked(true);
                    } else {
                        this.mChkOnlySignJoin.setChecked(isOnlySignJoin);
                        this.mJoinUserType = 1;
                    }
                } else if (isSpecifiedDomains) {
                    String domains = profile.getRestrictJoinUserDomains();
                    this.mJoinSpecifiedDomains = PreferenceUtil.readStringValue("schedule_opt.specified_domains", domains);
                    this.mJoinUserType = !StringUtil.isEmptyOrNull((String)this.mJoinSpecifiedDomains) ? 3 : 2;
                    this.mChkOnlySignJoin.setChecked(true);
                } else {
                    isOnlySignJoin = PreferenceUtil.readBooleanValue("schedule_opt.only_signin_join", isOnlySignJoin);
                    this.mChkOnlySignJoin.setChecked(isOnlySignJoin);
                    this.mJoinUserType = 1;
                }
                if (cnMeetingOn) {
                    this.mChkCNMeeting.setChecked(PreferenceUtil.readBooleanValue("schedule_opt.cn_meeting", false));
                }
            }
        }
        this.mChkAddToCalendar.setChecked(PreferenceUtil.readBooleanValue("schedule_opt.add_to_caclendar", true));
        if (this.mIsEditMeeting) {
            this.mTxtTitle.setText(R.string.zm_title_edit_meeting);
            this.mBtnSchedule.setText(R.string.zm_btn_done);
        }
        this.mEdtTopic.setSelection(this.mEdtTopic.getText().length(), this.mEdtTopic.getText().length());
        this.mEdtPassword.setSelection(this.mEdtPassword.getText().length(), this.mEdtPassword.getText().length());
        if (savedInstanceState != null) {
            this.mRepeatType = (AndroidAppUtil.EventRepeatType)savedInstanceState.getSerializable("mRepeatType");
            this.mTimeEndRepeat = savedInstanceState.getLong("mTimeEndRepeat");
            this.mDateTimeChangedByMannual = savedInstanceState.getBoolean("mDateTimeChangedByMannual");
            this.mDateFrom = (Calendar)savedInstanceState.getSerializable("mDateFrom");
            this.mDateTo = (Calendar)savedInstanceState.getSerializable("mDateTo");
            this.mTimeZoneId = savedInstanceState.getString("mTimeZoneId");
            this.mChkEnableJBH.setChecked(savedInstanceState.getBoolean("enableJBH"));
            this.mChkAddToCalendar.setChecked(savedInstanceState.getBoolean("addToCalendar"));
            this.mChkUsePMI.setChecked(savedInstanceState.getBoolean("usePMI"));
            this.mChkCNMeeting.setChecked(savedInstanceState.getBoolean("cnMeeting"));
            this.mChkOnlySignJoin.setChecked(savedInstanceState.getBoolean("mOnlySpecifiedDomainsJoin"));
            this.mScheduleForId = savedInstanceState.getString("mScheduleForId");
            this.mScheduleForName = savedInstanceState.getString("mScheduleForName");
            this.mHostVideoOn = savedInstanceState.getBoolean("mHostVideoOn");
            this.mAttendeeVideoOn = savedInstanceState.getBoolean("mAttendeeVideoOn");
            this.mAudioOptionParcelItem = (AudioOptionParcelItem)savedInstanceState.getParcelable("mAudioOptionParcelItem");
            this.mJoinUserType = savedInstanceState.getInt("mJoinUserType");
            this.mJoinSpecifiedDomains = savedInstanceState.getString("mJoinSpecifiedDomains");
        }
        TimeZone timezone = TimeZoneUtil.getTimeZoneById((String)this.mTimeZoneId);
        this.mDateFrom.setTimeZone(timezone);
        this.mDateTo.setTimeZone(timezone);
        this.mTxtTimeZoneName.setText((CharSequence)TimeZoneUtil.getFullName((String)this.mTimeZoneId));
        this.updateUIStatus();
        this.mBtnSchedule.setEnabled(this.validateInput());
        this.updatePasswordHint();
    }

    private ScheduledMeetingItem getPMIMeetingItem() {
        MeetingHelper meetingHelper = PTApp.getInstance().getMeetingHelper();
        if (meetingHelper == null) {
            return null;
        }
        MeetingInfo info = meetingHelper.getPmiMeetingItem();
        if (info == null) {
            return null;
        }
        return ScheduledMeetingItem.fromMeetingInfo(info);
    }

    private Date getBeginTime() {
        Date date = this.mDateFrom.getTime();
        date.setSeconds(0);
        return date;
    }

    private int getDurationInMinutes() {
        this.checkEndTime();
        return (int)((this.mDateTo.getTimeInMillis() - this.mDateFrom.getTimeInMillis()) / 60000L);
    }

    private String getTopic() {
        return this.mEdtTopic.getText().toString();
    }

    private boolean getIsRecurringMeeting() {
        return this.mRepeatType != AndroidAppUtil.EventRepeatType.NONE;
    }

    private String getPassword() {
        return this.mEdtPassword.getText().toString();
    }

    public void onResume() {
        super.onResume();
        this.updateUIStatus();
        PTUI.getInstance().addMeetingMgrListener(this);
    }

    public void onPause() {
        super.onPause();
        PTUI.getInstance().removeMeetingMgrListener(this);
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putSerializable("mRepeatType", (Serializable)this.mRepeatType);
        outState.putLong("mTimeEndRepeat", this.mTimeEndRepeat);
        outState.putBoolean("mDateTimeChangedByMannual", this.mDateTimeChangedByMannual);
        outState.putSerializable("mDateFrom", (Serializable)this.mDateFrom);
        outState.putSerializable("mDateTo", (Serializable)this.mDateTo);
        outState.putBoolean("enableJBH", this.mChkEnableJBH.isChecked());
        outState.putBoolean("cnMeeting", this.mChkCNMeeting.isChecked());
        outState.putBoolean("addToCalendar", this.mChkAddToCalendar.isChecked());
        outState.putBoolean("usePMI", this.mChkUsePMI.isChecked());
        outState.putString("mScheduleForId", this.mScheduleForId);
        outState.putString("mScheduleForName", this.mScheduleForName);
        outState.putBoolean("mHostVideoOn", this.mHostVideoOn);
        outState.putBoolean("mAttendeeVideoOn", this.mAttendeeVideoOn);
        outState.putParcelable("mAudioOptionParcelItem", (Parcelable)this.mAudioOptionParcelItem);
        outState.putString("mTimeZoneId", this.mTimeZoneId);
        outState.putBoolean("mOnlySignJoin", this.mChkOnlySignJoin.isChecked());
        outState.putInt("mJoinUserType", this.mJoinUserType);
        outState.putString("mJoinSpecifiedDomains", this.mJoinSpecifiedDomains);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        } else if (id2 == R.id.optionDate) {
            this.onClickBtnDate();
        } else if (id2 == R.id.optionTimeFrom) {
            this.onClickBtnTimeFrom();
        } else if (id2 == R.id.optionTimeTo) {
            this.onClickBtnTimeTo();
        } else if (id2 == R.id.btnSchedule) {
            this.onClickBtnSchedule();
        } else if (id2 == R.id.optionEnableJBH) {
            this.onClickEnableJBH();
        } else if (id2 == R.id.optionUsePMI) {
            this.onClickUsePMI();
        } else if (id2 == R.id.optionAddToCalendar) {
            this.onClickChkAddToCalendar();
        } else if (id2 == R.id.optionRepeat) {
            this.onClickRepeat();
        } else if (id2 == R.id.optionEndRepeat) {
            this.onClickEndRepeat();
        } else if (id2 == R.id.optionScheduleFor) {
            this.onClickScheduleFor();
        } else if (id2 == R.id.optionHostVideo) {
            this.onClickChkHostVideo();
        } else if (id2 == R.id.optionAttendeeVideo) {
            this.onClickChkAttendeeVideo();
        } else if (id2 == R.id.optionAudio) {
            this.onClickOptionAudio();
        } else if (id2 == R.id.optionEnableCNMeeting) {
            this.onClickEnableCnMeeting();
        } else if (id2 == R.id.optionTimeZone) {
            this.onClickPickTimeZone();
        } else if (id2 == R.id.optionOnlySignJoin) {
            this.onClickOnlySignJoin();
        } else if (id2 == R.id.optionJoinUserType) {
            this.onClickOptionJoinUserType();
        } else if (id2 == R.id.tvAdvancedOptions) {
            this.showAdvancedOptions();
        } else if (id2 == R.id.optionAlterHost) {
            this.onClickOptionAlterHost();
        }
    }

    private void onClickOptionJoinUserType() {
        ScheduleChooseUserTypeFragment.showInActivity((Fragment)this, 2001, this.mJoinUserType, this.mJoinSpecifiedDomains);
    }

    private void onClickEndRepeat() {
        Date time;
        if (this.mTimeEndRepeat > 0L) {
            time = new Date(this.mTimeEndRepeat);
        } else {
            time = this.getBeginTime();
            switch (this.mRepeatType) {
                case DAILY: 
                case WORKDAY: {
                    time.setTime(time.getTime() + 864000000L);
                    break;
                }
                case WEEKLY: {
                    time.setTime(time.getTime() + 604800000L);
                    break;
                }
                case BIWEEKLY: {
                    time.setTime(time.getTime() + 1209600000L);
                    break;
                }
                case MONTHLY: {
                    int month = time.getMonth();
                    if (month < 11) {
                        time.setMonth(month + 1);
                        break;
                    }
                    time.setYear(time.getYear() + 1);
                    break;
                }
                case YEARLY: {
                    time.setYear(time.getYear() + 1);
                }
            }
        }
        EndRepeatFragment.showDialog(this.getChildFragmentManager(), time);
    }

    public void onSelectEndRepeat(Date endRepeat) {
        this.mTimeEndRepeat = endRepeat.getTime();
        this.updateUIStatus();
    }

    private void onClickRepeat() {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        final ZMMenuAdapter menuAdapter = new ZMMenuAdapter((Context)activity, false);
        ReportOptionMenuItem item = new ReportOptionMenuItem(AndroidAppUtil.EventRepeatType.NONE, this.getString(R.string.zm_lbl_repeat_never_in_list), this.mRepeatType == AndroidAppUtil.EventRepeatType.NONE);
        menuAdapter.addItem((IZMMenuItem)item);
        item = new ReportOptionMenuItem(AndroidAppUtil.EventRepeatType.DAILY, this.getString(R.string.zm_lbl_repeat_daily_in_list), this.mRepeatType == AndroidAppUtil.EventRepeatType.DAILY);
        menuAdapter.addItem((IZMMenuItem)item);
        item = new ReportOptionMenuItem(AndroidAppUtil.EventRepeatType.WEEKLY, this.getString(R.string.zm_lbl_repeat_weekly_in_list), this.mRepeatType == AndroidAppUtil.EventRepeatType.WEEKLY);
        menuAdapter.addItem((IZMMenuItem)item);
        item = new ReportOptionMenuItem(AndroidAppUtil.EventRepeatType.BIWEEKLY, this.getString(R.string.zm_lbl_repeat_biweekly_in_list), this.mRepeatType == AndroidAppUtil.EventRepeatType.BIWEEKLY);
        menuAdapter.addItem((IZMMenuItem)item);
        item = new ReportOptionMenuItem(AndroidAppUtil.EventRepeatType.MONTHLY, this.getString(R.string.zm_lbl_repeat_monthly_in_list), this.mRepeatType == AndroidAppUtil.EventRepeatType.MONTHLY);
        menuAdapter.addItem((IZMMenuItem)item);
        item = new ReportOptionMenuItem(AndroidAppUtil.EventRepeatType.YEARLY, this.getString(R.string.zm_lbl_repeat_yearly_in_list), this.mRepeatType == AndroidAppUtil.EventRepeatType.YEARLY);
        menuAdapter.addItem((IZMMenuItem)item);
        menuAdapter.setShowSelectedStatus(true);
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)activity).setTitle(R.string.zm_lbl_repeat).setAdapter((ListAdapter)menuAdapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ReportOptionMenuItem mi = (ReportOptionMenuItem)((Object)menuAdapter.getItem(which));
                ScheduleFragment.this.onSelectRepeatOptionMenuItem(mi);
            }
        }).create();
        dialog.setCanceledOnTouchOutside(true);
        dialog.show();
    }

    private void onSelectRepeatOptionMenuItem(ReportOptionMenuItem item) {
        if (item == null) {
            return;
        }
        AndroidAppUtil.EventRepeatType type = item.getItemType();
        if (type == null) {
            return;
        }
        this.onSelectRepeatType(type);
    }

    private void onClickBtnDate() {
        if (this.mDatePickerDialog != null || this.mTimePickerDialog != null) {
            return;
        }
        this.mDatePickerDialog = new ZMDatePickerDialog((Context)this.getActivity(), new ZMDatePickerDialog.OnDateSetListener(){

            public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
                ScheduleFragment.this.mDatePickerDialog = null;
                ScheduleFragment.this.mDateFrom.set(1, year);
                ScheduleFragment.this.mDateFrom.set(2, monthOfYear);
                ScheduleFragment.this.mDateFrom.set(5, dayOfMonth);
                ScheduleFragment.this.mDateTo.set(1, year);
                ScheduleFragment.this.mDateTo.set(2, monthOfYear);
                ScheduleFragment.this.mDateTo.set(5, dayOfMonth);
                ScheduleFragment.this.mDateTimeChangedByMannual = true;
                ScheduleFragment.this.mBtnSchedule.setEnabled(ScheduleFragment.this.validateInput());
                ScheduleFragment.this.mTxtDate.setText((CharSequence)TimeUtil.formatDate((Context)ScheduleFragment.this.getActivity(), (Calendar)ScheduleFragment.this.mDateFrom));
            }
        }, this.mDateFrom.get(1), this.mDateFrom.get(2), this.mDateFrom.get(5));
        this.mDatePickerDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                ScheduleFragment.this.mDatePickerDialog = null;
            }
        });
        this.mDatePickerDialog.show();
    }

    private void onClickBtnTimeFrom() {
        if (this.mDatePickerDialog != null || this.mTimePickerDialog != null) {
            return;
        }
        this.mTimePickerDialog = new ZMTimePickerDialog((Context)this.getActivity(), new ZMTimePickerDialog.OnTimeSetListener(){

            public void onTimeSet(TimePicker view, int hourOfDay, int minute) {
                ScheduleFragment.this.mTimePickerDialog = null;
                ScheduleFragment.this.mDateFrom.set(11, hourOfDay);
                ScheduleFragment.this.mDateFrom.set(12, minute);
                ScheduleFragment.this.mDateTimeChangedByMannual = true;
                ScheduleFragment.this.mBtnSchedule.setEnabled(ScheduleFragment.this.validateInput());
                ScheduleFragment.this.mTxtTimeFrom.setText((CharSequence)TimeUtil.formatTime((Context)ScheduleFragment.this.getActivity(), (Calendar)ScheduleFragment.this.mDateFrom));
            }
        }, this.mDateFrom.get(11), this.mDateFrom.get(12), DateFormat.is24HourFormat((Context)this.getActivity()));
        this.mTimePickerDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                ScheduleFragment.this.mTimePickerDialog = null;
            }
        });
        this.mTimePickerDialog.show();
    }

    private void setTimeZone(String timezoneId) {
        if (StringUtil.isEmptyOrNull((String)timezoneId)) {
            return;
        }
        TimeZone timezone = TimeZone.getTimeZone(timezoneId);
        this.mDateFrom.setTimeZone(timezone);
        this.mDateTo.setTimeZone(timezone);
    }

    private void checkEndTime() {
        int year = this.mDateFrom.get(1);
        int month = this.mDateFrom.get(2);
        int date = this.mDateFrom.get(5);
        this.mDateTo.set(1, year);
        this.mDateTo.set(2, month);
        this.mDateTo.set(5, date);
        if (this.mDateTo.after(this.mDateFrom)) {
            return;
        }
        this.mDateTo.add(5, 1);
    }

    private void onClickBtnTimeTo() {
        if (this.mDatePickerDialog != null || this.mTimePickerDialog != null) {
            return;
        }
        this.mTimePickerDialog = new ZMTimePickerDialog((Context)this.getActivity(), new ZMTimePickerDialog.OnTimeSetListener(){

            public void onTimeSet(TimePicker view, int hourOfDay, int minute) {
                ScheduleFragment.this.mTimePickerDialog = null;
                ScheduleFragment.this.mDateTo.set(11, hourOfDay);
                ScheduleFragment.this.mDateTo.set(12, minute);
                ScheduleFragment.this.mDateTimeChangedByMannual = true;
                ScheduleFragment.this.mBtnSchedule.setEnabled(ScheduleFragment.this.validateInput());
                ScheduleFragment.this.mTxtTimeTo.setText((CharSequence)TimeUtil.formatTime((Context)ScheduleFragment.this.getActivity(), (Calendar)ScheduleFragment.this.mDateTo));
            }
        }, this.mDateTo.get(11), this.mDateTo.get(12), DateFormat.is24HourFormat((Context)this.getActivity()));
        this.mTimePickerDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                ScheduleFragment.this.mTimePickerDialog = null;
            }
        });
        this.mTimePickerDialog.show();
    }

    private void onClickEnableJBH() {
        this.mChkEnableJBH.setChecked(!this.mChkEnableJBH.isChecked());
        this.updatePasswordHint();
    }

    private void onClickUsePMI() {
        this.mChkUsePMI.setChecked(!this.mChkUsePMI.isChecked());
        this.updatePasswordHint();
    }

    private void onClickEnableCnMeeting() {
        this.mChkCNMeeting.setChecked(!this.mChkCNMeeting.isChecked());
    }

    private void onClickPickTimeZone() {
        TimeZonePickerFragment.show((Fragment)this, null, 2000);
    }

    private void onClickChkAddToCalendar() {
        this.mChkAddToCalendar.setChecked(!this.mChkAddToCalendar.isChecked());
    }

    private void onClickOnlySignJoin() {
        this.mChkOnlySignJoin.setChecked(!this.mChkOnlySignJoin.isChecked());
    }

    private void onClickChkHostVideo() {
        this.mChkHostVideo.setChecked(!this.mChkHostVideo.isChecked());
        this.mHostVideoOn = this.mChkHostVideo.isChecked();
    }

    private void onClickChkAttendeeVideo() {
        this.mChkAttendeeVideo.setChecked(!this.mChkAttendeeVideo.isChecked());
        this.mAttendeeVideoOn = this.mChkAttendeeVideo.isChecked();
    }

    private void onClickOptionAudio() {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        if (profile == null) {
            return;
        }
        AudioOptionActivity.show((Fragment)this, 2005, this.mAudioOptionParcelItem);
    }

    private void onClickScheduleFor() {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        final ZMMenuAdapter menuAdapter = new ZMMenuAdapter((Context)activity, false);
        ScheduleForMenuItem item = new ScheduleForMenuItem(0, activity.getString(R.string.zm_lbl_schedule_for_myself), null);
        menuAdapter.addItem((IZMMenuItem)item);
        PTApp ptApp = PTApp.getInstance();
        int count = ptApp.getAltHostCount();
        for (int i = 0; i < count; ++i) {
            AlterHost host = ptApp.getAltHostAt(i);
            if (host == null) continue;
            item = new ScheduleForMenuItem(1, StringUtil.formatPersonName((String)host.getFirstName(), (String)host.getLastName(), (String)PTApp.getInstance().getRegionCodeForNameFormating()), host.getHostID());
            menuAdapter.addItem((IZMMenuItem)item);
        }
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)activity).setTitle(R.string.zm_lbl_schedule_for).setAdapter((ListAdapter)menuAdapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ScheduleForMenuItem mi = (ScheduleForMenuItem)((Object)menuAdapter.getItem(which));
                ScheduleFragment.this.onSelectScheduleForMenuItem(mi);
            }
        }).create();
        dialog.setCanceledOnTouchOutside(true);
        dialog.show();
    }

    private void onSelectScheduleForMenuItem(ScheduleForMenuItem mi) {
        if (this.isPMIEnabled() && mi.getAction() == 0) {
            this.mScheduleForId = null;
            this.mScheduleForName = null;
            this.mTxtScheduleFor.setText(R.string.zm_lbl_schedule_for_myself);
            this.mOptionUsePMI.setVisibility(0);
        } else {
            this.mScheduleForId = mi.getAltHostId();
            this.mScheduleForName = mi.getLabel();
            this.mTxtScheduleFor.setText((CharSequence)this.mScheduleForName);
            this.mOptionUsePMI.setVisibility(8);
        }
    }

    private void updateUIStatus() {
        this.mTxtDate.setText((CharSequence)TimeUtil.formatDate((Context)this.getActivity(), (Calendar)this.mDateFrom));
        this.mTxtTimeFrom.setText((CharSequence)TimeUtil.formatTime((Context)this.getActivity(), (Calendar)this.mDateFrom));
        this.mTxtTimeTo.setText((CharSequence)TimeUtil.formatTime((Context)this.getActivity(), (Calendar)this.mDateTo));
        this.mTxtTimeZoneName.setText((CharSequence)TimeZoneUtil.getFullName((String)this.mTimeZoneId));
        this.mOptionEndRepeat.setVisibility(this.getIsRecurringMeeting() ? 0 : 8);
        if (this.mTimeEndRepeat > 0L) {
            this.mTxtEndRepeat.setText((CharSequence)TimeFormatUtil.formatDate((Context)this.getActivity(), this.mTimeEndRepeat, true));
        } else {
            this.mTxtEndRepeat.setText(R.string.zm_lbl_end_repeat_never);
        }
        switch (this.mRepeatType) {
            case DAILY: 
            case WORKDAY: {
                this.mTxtRepeatType.setText(R.string.zm_lbl_repeat_daily);
                break;
            }
            case WEEKLY: {
                this.mTxtRepeatType.setText(R.string.zm_lbl_repeat_weekly);
                break;
            }
            case BIWEEKLY: {
                this.mTxtRepeatType.setText(R.string.zm_lbl_repeat_biweekly);
                break;
            }
            case MONTHLY: {
                this.mTxtRepeatType.setText(R.string.zm_lbl_repeat_monthly);
                break;
            }
            case YEARLY: {
                this.mTxtRepeatType.setText(R.string.zm_lbl_repeat_yearly);
                break;
            }
            case NONE: {
                this.mTxtRepeatType.setText(R.string.zm_lbl_repeat_never);
            }
        }
        if (this.mScheduleForName != null && !StringUtil.isSameString((String)this.getMyZoomId(), (String)this.mScheduleForId)) {
            this.mTxtScheduleFor.setText((CharSequence)this.mScheduleForName);
        } else {
            this.mTxtScheduleFor.setText(R.string.zm_lbl_schedule_for_myself);
        }
        long pmi = this.getPMINumber();
        String sMeetingNo = String.valueOf(pmi);
        int iFormat = 0;
        if (sMeetingNo.length() > 10) {
            iFormat = ResourcesUtil.getInteger((Context)this.getActivity(), (int)R.integer.zm_config_long_meeting_id_format_type, (int)iFormat);
        }
        String sPmi = StringUtil.formatConfNumber((long)pmi, (int)iFormat);
        this.mTxtUsePMI.setText((CharSequence)sPmi);
        this.mChkUsePMI.setContentDescription((CharSequence)this.getString(R.string.zm_chk_schedule_use_pmi, new Object[]{sPmi}));
        if (PTApp.getInstance().getAltHostCount() <= 0) {
            this.mPanelScheduleFor.setVisibility(8);
        } else {
            this.mOptionScheduleFor.setEnabled(!this.mIsEditMeeting);
        }
        this.updateVideoOptions();
        this.updateAudioOptions();
        this.updateJoinUserType();
        if (this.isPMIEnabled() && (StringUtil.isEmptyOrNull((String)this.mScheduleForId) || StringUtil.isSameString((String)this.getMyZoomId(), (String)this.mScheduleForId))) {
            this.mOptionUsePMI.setVisibility(0);
        } else {
            this.mOptionUsePMI.setVisibility(8);
        }
        this.mBtnSchedule.setEnabled(this.validateInput());
    }

    private void updateJoinUserType() {
        if (this.mJoinUserType == 3 && TextUtils.isEmpty((CharSequence)this.mJoinSpecifiedDomains)) {
            this.mJoinUserType = 2;
        }
        switch (this.mJoinUserType) {
            case 2: {
                this.mTxtJoinUserType.setText(R.string.zm_lbl_allow_join_signed);
                break;
            }
            case 1: {
                this.mTxtJoinUserType.setText(R.string.zm_lbl_allow_join_everyone);
                break;
            }
            case 3: {
                String[] domains = this.mJoinSpecifiedDomains.split(";");
                StringBuilder builder = new StringBuilder();
                int width = this.mTxtJoinUserType.getMeasuredWidth();
                for (int i = 0; i < domains.length; ++i) {
                    String str = domains[i];
                    String label = width > 0 ? TextUtils.ellipsize((CharSequence)str, (TextPaint)this.mTxtJoinUserType.getPaint(), (float)width, (TextUtils.TruncateAt)TextUtils.TruncateAt.END).toString() : str;
                    builder.append(label);
                    if (i == domains.length - 1) continue;
                    builder.append("\n");
                }
                this.mTxtJoinUserType.setText((CharSequence)builder.toString());
                break;
            }
        }
    }

    private boolean isPMIEnabled() {
        return ResourcesUtil.getBoolean((Context)this.getActivity(), (int)R.bool.zm_config_pmi_enabled, (boolean)true);
    }

    private long getPMINumber() {
        MeetingHelper meetingHelper = PTApp.getInstance().getMeetingHelper();
        if (meetingHelper == null) {
            return this.getRoomMeetingID();
        }
        MeetingInfo meetingInfo = meetingHelper.getPmiMeetingItem();
        if (meetingInfo == null) {
            return this.getRoomMeetingID();
        }
        return meetingInfo.getMeetingNumber();
    }

    private long getRoomMeetingID() {
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        if (profile == null) {
            return 0L;
        }
        return profile.getRoomMeetingID();
    }

    private void updateVideoOptions() {
        this.mChkHostVideo.setChecked(this.mHostVideoOn);
        this.mChkAttendeeVideo.setChecked(this.mAttendeeVideoOn);
    }

    private void updateAudioOptions() {
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        if (profile != null && profile.isDisablePSTN() && !profile.hasSelfTelephony()) {
            this.mOptionAudio.setVisibility(8);
            this.mOption3rdPartyAudioInfo.setVisibility(8);
            return;
        }
        this.mOptionAudio.setVisibility(0);
        String selectedConutriesDesc = this.mAudioOptionParcelItem.getmSelectedDialInCountryDesc(this.getContext());
        if (!this.mAudioOptionParcelItem.isCanEditCountry() || StringUtil.isEmptyOrNull((String)selectedConutriesDesc)) {
            this.mTxtDialInDesc.setVisibility(8);
        } else {
            this.mTxtDialInDesc.setVisibility(0);
            this.mTxtDialInDesc.setText((CharSequence)selectedConutriesDesc);
        }
        switch (this.mAudioOptionParcelItem.getmSelectedAudioType()) {
            case 0: {
                this.mTxtAudioOption.setText(R.string.zm_lbl_audio_option_voip);
                this.mOption3rdPartyAudioInfo.setVisibility(8);
                this.mBtnSchedule.setEnabled(this.validateInput());
                break;
            }
            case 1: {
                this.mTxtAudioOption.setText(R.string.zm_lbl_audio_option_telephony);
                this.mOption3rdPartyAudioInfo.setVisibility(8);
                this.mBtnSchedule.setEnabled(this.validateInput());
                break;
            }
            case 2: {
                this.mTxtAudioOption.setText(R.string.zm_lbl_audio_option_voip_and_telephony_detail);
                this.mOption3rdPartyAudioInfo.setVisibility(8);
                this.mBtnSchedule.setEnabled(this.validateInput());
                break;
            }
            case 3: {
                String info;
                this.mTxtAudioOption.setText(R.string.zm_lbl_audio_option_3rd_party);
                this.mOption3rdPartyAudioInfo.setVisibility(0);
                if (this.mEdt3rdPartyAudioInfo.getText().length() == 0 && profile != null && (info = profile.getMyTelephoneInfo()) != null) {
                    this.mEdt3rdPartyAudioInfo.setText((CharSequence)info);
                }
                this.mBtnSchedule.setEnabled(this.validateInput());
            }
        }
    }

    private void onClickBtnBack() {
        this.dismissCancel();
    }

    private void onClickBtnSchedule() {
        if (this.isRequiredPassword() && StringUtil.isEmptyOrNull((String)this.getPassword())) {
            int[] viewToShowLocation = new int[]{0, 0};
            this.mEdtPassword.getLocationOnScreen(viewToShowLocation);
            int[] scrollLocation = new int[]{0, 0};
            this.mScrollView.getLocationInWindow(scrollLocation);
            int y = this.mScrollView.getScrollY();
            this.mScrollView.smoothScrollTo(0, y + viewToShowLocation[1] - scrollLocation[1]);
            this.mEdtPassword.requestFocus();
            DialogUtils.showAlertDialog((ZMActivity)this.getActivity(), R.string.zm_title_password_required_17552, R.string.zm_msg_password_required_17552, R.string.zm_btn_ok);
            return;
        }
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mBtnSchedule);
        if (!this.validateInput()) {
            return;
        }
        if (!NetworkUtil.hasDataNetwork((Context)this.getActivity())) {
            this.showNormalErrorOrTimeoutDialog();
            return;
        }
        PTApp ptApp = PTApp.getInstance();
        PTUserProfile profile = ptApp.getCurrentUserProfile();
        if (profile == null) {
            return;
        }
        MeetingInfo meetingInfo = new MeetingInfo();
        meetingInfo.setTopic(this.getTopic());
        meetingInfo.setPassword(this.getPassword());
        meetingInfo.setType(this.getIsRecurringMeeting() ? MeetingInfo.MeetingType.REPEAT : MeetingInfo.MeetingType.SCHEDULE);
        meetingInfo.setStartTime(this.getBeginTime().getTime() / 1000L);
        meetingInfo.setDuration(this.getDurationInMinutes());
        meetingInfo.setCanJoinBeforeHost(this.mChkEnableJBH.isChecked());
        meetingInfo.setIsCnMeeting(this.mChkCNMeeting.isChecked());
        meetingInfo.setTimeZoneId(this.getTimeZoneId());
        boolean isOnlySignJoin = ptApp.isSignedInUserMeetingOn();
        boolean isSpecifiedDomains = ptApp.isSpecifiedDomainsMeetingOn();
        if (isSpecifiedDomains) {
            meetingInfo.setIsOnlySignJoin(this.mJoinUserType != 1);
            if (this.mJoinUserType == 3 && !TextUtils.isEmpty((CharSequence)this.mJoinSpecifiedDomains)) {
                meetingInfo.setSpecialDomains(this.mJoinSpecifiedDomains);
            }
        } else if (isOnlySignJoin) {
            meetingInfo.setIsOnlySignJoin(this.mChkOnlySignJoin.isChecked());
        }
        if (StringUtil.isEmptyOrNull((String)this.mScheduleForId) || StringUtil.isSameString((String)this.getMyZoomId(), (String)this.mScheduleForId)) {
            meetingInfo.setUsePmiAsMeetingID(this.mChkUsePMI.isChecked());
        } else {
            meetingInfo.setUsePmiAsMeetingID(false);
        }
        if (this.getIsRecurringMeeting()) {
            meetingInfo.setRepeatType(ScheduledMeetingItem.nativeRepeatTypeToZoomRepeatType(this.mRepeatType));
            meetingInfo.setRepeatEndTime(this.mTimeEndRepeat / 1000L);
        }
        if (this.mIsEditMeeting) {
            meetingInfo.setId(this.mMeetingItem.getId());
            meetingInfo.setMeetingNumber(this.mMeetingItem.getMeetingNo());
            meetingInfo.setMeetingStatus(this.mMeetingItem.getMeetingStatus());
            meetingInfo.setInviteEmailContent(this.mMeetingItem.getInvitationEmailContent());
            meetingInfo.setOriginalMeetingNumber(this.mMeetingItem.getOriginalMeetingNo());
            meetingInfo.setMeetingHostID(this.mMeetingItem.getHostId());
        }
        meetingInfo.setHostVideoOff(!this.mHostVideoOn);
        meetingInfo.setAttendeeVideoOff(!this.mAttendeeVideoOn);
        if (profile.hasSelfTelephony() && this.mAudioOptionParcelItem.getmSelectedAudioType() == 3) {
            meetingInfo.setIsSelfTelephonyOn(true);
            meetingInfo.setOtherTeleConfInfo(this.mEdt3rdPartyAudioInfo.getText().toString());
        } else {
            meetingInfo.setIsSelfTelephonyOn(false);
            if (profile.hasSelfTelephony() || !profile.isDisablePSTN()) {
                meetingInfo.setVoipOff(this.mAudioOptionParcelItem.getmSelectedAudioType() != 0 && this.mAudioOptionParcelItem.getmSelectedAudioType() != 2);
                meetingInfo.setTelephonyOff(this.mAudioOptionParcelItem.getmSelectedAudioType() != 1 && this.mAudioOptionParcelItem.getmSelectedAudioType() != 2);
            }
        }
        if (ptApp.isPaidUser()) {
            if (this.mAlterHostList == null) {
                this.mAlterHostList = new ArrayList();
            }
            meetingInfo.setAlterHost(this.mAlterHostList);
        }
        meetingInfo.setAvailableDialinCountry(this.mAudioOptionParcelItem.getAvailableDialinCountry());
        MeetingHelper helper = PTApp.getInstance().getMeetingHelper();
        if (helper == null) {
            return;
        }
        boolean res = this.mIsEditMeeting ? helper.editMeeting(meetingInfo, this.getTimeZoneId()) : helper.scheduleMeeting(meetingInfo, this.getTimeZoneId(), this.mScheduleForId);
        if (res) {
            this.showWaitingDialog(this.mIsEditMeeting ? R.string.zm_msg_waiting_edit_meeting : R.string.zm_msg_scheduling);
        } else {
            this.showNormalErrorOrTimeoutDialog();
        }
        this.saveOptionsAsDefault();
    }

    private String getMyZoomId() {
        PTUserProfile myProfile = PTApp.getInstance().getCurrentUserProfile();
        if (myProfile == null) {
            return null;
        }
        return myProfile.getUserID();
    }

    private void saveOptionsAsDefault() {
        PreferenceUtil.saveBooleanValue("schedule_opt.jbh", this.mChkEnableJBH.isChecked());
        PreferenceUtil.saveBooleanValue("schedule_opt.host_video_on", this.mHostVideoOn);
        PreferenceUtil.saveBooleanValue("schedule_opt.attendee_video_on", this.mAttendeeVideoOn);
        PreferenceUtil.saveIntValue("schedule_opt.audio_option", this.mAudioOptionParcelItem.getmSelectedAudioType());
        PreferenceUtil.saveBooleanValue("schedule_opt.add_to_caclendar", this.mChkAddToCalendar.isChecked());
        PreferenceUtil.saveBooleanValue("schedule_opt.use_pmi", this.mChkUsePMI.isChecked());
        PreferenceUtil.saveBooleanValue("schedule_opt.cn_meeting", this.mChkCNMeeting.isChecked());
        boolean isSpecifiedDomains = PTApp.getInstance().isSpecifiedDomainsMeetingOn();
        PreferenceUtil.saveBooleanValue("schedule_opt.is_specified_domains", isSpecifiedDomains);
        if (isSpecifiedDomains) {
            PreferenceUtil.saveStringValue("schedule_opt.specified_domains", this.mJoinSpecifiedDomains);
            PreferenceUtil.saveIntValue("schedule_opt.only_specified_domains_join", this.mJoinUserType);
        } else {
            PreferenceUtil.saveBooleanValue("schedule_opt.only_signin_join", this.mChkOnlySignJoin.isChecked());
        }
    }

    private String getTimeZoneId() {
        return this.mTimeZoneId;
    }

    @Override
    public void onScheduleMeetingResult(int result, MeetingInfo meetingInfo, String errorMsg) {
        this.dismissWaitingDialog();
        this.mScheduleMeetingInfo = meetingInfo;
        if (result == 0) {
            ConfLocalHelper.saveAlterHostsForOnlyEmail(this.mAlterHostList, this.mManualInputEmails);
            PTUserProfile ptUserProfile = PTApp.getInstance().getCurrentUserProfile();
            if (ptUserProfile == null) {
                return;
            }
            if (ptUserProfile.isEnableAddToGoogleCalendarForMobile() && meetingInfo != null && !StringUtil.isEmptyOrNull((String)meetingInfo.getGoogleCalendarUrl())) {
                UIUtil.openURL((Context)this.getContext(), (String)meetingInfo.getGoogleCalendarUrl());
                this.dismissScheduleSuccess(ScheduledMeetingItem.fromMeetingInfo(meetingInfo));
                return;
            }
            if (this.mChkAddToCalendar.isChecked()) {
                if (meetingInfo == null) {
                    return;
                }
                if (Build.VERSION.SDK_INT < 23 || this.checkSelfPermission("android.permission.WRITE_CALENDAR") == 0) {
                    this.addMeetingInfoToCalendar(meetingInfo);
                    this.dismissScheduleSuccess(ScheduledMeetingItem.fromMeetingInfo(meetingInfo));
                } else {
                    this.zm_requestPermissions(new String[]{"android.permission.WRITE_CALENDAR"}, 2002);
                }
            } else {
                this.dismissScheduleSuccess(ScheduledMeetingItem.fromMeetingInfo(meetingInfo));
            }
        } else if (result == 5003) {
            this.showNormalErrorOrTimeoutDialog();
        } else {
            this.showErrorCodeDialog(result, errorMsg);
        }
    }

    @Override
    public void onListMeetingResult(int result) {
    }

    @Override
    public void onListCalendarEventsResult(int result) {
    }

    @Override
    public void onUpdateMeetingResult(int result, MeetingInfo meetingInfo, String errorMsg) {
        this.dismissWaitingDialog();
        this.mUpdateMeetingInfo = meetingInfo;
        if (result == 0) {
            if (this.mChkAddToCalendar.isChecked()) {
                if (meetingInfo == null) {
                    return;
                }
                if (Build.VERSION.SDK_INT < 23 || this.checkSelfPermission("android.permission.WRITE_CALENDAR") == 0) {
                    this.updateMeetingInfoToCalendar(meetingInfo);
                    this.dismissEditSuccess(ScheduledMeetingItem.fromMeetingInfo(meetingInfo));
                } else {
                    this.zm_requestPermissions(new String[]{"android.permission.WRITE_CALENDAR"}, 2003);
                }
            } else {
                this.dismissEditSuccess(ScheduledMeetingItem.fromMeetingInfo(meetingInfo));
            }
        } else if (result == 5003) {
            this.showNormalErrorOrTimeoutDialog();
        } else {
            this.showErrorCodeDialog(result, errorMsg);
        }
    }

    private void addMeetingInfoToCalendar(MeetingInfo meetingInfo) {
        if (meetingInfo == null) {
            return;
        }
        String topic = this.getActivity().getString(R.string.zm_title_meeting_invitation_email_topic, new Object[]{meetingInfo.getTopic()});
        String location = meetingInfo.getJoinMeetingUrl();
        long beginTime = meetingInfo.getStartTime() * 1000L;
        long endTime = beginTime + (long)(meetingInfo.getDuration() * 60000);
        String content = MeetingInvitationUtil.buildEmailInvitationContent((Context)this.getActivity(), meetingInfo, false);
        String myEmail = null;
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        if (profile != null) {
            myEmail = profile.getEmail();
        }
        String rrule = null;
        if (meetingInfo.getType() == MeetingInfo.MeetingType.REPEAT) {
            rrule = AndroidAppUtil.buildCalendarRrule((Date)new Date(beginTime), (AndroidAppUtil.EventRepeatType)ScheduledMeetingItem.zoomRepeatTypeToNativeRepeatType(meetingInfo.getRepeatType()), (Date)new Date(meetingInfo.getRepeatEndTime() * 1000L));
        }
        AndroidAppUtil.addNewCalendarEvent((Context)this.getActivity(), (String)myEmail, (long)beginTime, (long)endTime, (String)topic, (String)content, (String)location, rrule);
    }

    private void updateMeetingInfoToCalendar(MeetingInfo meetingInfo) {
        String topic = this.getActivity().getString(R.string.zm_title_meeting_invitation_email_topic, new Object[]{meetingInfo.getTopic()});
        String location = meetingInfo.getJoinMeetingUrl();
        long beginTime = meetingInfo.getStartTime() * 1000L;
        long endTime = beginTime + (long)(meetingInfo.getDuration() * 60000);
        String content = MeetingInvitationUtil.buildEmailInvitationContent((Context)this.getActivity(), meetingInfo, false);
        long eventID = -1L;
        long[] eventIDs = AndroidAppUtil.queryCalendarEventsForMeeting((Context)this.getActivity(), (long)meetingInfo.getMeetingNumber(), (String)location);
        if (eventIDs != null && eventIDs.length > 0) {
            eventID = eventIDs[0];
        }
        String rrule = null;
        if (meetingInfo.getType() == MeetingInfo.MeetingType.REPEAT) {
            rrule = AndroidAppUtil.buildCalendarRrule((Date)new Date(beginTime), (AndroidAppUtil.EventRepeatType)ScheduledMeetingItem.zoomRepeatTypeToNativeRepeatType(meetingInfo.getRepeatType()), (Date)new Date(meetingInfo.getRepeatEndTime() * 1000L));
        }
        if (eventID >= 0L) {
            AndroidAppUtil.updateCalendarEvent((Context)this.getActivity(), (long)eventID, (long)beginTime, (long)endTime, (String)topic, (String)content, (String)location, rrule);
        }
    }

    public void onRequestPermissionsResult(final int requestCode, final @NonNull String[] permissions, final @NonNull int[] grantResults) {
        EventTaskManager eventTaskManager = this.getEventTaskManager();
        if (eventTaskManager == null) {
            return;
        }
        eventTaskManager.pushLater("SchedulePermissionResult", new EventAction("SchedulePermissionResult"){

            public void run(IUIElement ui) {
                ((ScheduleFragment)ui).handleRequestPermissionResult(requestCode, permissions, grantResults);
            }
        });
    }

    public void handleRequestPermissionResult(int requestCode, String[] permissions, int[] grantResults) {
        for (int i = 0; i < permissions.length; ++i) {
            if (!"android.permission.WRITE_CALENDAR".equals(permissions[i])) continue;
            if (requestCode == 2002 && this.mScheduleMeetingInfo != null) {
                if (grantResults[i] == 0) {
                    this.addMeetingInfoToCalendar(this.mScheduleMeetingInfo);
                }
                this.dismissScheduleSuccess(ScheduledMeetingItem.fromMeetingInfo(this.mScheduleMeetingInfo));
                continue;
            }
            if (requestCode != 2003 || this.mUpdateMeetingInfo == null) continue;
            if (grantResults[i] == 0) {
                this.updateMeetingInfoToCalendar(this.mUpdateMeetingInfo);
            }
            this.dismissEditSuccess(ScheduledMeetingItem.fromMeetingInfo(this.mUpdateMeetingInfo));
        }
    }

    @Override
    public void onDeleteMeetingResult(int result) {
    }

    @Override
    public void onStartFailBeforeLaunch(int result) {
    }

    @Override
    public void onPMIEvent(int event, int result, MeetingInfo item) {
    }

    private void showErrorCodeDialog(int errorCode, String errorMsg) {
        if (errorCode == 1113 || errorCode == 1114 || errorCode == 1115) {
            SimpleMessageDialog dialog = SimpleMessageDialog.newInstance(this.getActivity().getString(R.string.zm_alert_msg_alterhost_21201, new Object[]{ConfLocalHelper.formatScheduleMeetingErrorMsg(errorMsg)}));
            dialog.show(this.getFragmentManager(), SimpleMessageDialog.class.getName());
        } else {
            SimpleMessageDialog dialog = SimpleMessageDialog.newInstance(this.getActivity().getString(this.mIsEditMeeting ? R.string.zm_msg_edit_meeting_failed_unknown_error : R.string.zm_msg_schedule_failed_unknown_error, new Object[]{errorCode}));
            dialog.show(this.getFragmentManager(), SimpleMessageDialog.class.getName());
        }
    }

    private void showNormalErrorOrTimeoutDialog() {
        SimpleMessageDialog dialog = SimpleMessageDialog.newInstance(this.mIsEditMeeting ? R.string.zm_msg_edit_meeting_failed_normal_or_timeout : R.string.zm_msg_schedule_failed_normal_or_timeout);
        dialog.show(this.getFragmentManager(), SimpleMessageDialog.class.getName());
    }

    private boolean validateInput() {
        boolean isTopicValid = this.validateTopic();
        boolean isDateValid = this.validateDate();
        boolean isBeginTimeValid = this.validateBeginTime();
        boolean isEndTimeValid = this.validateEndTime();
        boolean isEndRepeatTimeValid = this.validateEndRepeatTime(this.mTimeEndRepeat, this.mDateFrom.getTime());
        boolean isPasswordValid = this.validatePassword(this.mEdtPassword.getText().toString().trim());
        boolean is3rdPartyAudioInfoValid = this.validata3rdPartyAudioInfo();
        return isTopicValid && isDateValid && isBeginTimeValid && isEndTimeValid && isEndRepeatTimeValid && isPasswordValid && is3rdPartyAudioInfoValid;
    }

    private boolean validata3rdPartyAudioInfo() {
        if (this.mOption3rdPartyAudioInfo.isShown()) {
            return this.mEdt3rdPartyAudioInfo.getText().length() > 0;
        }
        return true;
    }

    public boolean validatePassword(String password) {
        return true;
    }

    private boolean validateTopic() {
        if (StringUtil.isEmptyOrNull((String)this.getTopic())) {
            this.mEdtTopic.requestFocus();
            return false;
        }
        return true;
    }

    private boolean validateDate() {
        if (!this.mDateTimeChangedByMannual) {
            return true;
        }
        Calendar current = Calendar.getInstance(this.mDateFrom.getTimeZone());
        int curYear = current.get(1);
        int curMonth = current.get(2);
        int curDate = current.get(5);
        int year = this.mDateFrom.get(1);
        int month = this.mDateFrom.get(2);
        int date = this.mDateFrom.get(5);
        if (year < curYear || year == curYear && month < curMonth || year == curYear && month == curMonth && date < curDate) {
            this.mTxtDate.setTextColor(-65536);
            return false;
        }
        this.mTxtDate.setTextColor(this.mColorDateTimeNormal);
        return true;
    }

    private boolean validateBeginTime() {
        if (!this.mDateTimeChangedByMannual) {
            return true;
        }
        Calendar current = Calendar.getInstance();
        if (this.mDateFrom.before(current)) {
            this.mTxtTimeFrom.setTextColor(-65536);
            return false;
        }
        this.mTxtTimeFrom.setTextColor(this.mColorDateTimeNormal);
        return true;
    }

    private boolean validateEndTime() {
        this.checkEndTime();
        Calendar current = Calendar.getInstance();
        if (this.mDateTo.before(current)) {
            this.mTxtTimeTo.setTextColor(-65536);
            return false;
        }
        this.mTxtTimeTo.setTextColor(this.mColorDateTimeNormal);
        return true;
    }

    private boolean validateEndRepeatTime(long endRepeatTime, Date beginTime) {
        if (this.mRepeatType == AndroidAppUtil.EventRepeatType.NONE || this.mRepeatType == AndroidAppUtil.EventRepeatType.UNKNOWN) {
            return true;
        }
        if (endRepeatTime <= beginTime.getTime() && endRepeatTime > 0L) {
            this.mTxtEndRepeat.setTextColor(-65536);
            return false;
        }
        this.mTxtEndRepeat.setTextColor(this.mColorDateTimeNormal);
        return true;
    }

    public void dismissCancel() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        this.finishFragment(0);
    }

    public void dismissScheduleSuccess(ScheduledMeetingItem item) {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        if (this.getShowsDialog()) {
            ZMActivity activity = (ZMActivity)this.getActivity();
            if (activity instanceof IMActivity) {
                ((IMActivity)activity).onScheduleSuccess(item);
            }
            super.dismiss();
        } else {
            Intent intent = new Intent();
            intent.putExtra(ARG_MEETING_ITEM, (Serializable)item);
            this.getActivity().setResult(-1, intent);
            this.getActivity().finish();
        }
    }

    public void dismissEditSuccess(ScheduledMeetingItem item) {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        if (this.getShowsDialog()) {
            MeetingInfoFragment f = MeetingInfoFragment.getMeetingInfoFragment(this.getActivity().getSupportFragmentManager());
            if (f != null) {
                f.onEditSuccess(item);
            }
            super.dismiss();
        } else {
            Intent intent = new Intent();
            intent.putExtra(ARG_MEETING_ITEM, (Serializable)item);
            this.getActivity().setResult(-1, intent);
            this.getActivity().finish();
        }
    }

    public void onSelectRepeatType(AndroidAppUtil.EventRepeatType type) {
        this.mRepeatType = type;
        this.updateUIStatus();
    }

    private void showWaitingDialog(int msgId) {
        if (this.mWaitingDialog != null) {
            return;
        }
        WaitingDialog dialog = (WaitingDialog)this.getFragmentManager().findFragmentByTag(WaitingDialog.class.getName());
        if (dialog == null) {
            this.mWaitingDialog = new WaitingDialog(msgId);
            this.mWaitingDialog.show(this.getFragmentManager(), WaitingDialog.class.getName());
        }
    }

    private void dismissWaitingDialog() {
        if (this.mWaitingDialog != null) {
            this.mWaitingDialog.dismiss();
            this.mWaitingDialog = null;
            return;
        }
        WaitingDialog dialog = (WaitingDialog)this.getFragmentManager().findFragmentByTag(WaitingDialog.class.getName());
        if (dialog != null) {
            dialog.dismiss();
        }
    }

    private void showAdvancedOptions() {
        this.mTvAdvancedOptions.setVisibility(8);
        this.mOptionEnableJBH.setVisibility(0);
        boolean cnMeetingOn = PTApp.getInstance().isCNMeetingON();
        if (!cnMeetingOn) {
            this.mChkCNMeeting.setChecked(false);
            this.mOptionEnableCNMetting.setVisibility(8);
        } else {
            this.mOptionEnableCNMetting.setVisibility(0);
        }
        boolean isOnlySignJoin = PTApp.getInstance().isSignedInUserMeetingOn();
        boolean isSpecifiedDomains = PTApp.getInstance().isSpecifiedDomainsMeetingOn();
        if (isSpecifiedDomains) {
            this.mOptionOnlySignJoin.setVisibility(8);
            this.mOptionJoinUserType.setVisibility(0);
        } else if (isOnlySignJoin) {
            this.mOptionOnlySignJoin.setVisibility(0);
            this.mOptionJoinUserType.setVisibility(8);
        } else {
            this.mOptionOnlySignJoin.setVisibility(8);
            this.mOptionJoinUserType.setVisibility(8);
        }
        if (PTApp.getInstance().isPaidUser()) {
            this.mOptionAlterHost.setVisibility(0);
            if (this.mIsEditMeeting && this.mMeetingItem != null) {
                this.mTvAlterHost.setText((CharSequence)ConfLocalHelper.getDescAlternativeHosts(this.getContext(), this.mAlterHostList));
            }
        } else {
            this.mOptionAlterHost.setVisibility(8);
        }
    }

    private void hideAdvancedOptions() {
        this.mTvAdvancedOptions.setVisibility(0);
        this.mOptionEnableJBH.setVisibility(8);
        this.mOptionOnlySignJoin.setVisibility(8);
        this.mOptionEnableCNMetting.setVisibility(8);
        this.mOptionJoinUserType.setVisibility(8);
        this.mOptionJoinUserType.setVisibility(8);
        this.mOptionAlterHost.setVisibility(8);
    }

    private void updatePasswordHint() {
        if (this.isRequiredPassword()) {
            this.mEdtPassword.setHint(R.string.zm_hint_password_required_schedule_17552);
        } else {
            this.mEdtPassword.setHint(R.string.zm_hint_password_schedule_21201);
        }
    }

    private boolean isRequiredPassword() {
        PTUserProfile ptUserProfile = PTApp.getInstance().getCurrentUserProfile();
        return ptUserProfile != null && ptUserProfile.isEnableForcePMIJBHWithPassword() && this.mChkEnableJBH.isChecked() && this.mChkUsePMI.isChecked();
    }

    private void onClickOptionAlterHost() {
        ArrayList<String> preSelectedItems = new ArrayList<String>();
        Gson gson = new Gson();
        String title = this.getString(R.string.zm_lbl_schedule_alter_host_21201);
        if (this.mAlterHostList != null && !this.mAlterHostList.isEmpty()) {
            for (AlterHost alterHost : this.mAlterHostList) {
                if (alterHost == null) continue;
                SelectAlterHostItem selectAlterHostItem = new SelectAlterHostItem();
                selectAlterHostItem.setEmail(alterHost.getEmail());
                selectAlterHostItem.setLastName(alterHost.getLastName());
                selectAlterHostItem.setFirstName(alterHost.getFirstName());
                selectAlterHostItem.setHostID(alterHost.getHostID());
                selectAlterHostItem.setPicUrl(alterHost.getPicUrl());
                selectAlterHostItem.setPmi(alterHost.getPmi());
                preSelectedItems.add(gson.toJson((Object)selectAlterHostItem));
            }
            title = this.getString(R.string.zm_title_select_alternative_host_21201, new Object[]{preSelectedItems.size()});
        }
        MMSelectContactsActivity.SelectContactsParamter paramters = new MMSelectContactsActivity.SelectContactsParamter();
        paramters.title = title;
        paramters.preSelectedItems = preSelectedItems;
        paramters.btnOkText = this.getString(R.string.zm_btn_ok);
        paramters.instructionMessage = null;
        paramters.isAnimBottomTop = true;
        paramters.isOnlySameOrganization = false;
        paramters.includeRobot = false;
        paramters.isContainsAllInGroup = false;
        paramters.isAlternativeHost = true;
        MMSelectContactsActivity.show((Fragment)this, paramters, 2004, null);
    }

    private void initRetainedFragment() {
        this.mRetainedFragment = this.getRetainedFragment();
        if (this.mRetainedFragment == null) {
            this.mRetainedFragment = new RetainedFragment();
            ((ZMActivity)this.getContext()).getSupportFragmentManager().beginTransaction().add((Fragment)this.mRetainedFragment, RetainedFragment.class.getName()).commit();
        } else {
            this.mAlterHostList = this.mRetainedFragment.restoreAlterHostItems();
            this.mManualInputEmails = this.mRetainedFragment.restoreManualInputEmails();
            this.mAudioOptionParcelItem = this.mRetainedFragment.restoreAudioOptionParcelItem();
            this.updateAudioOptions();
        }
    }

    private RetainedFragment getRetainedFragment() {
        if (this.mRetainedFragment != null) {
            return this.mRetainedFragment;
        }
        FragmentManager fm = ((ZMActivity)this.getContext()).getSupportFragmentManager();
        return (RetainedFragment)fm.findFragmentByTag(RetainedFragment.class.getName());
    }

    public static class RetainedFragment
    extends ZMFragment {
        private ArrayList<AlterHost> mAlterHostItems = null;
        private Set<String> mManualInputEmails = new HashSet<String>();
        private AudioOptionParcelItem mAudioOptionParcelItem = new AudioOptionParcelItem();

        public RetainedFragment() {
            this.setRetainInstance(true);
        }

        public void saveAlterHostItems(ArrayList<AlterHost> items) {
            this.mAlterHostItems = items;
        }

        public ArrayList<AlterHost> restoreAlterHostItems() {
            return this.mAlterHostItems;
        }

        public void savManualInputEmails(Set<String> items) {
            this.mManualInputEmails = items;
        }

        public Set<String> restoreManualInputEmails() {
            return this.mManualInputEmails;
        }

        public void saveAudioOptionParcelItem(AudioOptionParcelItem audioOptionParcelItem) {
            this.mAudioOptionParcelItem = audioOptionParcelItem;
        }

        public AudioOptionParcelItem restoreAudioOptionParcelItem() {
            return this.mAudioOptionParcelItem;
        }
    }

    static class ReportOptionMenuItem
    extends ZMSimpleMenuItem {
        public ReportOptionMenuItem(AndroidAppUtil.EventRepeatType type, String label, boolean selected) {
            super(type.ordinal(), label, null, selected);
        }

        public AndroidAppUtil.EventRepeatType getItemType() {
            AndroidAppUtil.EventRepeatType[] types;
            int action = this.getAction();
            if (action >= (types = AndroidAppUtil.EventRepeatType.values()).length || action < 0) {
                return null;
            }
            return types[action];
        }
    }

    static class ScheduleForMenuItem
    extends ZMSimpleMenuItem {
        public static final int ACTION_MYSELF = 0;
        public static final int ACTION_OTHER = 1;
        private String mAltHostId;

        public ScheduleForMenuItem(int action, String label, String altHostId) {
            super(action, label);
            this.mAltHostId = altHostId;
        }

        public String getAltHostId() {
            return this.mAltHostId;
        }
    }

    public static class PasswordKeyListener
    extends DigitsKeyListener {
        private final char[] mAcceptedChars = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-_*@".toCharArray();

        public PasswordKeyListener() {
            super(false, false);
        }

        protected char[] getAcceptedChars() {
            return this.mAcceptedChars;
        }

        public int getInputType() {
            return 1;
        }
    }
}

