/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import com.zipow.videobox.SimpleActivity;
import java.util.ArrayList;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMSettingsCategory;
import us.zoom.videomeetings.R;

public class ScheduleChooseUserTypeFragment
extends ZMDialogFragment
implements View.OnClickListener {
    public static final String EXTRA_JOIN_USER_TYPE = "EXTRA_JOIN_USER_TYPE";
    public static final String EXTRA_SPECIFIED_DOMAINS = "EXTRA_SPECIFIED_DOMAINS";
    private Button mBtnAddNewDomain;
    private ZMSettingsCategory mPanelDomains;
    private ImageView mImgEveryone;
    private ImageView mImgAnySign;
    private ImageView mImgSpecifiedDomains;
    private TextView mTxtDomainsLabel;
    private ArrayList<CharSequence> mSpecifiedDomains;
    private int mUserType = 1;

    public static void showInActivity(ZMActivity activity, int requestCode) {
        if (activity == null) {
            return;
        }
        Bundle args = new Bundle();
        SimpleActivity.show(activity, ScheduleChooseUserTypeFragment.class.getName(), args, requestCode, false);
    }

    public static void showInActivity(Fragment fragment, int requestCode, int joinUserType, String domains) {
        if (fragment == null) {
            return;
        }
        Bundle args = new Bundle();
        args.putInt(EXTRA_JOIN_USER_TYPE, joinUserType);
        args.putString(EXTRA_SPECIFIED_DOMAINS, domains);
        SimpleActivity.show(fragment, ScheduleChooseUserTypeFragment.class.getName(), args, requestCode, false);
    }

    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View content = inflater.inflate(R.layout.zm_schedule_choose_user_type, container, false);
        this.mBtnAddNewDomain = (Button)content.findViewById(R.id.btnAddNewDomain);
        this.mPanelDomains = (ZMSettingsCategory)content.findViewById(R.id.panleDomains);
        this.mImgEveryone = (ImageView)content.findViewById(R.id.imgEveryone);
        this.mImgAnySign = (ImageView)content.findViewById(R.id.imgAnySign);
        this.mImgSpecifiedDomains = (ImageView)content.findViewById(R.id.imgSpecifiedDomains);
        this.mTxtDomainsLabel = (TextView)content.findViewById(R.id.txtDomainsLabel);
        content.findViewById(R.id.btnBack).setOnClickListener((View.OnClickListener)this);
        content.findViewById(R.id.optEveryone).setOnClickListener((View.OnClickListener)this);
        content.findViewById(R.id.optAnySign).setOnClickListener((View.OnClickListener)this);
        content.findViewById(R.id.optSpecifiedDomains).setOnClickListener((View.OnClickListener)this);
        content.findViewById(R.id.btnSave).setOnClickListener((View.OnClickListener)this);
        this.mBtnAddNewDomain.setOnClickListener((View.OnClickListener)this);
        this.mSpecifiedDomains = new ArrayList();
        Bundle args = this.getArguments();
        if (args != null) {
            this.mUserType = args.getInt(EXTRA_JOIN_USER_TYPE);
            this.initSpecifiedDomains(args.getString(EXTRA_SPECIFIED_DOMAINS));
        }
        if (savedInstanceState != null) {
            this.mUserType = savedInstanceState.getInt("mUserType");
            this.mSpecifiedDomains = savedInstanceState.getCharSequenceArrayList("mSpecifiedDomains");
        }
        this.updateJoinUserType(this.mUserType);
        return content;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt("mUserType", this.mUserType);
        outState.putCharSequenceArrayList("mSpecifiedDomains", this.mSpecifiedDomains);
    }

    private void updateJoinUserType(int type) {
        this.mUserType = type;
        this.mImgEveryone.setVisibility(8);
        this.mImgAnySign.setVisibility(8);
        this.mImgSpecifiedDomains.setVisibility(8);
        switch (this.mUserType) {
            case 1: {
                this.mImgEveryone.setVisibility(0);
                this.setQualifiedDomainPanelVisiable(false);
                break;
            }
            case 2: {
                this.mImgAnySign.setVisibility(0);
                this.setQualifiedDomainPanelVisiable(false);
                break;
            }
            case 3: {
                this.mImgSpecifiedDomains.setVisibility(0);
                this.setQualifiedDomainPanelVisiable(true);
                break;
            }
        }
    }

    private void initSpecifiedDomains(String domainsStr) {
        String[] domains;
        if (TextUtils.isEmpty((CharSequence)domainsStr)) {
            return;
        }
        for (String domain : domains = domainsStr.split(";")) {
            if (TextUtils.isEmpty((CharSequence)domain)) continue;
            this.mSpecifiedDomains.add(domain);
        }
        this.refreshDomainsPanel();
    }

    private void refreshDomainsPanel() {
        while (this.mPanelDomains.getChildCount() > 1) {
            this.mPanelDomains.removeViewAt(0);
        }
        for (int i = 0; i < this.mSpecifiedDomains.size(); ++i) {
            CharSequence domain = this.mSpecifiedDomains.get(i);
            View item = View.inflate((Context)this.getActivity(), (int)R.layout.zm_schedule_domain_item, null);
            TextView txtDomain = (TextView)item.findViewById(R.id.txtDomain);
            txtDomain.setText(domain);
            item.setTag((Object)i);
            item.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Object tag = v.getTag();
                    if (tag == null || !(tag instanceof Integer)) {
                        return;
                    }
                    ScheduleChooseUserTypeFragment.this.editDomain((Integer)tag);
                }
            });
            this.mPanelDomains.addView(item, this.mPanelDomains.getChildCount() - 1);
        }
    }

    private void editDomain(final int index) {
        boolean isEditMode;
        boolean bl = isEditMode = index >= 0;
        if (index >= this.mSpecifiedDomains.size()) {
            return;
        }
        View content = View.inflate((Context)this.getActivity(), (int)R.layout.zm_schedule_input_domain, null);
        final EditText editText = (EditText)content.findViewById(R.id.edtDomainName);
        if (isEditMode) {
            editText.setText(this.mSpecifiedDomains.get(index));
            editText.setSelection(editText.length());
        }
        editText.setHint(R.string.zm_hint_allow_join_input_domains);
        ZMAlertDialog.Builder builder = new ZMAlertDialog.Builder((Context)this.getActivity()).setView(content).setPositiveButton(R.string.zm_btn_save, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                String value = editText.getText().toString();
                if (isEditMode) {
                    ScheduleChooseUserTypeFragment.this.mSpecifiedDomains.set(index, value);
                } else {
                    ScheduleChooseUserTypeFragment.this.mSpecifiedDomains.add(value);
                }
                ScheduleChooseUserTypeFragment.this.refreshDomainsPanel();
            }
        }).setNeutralButton(R.string.zm_btn_cancel, null);
        if (isEditMode) {
            builder.setNegativeButton(R.string.zm_btn_delete, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ScheduleChooseUserTypeFragment.this.mSpecifiedDomains.remove(index);
                    ScheduleChooseUserTypeFragment.this.refreshDomainsPanel();
                }
            });
        }
        final ZMAlertDialog dialog = builder.create();
        editText.addTextChangedListener(new TextWatcher(){

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void afterTextChanged(Editable s) {
                boolean isDomain = StringUtil.isValidDomain((String)s.toString());
                dialog.getButton(-1).setEnabled(isDomain);
            }
        });
        dialog.show();
        dialog.getButton(-1).setEnabled(StringUtil.isValidDomain((String)editText.getText().toString()));
    }

    public void onClick(View v) {
        if (v == null) {
            return;
        }
        int id2 = v.getId();
        if (id2 == R.id.btnAddNewDomain) {
            this.onclickBtnAddNewDomain();
        } else if (id2 == R.id.btnBack) {
            this.onclickBtnBack();
        } else if (id2 == R.id.optEveryone) {
            this.onclickOptEveryone();
        } else if (id2 == R.id.optAnySign) {
            this.onclickOptAnySign();
        } else if (id2 == R.id.optSpecifiedDomains) {
            this.onclickOptSpecifiedDomains();
        } else if (id2 == R.id.btnSave) {
            this.onclickBtnSave();
        }
    }

    private void onclickBtnSave() {
        Intent intent = new Intent();
        intent.putExtra(EXTRA_JOIN_USER_TYPE, this.mUserType);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.mSpecifiedDomains.size(); ++i) {
            CharSequence domain = this.mSpecifiedDomains.get(i);
            builder.append(domain);
            if (i == this.mSpecifiedDomains.size() - 1) continue;
            builder.append(";");
        }
        intent.putExtra(EXTRA_SPECIFIED_DOMAINS, builder.toString());
        this.getActivity().setResult(-1, intent);
        this.dismiss();
    }

    private void onclickBtnBack() {
        this.dismiss();
    }

    private void onclickBtnAddNewDomain() {
        this.editDomain(-1);
    }

    private void onclickOptEveryone() {
        this.updateJoinUserType(1);
    }

    private void onclickOptAnySign() {
        this.updateJoinUserType(2);
    }

    private void onclickOptSpecifiedDomains() {
        this.updateJoinUserType(3);
    }

    private void setQualifiedDomainPanelVisiable(boolean visiable) {
        this.mTxtDomainsLabel.setVisibility(visiable ? 0 : 8);
        this.mPanelDomains.setVisibility(visiable ? 0 : 8);
    }

    public void dismiss() {
        this.finishFragment(true);
    }
}

