/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.fragment.ZMErrorMessageDialog;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class PasswordEditFragment
extends ZMDialogFragment
implements View.OnClickListener,
TextView.OnEditorActionListener {
    private EditText mOldPassword;
    private EditText mNewPassword;
    private EditText mConfirmPassword;
    private Button btnSave;
    private Button btnBack;
    private String mRequestID;
    private static String WAITING_DIALOG_TAG = "password_edit_waiting_dialog";
    private static int PASSWORD_LEAST_LENGTH = 6;
    private PTUI.IProfileListener mListener = new PTUI.SimpleProfileListener(){

        @Override
        public void OnProfileFieldUpdated(String reqID, int result, int type, String param) {
            if (StringUtil.isEmptyOrNull((String)reqID)) {
                return;
            }
            if (!reqID.equals(PasswordEditFragment.this.mRequestID)) {
                return;
            }
            UIUtil.dismissWaitingDialog((FragmentManager)PasswordEditFragment.this.getFragmentManager(), (String)WAITING_DIALOG_TAG);
            PasswordEditFragment.this.handleProfileUpdate(result, type, param);
        }
    };

    private void handleProfileUpdate(int result, int type, String param) {
        if (result == 0) {
            this.dismiss();
        } else {
            this.showErrorMessage(result, param);
        }
    }

    public static void showAsActivity(ZMActivity activity) {
        Bundle args = new Bundle();
        SimpleActivity.show(activity, PasswordEditFragment.class.getName(), args, 0);
    }

    public static void showAsActivity(Fragment fragment) {
        Bundle args = new Bundle();
        SimpleActivity.show(fragment, PasswordEditFragment.class.getName(), args, 0);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_password_edit, container, false);
        this.mOldPassword = (EditText)view.findViewById(R.id.edtOldPwd);
        this.mNewPassword = (EditText)view.findViewById(R.id.edtNewPwd);
        this.mConfirmPassword = (EditText)view.findViewById(R.id.edtConfirmPwd);
        this.btnSave = (Button)view.findViewById(R.id.btnSave);
        this.btnBack = (Button)view.findViewById(R.id.btnBack);
        this.btnSave.setEnabled(false);
        this.btnSave.setOnClickListener((View.OnClickListener)this);
        this.btnBack.setOnClickListener((View.OnClickListener)this);
        if (this.mConfirmPassword != null) {
            this.mConfirmPassword.setImeOptions(6);
            this.mConfirmPassword.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        }
        this.mOldPassword.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                PasswordEditFragment.this.refresh();
            }
        });
        this.mNewPassword.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                PasswordEditFragment.this.refresh();
            }
        });
        this.mConfirmPassword.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                PasswordEditFragment.this.refresh();
            }
        });
        return view;
    }

    public void onResume() {
        PTUI.getInstance().addProfileListener(this.mListener);
        this.refresh();
        super.onResume();
    }

    public void onPause() {
        PTUI.getInstance().removeProfileListener(this.mListener);
        super.onPause();
    }

    public void refresh() {
        boolean ret = this.checkInputPassword();
        this.btnSave.setEnabled(ret);
    }

    private boolean checkInputPassword() {
        String oldPwd = this.mOldPassword.getText().toString();
        if (StringUtil.isEmptyOrNull((String)oldPwd)) {
            return false;
        }
        String newPwd = this.mNewPassword.getText().toString();
        if (StringUtil.isEmptyOrNull((String)newPwd)) {
            return false;
        }
        String confirmPwd = this.mConfirmPassword.getText().toString();
        if (StringUtil.isEmptyOrNull((String)confirmPwd)) {
            return false;
        }
        return newPwd.length() >= PASSWORD_LEAST_LENGTH;
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnSave) {
            this.onClickBtnSave();
        } else if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        }
    }

    private void onClickBtnSave() {
        if (!this.checkInputPassword()) {
            return;
        }
        String oldPassword = this.mOldPassword.getText().toString();
        String newPassword = this.mNewPassword.getText().toString();
        String confirm = this.mConfirmPassword.getText().toString();
        if (newPassword.equals(oldPassword)) {
            this.showErrorMessage(300, "");
            return;
        }
        if (!newPassword.equals(confirm)) {
            this.showConfirmNotMatchMessage();
            return;
        }
        this.mRequestID = PTApp.getInstance().changeUserPassword(oldPassword, newPassword);
        if (StringUtil.isEmptyOrNull((String)this.mRequestID)) {
            this.showErrorMessage(5000, "");
            return;
        }
        UIUtil.showWaitingDialog((FragmentManager)this.getFragmentManager(), (int)R.string.zm_msg_waiting, (String)WAITING_DIALOG_TAG);
    }

    private String getErrorMessage(int errorCode, String data) {
        String message = "";
        switch (errorCode) {
            case 5000: 
            case 5003: {
                message = this.getString(R.string.zm_lbl_profile_change_fail_cannot_connect_service);
                break;
            }
            case 300: {
                message = this.getString(R.string.zm_lbl_password_same_fail);
                break;
            }
            case 1001: {
                message = this.getString(R.string.zm_lbl_user_not_exist);
                break;
            }
            case 1002: {
                message = this.getString(R.string.zm_lbl_password_old_incorrect);
                break;
            }
            case 1124: {
                try {
                    int len = Integer.parseInt(data);
                    message = this.getString(R.string.zm_lbl_password_characters_limit_fail, new Object[]{len});
                }
                catch (NumberFormatException len) {}
                break;
            }
            case 1125: {
                message = this.getString(R.string.zm_lbl_password_letter_limit_fail);
                break;
            }
            case 1126: {
                message = this.getString(R.string.zm_lbl_password_number_limit_fail);
                break;
            }
            case 1127: {
                message = this.getString(R.string.zm_lbl_password_special_character_fail);
                break;
            }
            case 1128: {
                message = this.getString(R.string.zm_lbl_password_uper_lower_character_fail);
                break;
            }
            case 1129: {
                try {
                    int num = Integer.parseInt(data);
                    message = this.getString(R.string.zm_lbl_password_same_with_before_fail, new Object[]{num});
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case 1130: {
                message = this.getString(R.string.zm_lbl_password_same_character_fail);
                break;
            }
            case 1131: {
                message = this.getString(R.string.zm_lbl_password_continuation_character_fail);
                break;
            }
            default: {
                message = this.getString(R.string.zm_lbl_password_unknow_error, new Object[]{errorCode});
            }
        }
        return message;
    }

    private HashMap<String, String> parseErrorMessage(String param) {
        if (StringUtil.isEmptyOrNull((String)param)) {
            return null;
        }
        HashMap<String, String> messages = new HashMap<String, String>();
        try {
            JSONObject o = new JSONObject(param);
            Iterator keys = o.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String data = o.getString(key);
                messages.put(key, data);
            }
        }
        catch (JSONException e) {
            return null;
        }
        return messages;
    }

    private void showConfirmNotMatchMessage() {
        ArrayList<String> messages = new ArrayList<String>();
        String message = this.getString(R.string.zm_lbl_password_confirm_not_match);
        messages.add(message);
        String title = this.getString(R.string.zm_title_password_fail);
        ZMErrorMessageDialog.show(this.getFragmentManager(), title, messages, "VanityURLModifyFragment error dialog");
    }

    private void showErrorMessage(int result, String param) {
        ArrayList<String> messages = new ArrayList<String>();
        if (result == 1124) {
            HashMap<String, String> errorInfo = this.parseErrorMessage(param);
            if (errorInfo != null) {
                Set<String> keys = errorInfo.keySet();
                if (keys.size() <= 0) {
                    return;
                }
                for (String key : keys) {
                    String data = errorInfo.get(key);
                    int code = 0;
                    try {
                        code = Integer.parseInt(key);
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                    String message = this.getErrorMessage(code, data);
                    if (StringUtil.isEmptyOrNull((String)message)) continue;
                    messages.add(message);
                }
            } else {
                String message = this.getErrorMessage(result, "8");
                if (StringUtil.isEmptyOrNull((String)message)) {
                    return;
                }
                messages.add(message);
            }
        } else {
            String message = this.getErrorMessage(result, "");
            if (StringUtil.isEmptyOrNull((String)message)) {
                return;
            }
            messages.add(message);
        }
        String title = this.getString(R.string.zm_title_password_fail);
        ZMErrorMessageDialog.show(this.getFragmentManager(), title, messages, "VanityURLModifyFragment error dialog");
    }

    private void onClickBtnBack() {
        this.dismiss();
    }

    public void dismiss() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        this.finishFragment(true);
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        switch (actionId) {
            case 6: {
                this.onClickBtnSave();
                return true;
            }
        }
        return false;
    }
}

